/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.threads.ThreadsDetailsPanel;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;
import org.netbeans.lib.profiler.ui.threads.ThreadsTablePanel;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class ThreadsWindow
extends TopComponent
implements ProfilingStateListener,
ActionListener,
ChangeListener,
SaveViewAction.ViewProvider {
    private static final String THREADS_WINDOW_NAME = NbBundle.getMessage(ThreadsWindow.class, (String)"ThreadsWindow_ThreadsWindowName");
    private static final String THREADS_TIMELINE_TAB_NAME = NbBundle.getMessage(ThreadsWindow.class, (String)"ThreadsWindow_ThreadsTimelineTabName");
    private static final String THREADS_TABLE_TAB_NAME = NbBundle.getMessage(ThreadsWindow.class, (String)"ThreadsWindow_ThreadsTableTabName");
    private static final String THREADS_DETAILS_TAB_NAME = NbBundle.getMessage(ThreadsWindow.class, (String)"ThreadsWindow_ThreadsDetailsTabName");
    private static final String THREADS_TIMELINE_TAB_DESCR = NbBundle.getMessage(ThreadsWindow.class, (String)"ThreadsWindow_ThreadsTimelineTabDescr");
    private static final String THREADS_TABLE_TAB_DESCR = NbBundle.getMessage(ThreadsWindow.class, (String)"ThreadsWindow_ThreadsTableTabDescr");
    private static final String THREADS_DETAILS_TAB_DESCR = NbBundle.getMessage(ThreadsWindow.class, (String)"ThreadsWindow_ThreadsDetailsTabDescr");
    private static final String THREADS_ACCESS_DESCR = NbBundle.getMessage(ThreadsWindow.class, (String)"ThreadsWindow_ThreadsAccessDescr");
    private static final String HELP_CTX_KEY = "ThreadsWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ThreadsWindow.HelpCtx");
    private static ThreadsWindow defaultInstance;
    private static final Image windowIcon;
    private final JPanel threadsTimelinePanelContainer;
    private final JTabbedPane tabs;
    private final ThreadsPanel threadsPanel;
    private final ThreadsTablePanel threadsTablePanel;
    private Component lastFocusOwner;
    private JPanel threadsDetailsPanelContainer;
    private ThreadsDetailsPanel threadsDetailsPanel;

    public ThreadsWindow() {
        this.setName(THREADS_WINDOW_NAME);
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(THREADS_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.setTabPlacement(3);
        this.add(this.tabs, "Center");
        boolean tvmSupportsSleepingState = Platform.supportsThreadSleepingStateMonitoring((String)Profiler.getDefault().getTargetAppRunner().getProfilerEngineSettings().getTargetJDKVersionString());
        this.threadsPanel = new ThreadsPanel(Profiler.getDefault().getThreadsManager(), new ThreadsPanel.ThreadsDetailsCallback(){

            public void showDetails(int[] indexes) {
                ThreadsWindow.this.threadsDetailsPanel.showDetails(indexes);
                ThreadsWindow.this.tabs.setSelectedComponent(ThreadsWindow.this.threadsDetailsPanelContainer);
            }
        }, tvmSupportsSleepingState);
        this.threadsTimelinePanelContainer = new JPanel(){

            @Override
            public void requestFocus() {
                ThreadsWindow.this.threadsPanel.requestFocus();
            }
        };
        this.threadsTimelinePanelContainer.setLayout(new BorderLayout());
        this.threadsTimelinePanelContainer.add((Component)this.threadsPanel, "Center");
        this.threadsPanel.addThreadsMonitoringActionListener((ActionListener)this);
        this.threadsPanel.addSaveViewAction((AbstractAction)new SaveViewAction(this));
        this.threadsTablePanel = new ThreadsTablePanel(Profiler.getDefault().getThreadsManager(), new ThreadsTablePanel.ThreadsDetailsCallback(){

            public void showDetails(int[] indexes) {
                ThreadsWindow.this.threadsDetailsPanel.showDetails(indexes);
                ThreadsWindow.this.tabs.setSelectedComponent(ThreadsWindow.this.threadsDetailsPanelContainer);
            }
        }, tvmSupportsSleepingState);
        this.threadsTablePanel.addSaveViewAction((AbstractAction)new SaveViewAction(this));
        this.threadsDetailsPanel = new ThreadsDetailsPanel(Profiler.getDefault().getThreadsManager(), tvmSupportsSleepingState);
        this.threadsDetailsPanelContainer = new JPanel(){

            @Override
            public void requestFocus() {
                ThreadsWindow.this.threadsDetailsPanel.requestFocus();
            }
        };
        this.threadsDetailsPanelContainer.setLayout(new BorderLayout());
        this.threadsDetailsPanelContainer.add((Component)this.threadsDetailsPanel, "Center");
        this.threadsDetailsPanel.addSaveViewAction((AbstractAction)new SaveViewAction(this));
        this.tabs.addTab(THREADS_TIMELINE_TAB_NAME, null, this.threadsTimelinePanelContainer, THREADS_TIMELINE_TAB_DESCR);
        this.tabs.addTab(THREADS_TABLE_TAB_NAME, null, (Component)this.threadsTablePanel, THREADS_TABLE_TAB_DESCR);
        this.tabs.addTab(THREADS_DETAILS_TAB_NAME, null, this.threadsDetailsPanelContainer, THREADS_DETAILS_TAB_DESCR);
        this.profilingStateChanged(Profiler.getDefault().getProfilingState());
        this.threadsMonitoringChanged();
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsWindow.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsWindow.this.moveToNextSubTab();
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.tabs.addChangeListener(this);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public static ThreadsWindow getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ThreadsWindow();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Profiler.getDefault().setThreadsMonitoringEnabled(true);
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (this.tabs.getSelectedComponent() == this.threadsTimelinePanelContainer) {
            return this.threadsPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (this.tabs.getSelectedComponent() == this.threadsTablePanel) {
            return this.threadsTablePanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (this.tabs.getSelectedComponent() == this.threadsDetailsPanelContainer) {
            return this.threadsDetailsPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        return null;
    }

    @Override
    public String getViewName() {
        if (this.tabs.getSelectedComponent() == this.threadsTimelinePanelContainer) {
            return "threads-timeline";
        }
        if (this.tabs.getSelectedComponent() == this.threadsTablePanel) {
            return "threads-table";
        }
        if (this.tabs.getSelectedComponent() == this.threadsDetailsPanelContainer) {
            return "threads-details";
        }
        return null;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.threadsPanel != null) {
            this.threadsPanel.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public boolean fitsVisibleArea() {
        if (this.tabs.getSelectedComponent() == this.threadsTimelinePanelContainer) {
            return this.threadsPanel.fitsVisibleArea();
        }
        if (this.tabs.getSelectedComponent() == this.threadsTablePanel) {
            return this.threadsTablePanel.fitsVisibleArea();
        }
        if (this.tabs.getSelectedComponent() == this.threadsDetailsPanelContainer) {
            return this.threadsDetailsPanel.fitsVisibleArea();
        }
        return true;
    }

    @Override
    public boolean hasView() {
        if (this.tabs.getSelectedComponent() == this.threadsTimelinePanelContainer) {
            return this.threadsPanel.hasView();
        }
        if (this.tabs.getSelectedComponent() == this.threadsTablePanel) {
            return this.threadsTablePanel.hasView();
        }
        if (this.tabs.getSelectedComponent() == this.threadsDetailsPanelContainer) {
            return this.threadsDetailsPanel.hasView();
        }
        return false;
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        this.profilingStateChanged(e.getNewState());
    }

    public void showThreads() {
        this.tabs.setSelectedComponent(this.threadsTimelinePanelContainer);
        this.open();
        this.requestActive();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ThreadsWindow.this.tabs.getSelectedComponent() != null) {
                    ThreadsWindow.this.tabs.getSelectedComponent().requestFocus();
                }
            }
        });
    }

    public void threadsMonitoringChanged() {
        if (Profiler.getDefault().getThreadsMonitoringEnabled()) {
            this.threadsPanel.threadsMonitoringEnabled();
            this.tabs.setEnabledAt(1, true);
            this.tabs.setEnabledAt(2, true);
        } else {
            this.threadsPanel.threadsMonitoringDisabled();
            this.tabs.setSelectedIndex(0);
            this.tabs.setEnabledAt(1, false);
            this.tabs.setEnabledAt(2, false);
        }
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void profilingStateChanged(boolean enable) {
        if (enable) {
            this.threadsPanel.profilingSessionStarted();
        } else {
            this.threadsPanel.profilingSessionFinished();
        }
    }

    private void profilingStateChanged(int profilingState) {
        if (profilingState == 4) {
            this.profilingStateChanged(true);
        } else {
            this.profilingStateChanged(false);
        }
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowThreads");
    }
}

