/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.ImagePreviewPanel;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class SaveViewAction
extends AbstractAction {
    private static final String SAVE_VIEW_ACTION_NAME = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_SaveViewActionName");
    private static final String SAVE_VIEW_ACTION_DESCR = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_SaveViewActionDescr");
    private static final String NO_VIEW_MSG = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_NoViewMsg");
    private static final String SAVING_VIEW_MSG = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_SavingViewMsg");
    private static final String OVERWRITE_FILE_CAPTION = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_OverwriteFileCaption");
    private static final String OVERWRITE_FILE_MSG = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_OverwriteFileMsg");
    private static final String CANNOT_OVERWRITE_FILE_MSG = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_CannotOverwriteFileMsg");
    private static final String SAVE_DIALOG_TITLE = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_SaveDialogTitle");
    private static final String SAVE_DIALOG_BUTTON = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_SaveDialogButton");
    private static final String SAVE_DIALOG_FILTER = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_SaveDialogFilter");
    private static final String SAVE_DIALOG_PREVIEW = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_SaveDialogPreview");
    private static final String SAVE_DIALOG_VISIBLE = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_SaveDialogVisible");
    private static final String OOME_SAVING_MSG = NbBundle.getMessage(SaveViewAction.class, (String)"SaveViewAction_OomeSavingMsg");
    private static final Icon ICON = Icons.getIcon((String)"GeneralIcons.SaveView");
    private static File exportDir;
    private BufferedImage image;
    private ImagePreviewPanel imagePreview;
    private JCheckBox visibleAreaCheckBox;
    private JFileChooser fileChooser;
    private ViewProvider viewProvider;
    private boolean visibleArea;

    public SaveViewAction(ViewProvider viewProvider) {
        this.putValue("Name", SAVE_VIEW_ACTION_NAME);
        this.putValue("ShortDescription", SAVE_VIEW_ACTION_DESCR);
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.SaveView"));
        this.viewProvider = viewProvider;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        SelectedFile saveFile;
        if (!this.viewProvider.hasView()) {
            ProfilerDialogs.displayError((String)NO_VIEW_MSG);
            return;
        }
        final LiveResultsWindow lrw = this.viewProvider instanceof LiveResultsWindow ? (LiveResultsWindow)this.viewProvider : null;
        final AppStatusHandler statusHandler = Profiler.getDefault().getTargetAppRunner().getAppStatusHandler();
        if (lrw != null) {
            statusHandler.pauseLiveUpdates();
        }
        if ((saveFile = this.selectSnapshotTargetFile(this.viewProvider)) == null) {
            if (lrw != null) {
                statusHandler.resumeLiveUpdates();
            }
            return;
        }
        final File file = saveFile.getSelectedFile();
        if (!this.checkFileExists(file)) {
            if (lrw != null) {
                statusHandler.resumeLiveUpdates();
            }
            return;
        }
        final boolean visibleArea = saveFile.visibleArea;
        final BufferedImage bImage = saveFile.image;
        saveFile = null;
        this.image = null;
        this.imagePreview.reset();
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle pHandle = null;
                try {
                    BufferedImage img;
                    pHandle = ProgressHandleFactory.createHandle((String)SAVING_VIEW_MSG);
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    BufferedImage bufferedImage = img = bImage == null ? SaveViewAction.this.viewProvider.getViewImage(visibleArea) : bImage;
                    if (img != null) {
                        FileImageOutputStream stream = new FileImageOutputStream(file);
                        ImageIO.write((RenderedImage)img, "png", stream);
                        stream.close();
                    }
                }
                catch (OutOfMemoryError e) {
                    ProfilerDialogs.displayError((String)OOME_SAVING_MSG);
                }
                catch (IOException ex) {
                    ProfilerDialogs.displayError((String)NbBundle.getMessage(SaveViewAction.class, (String)"ExportAction_FileWriteErrorMsg", (Object)file.getAbsolutePath()));
                }
                finally {
                    if (bImage != null) {
                        bImage.flush();
                    }
                    if (pHandle != null) {
                        pHandle.finish();
                    }
                    if (lrw != null) {
                        statusHandler.resumeLiveUpdates();
                    }
                }
            }
        });
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(SAVE_DIALOG_TITLE);
            this.fileChooser.setApproveButtonText(SAVE_DIALOG_BUTTON);
            this.fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".png") || f.getName().endsWith(".PNG");
                }

                @Override
                public String getDescription() {
                    return SAVE_DIALOG_FILTER;
                }
            });
            JLabel previewLabel = new JLabel(SAVE_DIALOG_PREVIEW);
            previewLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 5, 0));
            this.imagePreview = new ImagePreviewPanel();
            this.imagePreview.reset();
            this.imagePreview.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
            this.visibleAreaCheckBox = new JCheckBox(SAVE_DIALOG_VISIBLE);
            this.visibleAreaCheckBox.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 0));
            this.visibleAreaCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SaveViewAction.this.image = null;
                    SaveViewAction.this.imagePreview.clearImage();
                    SaveViewAction.this.visibleArea = SaveViewAction.this.visibleAreaCheckBox.isSelected();
                    SaveViewAction.this.imagePreview.setImage(new ImagePreviewPanel.ImageProvider(){

                        @Override
                        public BufferedImage getImage() {
                            SaveViewAction.this.image = SaveViewAction.this.viewProvider.getViewImage(SaveViewAction.this.visibleArea);
                            return SaveViewAction.this.image;
                        }
                    });
                }
            });
            JPanel accessoryPanel = new JPanel(new BorderLayout());
            accessoryPanel.add((Component)previewLabel, "North");
            accessoryPanel.add((Component)this.imagePreview, "Center");
            accessoryPanel.add((Component)this.visibleAreaCheckBox, "South");
            this.fileChooser.setAccessory(accessoryPanel);
        }
        return this.fileChooser;
    }

    private boolean checkFileExists(File file) {
        if (file.exists()) {
            if (!ProfilerDialogs.displayConfirmation((String)MessageFormat.format(OVERWRITE_FILE_CAPTION, file.getName()), (String)OVERWRITE_FILE_CAPTION)) {
                return false;
            }
            if (!file.delete()) {
                ProfilerDialogs.displayError((String)MessageFormat.format(CANNOT_OVERWRITE_FILE_MSG, file.getName()));
                return false;
            }
        }
        return true;
    }

    private SelectedFile selectSnapshotTargetFile(final ViewProvider viewProvider) {
        String targetName;
        File targetDir;
        String defaultName = viewProvider.getViewName();
        JFileChooser chooser = this.getFileChooser();
        if (exportDir != null) {
            chooser.setCurrentDirectory(exportDir);
        }
        this.visibleAreaCheckBox.setSelected(true);
        this.visibleAreaCheckBox.setEnabled(!viewProvider.fitsVisibleArea());
        this.image = null;
        this.imagePreview.clearImage();
        this.visibleArea = this.visibleAreaCheckBox.isSelected();
        this.imagePreview.setImage(new ImagePreviewPanel.ImageProvider(){

            @Override
            public BufferedImage getImage() {
                SaveViewAction.this.image = viewProvider.getViewImage(true);
                return SaveViewAction.this.image;
            }
        });
        int result = chooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
        this.imagePreview.reset();
        if (result != 0) {
            this.image = null;
            this.imagePreview.reset();
            return null;
        }
        File file = chooser.getSelectedFile();
        String targetExt = "png";
        if (file.isDirectory()) {
            exportDir = chooser.getCurrentDirectory();
            targetDir = file;
            targetName = defaultName;
        } else {
            targetDir = exportDir = chooser.getCurrentDirectory();
            String fName = file.getName();
            int idx = fName.lastIndexOf(".");
            if (idx == -1) {
                targetName = fName;
            } else {
                targetName = fName.substring(0, idx);
                targetExt = fName.substring(idx + 1);
            }
        }
        return new SelectedFile(targetDir, targetName, targetExt, this.image, this.visibleArea);
    }

    private static class SelectedFile {
        BufferedImage image;
        File folder;
        String fileExt;
        String fileName;
        boolean visibleArea;

        SelectedFile(File folder, String fileName, String fileExt, BufferedImage image, boolean visibleArea) {
            this.folder = folder;
            this.fileName = fileName;
            this.fileExt = fileExt;
            this.image = image;
            this.visibleArea = visibleArea;
        }

        File getSelectedFile() {
            return new File(this.folder + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    static interface ViewProvider {
        public BufferedImage getViewImage(boolean var1);

        public String getViewName();

        public boolean fitsVisibleArea();

        public boolean hasView();
    }
}

