/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.ClassHistoryDataManager;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.LiveResultsWindowContributor;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CodeRegionLivePanel;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.LiveFlatProfilePanel;
import org.netbeans.lib.profiler.ui.graphs.AllocationsHistoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.LivenessHistoryGraphPanel;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryActionsHandler;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryModels;
import org.netbeans.lib.profiler.ui.memory.LiveAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.LiveLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.Delegate;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class LiveResultsWindow
extends TopComponent
implements ProfilingStateListener,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.LiveResultsWindow");
    private static final String UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsAutomaticallyTooltip");
    private static final String UPDATE_RESULTS_NOW_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsNowTooltip");
    private static final String RUN_GC_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_RunGCTooltip");
    private static final String NO_PROFILING_RESULTS_LABEL_TEXT = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_NoProfilingResultsLabelText");
    private static final String ERROR_DISPLAYING_STACK_TRACES_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingStackTracesMsg");
    private static final String ERROR_DISPLAYING_CALL_GRAPH_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingCallGraphMsg");
    private static final String ERROR_INSTRUMENTING_ROOT_METHOD_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorInstrumentingRootMethodMsg");
    private static final String LIVE_RESULTS_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsTabName");
    private static final String HISTORY_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_HistoryTabName");
    private static final String LIVE_RESULTS_ACCESS_DESCR = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsAccessDescr");
    private static final String LOGGING_CONFIRMATION_CAPTION = NbBundle.getMessage(LiveResultsWindow.class, (String)"History_LoggingConfirmationCaption");
    private static final String LOGGING_RESET_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"History_LoggingResetMsg");
    private static final String LOGGING_STOP_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"History_LoggingStopMsg");
    private static final String HELP_CTX_KEY = "LiveResultsWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("LiveResultsWindow.HelpCtx");
    private static LiveResultsWindow defaultLiveInstance;
    private static final TargetAppRunner runner;
    private static final Image liveWindowIcon;
    private static final AtomicBoolean resultsDumpForced;
    private CPUResUserActionsHandler cpuActionsHandler;
    private Component lastFocusOwner;
    private EmptyLiveResultsPanel noResultsPanel;
    private JButton runGCButton;
    private JButton updateNowButton;
    private JPanel currentDisplayComponent;
    private JPanel memoryTabPanel;
    private JTabbedPane tabs;
    private JToggleButton autoToggle;
    private JToolBar.Separator graphButtonsSeparator;
    private List<JButton> chartActions = new ArrayList<JButton>();
    private JPanel historyPanel;
    private ClassHistoryDataManager classHistoryManager;
    private ClassHistoryModels classHistoryModels;
    private AllocationsHistoryGraphPanel allocationsHistoryPanel;
    private LivenessHistoryGraphPanel livenessHistoryPanel;
    private JToolBar toolBar;
    private LiveResultsPanel currentDisplay;
    private MemoryResUserActionsHandler memoryActionsHandler;
    private HistoryActionsHandler historyActionsHandler;
    private boolean autoRefresh = true;
    private volatile boolean profilerRunning = false;
    private volatile boolean resultsAvailable = false;
    private volatile boolean resultsAvailableinTA = false;
    private Listener listener;
    private final AtomicLong autoRefreshRequested = new AtomicLong(0L);

    public LiveResultsWindow() {
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                LiveResultsWindow.this.initUI();
                LiveResultsWindow.this.listener = (Listener)Lookup.getDefault().lookup(Listener.class);
                LiveResultsWindow.this.listener.setDelegate(LiveResultsWindow.this);
            }
        });
    }

    private void initUI() {
        this.setName(NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
        this.setIcon(liveWindowIcon);
        this.getAccessibleContext().setAccessibleDescription(LIVE_RESULTS_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        this.memoryActionsHandler = new MemoryActionsHandler();
        this.historyActionsHandler = new HistoryActionsHandler();
        this.cpuActionsHandler = new CPUActionsHandler();
        this.classHistoryManager = new ClassHistoryDataManager();
        this.classHistoryModels = new ClassHistoryModels(this.classHistoryManager);
        this.toolBar = this.createToolBar();
        this.add(this.toolBar, "North");
        this.noResultsPanel = new EmptyLiveResultsPanel();
        this.noResultsPanel.setLayout(new BorderLayout());
        this.noResultsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel noResultsLabel = new JLabel(NO_PROFILING_RESULTS_LABEL_TEXT);
        noResultsLabel.setFont(noResultsLabel.getFont().deriveFont(14));
        noResultsLabel.setIcon(Icons.getIcon((String)"ProfilerIcons.Monitoring32"));
        noResultsLabel.setIconTextGap(10);
        noResultsLabel.setEnabled(false);
        this.noResultsPanel.add((Component)noResultsLabel, "North");
        this.currentDisplay = null;
        this.currentDisplayComponent = this.noResultsPanel;
        this.add(this.noResultsPanel, "Center");
        this.memoryTabPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.graphButtonsSeparator = new JToolBar.Separator();
        this.toolBar.add(this.graphButtonsSeparator);
        final int chartButtonsOffset = this.toolBar.getComponentCount();
        this.memoryTabPanel.add((Component)this.tabs, "Center");
        this.tabs.setTabPlacement(3);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LiveResultsWindow.this.currentDisplayComponent == LiveResultsWindow.this.memoryTabPanel) {
                    if (LiveResultsWindow.this.tabs.getSelectedComponent() == LiveResultsWindow.this.historyPanel) {
                        for (JButton b : LiveResultsWindow.this.chartActions) {
                            LiveResultsWindow.this.toolBar.add((Component)b, chartButtonsOffset);
                        }
                        LiveResultsWindow.this.graphButtonsSeparator.setVisible(true);
                    } else {
                        for (JButton b : LiveResultsWindow.this.chartActions) {
                            LiveResultsWindow.this.toolBar.remove(b);
                        }
                        LiveResultsWindow.this.graphButtonsSeparator.setVisible(false);
                    }
                }
            }
        });
        this.historyPanel = new JPanel(new BorderLayout());
        this.hideContributors();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public static LiveResultsWindow getDefault() {
        if (!LiveResultsWindow.hasDefault()) {
            defaultLiveInstance = Singleton.INSTANCE;
        }
        return defaultLiveInstance;
    }

    public static void setPaused(boolean value) {
    }

    public static void closeIfOpened() {
        if (LiveResultsWindow.hasDefault()) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (defaultLiveInstance.isOpened()) {
                        defaultLiveInstance.close();
                    }
                }
            });
        }
    }

    public static boolean hasDefault() {
        return defaultLiveInstance != null;
    }

    public void setAutoRefresh(boolean value) {
        if (this.autoRefresh != value) {
            this.autoRefresh = value;
            this.autoToggle.setSelected(value);
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public int getPersistenceType() {
        return 2;
    }

    public int getSortingColumn() {
        if (this.currentDisplay == null) {
            return -1;
        }
        return this.currentDisplay.getSortingColumn();
    }

    public boolean getSortingOrder() {
        if (this.currentDisplay == null) {
            return false;
        }
        return this.currentDisplay.getSortingOrder();
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return UIUtils.createScreenshot((Component)this.historyPanel);
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewImage(onlyVisibleArea);
    }

    @Override
    public String getViewName() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return "memory-history-" + this.classHistoryManager.getTrackedClassName();
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewName();
    }

    public void componentActivated() {
        super.componentActivated();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.currentDisplayComponent != null) {
            this.currentDisplayComponent.requestFocus();
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public boolean fitsVisibleArea() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return true;
        }
        return this.currentDisplay != null && this.currentDisplay.fitsVisibleArea();
    }

    public void handleShutdown() {
        this.profilerRunning = false;
        if (this.isShowing()) {
            this.hideContributors();
            this.requestProfilingDataUpdate(false);
        }
    }

    public void handleStartup() {
        this.profilerRunning = true;
    }

    public void handleCleanupBeforeProfiling() {
        this.classHistoryManager.resetClass();
    }

    @Override
    public boolean hasView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    public void ideClosing() {
        this.hideContributors();
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
        this.requestProfilingDataUpdate(false);
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        this.updateActions(e.getNewState());
        switch (e.getNewState()) {
            case 1: {
                this.handleShutdown();
                break;
            }
            case 4: {
                this.handleStartup();
            }
        }
    }

    public boolean refreshLiveResults() {
        if (this.isAutoRefresh() && this.isShowing()) {
            this.requestProfilingDataUpdate(false);
            return true;
        }
        if (NetBeansProfiler.getDefaultNB().processesProfilingPoints()) {
            this.callForceObtainedResultsDump(runner.getProfilerClient(), false);
        }
        return false;
    }

    public void threadsMonitoringChanged() {
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        if (this.currentDisplayComponent == this.memoryTabPanel) {
            if (this.tabs.getSelectedComponent() instanceof LiveAllocResultsPanel) {
                ((LiveAllocResultsPanel)this.currentDisplay).exportData(exportedFileType, eDD, NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
            } else if (this.tabs.getSelectedComponent() instanceof LiveLivenessResultsPanel) {
                ((LiveLivenessResultsPanel)this.currentDisplay).exportData(exportedFileType, eDD, NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
            }
        } else if (this.currentDisplayComponent instanceof LiveFlatProfilePanel) {
            ((LiveFlatProfilePanel)this.currentDisplay).exportData(exportedFileType, eDD, NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return false;
    }

    @Override
    public boolean hasExportableView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.currentDisplay) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.hideContributors();
    }

    protected void componentOpened() {
        super.componentOpened();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.updateResultsDisplay();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    void reset() {
        this.resultsAvailable = false;
        if (this.currentDisplay != null) {
            this.currentDisplay.reset();
            this.resetResultsDisplay();
        }
        this.resetContributors();
    }

    private boolean callForceObtainedResultsDump(ProfilerClient client) {
        return this.callForceObtainedResultsDump(client, true);
    }

    private boolean callForceObtainedResultsDump(ProfilerClient client, boolean refreshDisplay) {
        if (!this.resultsAvailableinTA) {
            return false;
        }
        if (refreshDisplay) {
            resultsDumpForced.set(true);
        }
        try {
            if (client.getCurrentInstrType() != 1) {
                client.forceObtainedResultsDump(true);
            }
            return true;
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            return false;
        }
    }

    private boolean isProfiling() {
        return runner.getProfilerClient().getCurrentInstrType() != 0;
    }

    private static boolean checkIfResultsExist(ProfilerClient client, int currentInstrType) {
        switch (currentInstrType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return LiveResultsWindow.getDefault().resultsAvailable;
            }
            case 1: {
                try {
                    return client.cpuResultsExist();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    return false;
                }
            }
        }
        return false;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar(){

            @Override
            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
                }
                return super.add(comp);
            }
        };
        toolBar.setFloatable(false);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.autoToggle = new JToggleButton(Icons.getIcon((String)"GeneralIcons.UpdateAuto"));
        this.autoToggle.setSelected(true);
        this.autoToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveResultsWindow.this.autoRefresh = LiveResultsWindow.this.autoToggle.isSelected();
            }
        });
        this.autoToggle.setToolTipText(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.autoToggle.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.updateNowButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow"));
        this.updateNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.updateNowButton.setToolTipText(UPDATE_RESULTS_NOW_TOOLTIP);
        this.updateNowButton.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_NOW_TOOLTIP);
        this.runGCButton = new JButton(Icons.getIcon((String)"ProfilerIcons.RunGC"));
        this.runGCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    runner.runGC();
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    ProfilerDialogs.displayError((String)ex.getMessage());
                    ProfilerLogger.log((Exception)((Object)ex));
                }
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.runGCButton.setToolTipText(RUN_GC_TOOLTIP);
        this.runGCButton.getAccessibleContext().setAccessibleName(RUN_GC_TOOLTIP);
        toolBar.add(this.autoToggle);
        toolBar.add(this.updateNowButton);
        toolBar.add(this.runGCButton);
        toolBar.add(ResetResultsAction.getInstance());
        toolBar.addSeparator();
        toolBar.add(((Presenter.Toolbar)SystemAction.get(TakeSnapshotAction.class)).getToolbarPresenter());
        toolBar.addSeparator();
        toolBar.add(new ExportAction(this, null));
        toolBar.add(new SaveViewAction(this));
        return toolBar;
    }

    private LiveResultsPanel preparePanelForInstrType(int instrumentationType) {
        CodeRegionLivePanel aPanel = null;
        switch (instrumentationType) {
            case 5: {
                LiveAllocResultsPanel allocPanel = new LiveAllocResultsPanel(runner, this.memoryActionsHandler, (ClassHistoryActionsHandler)this.historyActionsHandler, this.classHistoryManager);
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)allocPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.historyPanel);
                this.tabs.setEnabledAt(1, false);
                aPanel = allocPanel;
                break;
            }
            case 6: {
                LiveLivenessResultsPanel livenessPanel = new LiveLivenessResultsPanel(runner, this.memoryActionsHandler, (ClassHistoryActionsHandler)this.historyActionsHandler, this.classHistoryManager);
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)livenessPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.historyPanel);
                this.tabs.setEnabledAt(1, false);
                aPanel = livenessPanel;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Lookup.Provider project = NetBeansProfiler.getDefaultNB().getProfiledProject();
                LiveFlatProfilePanel cpuPanel = new LiveFlatProfilePanel(runner, this.cpuActionsHandler);
                for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
                    c.addToCpuResults(cpuPanel, this.toolBar, runner.getProfilerClient(), project);
                }
                this.currentDisplayComponent = cpuPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                aPanel = cpuPanel;
                break;
            }
            case 1: {
                CodeRegionLivePanel regionPanel = new CodeRegionLivePanel(runner.getProfilerClient());
                this.currentDisplayComponent = regionPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                aPanel = regionPanel;
                break;
            }
            case 0: {
                throw new IllegalStateException();
            }
        }
        return aPanel;
    }

    private void requestProfilingDataUpdate(final boolean force) {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!LiveResultsWindow.this.isAutoRefresh() && !force) {
                    return;
                }
                if (!LiveResultsWindow.this.isProfiling() || !LiveResultsWindow.this.isOpened()) {
                    return;
                }
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LiveResultsWindow.this.autoRefreshRequested.incrementAndGet();
                        LiveResultsWindow.this.callForceObtainedResultsDump(runner.getProfilerClient());
                    }
                });
            }
        });
    }

    private void resetResultsDisplay() {
        if (this.currentDisplayComponent != null && this.currentDisplayComponent != this.noResultsPanel) {
            this.remove(this.currentDisplayComponent);
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            this.add(this.noResultsPanel, "Center");
            for (JButton b : this.chartActions) {
                this.toolBar.remove(b);
            }
            this.graphButtonsSeparator.setVisible(false);
            this.revalidate();
            this.repaint();
            this.hideContributors();
        }
    }

    private void updateActions(int newState) {
        this.runGCButton.setEnabled(newState == 4);
        this.updateNowButton.setEnabled(newState == 4);
    }

    private void refresh() {
        if (LOGGER.isLoggable(Level.FINE) && this.currentDisplayComponent != null) {
            LOGGER.log(Level.FINE, "refreshing contributors for drilldown: {0}", this.currentDisplayComponent.getClass().getName());
        }
        this.refreshContributors();
        if (this.profilerRunning && this.currentDisplayComponent instanceof LiveFlatProfilePanel) {
            LOGGER.fine("Showing contributors");
            if (this.isVisible()) {
                this.showContributors();
            }
        } else {
            LOGGER.fine("Hiding contributors");
            this.hideContributors();
        }
    }

    private void updateResultsDisplay() {
        if (!this.isOpened()) {
            return;
        }
        if (!this.resultsAvailable) {
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            return;
        }
        int instrType = runner.getProfilerClient().getCurrentInstrType();
        if (instrType != 0) {
            boolean instrSupported;
            boolean bl = instrSupported = this.currentDisplayComponent != null && this.currentDisplay != null && this.currentDisplay.supports(instrType);
            if (!instrSupported) {
                if (this.currentDisplayComponent != null) {
                    this.remove(this.currentDisplayComponent);
                }
                if (this.currentDisplay != null) {
                    this.currentDisplay.handleRemove();
                }
                this.currentDisplay = this.preparePanelForInstrType(instrType);
                this.add(this.currentDisplayComponent, "Center");
                this.revalidate();
                this.repaint();
                CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LiveResultsWindow.this.currentDisplayComponent.requestFocusInWindow();
                    }
                });
            }
            if (this.currentDisplay != null) {
                this.currentDisplay.updateLiveResults();
            }
        }
        this.refresh();
    }

    private void hideContributors() {
        for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            c.hide();
        }
    }

    private void showContributors() {
        for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            c.show();
        }
    }

    private void refreshContributors() {
        for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            c.refresh();
        }
    }

    private void resetContributors() {
        for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            c.reset();
        }
    }

    static {
        runner = Profiler.getDefault().getTargetAppRunner();
        liveWindowIcon = Icons.getImage((String)"ProfilerIcons.WindowLiveResults");
        resultsDumpForced = new AtomicBoolean(false);
    }

    private static class Singleton {
        private static final LiveResultsWindow INSTANCE = new LiveResultsWindow();

        private Singleton() {
        }
    }

    private final class HistoryActionsHandler
    implements ClassHistoryActionsHandler {
        private HistoryActionsHandler() {
        }

        public void showClassHistory(int classID, final String className) {
            int currentlyTrackedClass = LiveResultsWindow.this.classHistoryManager.getTrackedClassID();
            String currentlyTrackedClassName = LiveResultsWindow.this.classHistoryManager.getTrackedClassName();
            if (currentlyTrackedClass != -1 && (classID == currentlyTrackedClass ? !ProfilerDialogs.displayConfirmationDNSA((String)MessageFormat.format(LOGGING_RESET_MSG, currentlyTrackedClassName), (String)LOGGING_CONFIRMATION_CAPTION, null, (String)"History.historylogging.reset", (boolean)true) : !ProfilerDialogs.displayConfirmationDNSA((String)MessageFormat.format(LOGGING_STOP_MSG, currentlyTrackedClassName), (String)LOGGING_CONFIRMATION_CAPTION, null, (String)"History.historylogging.stop", (boolean)true))) {
                return;
            }
            LiveResultsWindow.this.classHistoryManager.setupClass(classID, className);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LiveResultsWindow.this.chartActions.clear();
                    Action[] actions = null;
                    if (runner.getProfilerClient().getCurrentInstrType() == 5) {
                        if (LiveResultsWindow.this.allocationsHistoryPanel == null) {
                            LiveResultsWindow.this.allocationsHistoryPanel = AllocationsHistoryGraphPanel.createPanel((ClassHistoryModels)LiveResultsWindow.this.classHistoryModels);
                        }
                        LiveResultsWindow.this.historyPanel.removeAll();
                        LiveResultsWindow.this.historyPanel.add((Component)LiveResultsWindow.this.allocationsHistoryPanel, "Center");
                        actions = LiveResultsWindow.this.allocationsHistoryPanel.getActions();
                    } else if (runner.getProfilerClient().getCurrentInstrType() == 6) {
                        if (LiveResultsWindow.this.livenessHistoryPanel == null) {
                            LiveResultsWindow.this.livenessHistoryPanel = LivenessHistoryGraphPanel.createPanel((ClassHistoryModels)LiveResultsWindow.this.classHistoryModels);
                        }
                        LiveResultsWindow.this.historyPanel.removeAll();
                        LiveResultsWindow.this.historyPanel.add((Component)LiveResultsWindow.this.livenessHistoryPanel, "Center");
                        actions = LiveResultsWindow.this.livenessHistoryPanel.getActions();
                    }
                    if (actions != null) {
                        for (void var5_5 : actions) {
                            LiveResultsWindow.this.chartActions.add(new JButton((Action)var5_5));
                        }
                    }
                    Collections.reverse(LiveResultsWindow.this.chartActions);
                    LiveResultsWindow.this.tabs.setEnabledAt(1, true);
                    LiveResultsWindow.this.tabs.setTitleAt(1, NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ClassHistoryTabName", (Object[])new Object[]{className}));
                    LiveResultsWindow.this.tabs.setSelectedIndex(1);
                }
            });
        }
    }

    private static final class MemoryActionsHandler
    implements MemoryResUserActionsHandler {
        private MemoryActionsHandler() {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            if (methodName == null && methodSig == null && (VMUtils.isVMPrimitiveType((String)className) || VMUtils.isPrimitiveType((String)className))) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(className) && "traceVMObjectAlloc".equals(methodName)) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                GoToSource.openSource((Lookup.Provider)NetBeansProfiler.getDefaultNB().getProfiledProject(), (String)className, (String)methodName, (String)methodSig);
            }
        }

        public void showStacksForClass(final int selectedClassId, final int sortingColumn, final boolean sortingOrder) {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    final LoadedSnapshot ls = ResultsManager.getDefault().takeSnapshot();
                    if (ls != null) {
                        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SnapshotResultsWindow srw = SnapshotResultsWindow.get(ls, sortingColumn, sortingOrder);
                                if (srw != null) {
                                    srw.displayStacksForClass(selectedClassId, sortingColumn, sortingOrder);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(String className, String methodName, String methodSig) {
            ProfilingSettings settingsToModify;
            Lookup.Provider project = NetBeansProfiler.getDefaultNB().getProfiledProject();
            ProfilingSettings[] projectSettings = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)project).getProfilingSettings();
            ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
            for (ProfilingSettings settings : projectSettings) {
                if (!ProfilingSettings.isCPUSettings((int)settings.getProfilingType())) continue;
                cpuSettings.add(settings);
            }
            ProfilingSettings lastProfilingSettings = null;
            String lastProfilingSettingsName = Profiler.getDefault().getLastProfilingSettings().getSettingsName();
            for (ProfilingSettings settings : cpuSettings) {
                if (!settings.getSettingsName().equals(lastProfilingSettingsName)) continue;
                lastProfilingSettings = settings;
                break;
            }
            if ((settingsToModify = IDEUtils.selectSettings(16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), lastProfilingSettings)) == null) {
                return;
            }
            settingsToModify.addRootMethod(className, methodName, methodSig);
            if (cpuSettings.contains(settingsToModify)) {
                ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])projectSettings, (ProfilingSettings)settingsToModify, (Lookup.Provider)project);
            } else {
                ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                newProjectSettings[projectSettings.length] = settingsToModify;
                ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])newProjectSettings, (ProfilingSettings)settingsToModify, (Lookup.Provider)project);
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot snapshot, int threadId, int methodId, int view, int sortingColumn, boolean sortingOrder) {
            throw new IllegalStateException(ERROR_DISPLAYING_CALL_GRAPH_MSG);
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            GoToSource.openSource((Lookup.Provider)NetBeansProfiler.getDefaultNB().getProfiledProject(), (String)className, (String)methodName, (String)methodSig);
        }

        public void viewChanged(int viewType) {
            if (LiveResultsWindow.this.currentDisplay != null) {
                ((FlatProfilePanel)LiveResultsWindow.this.currentDisplay).prepareResults();
            }
        }
    }

    public static final class ResultsMonitor
    implements CPUCCTProvider.Listener,
    MemoryCCTProvider.Listener {
        public void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean empty) {
            if (!empty) {
                LiveResultsWindow.getDefault().resultsAvailable = true;
                if (resultsDumpForced.getAndSet(false) && LiveResultsWindow.getDefault().autoRefreshRequested.getAndDecrement() > 0L) {
                    CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LiveResultsWindow.getDefault().updateResultsDisplay();
                        }
                    });
                } else {
                    LiveResultsWindow.getDefault().autoRefreshRequested.compareAndSet(-1L, 0L);
                }
            } else {
                resultsDumpForced.set(false);
            }
        }

        public void cctReset() {
            LiveResultsWindow.getDefault().resultsAvailable = false;
        }
    }

    public static final class EmptyLiveResultsPanel
    extends JPanel
    implements LiveResultsPanel {
        public int getSortingColumn() {
            return -1;
        }

        public boolean getSortingOrder() {
            return true;
        }

        public BufferedImage getViewImage(boolean b) {
            throw new UnsupportedOperationException();
        }

        public String getViewName() {
            return "Empty live results";
        }

        public boolean fitsVisibleArea() {
            return false;
        }

        public void handleRemove() {
        }

        public void handleShutdown() {
        }

        public boolean hasView() {
            return false;
        }

        public void reset() {
        }

        public boolean supports(int instrumentationType) {
            return true;
        }

        public void updateLiveResults() {
        }
    }

    public static class Listener
    extends Delegate<LiveResultsWindow>
    implements ResultsListener {
        @Override
        public void resultsAvailable() {
            LiveResultsWindow.getDefault().resultsAvailableinTA = true;
        }

        @Override
        public void resultsReset() {
            LiveResultsWindow.getDefault().resultsAvailableinTA = false;
            if (this.getDelegate() != null) {
                ((LiveResultsWindow)this.getDelegate()).reset();
            }
        }
    }
}

