/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.core.startup.layers.Bundle;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class SystemFileSystem
extends MultiFileSystem
implements FileChangeListener {
    static final long serialVersionUID = -7761052280240991668L;
    private static final String SYSTEM_NAME = "SystemFileSystem";
    private static final Logger LOG = Logger.getLogger(SystemFileSystem.class.getName());
    private ModuleLayeredFileSystem user;
    private ModuleLayeredFileSystem home;

    private SystemFileSystem(FileSystem[] fss) throws PropertyVetoException {
        super(fss);
        this.user = (ModuleLayeredFileSystem)fss[0];
        this.home = fss.length > 1 ? (ModuleLayeredFileSystem)fss[1] : null;
        this.setSystemName(SYSTEM_NAME);
        this.setHidden(true);
        this.addFileChangeListener(this);
    }

    public String getDisplayName() {
        return Bundle.CTL_SystemFileSystem();
    }

    public ModuleLayeredFileSystem getInstallationLayer() {
        return this.home;
    }

    public ModuleLayeredFileSystem getUserLayer() {
        return this.user;
    }

    public final void setLayers(FileSystem[] arr) throws IllegalArgumentException {
        HashSet<FileSystem> s = new HashSet<FileSystem>();
        for (int i = 0; i < arr.length; ++i) {
            if (s.contains(arr[i])) {
                throw new IllegalArgumentException("Overlap in filesystem layers");
            }
            s.add(arr[i]);
        }
        this.setDelegates((FileSystem[])arr.clone());
        this.firePropertyChange("layers", null, null);
    }

    public FileSystem[] getLayers() {
        return (FileSystem[])this.getDelegates().clone();
    }

    protected FileSystem createWritableOnForRename(String oldName, String newName) throws IOException {
        return this.createWritableOn(oldName);
    }

    protected FileSystem createWritableOn(String name) throws IOException {
        FileSystem[] fss = this.getDelegates();
        for (int index = 0; index < fss.length; ++index) {
            if (fss[index].isReadOnly()) continue;
            return fss[index];
        }
        throw new IOException("No writable filesystems in our delegates");
    }

    protected Set<? extends FileSystem> createLocksOn(String name) throws IOException {
        LocalFileSystemEx.potentialLock(name);
        return super.createLocksOn(name);
    }

    @Deprecated
    public boolean isPersistent() {
        return true;
    }

    static SystemFileSystem create(File userDir, File homeDir, File[] extradirs) throws PropertyVetoException, IOException {
        LocalFileSystemEx home;
        Object user;
        String customFSClass = System.getProperty("org.netbeans.core.systemfilesystem.custom");
        if (customFSClass != null) {
            try {
                Class<?> clazz = Class.forName(customFSClass);
                Object instance = clazz.newInstance();
                user = (FileSystem)instance;
            }
            catch (Exception x) {
                ModuleLayeredFileSystem.err.log(Level.WARNING, "Custom system file system writable layer init failed ", x);
                user = FileUtil.createMemoryFileSystem();
            }
        } else if (userDir != null) {
            if (!userDir.exists()) {
                userDir.mkdirs();
            }
            LocalFileSystemEx l = new LocalFileSystemEx(true);
            l.setRootDirectory(userDir);
            user = l;
        } else {
            user = FileUtil.createMemoryFileSystem();
        }
        if (homeDir == null || !homeDir.isDirectory()) {
            home = null;
        } else {
            home = new LocalFileSystemEx();
            home.setRootDirectory(homeDir);
            home.setReadOnly(true);
        }
        LocalFileSystem[] extras = new LocalFileSystem[extradirs.length];
        for (int i = 0; i < extradirs.length; ++i) {
            extras[i] = new LocalFileSystemEx();
            extras[i].setRootDirectory(extradirs[i]);
            extras[i].setReadOnly(true);
        }
        FileSystem[] arr = new FileSystem[home == null ? 1 : 2];
        arr[0] = new ModuleLayeredFileSystem((FileSystem)user, true, new FileSystem[0], false);
        if (home != null) {
            arr[1] = new ModuleLayeredFileSystem((FileSystem)home, false, (FileSystem[])extras, true);
        }
        return new SystemFileSystem(arr);
    }

    protected void notifyMigration(FileObject fo) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fo, false, true));
    }

    public void fileFolderCreated(FileEvent fe) {
        SystemFileSystem.log("fileFolderCreated", fe);
    }

    public void fileDataCreated(FileEvent fe) {
        SystemFileSystem.log("fileDataCreated", fe);
    }

    public void fileChanged(FileEvent fe) {
        SystemFileSystem.log("fileChanged", fe);
    }

    public void fileDeleted(FileEvent fe) {
        SystemFileSystem.log("fileDeleted", fe);
    }

    public void fileRenamed(FileRenameEvent fe) {
        SystemFileSystem.log("fileDeleted", (FileEvent)fe);
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        SystemFileSystem.log("fileAttributeChanged", (FileEvent)fe);
    }

    private static void log(String type, FileEvent fe) {
        if (LOG.isLoggable(Level.FINER)) {
            LogRecord r = new LogRecord(Level.FINER, "LOG_FILE_EVENT");
            r.setLoggerName(LOG.getName());
            r.setParameters(new Object[]{type, fe.getFile().getPath(), fe.getFile(), fe});
            r.setResourceBundle(NbBundle.getBundle(SystemFileSystem.class));
            LOG.log(r);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        new NotSerializableException("WARNING - SystemFileSystem is not designed to be serialized").printStackTrace();
        return new SingletonSerializer();
    }

    private static final class SingletonSerializer
    implements Serializable {
        private static final long serialVersionUID = 6436781994611L;

        SingletonSerializer() {
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                return FileUtil.getConfigRoot().getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }
}

