/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public final class AutomaticDependencies {
    private static final Logger LOG = Logger.getLogger(AutomaticDependencies.class.getName());
    private final List<TransformationGroup> groups = new ArrayList<TransformationGroup>();

    private AutomaticDependencies() {
    }

    public static AutomaticDependencies empty() {
        return new AutomaticDependencies();
    }

    public static AutomaticDependencies parse(URL[] urls) throws SAXException, IOException {
        LOG.log(Level.FINE, "Parsing automatic dependencies {0}", Arrays.asList(urls));
        AutomaticDependencies h = new AutomaticDependencies();
        Parser p = new Parser(h.new Handler());
        for (URL url : urls) {
            String id = url.toExternalForm();
            InputStream inS = null;
            try {
                InputSource is = new InputSource(id);
                inS = new BufferedInputStream(url.openStream());
                is.setByteStream(inS);
                p.parse(is);
            }
            catch (SAXException e) {
                throw new SAXException("While parsing: " + id, e);
            }
            catch (IOException e) {
                IOException exc = new IOException("While parsing: " + id);
                exc.initCause(e);
                throw exc;
            }
            finally {
                if (inS != null) {
                    inS.close();
                }
            }
        }
        return h;
    }

    public static void main(String[] x) throws Exception {
        URL[] urls = new URL[x.length];
        for (int i = 0; i < x.length; ++i) {
            urls[i] = new URL(x[i]);
        }
        AutomaticDependencies.parse(urls);
        long time = System.currentTimeMillis();
        System.out.println(AutomaticDependencies.parse(urls));
        long taken = System.currentTimeMillis() - time;
        System.out.println("Time taken: " + taken + " msec");
    }

    public Report refineDependenciesAndReport(String cnb, Set<Dependency> dependencies) {
        HashSet<Dependency> oldDependencies = new HashSet<Dependency>(dependencies);
        HashMap<String, Dependency> modDeps = new HashMap<String, Dependency>();
        HashMap<String, Dependency> tokDeps = new HashMap<String, Dependency>();
        HashMap<String, Dependency> pkgDeps = new HashMap<String, Dependency>();
        block6: for (Dependency d : dependencies) {
            switch (d.getType()) {
                case 1: {
                    String dcnb = (String)Util.parseCodeName((String)d.getName())[0];
                    modDeps.put(dcnb, d);
                    continue block6;
                }
                case 2: {
                    String name = AutomaticDependencies.packageBaseName(d.getName());
                    pkgDeps.put(name, d);
                    continue block6;
                }
                case 5: 
                case 6: 
                case 7: {
                    tokDeps.put(d.getName(), d);
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
            throw new IllegalStateException(d.toString());
        }
        TreeSet<String> messages = new TreeSet<String>();
        for (TransformationGroup g : this.groups) {
            if (g.isExcluded(cnb)) continue;
            HashSet<Dependency> oldRunningDependencies = new HashSet<Dependency>(dependencies);
            for (Transformation t : g.transformations) {
                t.apply(modDeps, tokDeps, pkgDeps, dependencies);
            }
            if (((Object)oldRunningDependencies).equals(dependencies)) continue;
            messages.add(g.description);
        }
        if (!((Object)oldDependencies).equals(dependencies)) {
            assert (!messages.isEmpty());
            HashSet<Dependency> added = new HashSet<Dependency>(dependencies);
            added.removeAll(oldDependencies);
            oldDependencies.removeAll(dependencies);
            return new Report(cnb, added, oldDependencies, messages);
        }
        assert (messages.isEmpty());
        return new Report(cnb, Collections.<Dependency>emptySet(), Collections.<Dependency>emptySet(), Collections.<String>emptySet());
    }

    public void refineDependencies(String cnb, Set<Dependency> dependencies) {
        this.refineDependenciesAndReport(cnb, dependencies);
    }

    public String refineDependenciesSimple(String cnb, Set<String> dependencies) {
        HashSet<Dependency> deps = new HashSet<Dependency>();
        for (String d : dependencies) {
            deps.addAll(Dependency.create((int)1, (String)d));
        }
        Report r = this.refineDependenciesAndReport(cnb, deps);
        if (r.isModified()) {
            dependencies.clear();
            for (Dependency d : deps) {
                dependencies.add(d.toString().replaceFirst("^module ", ""));
            }
            return r.toString();
        }
        return null;
    }

    public String toString() {
        return "AutomaticDependencies[" + this.groups + "]";
    }

    private static String packageBaseName(String name) {
        int i = name.indexOf(91);
        if (i == -1) {
            return name;
        }
        if (i > 0) {
            return name.substring(0, i);
        }
        int i2 = name.lastIndexOf(46);
        return name.substring(1, i2);
    }

    private static final class Parser
    implements ContentHandler,
    ErrorHandler,
    EntityResolver {
        private StringBuffer buffer;
        private Handler handler;
        private Stack<Object[]> context;

        public Parser(Handler handler) {
            this.handler = handler;
            this.buffer = new StringBuffer(111);
            this.context = new Stack();
        }

        @Override
        public final void setDocumentLocator(Locator locator) {
        }

        @Override
        public final void startDocument() throws SAXException {
        }

        @Override
        public final void endDocument() throws SAXException {
        }

        @Override
        public final void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
            this.dispatch(true);
            this.context.push(new Object[]{qname, new AttributesImpl(attrs)});
            if ("trigger-dependency".equals(qname)) {
                this.handler.start_trigger(attrs);
            } else if ("transformation".equals(qname)) {
                this.handler.start_transformation(attrs);
            } else if ("module-dependency".equals(qname)) {
                this.handler.handle_module_dependency(attrs);
            } else if ("transformationgroup".equals(qname)) {
                this.handler.start_transformationgroup(attrs);
            } else if ("result".equals(qname)) {
                this.handler.start_result(attrs);
            } else if ("exclusion".equals(qname)) {
                this.handler.handle_exclusion(attrs);
            } else if ("token-dependency".equals(qname)) {
                this.handler.handle_token_dependency(attrs);
            } else if ("package-dependency".equals(qname)) {
                this.handler.handle_package_dependency(attrs);
            } else if ("transformations".equals(qname)) {
                this.handler.start_transformations(attrs);
            } else if ("implies".equals(qname)) {
                this.handler.start_results(attrs);
            }
        }

        @Override
        public final void endElement(String ns, String name, String qname) throws SAXException {
            this.dispatch(false);
            this.context.pop();
            if ("trigger-dependency".equals(qname)) {
                this.handler.end_trigger();
            } else if ("transformation".equals(qname)) {
                this.handler.end_transformation();
            } else if ("transformationgroup".equals(qname)) {
                this.handler.end_transformationgroup();
            } else if ("result".equals(qname)) {
                this.handler.end_result();
            } else if ("transformations".equals(qname)) {
                this.handler.end_transformations();
            } else if ("implies".equals(qname)) {
                this.handler.end_results();
            }
        }

        @Override
        public final void characters(char[] chars, int start, int len) throws SAXException {
            this.buffer.append(chars, start, len);
        }

        @Override
        public final void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
        }

        @Override
        public final void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public final void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public final void skippedEntity(String name) throws SAXException {
        }

        private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
            if (fireOnlyIfMixed && this.buffer.length() == 0) {
                return;
            }
            Object[] ctx = this.context.peek();
            String here = (String)ctx[0];
            Attributes attrs = (Attributes)ctx[1];
            if ("description".equals(here)) {
                if (fireOnlyIfMixed) {
                    throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
                }
                this.handler.handle_description(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
            }
            this.buffer.delete(0, this.buffer.length());
        }

        public void parse(InputSource input) throws SAXException, IOException {
            XMLReader parser = XMLUtil.createXMLReader((boolean)false, (boolean)false);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.setEntityResolver(this);
            parser.parse(input);
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }

    private final class Handler {
        private TransformationGroup currentGroup = null;
        private Transformation currentTransformation = null;
        private boolean inTrigger = false;

        Handler() {
        }

        public void start_trigger(Attributes meta) throws SAXException {
            this.inTrigger = true;
            this.currentTransformation.triggerType = meta.getValue("type");
        }

        public void end_trigger() throws SAXException {
            this.inTrigger = false;
        }

        public void start_transformation(Attributes meta) throws SAXException {
            this.currentTransformation = new Transformation();
        }

        public void end_transformation() throws SAXException {
            this.currentGroup.transformations.add(this.currentTransformation);
            this.currentTransformation = null;
        }

        private void handleDep(Dep d) throws SAXException {
            if (this.inTrigger) {
                this.currentTransformation.trigger = d;
            } else {
                this.currentTransformation.results.add(d);
            }
        }

        public void handle_module_dependency(Attributes meta) throws SAXException {
            ModuleDep d = new ModuleDep();
            String major = meta.getValue("major");
            if (major != null) {
                d.major = Integer.parseInt(major);
            }
            d.codenamebase = meta.getValue("codenamebase");
            String s = meta.getValue("spec");
            d.spec = s == null ? null : new SpecificationVersion(s);
            this.handleDep(d);
        }

        public void handle_token_dependency(Attributes meta) throws SAXException {
            TokenDep d = new TokenDep();
            d.name = meta.getValue("name");
            this.handleDep(d);
        }

        public void handle_package_dependency(Attributes meta) throws SAXException {
            PackageDep d = new PackageDep();
            d.name = meta.getValue("name");
            d.bname = AutomaticDependencies.packageBaseName(d.name);
            if (this.inTrigger && !d.name.equals(d.bname)) {
                throw new SAXException("Cannot use test class in trigger");
            }
            String s = meta.getValue("spec");
            d.spec = s == null ? null : new SpecificationVersion(s);
            this.handleDep(d);
        }

        public void start_transformationgroup(Attributes meta) throws SAXException {
            this.currentGroup = new TransformationGroup();
        }

        public void end_transformationgroup() throws SAXException {
            AutomaticDependencies.this.groups.add(this.currentGroup);
            this.currentGroup = null;
        }

        public void start_result(Attributes meta) throws SAXException {
        }

        public void end_result() throws SAXException {
        }

        public void handle_exclusion(Attributes meta) throws SAXException {
            Exclusion excl = new Exclusion();
            excl.codenamebase = meta.getValue("codenamebase");
            excl.prefix = Boolean.valueOf(meta.getValue("prefix"));
            this.currentGroup.exclusions.add(excl);
        }

        public void handle_description(String data, Attributes meta) throws SAXException {
            this.currentGroup.description = data;
        }

        public void start_transformations(Attributes meta) throws SAXException {
            if (!"1.0".equals(meta.getValue("version"))) {
                throw new SAXException("Unsupported DTD");
            }
        }

        public void end_transformations() throws SAXException {
        }

        public void start_results(Attributes meta) throws SAXException {
        }

        public void end_results() throws SAXException {
        }
    }

    private static final class TokenDep
    extends Dep {
        public String name;

        @Override
        public String toManifestForm() {
            return this.name;
        }

        @Override
        public String manifestKey() {
            return "OpenIDE-Module-Requires";
        }

        @Override
        public int type() {
            return 5;
        }

        @Override
        public Dependency applies(Map<String, Dependency> modDeps, Map<String, Dependency> tokDeps, Map<String, Dependency> pkgDeps, Set<Dependency> dependencies, String type) {
            Dependency d = tokDeps.get(this.name);
            if (d == null) {
                return null;
            }
            if (type.equals("cancel")) {
                return d;
            }
            throw new IllegalStateException(type);
        }

        @Override
        public void update(Map<String, Dependency> modDeps, Map<String, Dependency> tokDeps, Map<String, Dependency> pkgDeps, Set<Dependency> dependencies) {
            if (tokDeps.get(this.name) == null) {
                dependencies.add(this.createDependency());
            }
        }
    }

    private static final class PackageDep
    extends Dep {
        public String name;
        public String bname;
        public SpecificationVersion spec = null;

        @Override
        public String toManifestForm() {
            return this.name + (this.spec == null ? "" : " > " + this.spec);
        }

        @Override
        public String manifestKey() {
            return "OpenIDE-Module-Package-Dependencies";
        }

        @Override
        public int type() {
            return 2;
        }

        private boolean older(Dependency d) {
            if (d.getType() != 2) {
                throw new IllegalArgumentException();
            }
            if (d.getComparison() == 2) {
                return false;
            }
            if (this.spec == null) {
                return false;
            }
            String dSpec = d.getVersion();
            if (dSpec == null) {
                return true;
            }
            assert (d.getComparison() == 1) : d.getComparison();
            return new SpecificationVersion(dSpec).compareTo((Object)this.spec) < 0;
        }

        @Override
        public Dependency applies(Map<String, Dependency> modDeps, Map<String, Dependency> tokDeps, Map<String, Dependency> pkgDeps, Set<Dependency> dependencies, String type) {
            Dependency d = pkgDeps.get(this.bname);
            if (d == null) {
                return null;
            }
            if (type.equals("cancel")) {
                return d;
            }
            if (type.equals("older")) {
                if (this.spec == null) {
                    throw new IllegalStateException();
                }
                return this.older(d) ? d : null;
            }
            throw new IllegalStateException(type);
        }

        @Override
        public void update(Map<String, Dependency> modDeps, Map<String, Dependency> tokDeps, Map<String, Dependency> pkgDeps, Set<Dependency> dependencies) {
            Dependency d = pkgDeps.get(this.bname);
            if (d != null && this.older(d)) {
                dependencies.remove(d);
                dependencies.add(this.createDependency());
            } else if (d == null) {
                dependencies.add(this.createDependency());
            }
        }
    }

    private static final class ModuleDep
    extends Dep {
        public String codenamebase;
        public int major = -1;
        public SpecificationVersion spec = null;

        @Override
        public String toManifestForm() {
            return this.codenamebase + (this.major == -1 ? "" : "/" + this.major) + (this.spec == null ? "" : " > " + this.spec);
        }

        @Override
        public String manifestKey() {
            return "OpenIDE-Module-Module-Dependencies";
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public Dependency applies(Map<String, Dependency> modDeps, Map<String, Dependency> tokDeps, Map<String, Dependency> pkgDeps, Set<Dependency> dependencies, String type) {
            Dependency d = modDeps.get(this.codenamebase);
            if (d == null) {
                return null;
            }
            if (type.equals("cancel")) {
                return d;
            }
            if (type.equals("older")) {
                return this.older(d) ? d : null;
            }
            throw new IllegalArgumentException(type);
        }

        private boolean older(Dependency d) {
            int dRel;
            if (d.getType() != 1) {
                throw new IllegalArgumentException();
            }
            if (d.getComparison() == 2) {
                return false;
            }
            Integer dRelI = (Integer)Util.parseCodeName((String)d.getName())[1];
            int n = dRel = dRelI == null ? -1 : dRelI;
            if (dRel < this.major) {
                return true;
            }
            if (dRel > this.major) {
                return false;
            }
            if (this.spec == null) {
                return false;
            }
            String dSpec = d.getVersion();
            if (dSpec == null) {
                return true;
            }
            assert (d.getComparison() == 1) : d.getComparison();
            return new SpecificationVersion(dSpec).compareTo((Object)this.spec) < 0;
        }

        @Override
        public void update(Map<String, Dependency> modDeps, Map<String, Dependency> tokDeps, Map<String, Dependency> pkgDeps, Set<Dependency> dependencies) {
            Dependency d = modDeps.get(this.codenamebase);
            if (d != null && this.older(d)) {
                dependencies.remove(d);
                Dependency nue = this.createDependency();
                assert (!nue.equals((Object)d)) : "older() claimed to be true on itself for " + d;
                dependencies.add(nue);
            } else if (d == null) {
                dependencies.add(this.createDependency());
            }
        }
    }

    private static abstract class Dep {
        public final String toString() {
            return this.manifestKey() + ": " + this.toManifestForm();
        }

        public abstract String toManifestForm();

        public abstract String manifestKey();

        public abstract int type();

        public final Dependency createDependency() {
            return (Dependency)Dependency.create((int)this.type(), (String)this.toManifestForm()).iterator().next();
        }

        public abstract Dependency applies(Map<String, Dependency> var1, Map<String, Dependency> var2, Map<String, Dependency> var3, Set<Dependency> var4, String var5);

        public abstract void update(Map<String, Dependency> var1, Map<String, Dependency> var2, Map<String, Dependency> var3, Set<Dependency> var4);
    }

    private static final class Transformation {
        public Dep trigger;
        public String triggerType;
        public final List<Dep> results = new ArrayList<Dep>();

        public String toString() {
            return "Transformation[trigger=" + this.trigger + ",triggerType=" + this.triggerType + ",results=" + this.results + "]";
        }

        public void apply(Map<String, Dependency> modDeps, Map<String, Dependency> tokDeps, Map<String, Dependency> pkgDeps, Set<Dependency> dependencies) {
            Dependency d = this.trigger.applies(modDeps, tokDeps, pkgDeps, dependencies, this.triggerType);
            if (d != null) {
                if (this.triggerType.equals("cancel")) {
                    dependencies.remove(d);
                } else if (!this.triggerType.equals("older")) {
                    throw new IllegalStateException(this.triggerType);
                }
                for (Dep nue : this.results) {
                    nue.update(modDeps, tokDeps, pkgDeps, dependencies);
                }
            }
        }
    }

    private static final class TransformationGroup {
        public String description;
        public final List<Exclusion> exclusions = new ArrayList<Exclusion>();
        public final List<Transformation> transformations = new ArrayList<Transformation>();

        public String toString() {
            return "TransformationGroup[" + this.exclusions + "," + this.transformations + "]";
        }

        public boolean isExcluded(String cnb) {
            Iterator<Exclusion> it = this.exclusions.iterator();
            while (it.hasNext()) {
                if (!it.next().matches(cnb)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Exclusion {
        public String codenamebase;
        public boolean prefix;

        public String toString() {
            return "Exclusion[" + this.codenamebase + ",prefix=" + this.prefix + "]";
        }

        public boolean matches(String cnb) {
            return cnb.equals(this.codenamebase) || this.prefix && cnb.startsWith(this.codenamebase + ".");
        }
    }

    public static final class Report {
        private final String cnb;
        private final Set<Dependency> added;
        private final Set<Dependency> removed;
        private final Set<String> messages;

        Report(String cnb, Set<Dependency> added, Set<Dependency> removed, Set<String> messages) {
            this.cnb = cnb;
            this.added = added;
            this.removed = removed;
            this.messages = messages;
        }

        public Set<Dependency> getAdded() {
            return this.added;
        }

        public Set<Dependency> getRemoved() {
            return this.removed;
        }

        public Set<String> getMessages() {
            return this.messages;
        }

        public boolean isModified() {
            return !this.added.isEmpty() || !this.removed.isEmpty();
        }

        public String toString() {
            return "had to upgrade dependencies for module " + this.cnb + ": added = " + this.getAdded() + " removed = " + this.getRemoved() + "; details: " + this.getMessages();
        }
    }
}

