/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.web.common.api.FileReferenceCompletion;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.openide.filesystems.FileObject;

public abstract class AttrValuesCompletion {
    private static final Map<String, Map<String, ValueCompletion<HtmlCompletionItem>>> SUPPORTS = new HashMap<String, Map<String, ValueCompletion<HtmlCompletionItem>>>();
    private static final Map<String, ValueCompletion<HtmlCompletionItem>> ALL_TAG_SUPPORTS = new HashMap<String, ValueCompletion<HtmlCompletionItem>>();
    public static final ValueCompletion<HtmlCompletionItem> FILE_NAME_SUPPORT = new FilenameSupport();
    private static final ValueCompletion<HtmlCompletionItem> CONTENT_TYPE_SUPPORT = new ValuesSetSupport(new String[]{"text/css", "text/javascript"});
    private static final ValueCompletion<HtmlCompletionItem> TRUE_FALSE_SUPPORT = new ValuesSetSupport(new String[]{"true", "false"});
    private static final ValueCompletion<HtmlCompletionItem> SCOPE_SUPPORT = new ValuesSetSupport(new String[]{"row", "col", "rowgroup", "colgroup"});
    private static final ValueCompletion<HtmlCompletionItem> SHAPE_SUPPORT = new ValuesSetSupport(new String[]{"circle", "default", "poly", "rect"});
    private static final ValueCompletion<HtmlCompletionItem> ON_OFF_SUPPORT = new ValuesSetSupport(new String[]{"on", "off"});
    private static final ValueCompletion<HtmlCompletionItem> FORMENCTYPE_SUPPORT = new ValuesSetSupport(new String[]{"application/x-www-form-urlencoded", "multipart/form-data", "text/plain"});
    private static final ValueCompletion<HtmlCompletionItem> FORMMETHOD_SUPPORT = new ValuesSetSupport(new String[]{"GET", "POST", "PUT", "DELETE"});
    private static final ValueCompletion<HtmlCompletionItem> PRELOAD_SUPPORT = new ValuesSetSupport(new String[]{"none", "metadata", "auto"});
    private static final ValueCompletion<HtmlCompletionItem> BUTTON_TYPE_SUPPORT = new ValuesSetSupport(new String[]{"submit", "reset", "button"});
    private static final ValueCompletion<HtmlCompletionItem> COMMAND_TYPE_SUPPORT = new ValuesSetSupport(new String[]{"command", "checkbox", "radio"});
    private static final ValueCompletion<HtmlCompletionItem> MENU_TYPE_SUPPORT = new ValuesSetSupport(new String[]{"context", "toolbar"});
    private static final ValueCompletion<HtmlCompletionItem> WRAP_SUPPORT = new ValuesSetSupport(new String[]{"soft", "hard"});
    private static final ValueCompletion<HtmlCompletionItem> INPUT_TYPE_SUPPORT = new ValuesSetSupport(new String[]{"hidden", "text", "search", "tel", "url", "email", "password", "datetime", "date", "month", "week", "time", "datetime-local", "number", "range", "color", "checkbox", "radio", "file", "submit", "image", "reset", "button"});
    private static final ValueCompletion<HtmlCompletionItem> LINK_TYPES_SUPPORT = new ValuesSetSupport(new String[]{"alternate", "stylesheet", "start", "next", "prev", "contents", "index", "glossary", "copyright", "chapter", "section", "subsection", "appendix", "help", "bookmark"});
    private static final ValueCompletion<HtmlCompletionItem> DIR_SUPPORT = new ValuesSetSupport(new String[]{"ltr", "rtl"});

    private static void putSupport(String tag, String attr, ValueCompletion<HtmlCompletionItem> support) {
        if (tag == null) {
            ALL_TAG_SUPPORTS.put(attr, support);
        } else {
            Map<String, ValueCompletion<HtmlCompletionItem>> map = SUPPORTS.get(tag);
            if (map == null) {
                map = new HashMap<String, ValueCompletion<HtmlCompletionItem>>();
                SUPPORTS.put(tag, map);
            }
            map.put(attr, support);
        }
    }

    public static Map<String, ValueCompletion<HtmlCompletionItem>> getSupportsForTag(String tag) {
        return SUPPORTS.get(tag.toLowerCase(Locale.ENGLISH));
    }

    public static ValueCompletion<HtmlCompletionItem> getSupport(String tag, String attr) {
        Map<String, ValueCompletion<HtmlCompletionItem>> map = AttrValuesCompletion.getSupportsForTag(tag);
        if (map == null) {
            return ALL_TAG_SUPPORTS.get(attr);
        }
        ValueCompletion<HtmlCompletionItem> completion = map.get(attr.toLowerCase(Locale.ENGLISH));
        return completion == null ? ALL_TAG_SUPPORTS.get(attr) : completion;
    }

    static {
        AttrValuesCompletion.putSupport("a", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("area", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("a", "ping", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("area", "ping", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("link", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("base", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("script", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("audio", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("embed", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("iframe", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("img", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("input", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("source", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("track", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("video", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("img", "longdesc", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("img", "usemap", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("input", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("frame", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("iframe", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("body", "background", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("input", "usemap", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "classid", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "codebase", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "data", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "usemap", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("applet", "codebase", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("q", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("blackquote", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("ins", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("del", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("form", "action", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("button", "formaction", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("input", "formaction", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("command", "icon", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport(null, "itemprop", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport(null, "itemtype", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("html", "manifest", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("video", "poster", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("script", "type", CONTENT_TYPE_SUPPORT);
        AttrValuesCompletion.putSupport("style", "type", CONTENT_TYPE_SUPPORT);
        AttrValuesCompletion.putSupport("link", "type", CONTENT_TYPE_SUPPORT);
        AttrValuesCompletion.putSupport("form", "autocomplete", ON_OFF_SUPPORT);
        AttrValuesCompletion.putSupport("input", "autocomplete", ON_OFF_SUPPORT);
        AttrValuesCompletion.putSupport(null, "contenteditable", TRUE_FALSE_SUPPORT);
        AttrValuesCompletion.putSupport("button", "formenctype", FORMENCTYPE_SUPPORT);
        AttrValuesCompletion.putSupport("input", "formenctype", FORMENCTYPE_SUPPORT);
        AttrValuesCompletion.putSupport("button", "formmethod", FORMMETHOD_SUPPORT);
        AttrValuesCompletion.putSupport("input", "formmethod", FORMMETHOD_SUPPORT);
        AttrValuesCompletion.putSupport("audio", "preload", PRELOAD_SUPPORT);
        AttrValuesCompletion.putSupport("video", "preload", PRELOAD_SUPPORT);
        AttrValuesCompletion.putSupport(null, "spellcheck", TRUE_FALSE_SUPPORT);
        AttrValuesCompletion.putSupport("th", "scope", SCOPE_SUPPORT);
        AttrValuesCompletion.putSupport("area", "shape", SHAPE_SUPPORT);
        AttrValuesCompletion.putSupport("button", "type", BUTTON_TYPE_SUPPORT);
        AttrValuesCompletion.putSupport("command", "type", COMMAND_TYPE_SUPPORT);
        AttrValuesCompletion.putSupport("menu", "type", MENU_TYPE_SUPPORT);
        AttrValuesCompletion.putSupport("textarea", "wrap", WRAP_SUPPORT);
        AttrValuesCompletion.putSupport("input", "type", INPUT_TYPE_SUPPORT);
        AttrValuesCompletion.putSupport(null, "rel", LINK_TYPES_SUPPORT);
        AttrValuesCompletion.putSupport(null, "dir", DIR_SUPPORT);
    }

    public static class FilenameSupport
    extends FileReferenceCompletion<HtmlCompletionItem> {
        public HtmlCompletionItem createFileItem(int anchor, String name, Color color, ImageIcon icon) {
            return HtmlCompletionItem.createFileCompletionItem(name, anchor, color, icon);
        }

        public HtmlCompletionItem createGoUpItem(int anchor, Color color, ImageIcon icon) {
            return HtmlCompletionItem.createGoUpFileCompletionItem(anchor, color, icon);
        }
    }

    public static class ValuesSetSupport
    implements ValueCompletion {
        private String[] values;

        public ValuesSetSupport(String[] values) {
            this.values = values;
        }

        public List<HtmlCompletionItem> getItems(FileObject file, int offset, String valuePart) {
            ArrayList<HtmlCompletionItem> items = new ArrayList<HtmlCompletionItem>();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].startsWith(valuePart)) continue;
                items.add(HtmlCompletionItem.createAttributeValue(this.values[i], offset));
            }
            return items;
        }
    }
}

