/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.coloring;

import java.awt.Color;
import java.util.EventListener;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public class EmbeddingHighlightsContainer
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private static final Logger LOG = Logger.getLogger(EmbeddingHighlightsContainer.class.getName());
    private static final String CSS_BACKGROUND_TOKEN_NAME = "css-embedded";
    private static final String JAVASCRIPT_BACKGROUND_TOKEN_NAME = "javascript-embedded";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String CSS_MIME_TYPE = "text/x-css";
    private static final String CSS_INLINED_MIME_TYPE = "text/x-css-inlined";
    private static final String JAVASCRIPT_MIME_TYPE = "text/javascript";
    private final AttributeSet cssBackground;
    private final AttributeSet javascriptBackground;
    private final Document document;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    EmbeddingHighlightsContainer(Document document) {
        this.document = document;
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)HTML_MIME_TYPE).lookup(FontColorSettings.class);
        Color cssBC = null;
        Color jsBC = null;
        if (fcs != null) {
            cssBC = EmbeddingHighlightsContainer.getColoring(fcs, CSS_BACKGROUND_TOKEN_NAME);
            jsBC = EmbeddingHighlightsContainer.getColoring(fcs, JAVASCRIPT_BACKGROUND_TOKEN_NAME);
        }
        this.cssBackground = cssBC == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, cssBC, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE});
        this.javascriptBackground = jsBC == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, jsBC, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        EmbeddingHighlightsContainer embeddingHighlightsContainer = this;
        synchronized (embeddingHighlightsContainer) {
            if (this.javascriptBackground != null || this.cssBackground != null) {
                if (this.hierarchy == null) {
                    this.hierarchy = TokenHierarchy.get((Document)this.document);
                    if (this.hierarchy != null) {
                        this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
                    }
                }
                if (this.hierarchy != null) {
                    return new Highlights(this.version, this.hierarchy, startOffset, endOffset);
                }
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
        EmbeddingHighlightsContainer embeddingHighlightsContainer = this;
        synchronized (embeddingHighlightsContainer) {
            ++this.version;
        }
        this.fireHighlightsChange(evt.affectedStartOffset(), evt.affectedEndOffset());
    }

    private static Color getColoring(FontColorSettings fcs, String tokenName) {
        AttributeSet as = fcs.getTokenFontColors(tokenName);
        if (as != null) {
            return (Color)as.getAttribute(StyleConstants.Background);
        }
        return null;
    }

    private class Highlights
    implements HighlightsSequence {
        private final long version;
        private final TokenHierarchy<? extends Document> scanner;
        private final int startOffsetBoundary;
        private final int endOffsetBoundary;
        private List<TokenSequence<?>> tokenSequenceList = null;
        private int startOffset;
        private int endOffset;
        private int realEndOffset;
        private AttributeSet attributeSet;
        private boolean finished = false;

        private Highlights(long version, TokenHierarchy<? extends Document> scanner, int startOffset, int endOffset) {
            this.version = version;
            this.scanner = scanner;
            this.startOffsetBoundary = startOffset;
            this.endOffsetBoundary = endOffset;
        }

        private boolean _moveNext() {
            if (this.tokenSequenceList == null) {
                this.startOffset = this.startOffsetBoundary;
                this.endOffset = this.startOffsetBoundary;
                this.realEndOffset = this.startOffsetBoundary;
                String mimeType = (String)EmbeddingHighlightsContainer.this.document.getProperty("mimeType");
                Language language = Language.find((String)mimeType);
                if (language != null) {
                    LanguagePath topLevelLanguagePath = LanguagePath.get((Language)language);
                    if (mimeType.equals(EmbeddingHighlightsContainer.HTML_MIME_TYPE)) {
                        this.tokenSequenceList = this.scanner.tokenSequenceList(topLevelLanguagePath, this.startOffsetBoundary, this.endOffsetBoundary);
                    } else {
                        LanguagePath htmlPath = LanguagePath.get((LanguagePath)topLevelLanguagePath, (Language)HTMLTokenId.language());
                        this.tokenSequenceList = this.scanner.tokenSequenceList(htmlPath, this.startOffsetBoundary, this.endOffsetBoundary);
                    }
                } else {
                    LOG.log(Level.WARNING, "Language " + mimeType + " obtained from the document mimeType property cannot be found!");
                }
            }
            if (this.tokenSequenceList != null) {
                for (TokenSequence<?> tokenSequence : this.tokenSequenceList) {
                    assert (tokenSequence.language().mimeType().equals(EmbeddingHighlightsContainer.HTML_MIME_TYPE));
                    tokenSequence.move(this.realEndOffset);
                    while (tokenSequence.moveNext() && tokenSequence.offset() < this.endOffsetBoundary) {
                        String embeddedMimeType;
                        TokenSequence eTokenSequence = tokenSequence.embedded();
                        if (eTokenSequence == null || !eTokenSequence.moveNext() || !EmbeddingHighlightsContainer.CSS_MIME_TYPE.equals(embeddedMimeType = eTokenSequence.language().mimeType()) && !EmbeddingHighlightsContainer.CSS_INLINED_MIME_TYPE.equals(embeddedMimeType) && !EmbeddingHighlightsContainer.JAVASCRIPT_MIME_TYPE.equals(embeddedMimeType)) continue;
                        try {
                            int endLO;
                            this.startOffset = eTokenSequence.offset();
                            do {
                                this.endOffset = eTokenSequence.offset() + eTokenSequence.token().length();
                            } while (eTokenSequence.moveNext());
                            this.realEndOffset = this.endOffset > this.realEndOffset ? this.endOffset : this.realEndOffset + 1;
                            int startLO = Utilities.getLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)this.startOffset);
                            if (startLO != (endLO = Utilities.getLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)this.endOffset))) {
                                if (Utilities.getFirstNonWhiteBwd((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)Utilities.getRowEnd((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)this.startOffset)) + 1 == this.startOffset) {
                                    this.startOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)(startLO + 1));
                                }
                                if (Utilities.getFirstNonWhiteFwd((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)endLO)) == this.endOffset) {
                                    this.endOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)endLO);
                                }
                            }
                            AttributeSet attributeSet = this.attributeSet = embeddedMimeType.equals(EmbeddingHighlightsContainer.JAVASCRIPT_MIME_TYPE) ? EmbeddingHighlightsContainer.this.javascriptBackground : EmbeddingHighlightsContainer.this.cssBackground;
                            if (this.attributeSet == null) continue;
                            return true;
                        }
                        catch (BadLocationException ex) {
                            LOG.log(Level.INFO, "An error occured when creating coloured background for CSS and JavaScript.", ex);
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            EmbeddingHighlightsContainer embeddingHighlightsContainer = EmbeddingHighlightsContainer.this;
            synchronized (embeddingHighlightsContainer) {
                if (this.checkVersion() && this._moveNext()) {
                    return true;
                }
            }
            this.finished = true;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            EmbeddingHighlightsContainer embeddingHighlightsContainer = EmbeddingHighlightsContainer.this;
            synchronized (embeddingHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.tokenSequenceList != null) : "Sequence not initialized, call moveNext() first.";
                return this.startOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            EmbeddingHighlightsContainer embeddingHighlightsContainer = EmbeddingHighlightsContainer.this;
            synchronized (embeddingHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.tokenSequenceList != null) : "Sequence not initialized, call moveNext() first.";
                return this.endOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            EmbeddingHighlightsContainer embeddingHighlightsContainer = EmbeddingHighlightsContainer.this;
            synchronized (embeddingHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.tokenSequenceList != null) : "Sequence not initialized, call moveNext() first.";
                return this.attributeSet;
            }
        }

        private boolean checkVersion() {
            return this.version == EmbeddingHighlightsContainer.this.version;
        }
    }
}

