/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend.util;

import java.io.File;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ZendUtils {
    public static final String CONTROLLER_FILE_SUFIX = "Controller";
    public static final String CONTROLLER_CLASS_SUFFIX = "Controller";
    public static final String CONTROLLER_METHOD_SUFIX = "Action";
    private static final String DIR_CONTROLLERS = "controllers";
    private static final String DIR_SCRIPTS = "scripts";
    private static final String DIR_VIEWS = "views";
    private static final String FILE_VIEW_EXT = "phtml";
    private static final String FILE_CONTROLLER_RELATIVE = "../../../controllers/%s.php";
    private static final String FILE_VIEW_RELATIVE = "../views/scripts/%s/%s.phtml";
    private static final String DASH = "-";

    private ZendUtils() {
    }

    public static boolean isView(FileObject fo) {
        if (!fo.isData() || !fo.getExt().equals(FILE_VIEW_EXT)) {
            return false;
        }
        File file = FileUtil.toFile((FileObject)fo);
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (!DIR_SCRIPTS.equals((parent = parent.getParentFile()).getName())) {
            return false;
        }
        return (parent = parent.getParentFile()) != null && DIR_VIEWS.equals(parent.getName());
    }

    public static boolean isViewWithAction(FileObject fo) {
        return ZendUtils.isView(fo) && ZendUtils.getAction(fo) != null;
    }

    public static boolean isAction(FileObject fo) {
        return fo.isData() && fo.getName().endsWith("Controller") && fo.getParent().getNameExt().equals(DIR_CONTROLLERS);
    }

    public static FileObject getAction(FileObject view) {
        File parent = FileUtil.toFile((FileObject)view).getParentFile();
        File action = PropertyUtils.resolveFile((File)parent, (String)String.format(FILE_CONTROLLER_RELATIVE, ZendUtils.getControllerName(parent.getName())));
        if (action.isFile()) {
            return FileUtil.toFileObject((File)action);
        }
        return null;
    }

    public static FileObject getView(FileObject fo, PhpBaseElement phpElement) {
        FileObject view = null;
        if (phpElement instanceof PhpClass.Method) {
            view = ZendUtils.getView(fo, ZendUtils.getViewName(phpElement.getName()));
        }
        return view;
    }

    private static FileObject getView(FileObject fo, String viewName) {
        File parent = FileUtil.toFile((FileObject)fo).getParentFile();
        File view = PropertyUtils.resolveFile((File)parent, (String)String.format(FILE_VIEW_RELATIVE, ZendUtils.getViewFolderName(fo.getName()), viewName));
        if (view.isFile()) {
            return FileUtil.toFileObject((File)view);
        }
        return null;
    }

    static String getViewName(String actionName) {
        if (!actionName.endsWith(CONTROLLER_METHOD_SUFIX)) {
            return null;
        }
        return ZendUtils.dashize(actionName.replace(CONTROLLER_METHOD_SUFIX, ""));
    }

    static String getViewFolderName(String controllerName) {
        return ZendUtils.dashize(controllerName.replace("Controller", ""));
    }

    static String getControllerName(String viewFolderName) {
        return ZendUtils.undashize(viewFolderName, false) + "Controller";
    }

    public static String getActionName(FileObject view) {
        return ZendUtils.getActionName(view.getName());
    }

    public static String getActionName(String viewName) {
        return ZendUtils.undashize(viewName, true) + CONTROLLER_METHOD_SUFIX;
    }

    private static String undashize(String input, boolean firstLowerCase) {
        StringBuilder sb = new StringBuilder(input.length());
        boolean first = firstLowerCase;
        for (String part : input.split(Pattern.quote(DASH))) {
            if (first) {
                first = false;
                sb.append(part);
                continue;
            }
            sb.append(part.substring(0, 1).toUpperCase());
            sb.append(part.substring(1));
        }
        return sb.toString();
    }

    private static String dashize(String input) {
        StringBuilder sb = new StringBuilder(2 * input.length());
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i != 0) {
                    sb.append(DASH);
                }
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

