/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.nbimpl.javac.ClasspathInfoFactory;
import org.netbeans.modules.profiler.nbimpl.javac.JavacClassInfo;
import org.netbeans.modules.profiler.nbimpl.javac.JavacMethodInfo;
import org.netbeans.modules.profiler.spi.java.AbstractJavaProfilerSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JavaProfilerSourceImpl
implements AbstractJavaProfilerSource {
    private static final String JUNIT_SUITE = "junit.framework.TestSuite";
    private static final String JUNIT_TEST = "junit.framework.Test";
    private static final String[] APPLET_CLASSES = new String[]{"java.applet.Applet", "javax.swing.JApplet"};
    private static final String[] TEST_CLASSES = new String[]{"junit.framework.TestSuite", "junit.framework.Test"};
    private static final String[] TEST_ANNOTATIONS = new String[]{"org.junit.Test", "org.junit.runners.Suite", "org.testng.annotations.Test"};

    public SourceClassInfo getEnclosingClass(FileObject fo, final int position) {
        final SourceClassInfo[] result = new SourceClassInfo[1];
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController cc) throws Exception {
                    if (cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    TypeElement parentClass = cc.getTreeUtilities().scopeFor(position).getEnclosingClass();
                    if (parentClass != null) {
                        result[0] = new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)parentClass), cc);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result[0];
    }

    public SourceMethodInfo getEnclosingMethod(FileObject fo, final int position) {
        final SourceMethodInfo[] result = new SourceMethodInfo[1];
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController cc) throws Exception {
                    if (cc.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    ExecutableElement parentMethod = cc.getTreeUtilities().scopeFor(position).getEnclosingMethod();
                    if (parentMethod != null) {
                        result[0] = new JavacMethodInfo(parentMethod, cc);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            ProfilerLogger.log((Exception)ex);
        }
        return result[0];
    }

    public Set<SourceClassInfo> getMainClasses(FileObject fo) {
        HashSet<SourceClassInfo> mainClasses = new HashSet<SourceClassInfo>();
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return Collections.EMPTY_SET;
        }
        ClasspathInfo cpInfo = ClasspathInfoFactory.infoFor(p);
        for (ElementHandle handle : SourceUtils.getMainClasses((FileObject)fo)) {
            mainClasses.add(new JavacClassInfo((ElementHandle<TypeElement>)handle, cpInfo));
        }
        return mainClasses;
    }

    public Set<SourceMethodInfo> getConstructors(FileObject fo) {
        final HashSet<SourceMethodInfo> constructors = new HashSet<SourceMethodInfo>();
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(final CompilationController cc) throws Exception {
                    if (cc.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

                        @Override
                        public Void visitMethod(MethodTree node, Void p) {
                            ExecutableElement method = (ExecutableElement)cc.getTrees().getElement(this.getCurrentPath());
                            constructors.add(new JavacMethodInfo(method, cc));
                            Void retValue = (Void)super.visitMethod(node, p);
                            return retValue;
                        }
                    };
                    scanner.scan(cc.getCompilationUnit(), null);
                }
            }, true);
        }
        catch (IOException e) {
            ProfilerLogger.log((Exception)e);
        }
        return constructors;
    }

    public Set<SourceClassInfo> getClasses(FileObject fo) {
        final HashSet<SourceClassInfo> result = new HashSet<SourceClassInfo>();
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(final CompilationController cc) throws Exception {
                    if (cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

                        @Override
                        public Void visitClass(ClassTree node, Void param) {
                            try {
                                TypeElement te = (TypeElement)cc.getTrees().getElement(this.getCurrentPath());
                                result.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)te), cc));
                            }
                            catch (NullPointerException e) {
                                ProfilerLogger.log((Exception)e);
                            }
                            return null;
                        }
                    };
                    scanner.scan(cc.getCompilationUnit(), null);
                }
            }, true);
        }
        catch (IOException ex) {
            ProfilerLogger.log((Exception)ex);
        }
        return result;
    }

    public SourceClassInfo getTopLevelClass(FileObject fo) {
        String fName = fo.getName();
        for (SourceClassInfo ci : this.getClasses(fo)) {
            if (!ci.getSimpleName().equals(fName)) continue;
            return ci;
        }
        return null;
    }

    public boolean hasAnnotation(FileObject fo, final String[] annotationNames, boolean allRequired) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean result = new AtomicBoolean(false);
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return false;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(final CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

                        @Override
                        public Void visitAnnotation(AnnotationTree annTree, Void p) {
                            TypeElement annType;
                            if (result.get()) {
                                return null;
                            }
                            TypeMirror tm = controller.getTrees().getTypeMirror(this.getCurrentPath());
                            if (tm != null && (annType = (TypeElement)controller.getTypes().asElement(tm)) != null) {
                                boolean res = result.get();
                                if (!res) {
                                    for (String ann : annotationNames) {
                                        if (!ann.equals(ElementUtilities.getBinaryName((TypeElement)annType))) continue;
                                        res = true;
                                        break;
                                    }
                                }
                                result.set(res);
                            }
                            return null;
                        }
                    };
                    scanner.scan(controller.getCompilationUnit(), null);
                    latch.countDown();
                }
            }, true);
            latch.await();
            return result.get();
        }
        catch (IOException e) {
            ProfilerLogger.log((Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public boolean hasAnnotation(FileObject fo, String annotation) {
        return this.hasAnnotation(fo, new String[]{annotation}, true);
    }

    public boolean isApplet(FileObject fo) {
        return this.isInstanceOf(fo, APPLET_CLASSES, false);
    }

    public boolean isInstanceOf(FileObject fo, final String[] classNames, final boolean allRequired) {
        final boolean[] result = new boolean[]{false};
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return false;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    if (controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    Elements elements = controller.getElements();
                    Trees trees = controller.getTrees();
                    Types types = controller.getTypes();
                    ArrayList<TypeElement> classElements = new ArrayList<TypeElement>();
                    for (String string : classNames) {
                        TypeElement resolvedElement = elements.getTypeElement(string);
                        if (resolvedElement == null) continue;
                        classElements.add(resolvedElement);
                    }
                    if (classElements.isEmpty()) {
                        result[0] = false;
                        return;
                    }
                    CompilationUnitTree cu = controller.getCompilationUnit();
                    List<? extends Tree> topLevels = cu.getTypeDecls();
                    for (Tree tree : topLevels) {
                        TypeElement classElement;
                        Set<Modifier> modifiers;
                        TypeElement type;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || (type = (TypeElement)trees.getElement(TreePath.getPath(cu, tree))) == null || !(modifiers = type.getModifiers()).contains((Object)Modifier.PUBLIC) || classElements == null) continue;
                        boolean rslt = allRequired;
                        Iterator i$ = classElements.iterator();
                        while (i$.hasNext() && ((classElement = (TypeElement)i$.next()) == null || !(allRequired ? !(rslt = rslt && types.isSubtype(type.asType(), classElement.asType())) : (rslt = rslt || types.isSubtype(type.asType(), classElement.asType()))))) {
                        }
                        result[0] = rslt;
                        if (!rslt) continue;
                        break;
                    }
                }
            }, true);
        }
        catch (IOException e) {
            ProfilerLogger.log((Exception)e);
        }
        return result[0];
    }

    public boolean isInstanceOf(FileObject fo, String className) {
        return this.isInstanceOf(fo, new String[]{className}, true);
    }

    public boolean isOffsetValid(FileObject fo, final int offset) {
        final Boolean[] validated = new Boolean[1];
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js != null) {
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        validated[0] = false;
                        Scope sc = controller.getTreeUtilities().scopeFor(offset);
                        if (sc.getEnclosingClass() != null) {
                            validated[0] = true;
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                ProfilerLogger.log((Exception)ex);
            }
        }
        return validated[0];
    }

    public boolean isTest(FileObject fo) {
        return this.hasAnnotation(fo, TEST_ANNOTATIONS, false) || this.isInstanceOf(fo, TEST_CLASSES, false) || JavaProfilerSourceImpl.isJunit3TestSuite(fo);
    }

    public SourceMethodInfo resolveMethodAtPosition(FileObject fo, final int position) {
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final SourceMethodInfo[] resolvedMethod = new SourceMethodInfo[1];
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController cc) throws Exception {
                    if (cc.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePath path = cc.getTreeUtilities().pathFor(position);
                    if (path == null) {
                        return;
                    }
                    Element element = cc.getTrees().getElement(path);
                    if (element != null && (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR || element.getKind() == ElementKind.STATIC_INIT)) {
                        ExecutableElement method = (ExecutableElement)element;
                        resolvedMethod[0] = new JavacMethodInfo(method, cc);
                    }
                }
            }, true);
        }
        catch (IOException ioex) {
            ProfilerLogger.log((Exception)ioex);
            return null;
        }
        return resolvedMethod[0];
    }

    public SourceClassInfo resolveClassAtPosition(FileObject fo, final int position, final boolean resolveField) {
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final SourceClassInfo[] resolvedClass = new SourceClassInfo[1];
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController cc) throws Exception {
                    if (cc.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePath path = cc.getTreeUtilities().pathFor(position);
                    if (path == null) {
                        return;
                    }
                    Element element = cc.getTrees().getElement(path);
                    if (element == null) {
                        return;
                    }
                    if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.ENUM) {
                        TypeElement jclass = (TypeElement)element;
                        resolvedClass[0] = new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)jclass), cc);
                        return;
                    }
                    if (resolveField && (element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.LOCAL_VARIABLE) && element.asType().getKind() == TypeKind.DECLARED) {
                        TypeMirror jclassMirror = cc.getTypes().erasure(element.asType());
                        TypeElement jclass = (TypeElement)cc.getTypes().asElement(jclassMirror);
                        resolvedClass[0] = new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)jclass), cc);
                        return;
                    }
                }
            }, true);
        }
        catch (IOException ioex) {
            ProfilerLogger.log((Exception)ioex);
            ioex.printStackTrace();
            return null;
        }
        return resolvedClass[0];
    }

    private static boolean isJunit3TestSuite(FileObject fo) {
        final boolean[] rslt = new boolean[]{false};
        SourceGroup sg = SourceGroupModifier.createSourceGroup((Project)FileOwnerQuery.getOwner((FileObject)fo), (String)"java", (String)"test");
        if (FileUtil.getRelativePath((FileObject)sg.getRootFolder(), (FileObject)fo) != null && sg.contains(fo)) {
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            if (js == null) {
                return false;
            }
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(final CompilationController cc) throws Exception {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

                            @Override
                            public Void visitMethod(MethodTree node, Void p) {
                                ExecutableElement ee;
                                Element e = cc.getTrees().getElement(this.getCurrentPath());
                                if (e.getKind() == ElementKind.METHOD && (ee = (ExecutableElement)e).getSimpleName().contentEquals("suite") && (((Object)ee.getReturnType()).toString().equals(JavaProfilerSourceImpl.JUNIT_TEST) || ((Object)ee.getReturnType()).toString().equals(JavaProfilerSourceImpl.JUNIT_SUITE))) {
                                    rslt[0] = rslt[0] | true;
                                }
                                return (Void)super.visitMethod(node, p);
                            }
                        };
                        scanner.scan(cc.getCompilationUnit(), null);
                    }
                }, true);
                return rslt[0];
            }
            catch (IOException ioex) {
                ProfilerLogger.log((Exception)ioex);
                return false;
            }
        }
        return rslt[0];
    }
}

