/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.netbeans.modules.profiler.attach.spi.AbstractRemotePackExporter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.InstalledFileLocator;

public class AntRemotePackExporter
extends AbstractRemotePackExporter {
    private AntProjectCookie cookie;

    public AntRemotePackExporter() {
        try {
            File antFile = InstalledFileLocator.getDefault().locate("remote-pack-defs/build.xml", "org-netbeans-lib-profiler", false);
            this.cookie = (AntProjectCookie)DataObject.find((FileObject)FileUtil.toFileObject((File)antFile)).getCookie(AntProjectCookie.class);
        }
        catch (DataObjectNotFoundException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    public String export(String exportPath, String hostOS, String jvm) throws IOException {
        assert (hostOS != null);
        assert (jvm != null);
        AntTargetExecutor.Env env = new AntTargetExecutor.Env();
        env.setVerbosity(3);
        Properties antProperties = new Properties();
        antProperties.setProperty("lib.dir", "../lib");
        antProperties.setProperty("dest.dir", this.adjustExportPath(exportPath));
        env.setProperties(antProperties);
        AntTargetExecutor ate = AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)env);
        ate.execute(this.cookie, new String[]{"profiler-server-" + this.getPlatformShort(hostOS) + "-" + this.getJVMShort(jvm)}).result();
        return this.getRemotePackPath(exportPath, hostOS);
    }

    public String getRemotePackPath(String exportPath, String hostOS) {
        return this.adjustExportPath(exportPath) + File.separator + "profiler-server-" + this.getPlatformShort(hostOS) + ".zip";
    }

    private String adjustExportPath(String exportPath) {
        return exportPath != null ? exportPath : System.getProperty("java.io.tmpdir");
    }
}

