/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.swing.Action;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.actions.ProfilingSupport;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.api.project.AntProjectSupport;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.nbimpl.NetBeansProfiler;
import org.netbeans.modules.profiler.nbimpl.actions.FileSensitiveAction;
import org.netbeans.modules.profiler.nbimpl.actions.ProjectSensitiveAction;
import org.netbeans.modules.profiler.nbimpl.project.ProjectUtilities;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.spi.project.ui.support.MainProjectSensitiveActions;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class AntActions {
    private static final String FILE_TEST_NOT_FOUND_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_FileTestNotFoundMsg");
    private static final String FAILED_DETERMINE_JAVA_PLATFORM_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_FailedDetermineJavaPlatformMsg");
    private static final String FAILED_DETERMINE_PROJECT_BUILDSCRIPT_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_FailedDetermineProjectBuildScriptMsg");
    private static final String INCORRECT_JAVA_SPECVERSION_DIALOG_CAPTION = NbBundle.getMessage(AntActions.class, (String)"AntActions_IncorrectJavaSpecVersionDialogCaption");
    private static final String INCORRECT_JAVA_SPECVERSION_DIALOG_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_IncorrectJavaSpecVersionDialogMsg");
    private static final String LINUX_THREAD_TIMER_KEY = "-XX:+UseLinuxPosixThreadCPUClocks";
    private static final String UNSUPPORTED_PROJECT_TYPE_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_UnsupportedProjectTypeMsg");
    private static final String INVALID_JAVAPLATFORM_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_InvalidJavaplatformMsg");
    private static final String INVALID_PLATFORM_PROJECT_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_InvalidPlatformProjectMsg");
    private static final String INVALID_PLATFORM_PROFILER_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_InvalidPlatformProfilerMsg");

    private AntActions() {
    }

    public static Action profileMainProject() {
        Action a = MainProjectSensitiveActions.mainProjectSensitiveAction((ProjectActionPerformer)new ProjectActionPerformer(){

            public boolean enable(Project project) {
                if (!org.netbeans.modules.profiler.NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (OpenProjects.getDefault().getOpenProjects().length == 0) {
                    return false;
                }
                if (project == null) {
                    return true;
                }
                return ProjectUtilities.isProjectTypeSupported(project);
            }

            public void perform(Project project) {
                if (ProjectUtilities.isProjectTypeSupported(project)) {
                    AntActions.doProfileProject(project, null, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProject"));
                } else {
                    ProfilerDialogs.displayError((String)UNSUPPORTED_PROJECT_TYPE_MSG);
                }
            }
        }, (String)NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileMainProjectAction"), null);
        a.putValue("ShortDescription", NbBundle.getMessage(AntActions.class, (String)"HINT_ProfileMainProjectAction"));
        a.putValue("iconBase", Icons.getResource((String)"ProfilerIcons.Profile"));
        a.putValue("SmallIcon", Icons.getIcon((String)"ProfilerIcons.Profile"));
        return a;
    }

    public static Action profileProject() {
        ProjectSensitiveAction a = ProjectSensitiveAction.projectSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!org.netbeans.modules.profiler.NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                return ProjectUtilities.isProjectTypeSupported(project);
            }

            @Override
            public void perform(Project project, Lookup context) {
                AntActions.doProfileProject(project, null, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProject"));
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectAction40_General"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectAction40"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action profileProjectPopup() {
        ProjectSensitiveAction a = ProjectSensitiveAction.projectSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!org.netbeans.modules.profiler.NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                return ProjectUtilities.isProjectTypeSupported(project);
            }

            @Override
            public void perform(Project project, Lookup context) {
                AntActions.doProfileProject(project, null, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProject"));
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectActionPopup"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectActionPopup"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action profileSingle() {
        FileSensitiveAction a = FileSensitiveAction.fileSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!org.netbeans.modules.profiler.NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    return false;
                }
                ProjectProfilingSupport support = ProjectProfilingSupport.get((Lookup.Provider)project);
                if (!lightweightOnly) {
                    if (!support.isFileObjectSupported(fos[0])) {
                        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                    }
                } else {
                    return support.isProfilingSupported() || org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                }
                return true;
            }

            @Override
            public void perform(Project project, Lookup context) {
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    throw new IllegalStateException();
                }
                AntActions.doProfileProject(project, JavaProfilerSource.createFrom((FileObject)fos[0]), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileFile"));
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleAction40_General"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleAction40"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action profileSinglePopup() {
        FileSensitiveAction a = FileSensitiveAction.fileSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!org.netbeans.modules.profiler.NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    return false;
                }
                ProjectProfilingSupport support = ProjectProfilingSupport.get((Lookup.Provider)project);
                if (!lightweightOnly) {
                    if (!support.isFileObjectSupported(fos[0])) {
                        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                    }
                } else {
                    return support.isProfilingSupported() || org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                }
                return true;
            }

            @Override
            public void perform(Project project, Lookup context) {
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    throw new IllegalStateException();
                }
                ProjectProfilingSupport support = ProjectProfilingSupport.get((Lookup.Provider)project);
                if (!support.isFileObjectSupported(fos[0]) && !org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single")) {
                    throw new IllegalStateException();
                }
                AntActions.doProfileProject(project, JavaProfilerSource.createFrom((FileObject)fos[0]), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileFile"));
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleActionPopup"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleActionPopup"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action profileTest() {
        FileSensitiveAction a = FileSensitiveAction.fileSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!org.netbeans.modules.profiler.NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    return false;
                }
                FileObject fo = org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.findTestForFile((FileObject)fos[0]);
                if (fo == null) {
                    return false;
                }
                ProjectProfilingSupport support = ProjectProfilingSupport.get((Lookup.Provider)project);
                if (!lightweightOnly) {
                    return support.isFileObjectSupported(fo);
                }
                return support.isProfilingSupported();
            }

            @Override
            public void perform(Project project, Lookup context) {
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    throw new IllegalStateException();
                }
                FileObject fo = org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.findTestForFile((FileObject)fos[0]);
                if (fo == null) {
                    throw new IllegalStateException(FILE_TEST_NOT_FOUND_MSG);
                }
                if (!ProjectProfilingSupport.get((Lookup.Provider)project).isFileObjectSupported(fo)) {
                    throw new IllegalStateException();
                }
                AntActions.doProfileProject(project, JavaProfilerSource.createFrom((FileObject)fo), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileTest"));
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileTestAction_General"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileTestAction"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action unintegrateProfiler() {
        ProjectSensitiveAction a = ProjectSensitiveAction.projectSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!org.netbeans.modules.profiler.NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                ProjectProfilingSupport support = ProjectProfilingSupport.get((Lookup.Provider)project);
                return support.supportsUnintegrate();
            }

            @Override
            public void perform(Project project, Lookup context) {
                ProjectProfilingSupport support = ProjectProfilingSupport.get((Lookup.Provider)project);
                try {
                    support.unintegrateProfiler();
                }
                catch (Exception e) {
                    ProfilerLogger.log((Exception)e);
                }
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_UnintegrateProfilerAction"), NbBundle.getMessage(AntActions.class, (String)"LBL_UnintegrateProfilerAction"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    private static String getHeapDumpPath(ProfilerIDESettings gps, Project project) {
        int oomeDetectionMode = gps.getOOMDetectionMode();
        switch (oomeDetectionMode) {
            case 1: {
                return System.getProperty("java.io.tmpdir");
            }
            case 2: {
                try {
                    return FileUtil.toFile((FileObject)ProjectStorage.getSettingsFolder((Lookup.Provider)project, (boolean)true)).getAbsolutePath();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Cannot resolve project settings directory:\n" + e.getMessage());
                    ErrorManager.getDefault().notify(65536, (Throwable)e);
                    return null;
                }
            }
            case 3: {
                return gps.getCustomHeapdumpPath();
            }
        }
        return null;
    }

    private static void activateLinuxPosixThreadTime(ProfilingSettings ps, Properties props, Project project) {
        if (ps.getThreadCPUTimerOn()) {
            props.setProperty("profiler.info.jvmargs", "-XX:+UseLinuxPosixThreadCPUClocks " + props.getProperty("profiler.info.jvmargs"));
            ProfilerLogger.log((String)"Profiler.UseLinuxPosixThreadCPUClocks: Enabled");
        }
    }

    private static void activateOOMProtection(ProfilerIDESettings gps, Properties props, Project project) {
        if (gps.isOOMDetectionEnabled()) {
            String oldArgs = props.getProperty("profiler.info.jvmargs");
            oldArgs = oldArgs != null ? oldArgs : "";
            StringBuilder oomArgsBuffer = new StringBuilder(oldArgs);
            String heapDumpPath = AntActions.getHeapDumpPath(gps, project);
            if (heapDumpPath != null && heapDumpPath.length() > 0) {
                props.setProperty("profiler.info.oomeprotection", "yes");
                props.setProperty("profiler.info.oomeprotection.dumppath", heapDumpPath);
                if (heapDumpPath.contains(" ")) {
                    heapDumpPath = "\"" + heapDumpPath + "\"";
                }
                oomArgsBuffer.append(" -XX:+HeapDumpOnOutOfMemoryError");
                oomArgsBuffer.append(" -XX:HeapDumpPath=").append(heapDumpPath).append(" ");
                ProfilerLogger.log((String)"Profiler.OutOfMemoryDetection: Enabled");
            }
            props.setProperty("profiler.info.jvmargs", oomArgsBuffer.toString());
        }
    }

    private static void doProfileProject(final Project project, JavaProfilerSource profiledClassFile, final String actionName) {
        FileObject fo;
        final boolean isTest = profiledClassFile != null ? profiledClassFile.isTest() : false;
        FileObject fileObject = fo = profiledClassFile != null ? profiledClassFile.getFile() : null;
        if (ProfilingSupport.getDefault().isProfilingActionInvoked()) {
            return;
        }
        ProfilingSupport.getDefault().setProfilingActionInvoked(true);
        final Runnable actionPerform = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ProfilingSupport.checkProfilingInProgress()) {
                        return;
                    }
                    ProjectProfilingSupport support = ProjectProfilingSupport.get((Lookup.Provider)project);
                    if (!support.isProfilingSupported()) {
                        org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.invokeAction((Project)project, (String)(isTest ? "profile-tests" : "profile"));
                    } else {
                        if (!support.checkProjectIsModifiedForProfiler()) {
                            return;
                        }
                        JavaPlatform platform = AntActions.initPlatform(project, support);
                        if (platform == null) {
                            return;
                        }
                        if (!support.checkProjectCanBeProfiled(fo)) {
                            return;
                        }
                        ProfilerIDESettings gps = ProfilerIDESettings.getInstance();
                        String javaFile = platform.getPlatformJavaFile();
                        if (javaFile == null) {
                            if (ProfilerIDESettings.getInstance().getJavaPlatformForProfiling() == null) {
                                ProfilerDialogs.displayError((String)MessageFormat.format(INVALID_PLATFORM_PROJECT_MSG, platform.getDisplayName()));
                            } else {
                                ProfilerDialogs.displayError((String)MessageFormat.format(INVALID_PLATFORM_PROFILER_MSG, platform.getDisplayName()));
                            }
                            return;
                        }
                        String javaVersion = platform.getPlatformJDKVersion();
                        if (javaVersion == null) {
                            ProfilerDialogs.displayError((String)MessageFormat.format(FAILED_DETERMINE_JAVA_PLATFORM_MSG, platform.getDisplayName()));
                            return;
                        }
                        SessionSettings ss = new SessionSettings();
                        ss.setJavaExecutable(javaFile);
                        ss.setJavaVersionString(javaVersion);
                        ss.setSystemArchitecture(platform.getPlatformArchitecture());
                        ss.setPortNo(gps.getPortNo());
                        support.setupProjectSessionSettings(ss);
                        boolean settingsAccepted = false;
                        ProfilingSettings pSettings = null;
                        while (!settingsAccepted) {
                            pSettings = ProfilingSupport.getDefault().selectTaskForProfiling((Lookup.Provider)project, ss, fo, support.supportsSettingsOverride());
                            if (pSettings == null) {
                                return;
                            }
                            settingsAccepted = true;
                        }
                        ProfilingSettings profilingSettings = pSettings;
                        Properties props = new Properties();
                        profilingSettings.store((Map)props);
                        ss.store((Map)props);
                        String projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath();
                        props.setProperty("profiler.info.project.dir", projectDir);
                        if (fo != null) {
                            String singleFile = FileUtil.toFile((FileObject)fo).getAbsolutePath();
                            props.setProperty("profiler.info.single.file", singleFile);
                        }
                        String usedJavaExecutable = ss.getJavaExecutable();
                        String usedJvmArgs = ss.getJVMArgs();
                        if (profilingSettings.getOverrideGlobalSettings()) {
                            JavaPlatform jp;
                            String javaPlatformName = profilingSettings.getJavaPlatformName();
                            if (javaPlatformName != null) {
                                usedJavaExecutable = Profiler.getDefault().getPlatformJavaFile(javaPlatformName);
                                jp = JavaPlatform.getJavaPlatformById((String)javaPlatformName);
                                if (jp == null) {
                                    String text = MessageFormat.format(INVALID_JAVAPLATFORM_MSG, javaPlatformName);
                                    ProfilerDialogs.displayWarning((String)text);
                                    jp = platform;
                                }
                            } else {
                                jp = platform;
                            }
                            props.setProperty("profiler.info.javaPlatform", jp.getPlatformId());
                            usedJvmArgs = profilingSettings.getJVMArgs();
                        } else {
                            props.setProperty("profiler.info.javaPlatform", platform.getPlatformId());
                        }
                        props.setProperty("profiler.info.jvm", usedJavaExecutable);
                        props.setProperty("profiler.info.jvmargs", usedJvmArgs);
                        if (javaVersion.equals("jdk15")) {
                            props.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument15((int)ss.getPortNo(), (int)ss.getSystemArchitecture()));
                            if (platform.getPlatformJDKMinor() >= 7) {
                                AntActions.activateOOMProtection(gps, props, project);
                            } else {
                                ProfilerLogger.log((String)"Profiler.OutOfMemoryDetection: Disabled. Not supported JVM. Use at least 1.4.2_12 or 1.5.0_07");
                            }
                        } else if (javaVersion.equals("jdk16")) {
                            props.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument16((int)ss.getPortNo(), (int)ss.getSystemArchitecture()));
                            AntActions.activateOOMProtection(gps, props, project);
                        } else if (javaVersion.equals("jdk17")) {
                            props.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument17((int)ss.getPortNo(), (int)ss.getSystemArchitecture()));
                            AntActions.activateOOMProtection(gps, props, project);
                        } else if (javaVersion.equals("jdk18")) {
                            props.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument18((int)ss.getPortNo(), (int)ss.getSystemArchitecture()));
                            AntActions.activateOOMProtection(gps, props, project);
                        } else {
                            throw new IllegalArgumentException("Unsupported JDK " + javaVersion);
                        }
                        if (Platform.isLinux() && javaVersion.equals("jdk16")) {
                            AntActions.activateLinuxPosixThreadTime(pSettings, props, project);
                        }
                        if (!support.startProfilingSession(fo, isTest, props)) {
                            AntProjectSupport antSupport = AntProjectSupport.get((Lookup.Provider)project);
                            FileObject buildScriptFO = antSupport.getProjectBuildScript();
                            if (buildScriptFO == null) {
                                ProfilerDialogs.displayError((String)MessageFormat.format(FAILED_DETERMINE_PROJECT_BUILDSCRIPT_MSG, ProjectUtils.getInformation((Project)project).getName()));
                                return;
                            }
                            int type = isTest ? (fo == null ? 3 : 4) : (fo == null ? 1 : 2);
                            String profileTarget = antSupport.getProfilerTargetName(buildScriptFO, type, fo);
                            if (profileTarget == null) {
                                return;
                            }
                            support.configurePropertiesForProfiling(props, fo);
                            ((NetBeansProfiler)Profiler.getDefault()).runTarget(buildScriptFO, profileTarget, props);
                        }
                    }
                }
                finally {
                    ProfilingSupport.getDefault().setProfilingActionInvoked(false);
                }
            }
        };
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RequestProcessor.getDefault().post(actionPerform);
                    }
                }, (String)actionName)) {
                    ProfilingSupport.getDefault().setProfilingActionInvoked(false);
                }
            }
        });
    }

    private static JavaPlatform initPlatform(Project project, ProjectProfilingSupport pps) {
        ProfilerIDESettings gps = ProfilerIDESettings.getInstance();
        JavaPlatform platform = JavaPlatform.getJavaPlatformById((String)gps.getJavaPlatformForProfiling());
        JavaPlatform projectPlatform = pps.getProjectJavaPlatform();
        if (!(platform != null || (platform = projectPlatform) != null && MiscUtils.isSupportedJVM((Map)platform.getSystemProperties()) || (platform = JavaPlatformSelector.getDefault().selectPlatformToUse()) != null)) {
            return null;
        }
        if (projectPlatform != null) {
            Boolean ret;
            while (projectPlatform.getVersion().compareTo(platform.getVersion()) > 0 && !Boolean.TRUE.equals(ret = ProfilerDialogs.displayCancellableConfirmation((String)INCORRECT_JAVA_SPECVERSION_DIALOG_MSG, (String)INCORRECT_JAVA_SPECVERSION_DIALOG_CAPTION))) {
                if (Boolean.FALSE.equals(ret)) {
                    platform = JavaPlatformSelector.getDefault().selectPlatformToUse();
                    if (platform != null) continue;
                    return null;
                }
                return null;
            }
        }
        return platform;
    }
}

