/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import com.sun.source.tree.ClassTree;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.AnnotationMirror;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.EJBVerificationRule;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WSisSLSB
extends EJBVerificationRule {
    @Override
    public Collection<ErrorDescription> check(EJBProblemContext ctx) {
        J2eeModuleProvider provider;
        boolean isEJB = false;
        Project project = FileOwnerQuery.getOwner((FileObject)ctx.getFileObject());
        if (project != null && (provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            J2eeModule module = provider.getJ2eeModule();
            boolean bl = isEJB = module != null && J2eeModule.Type.EJB.equals(module.getType());
        }
        if (!isEJB) {
            return null;
        }
        AnnotationMirror annWebService = JavaUtils.findAnnotation(ctx.getClazz(), "javax.jws.WebService");
        if (annWebService != null) {
            Session session;
            ClassTree classTree = ctx.getComplilationInfo().getTrees().getTree(ctx.getClazz());
            if (ctx.getComplilationInfo().getTreeUtilities().isInterface(classTree)) {
                return null;
            }
            if (ctx.getEjb() instanceof Session && ("Stateless".equals((session = (Session)ctx.getEjb()).getSessionType()) || "Singleton".equals(session.getSessionType()))) {
                return null;
            }
            ErrorDescription err = HintsUtils.createProblem(ctx.getClazz(), ctx.getComplilationInfo(), NbBundle.getMessage(WSisSLSB.class, (String)"MSG_WSisSLSB"));
            return Collections.singletonList(err);
        }
        return null;
    }
}

