/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.LayoutLaunchingPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.LayoutSummaryPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.LayoutWarningPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public final class LayoutIterator
extends BasicWizardIterator {
    private NewTCIterator.DataModel data;

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return Collections.singleton(LayerHandle.forProject(this.data.getProject()).getLayerFile());
    }

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new NewTCIterator.DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new LayoutWarningPanel(wiz, this.data), new LayoutLaunchingPanel(wiz, this.data), new LayoutSummaryPanel(wiz, this.data)};
    }

    @Override
    public void uninitialize(WizardDescriptor wiz) {
        super.uninitialize(wiz);
        this.data = null;
    }

    static void generateFileChanges(NewTCIterator.DataModel model) {
        Map<String, String> newModes;
        boolean propertiesPersistence;
        boolean xmlLessTC;
        boolean actionLessTC;
        CreatedModifiedFiles fileChanges = new CreatedModifiedFiles(model.getProject());
        Project project = model.getProject();
        NbModuleProvider moduleInfo = model.getModuleInfo();
        String name = model.getName();
        String packageName = model.getPackageName();
        String mode = model.getMode();
        try {
            SpecificationVersion current = model.getModuleInfo().getDependencyVersion("org.openide.windows");
            actionLessTC = current == null || current.compareTo((Object)new SpecificationVersion("6.24")) >= 0;
            xmlLessTC = current == null || current.compareTo((Object)new SpecificationVersion("6.37")) >= 0;
        }
        catch (IOException ex) {
            Logger.getLogger(LayoutIterator.class.getName()).log(Level.INFO, null, ex);
            actionLessTC = false;
            xmlLessTC = false;
        }
        try {
            SpecificationVersion current = model.getModuleInfo().getDependencyVersion("org.netbeans.modules.settings");
            propertiesPersistence = current == null || current.compareTo((Object)new SpecificationVersion("1.18")) >= 0;
        }
        catch (IOException ex) {
            Logger.getLogger(LayoutIterator.class.getName()).log(Level.INFO, null, ex);
            propertiesPersistence = false;
        }
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.put("TEMPLATENAME", name);
        replaceTokens.put("PACKAGENAME", packageName);
        replaceTokens.put("MODE", mode);
        replaceTokens.put("OPENED", model.isOpened() ? "true" : "false");
        replaceTokens.put("WINSYSBEHAVIOR", LayoutIterator.defineWinSysBehavior(model));
        String icon = model.getIcon();
        File fil = null;
        if (icon != null && !(fil = new File(icon)).exists()) {
            fil = null;
        }
        String relativeIconPath = null;
        if (fil != null) {
            FileObject fo = FileUtil.toFileObject((File)fil);
            if (!FileUtil.isParentOf((FileObject)Util.getResourceDirectory(project), (FileObject)fo)) {
                String iconPath = LayoutIterator.getRelativePath(moduleInfo.getResourceDirectoryPath(false), packageName, "", fo.getNameExt());
                fileChanges.add(fileChanges.createFile(iconPath, fo));
                relativeIconPath = packageName.replace('.', '/') + "/" + fo.getNameExt();
            } else {
                relativeIconPath = FileUtil.getRelativePath((FileObject)Util.getResourceDirectory(project), (FileObject)fo);
            }
            replaceTokens.put("ICONPATH", relativeIconPath);
            replaceTokens.put("COMMENTICON", "");
        } else {
            replaceTokens.put("ICONPATH", "SET/PATH/TO/ICON/HERE");
            replaceTokens.put("COMMENTICON", "//");
        }
        replaceTokens.put("MODULENAME", moduleInfo.getCodeNameBase());
        String specVersion = moduleInfo.getSpecVersion();
        replaceTokens.put("SPECVERSION", specVersion != null ? specVersion : "0");
        fileChanges.add(fileChanges.addModuleDependency("org.openide.windows"));
        fileChanges.add(fileChanges.addManifestToken("OpenIDE-Module-Requires", WindowManager.class.getName()));
        fileChanges.add(fileChanges.addModuleDependency("org.openide.util"));
        fileChanges.add(fileChanges.addModuleDependency("org.openide.util.lookup"));
        fileChanges.add(fileChanges.addModuleDependency("org.openide.awt"));
        if (propertiesPersistence) {
            fileChanges.add(fileChanges.addModuleDependency("org.netbeans.modules.settings"));
        }
        String tcName = LayoutIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "TopComponent.java");
        FileObject template = CreatedModifiedFiles.getTemplate(xmlLessTC ? "templateTopComponent637.java" : (propertiesPersistence ? "templateTopComponentAnno.java" : "templateTopComponent.java"));
        fileChanges.add(fileChanges.createFileWithSubstitutions(tcName, template, replaceTokens));
        String tcFormName = LayoutIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "TopComponent.form");
        template = CreatedModifiedFiles.getTemplate("templateTopComponent.form");
        fileChanges.add(fileChanges.createFileWithSubstitutions(tcFormName, template, replaceTokens));
        if (!actionLessTC) {
            String actionName = LayoutIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "Action.java");
            template = CreatedModifiedFiles.getTemplate("templateAction.java");
            fileChanges.add(fileChanges.createFileWithSubstitutions(actionName, template, replaceTokens));
        }
        if (!xmlLessTC) {
            String settingsName = name + "TopComponent.settings";
            template = CreatedModifiedFiles.getTemplate("templateSettings.xml");
            fileChanges.add(fileChanges.createLayerEntry("Windows2/Components/" + settingsName, template, replaceTokens, null, null));
        }
        if (!xmlLessTC) {
            String wstcrefName = name + "TopComponent.wstcref";
            template = CreatedModifiedFiles.getTemplate("templateWstcref.xml");
            fileChanges.add(fileChanges.createLayerEntry("Windows2/Modes/" + mode + "/" + wstcrefName, template, replaceTokens, null, null));
        }
        String bundlePath = LayoutIterator.getRelativePath(moduleInfo.getResourceDirectoryPath(false), packageName, "", "Bundle.properties");
        if (!xmlLessTC) {
            if (actionLessTC) {
                String path = "Actions/Window/" + packageName.replace('.', '-') + "-" + name + "Action.instance";
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("instanceCreate", "methodvalue:org.openide.windows.TopComponent.openAction");
                attrs.put("component", "methodvalue:" + packageName + '.' + name + "TopComponent.findInstance");
                if (relativeIconPath != null) {
                    attrs.put("iconBase", relativeIconPath);
                }
                attrs.put("displayName", "bundlevalue:" + packageName + ".Bundle#CTL_" + name + "Action");
                fileChanges.add(fileChanges.createLayerEntry(path, null, null, null, attrs));
                fileChanges.add(fileChanges.createLayerEntry("Menu/Window/" + name + "Action.shadow", null, null, null, Collections.singletonMap("originalFile", path)));
            } else {
                fileChanges.add(fileChanges.layerModifications(new CreateActionEntryOperation(name + "Action", packageName), Collections.<String>emptySet()));
            }
        }
        if (!xmlLessTC) {
            fileChanges.add(fileChanges.bundleKey(bundlePath, "CTL_" + name + "Action", name));
            fileChanges.add(fileChanges.bundleKey(bundlePath, "CTL_" + name + "TopComponent", name + " Window"));
            fileChanges.add(fileChanges.bundleKey(bundlePath, "HINT_" + name + "TopComponent", "This is a " + name + " window"));
        }
        if ((newModes = model.getNewModes()) != null) {
            FileObject parent;
            HashSet<String> files = new HashSet<String>();
            try {
                parent = moduleInfo.getEffectiveSystemFilesystem().findResource("Windows2/Modes");
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
                parent = null;
            }
            for (String wsmode : newModes.keySet()) {
                files.add(LayerUtils.findGeneratedName(parent, wsmode + ".wsmode"));
            }
            fileChanges.add(fileChanges.layerModifications(new CreatedModifiedFiles.LayerOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(FileSystem layer) throws IOException {
                    FileObject fo = FileUtil.createFolder((FileObject)layer.getRoot(), (String)"Windows2/Modes");
                    for (Map.Entry entry : newModes.entrySet()) {
                        FileObject wsmode = fo.createData((String)entry.getKey() + ".wsmode");
                        OutputStream os = wsmode.getOutputStream();
                        try {
                            os.write(((String)entry.getValue()).getBytes("UTF-8"));
                        }
                        finally {
                            os.close();
                        }
                    }
                }
            }, files));
        }
        model.setCreatedModifiedFiles(fileChanges);
    }

    private static String defineWinSysBehavior(NewTCIterator.DataModel model) {
        StringBuffer res = new StringBuffer();
        if (model.isClosingNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_CLOSING_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isDraggingNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_DRAGGING_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isMaximizationNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_MAXIMIZATION_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isSlidingNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_SLIDING_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isUndockingNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_UNDOCKING_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isKeepPrefSize()) {
            res.append("\tputClientProperty(TopComponent.PROP_KEEP_PREFERRED_SIZE_WHEN_SLIDED_IN, Boolean.TRUE);\n");
        }
        return res.toString();
    }

    private static String getRelativePath(String rootpath, String fullyQualifiedPackageName, String prefix, String postfix) {
        StringBuffer sb = new StringBuffer();
        sb.append(rootpath).append('/').append(fullyQualifiedPackageName.replace('.', '/')).append('/').append(prefix).append(postfix);
        return sb.toString();
    }

    static class CreateActionEntryOperation
    implements CreatedModifiedFiles.LayerOperation {
        private String name;
        private String packageName;

        public CreateActionEntryOperation(String actionname, String packageName) {
            this.packageName = packageName;
            this.name = actionname;
        }

        @Override
        public void run(FileSystem layer) throws IOException {
            FileObject folder = layer.getRoot().getFileObject("Actions/Window");
            if (folder == null) {
                folder = FileUtil.createFolder((FileObject)layer.getRoot(), (String)"Actions/Window");
            }
            String instance = this.packageName.replace('.', '-') + "-" + this.name;
            FileObject file = folder.createData(instance, "instance");
            folder = layer.getRoot().getFileObject("Menu/Window");
            if (folder == null) {
                folder = FileUtil.createFolder((FileObject)layer.getRoot(), (String)"Menu/Window");
            }
            file = folder.createData(this.name, "shadow");
            file.setAttribute("originalFile", (Object)("Actions/Window/" + instance + ".instance"));
        }
    }
}

