/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.updatecenter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.updatecenter.DataModel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class UpdateCenterRegistrationPanel
extends BasicWizardIterator.Panel {
    private DataModel data;
    private DocumentListener updateListener;
    private JTextArea createdFiles;
    private JLabel createdFilesLabel;
    private JTextField displayName;
    private JLabel displayNameLabel;
    private JTextArea modifiedFiles;
    private JLabel modifiedFilesLabel;
    private JTextField project;
    private JLabel projectLabel;
    private JTextField ucUrl;
    private JLabel ucUrlLabel;

    public UpdateCenterRegistrationPanel(WizardDescriptor setting, DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.putClientProperty("NewFileWizard_Title", UpdateCenterRegistrationPanel.getMessage("LBL_NewUpdateCenterWizardTitle"));
        this.updateListener = new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                UpdateCenterRegistrationPanel.this.updateData();
            }
        };
    }

    private void addListeners() {
        this.ucUrl.getDocument().addDocumentListener(this.updateListener);
        this.displayName.getDocument().addDocumentListener(this.updateListener);
    }

    private void removeListeners() {
        this.ucUrl.getDocument().removeDocumentListener(this.updateListener);
        this.displayName.getDocument().removeDocumentListener(this.updateListener);
    }

    @Override
    protected String getPanelName() {
        return UpdateCenterRegistrationPanel.getMessage("LBL_UpdateCenterRegistrationPanel_Title");
    }

    @Override
    protected void storeToDataModel() {
        this.removeListeners();
        this.storeBaseData();
    }

    @Override
    protected void readFromDataModel() {
        this.updateData();
        this.addListeners();
    }

    void updateData() {
        this.storeBaseData();
        if (this.checkValidity()) {
            CreatedModifiedFiles files = this.data.refreshCreatedModifiedFiles();
            this.createdFiles.setText(UIUtil.generateTextAreaContent(files.getCreatedPaths()));
            this.modifiedFiles.setText(UIUtil.generateTextAreaContent(files.getModifiedPaths()));
        }
    }

    private void storeBaseData() {
        this.data.setUpdateCenterURL(this.ucUrl.getText().trim());
        this.data.setUpdateCenterDisplayName(this.displayName.getText().trim());
    }

    private boolean checkValidity() {
        boolean result = false;
        if (this.data.getUpdateCenterURL().length() == 0) {
            this.setError(UpdateCenterRegistrationPanel.getMessage("ERR_Url_Is_Empty"));
        } else if (this.data.getUpdateCenterDisplayName().length() == 0) {
            this.setError(UpdateCenterRegistrationPanel.getMessage("ERR_Empty_Display_Name"));
        } else {
            result = true;
            if (!this.data.getUpdateCenterURL().endsWith(".xml")) {
                this.setWarning(UpdateCenterRegistrationPanel.getMessage("WRN_Url_dont_xml_file"));
            } else {
                try {
                    new URL(this.data.getUpdateCenterURL());
                    this.markValid();
                }
                catch (MalformedURLException ex) {
                    this.setWarning(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"WRN_Url_cannot_be_created", (Object)ex.getLocalizedMessage()));
                }
            }
        }
        return result;
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(UpdateCenterRegistrationPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)key);
    }

    private void initComponents() {
        this.ucUrlLabel = new JLabel();
        this.ucUrl = new JTextField();
        this.displayNameLabel = new JLabel();
        this.displayName = new JTextField();
        this.projectLabel = new JLabel();
        this.project = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.createdFilesLabel = new JLabel();
        this.createdFiles = new JTextArea();
        this.modifiedFilesLabel = new JLabel();
        this.modifiedFiles = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"ACN_UpdateCenterRegistrationPanel", (Object[])new Object[0]));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"ACD_UpdateCenterRegistrationPanel", (Object[])new Object[0]));
        this.ucUrlLabel.setLabelFor(this.ucUrl);
        Mnemonics.setLocalizedText((JLabel)this.ucUrlLabel, (String)NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"LBL_UpdateCenterURL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.ucUrlLabel, gridBagConstraints);
        this.ucUrlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"ACD_UpdateCenterRegistrationPanel_ucUrlLabel", (Object[])new Object[0]));
        this.ucUrl.setText(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"CTL_SampleURL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.ucUrl, gridBagConstraints);
        this.displayNameLabel.setLabelFor(this.displayName);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLabel, (String)NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"LBL_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.displayNameLabel, gridBagConstraints);
        this.displayNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"ACD_UpdateCenterRegistrationPanel_displayNameLabel", (Object[])new Object[0]));
        this.displayName.setText(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"CTL_SampleName", (Object[])new Object[]{this.project.getText()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.displayName, gridBagConstraints);
        this.projectLabel.setLabelFor(this.project);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"ACD_UpdateCenterRegistrationPanel_projectLabel", (Object[])new Object[0]));
        this.project.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.project, gridBagConstraints);
        this.createdFilesLabel.setLabelFor(this.createdFiles);
        Mnemonics.setLocalizedText((JLabel)this.createdFilesLabel, (String)NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFilesLabel, gridBagConstraints);
        this.createdFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"ACD_UpdateCenterRegistrationPanel_createdFilesLabel", (Object[])new Object[0]));
        this.createdFiles.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFiles.setColumns(20);
        this.createdFiles.setEditable(false);
        this.createdFiles.setRows(5);
        this.createdFiles.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.modifiedFilesLabel.setLabelFor(this.modifiedFiles);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFilesLabel, (String)NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFilesLabel, gridBagConstraints);
        this.modifiedFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateCenterRegistrationPanel.class, (String)"ACD_UpdateCenterRegistrationPanel_modifiedFilesLabel", (Object[])new Object[0]));
        this.modifiedFiles.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFiles.setColumns(20);
        this.modifiedFiles.setEditable(false);
        this.modifiedFiles.setRows(5);
        this.modifiedFiles.setToolTipText("modifiedFilesValue");
        this.modifiedFiles.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.modifiedFiles, gridBagConstraints);
    }
}

