/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.loader;

import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.loader.FileRecognitionPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.loader.NameAndLocationPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;

public final class NewLoaderIterator
extends BasicWizardIterator {
    private DataModel data;

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return NewLoaderIterator.getCreatedFiles(cmf, this.data.getProject());
    }

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new FileRecognitionPanel(wiz, this.data), new NameAndLocationPanel(wiz, this.data)};
    }

    @Override
    public void uninitialize(WizardDescriptor wiz) {
        super.uninitialize(wiz);
        this.data = null;
    }

    public static void generateFileChanges(DataModel model) {
        String suffix;
        FileObject template;
        HashMap<String, String> replaceTokens;
        String packageName;
        String namePrefix;
        CreatedModifiedFiles fileChanges;
        block30: {
            boolean isEditable;
            String relativeIconPath;
            boolean lookupReadyObject;
            boolean loaderlessObject;
            fileChanges = new CreatedModifiedFiles(model.getProject());
            try {
                SpecificationVersion current = model.getModuleInfo().getDependencyVersion("org.openide.loaders");
                loaderlessObject = current == null || current.compareTo((Object)new SpecificationVersion("7.1")) >= 0;
                lookupReadyObject = current == null || current.compareTo((Object)new SpecificationVersion("6.0")) >= 0;
            }
            catch (IOException ex) {
                Logger.getLogger(NewLoaderIterator.class.getName()).log(Level.INFO, null, ex);
                loaderlessObject = false;
                lookupReadyObject = false;
            }
            namePrefix = model.getPrefix();
            packageName = model.getPackageName();
            final String mime = model.getMimeType();
            replaceTokens = new HashMap<String, String>();
            replaceTokens.put("PREFIX", namePrefix);
            replaceTokens.put("PACKAGENAME", packageName);
            replaceTokens.put("MIMETYPE", mime);
            replaceTokens.put("EXTENSIONS", NewLoaderIterator.formatExtensions(model.isExtensionBased(), model.getExtension(), mime));
            replaceTokens.put("NAMESPACES", NewLoaderIterator.formatNameSpace(model.isExtensionBased(), model.getNamespace(), mime));
            String origIconPath = model.getIconPath();
            if (origIconPath != null && new File(origIconPath).exists()) {
                relativeIconPath = model.addCreateIconOperation(fileChanges, origIconPath);
                replaceTokens.put("IMAGESNIPPET", NewLoaderIterator.formatImageSnippet(relativeIconPath));
                replaceTokens.put("ICONPATH", relativeIconPath);
                replaceTokens.put("COMMENTICON", "");
            } else {
                replaceTokens.put("IMAGESNIPPET", NewLoaderIterator.formatImageSnippet(null));
                replaceTokens.put("ICONPATH", "SET/PATH/TO/ICON/HERE");
                replaceTokens.put("COMMENTICON", "//");
                relativeIconPath = null;
            }
            if (!loaderlessObject) {
                String loaderName = model.getDefaultPackagePath(namePrefix + "DataLoader.java", false);
                template = CreatedModifiedFiles.getTemplate("templateDataLoader.java");
                fileChanges.add(fileChanges.createFileWithSubstitutions(loaderName, template, replaceTokens));
                String loaderInfoName = model.getDefaultPackagePath(namePrefix + "DataLoaderBeanInfo.java", false);
                template = CreatedModifiedFiles.getTemplate("templateDataLoaderBeanInfo.java");
                fileChanges.add(fileChanges.createFileWithSubstitutions(loaderInfoName, template, replaceTokens));
            }
            if (isEditable = Pattern.matches("(application/([a-zA-Z0-9_.-])*\\+xml|text/([a-zA-Z0-9_.+-])*)", mime)) {
                StringBuffer editorBuf = new StringBuffer();
                editorBuf.append("        CookieSet cookies = getCookieSet();\n");
                editorBuf.append("        cookies.add((Node.Cookie) DataEditorSupport.create(this, getPrimaryEntry(), cookies));");
                replaceTokens.put("EDITOR_SUPPORT_SNIPPET", editorBuf.toString());
                replaceTokens.put("EDITOR_SUPPORT_IMPORT", "import org.openide.text.DataEditorSupport;");
            } else {
                replaceTokens.put("EDITOR_SUPPORT_SNIPPET", "");
                replaceTokens.put("EDITOR_SUPPORT_IMPORT", "");
            }
            String doName = model.getDefaultPackagePath(namePrefix + "DataObject.java", false);
            template = null;
            if (loaderlessObject) {
                template = model.isUseMultiview() ? CreatedModifiedFiles.getTemplate("templateDataObjectMulti.java") : CreatedModifiedFiles.getTemplate("templateDataObjectInLayer.java");
            } else if (lookupReadyObject) {
                template = CreatedModifiedFiles.getTemplate("templateDataObjectWithLookup.java");
            }
            if (template == null) {
                template = CreatedModifiedFiles.getTemplate("templateDataObject.java");
            }
            fileChanges.add(fileChanges.createFileWithSubstitutions(doName, template, replaceTokens));
            if (model.isUseMultiview()) {
                String formName = model.getDefaultPackagePath(namePrefix + "VisualElement.form", false);
                String javaName = model.getDefaultPackagePath(namePrefix + "VisualElement.java", false);
                FileObject java = CreatedModifiedFiles.getTemplate("templateDataObjectMultiForm.java");
                FileObject form = CreatedModifiedFiles.getTemplate("templateDataObjectMultiForm.form");
                fileChanges.add(fileChanges.createFile(formName, form));
                fileChanges.add(fileChanges.createFileWithSubstitutions(javaName, java, replaceTokens));
            }
            if (!loaderlessObject) {
                String nodeName = model.getDefaultPackagePath(namePrefix + "DataNode.java", false);
                template = CreatedModifiedFiles.getTemplate("templateDataNode.java");
                fileChanges.add(fileChanges.createFileWithSubstitutions(nodeName, template, replaceTokens));
            }
            template = CreatedModifiedFiles.getTemplate("templateresolver.xml");
            fileChanges.add(fileChanges.createLayerEntry("Services/MIMEResolver/" + namePrefix + "Resolver.xml", template, replaceTokens, namePrefix + " Files", null));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.filesystems"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.loaders"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.nodes"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.util"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.util.lookup"));
            if (isEditable) {
                fileChanges.add(fileChanges.addModuleDependency("org.openide.text"));
            }
            if (isEditable) {
                fileChanges.add(fileChanges.addModuleDependency("org.openide.windows"));
            }
            if (model.isUseMultiview()) {
                fileChanges.add(fileChanges.addModuleDependency("org.netbeans.core.multiview"));
                fileChanges.add(fileChanges.addModuleDependency("org.openide.awt"));
            }
            if (!loaderlessObject) {
                String bundlePath = model.getDefaultPackagePath("Bundle.properties", true);
                fileChanges.add(fileChanges.bundleKey(bundlePath, "LBL_" + namePrefix + "_loader_name", namePrefix + " Files"));
            }
            if (loaderlessObject) {
                String path = "Loaders/" + mime + "/Factories/" + namePrefix + "DataLoader.instance";
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("instanceCreate", "methodvalue:org.openide.loaders.DataLoaderPool.factory");
                attrs.put("dataObjectClass", packageName + "." + namePrefix + "DataObject");
                attrs.put("mimeType", mime);
                if (relativeIconPath != null) {
                    attrs.put("iconBase", relativeIconPath);
                }
                fileChanges.add(fileChanges.createLayerEntry(path, null, null, null, attrs));
            } else {
                boolean isXml = Pattern.matches("(application/([a-zA-Z0-9_.-])*\\+xml|text/([a-zA-Z0-9_.-])*\\+xml)", mime);
                String installBefore = null;
                if (isXml) {
                    installBefore = "org.openide.loaders.XMLDataObject, org.netbeans.modules.xml.XMLDataObject";
                }
                fileChanges.add(fileChanges.addLoaderSection(packageName.replace('.', '/') + "/" + namePrefix + "DataLoader", installBefore));
                fileChanges.add(fileChanges.addLookupRegistration("org.openide.loaders.DataLoader", packageName + '.' + namePrefix + "DataLoader", true));
            }
            fileChanges.add(fileChanges.layerModifications(new CreatedModifiedFiles.LayerOperation(){

                @Override
                public void run(FileSystem layer) throws IOException {
                    ArrayList<String> actions = new ArrayList<String>();
                    if (isEditable) {
                        actions.add("System/org-openide-actions-OpenAction");
                    }
                    actions.addAll(Arrays.asList(null, "Edit/org-openide-actions-CutAction", "Edit/org-openide-actions-CopyAction", null, "Edit/org-openide-actions-DeleteAction", "System/org-openide-actions-RenameAction", null, "System/org-openide-actions-SaveAsTemplateAction", null, "System/org-openide-actions-FileSystemAction", null, "System/org-openide-actions-ToolsAction", "System/org-openide-actions-PropertiesAction"));
                    FileObject folder = FileUtil.createFolder((FileObject)layer.getRoot(), (String)("Loaders/" + mime + "/Actions"));
                    ArrayList<DataObject> kids = new ArrayList<DataObject>();
                    Iterator it = actions.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        FileObject kid;
                        String name = (String)it.next();
                        if (name != null) {
                            kid = folder.createData(name.replaceAll("[^/]*/", "") + ".shadow");
                            kid.setAttribute("originalFile", (Object)("Actions/" + name + ".instance"));
                        } else {
                            kid = folder.createData("sep-" + ++i + ".instance");
                            kid.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
                        }
                        kids.add(DataObject.find((FileObject)kid));
                    }
                    DataFolder.findFolder((FileObject)folder).setOrder(kids.toArray(new DataObject[kids.size()]));
                }
            }, Collections.<String>emptySet()));
            suffix = null;
            if (model.isExtensionBased()) {
                suffix = "Template." + NewLoaderIterator.getFirstExtension(model.getExtension());
                template = CreatedModifiedFiles.getTemplate("templateNew1");
            } else {
                template = CreatedModifiedFiles.getTemplate("templateNew2");
                suffix = "Template.xml";
                try {
                    replaceTokens.put("NAMESPACE", XMLUtil.toElementContent((String)model.getNamespace()));
                }
                catch (CharConversionException ex) {
                    if ($assertionsDisabled) break block30;
                    throw new AssertionError((Object)ex);
                }
            }
        }
        boolean useTR = false;
        NbModuleProvider nbmp = model.getModuleInfo();
        try {
            SpecificationVersion v = nbmp.getDependencyVersion("org.openide.loaders");
            if (v != null && v.compareTo((Object)new SpecificationVersion("7.29")) >= 0) {
                useTR = true;
            }
        }
        catch (IOException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
        String displayName = "Empty " + namePrefix + " file";
        String templateName = namePrefix + suffix;
        if (useTR) {
            fileChanges.add(fileChanges.createFileWithSubstitutions(model.getDefaultPackagePath(templateName, true), template, replaceTokens));
            LinkedHashMap<String, Map<Object, Object>> annos = new LinkedHashMap<String, Map<Object, Object>>();
            LinkedHashMap<String, String> tr = new LinkedHashMap<String, String>();
            tr.put("folder", "Other");
            tr.put("displayName", "#" + namePrefix + "template_displayName");
            tr.put("content", templateName);
            annos.put("org.netbeans.api.templates.TemplateRegistration", tr);
            annos.put("org.openide.util.NbBundle.Messages", Collections.singletonMap("value", namePrefix + "template_displayName=" + displayName));
            fileChanges.add(fileChanges.packageInfo(packageName, annos));
        } else {
            fileChanges.add(fileChanges.createLayerEntry("Templates/Other/" + templateName, template, replaceTokens, displayName, Collections.singletonMap("template", true)));
        }
        model.setCreatedModifiedFiles(fileChanges);
    }

    private static String formatExtensions(boolean isExtensionBased, String ext, String mime) {
        if (!isExtensionBased) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(ext, " ,");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken().trim();
            if (element.startsWith(".")) {
                element = element.substring(1);
            }
            buff.append("        <ext name=\"").append(element).append("\"/>\n");
        }
        buff.append("        <resolver mime=\"").append(mime).append("\"/>");
        return buff.toString();
    }

    private static String getFirstExtension(String ext) {
        StringTokenizer tokens = new StringTokenizer(ext, " ,");
        String element = "someextension";
        if (tokens.hasMoreTokens() && (element = tokens.nextToken().trim()).startsWith(".")) {
            element = element.substring(1);
        }
        return element;
    }

    private static String formatNameSpace(boolean isExtensionBased, String namespace, String mime) {
        StringBuffer buff;
        block3: {
            if (isExtensionBased) {
                return "";
            }
            buff = new StringBuffer();
            buff.append("        <ext name=\"xml\"/>\n");
            buff.append("        <resolver mime=\"").append(mime).append("\">\n");
            buff.append("            <xml-rule>\n");
            try {
                buff.append("                <element ns=\"").append(XMLUtil.toElementContent((String)namespace)).append("\"/>\n");
            }
            catch (CharConversionException ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)ex);
            }
        }
        buff.append("            </xml-rule>\n");
        buff.append("        </resolver>");
        return buff.toString();
    }

    private static String formatImageSnippet(String path) {
        if (path == null) {
            return "return super.getIcon(type); // TODO add a custom icon here: ImageUtilities.loadImage(..., true)\n";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("        if (type == BeanInfo.ICON_COLOR_16x16 || type == BeanInfo.ICON_MONO_16x16) {\n");
        buff.append("            return ImageUtilities.loadImage(\"");
        buff.append(path).append("\");\n");
        buff.append("        } else {\n");
        buff.append("            return null;\n        }\n");
        return buff.toString();
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private String prefix;
        private String iconPath;
        private String mimeType;
        private boolean extensionBased = true;
        private String extension;
        private String namespace;
        private boolean useMultiview;
        private CreatedModifiedFiles files;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.files;
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getIconPath() {
            return this.iconPath;
        }

        public void setIconPath(String iconPath) {
            this.iconPath = iconPath;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public boolean isExtensionBased() {
            return this.extensionBased;
        }

        public void setExtensionBased(boolean extensionBased) {
            this.extensionBased = extensionBased;
        }

        public boolean canUseMultiview() {
            try {
                SpecificationVersion v = this.getModuleInfo().getDependencyVersion("org.netbeans.core.multiview");
                if (v == null) {
                    return false;
                }
                SpecificationVersion l = this.getModuleInfo().getDependencyVersion("org.openide.loaders");
                if (l == null) {
                    return false;
                }
                return v.compareTo((Object)new SpecificationVersion("1.24")) >= 0 && l.compareTo((Object)new SpecificationVersion("7.26")) >= 0;
            }
            catch (IOException ex) {
                return false;
            }
        }

        public boolean isUseMultiview() {
            return this.useMultiview;
        }

        public void setUseMultiview(boolean useMultiview) {
            this.useMultiview = useMultiview;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }
    }
}

