/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.netbeans.modules.apisupport.project.ui.wizard.action.DataModel;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ActionTypePanel
extends BasicWizardIterator.Panel {
    private static final Map<String, String> NAME_TO_FQCN;
    private DataModel data;
    private JRadioButton alwaysEnabled;
    private JRadioButton condionallyEnabled;
    private JComboBox cookieClass;
    private JLabel cookieClassTxt;
    private JLabel filler;
    private ButtonGroup modeGroup;
    private JRadioButton modeMultiple;
    private JRadioButton modeOne;
    private ButtonGroup whenEnabledGroup;

    public ActionTypePanel(WizardDescriptor setting, DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccesibility();
        this.putClientProperty("NewFileWizard_Title", ActionTypePanel.getMessage("LBL_ActionWizardTitle"));
        this.cookieClass.setModel(ActionTypePanel.createCookieClassModel());
    }

    @Override
    protected String getPanelName() {
        return ActionTypePanel.getMessage("LBL_ActionType_Title");
    }

    @Override
    protected void storeToDataModel() {
        this.data.setAlwaysEnabled(this.alwaysEnabled.isSelected());
        this.data.setCookieClasses(this.getCookieClasses());
        this.data.setMultiSelection(this.isMultiSelection());
    }

    private String[] getCookieClasses() {
        StringTokenizer classesST = new StringTokenizer(this.cookieClass.getEditor().getItem().toString(), ", ");
        ArrayList<String> classes = new ArrayList<String>();
        while (classesST.hasMoreTokens()) {
            String clazz = classesST.nextToken().trim();
            String fqcn = NAME_TO_FQCN.get(clazz);
            classes.add(fqcn == null ? clazz : fqcn);
        }
        String[] s = new String[classes.size()];
        return classes.toArray(s);
    }

    @Override
    protected void readFromDataModel() {
        this.condionallyEnabledActionPerformed(null);
        this.markValid();
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(ActionTypePanel.class);
    }

    private boolean isMultiSelection() {
        return this.modeMultiple.isSelected();
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(ActionTypePanel.class, (String)key);
    }

    private static ComboBoxModel createCookieClassModel() {
        DefaultComboBoxModel<String> cookieClassModel = new DefaultComboBoxModel<String>();
        for (String fqcn : DataModel.PREDEFINED_COOKIE_CLASSES) {
            String name = DataModel.parseClassName(fqcn);
            cookieClassModel.addElement(name);
        }
        return cookieClassModel;
    }

    private void initComponents() {
        this.whenEnabledGroup = new ButtonGroup();
        this.modeGroup = new ButtonGroup();
        this.alwaysEnabled = new JRadioButton();
        this.condionallyEnabled = new JRadioButton();
        this.cookieClassTxt = new JLabel();
        this.cookieClass = new JComboBox();
        this.filler = new JLabel();
        this.modeOne = new JRadioButton();
        this.modeMultiple = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.whenEnabledGroup.add(this.alwaysEnabled);
        this.alwaysEnabled.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.alwaysEnabled, (String)NbBundle.getMessage(ActionTypePanel.class, (String)"CTL_AlwaysEnabled"));
        this.alwaysEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.alwaysEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.alwaysEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionTypePanel.this.condionallyEnabledActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.alwaysEnabled, gridBagConstraints);
        this.whenEnabledGroup.add(this.condionallyEnabled);
        Mnemonics.setLocalizedText((AbstractButton)this.condionallyEnabled, (String)NbBundle.getMessage(ActionTypePanel.class, (String)"CTL_ConditionallyEnabled"));
        this.condionallyEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.condionallyEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.condionallyEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionTypePanel.this.condionallyEnabledActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.condionallyEnabled, gridBagConstraints);
        this.cookieClassTxt.setLabelFor(this.cookieClass);
        Mnemonics.setLocalizedText((JLabel)this.cookieClassTxt, (String)NbBundle.getMessage(ActionTypePanel.class, (String)"LBL_CookieClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 6, 0);
        this.add((Component)this.cookieClassTxt, gridBagConstraints);
        this.cookieClass.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.add((Component)this.cookieClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        this.modeGroup.add(this.modeOne);
        this.modeOne.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.modeOne, (String)NbBundle.getMessage(ActionTypePanel.class, (String)"CTL_ModeOneNode"));
        this.modeOne.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.modeOne.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 6, 0);
        this.add((Component)this.modeOne, gridBagConstraints);
        this.modeGroup.add(this.modeMultiple);
        Mnemonics.setLocalizedText((AbstractButton)this.modeMultiple, (String)NbBundle.getMessage(ActionTypePanel.class, (String)"CTL_ModeMultipleNode"));
        this.modeMultiple.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.modeMultiple.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 0, 0);
        this.add((Component)this.modeMultiple, gridBagConstraints);
    }

    private void condionallyEnabledActionPerformed(ActionEvent evt) {
        boolean enabled = this.condionallyEnabled.isSelected();
        this.cookieClass.setEnabled(enabled);
        this.cookieClassTxt.setEnabled(enabled);
        this.modeOne.setEnabled(enabled);
        this.modeMultiple.setEnabled(enabled);
    }

    private void initAccesibility() {
        this.getAccessibleContext().setAccessibleDescription(ActionTypePanel.getMessage("ACS_ActionTypePanel"));
        this.alwaysEnabled.getAccessibleContext().setAccessibleDescription(ActionTypePanel.getMessage("ACS_CTL_alwaysEnabled"));
        this.condionallyEnabled.getAccessibleContext().setAccessibleDescription(ActionTypePanel.getMessage("ACS_CTL_condionallyEnabled"));
        this.cookieClass.getAccessibleContext().setAccessibleDescription(ActionTypePanel.getMessage("ACS_CTL_cookieClass"));
        this.modeMultiple.getAccessibleContext().setAccessibleDescription(ActionTypePanel.getMessage("ACS_CTL_modeMultiple"));
        this.modeOne.getAccessibleContext().setAccessibleDescription(ActionTypePanel.getMessage("ACS_CTL_modeOne"));
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>(DataModel.PREDEFINED_COOKIE_CLASSES.length);
        for (String fqcn : DataModel.PREDEFINED_COOKIE_CLASSES) {
            String name = DataModel.parseClassName(fqcn);
            map.put(name, fqcn);
        }
        NAME_TO_FQCN = Collections.unmodifiableMap(map);
    }
}

