/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.ui.branding.AbstractBrandingPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class BasicBrandingPanel
extends AbstractBrandingPanel {
    private URL iconSource48;
    private URL iconSource32;
    private URL iconSource16;
    private boolean titleValueModified;
    private JButton browse16;
    private JButton browse32;
    private JButton browse48;
    private ButtonGroup buttonGroup1;
    private JLabel icon16;
    private JLabel icon32;
    private JLabel icon48;
    private JLabel iconPreview16;
    private JLabel iconPreview32;
    private JLabel iconPreview48;
    private JLabel lblSpacer;
    private JLabel title;
    private JTextField titleValue;

    public BasicBrandingPanel(BrandingModel model) {
        super(NbBundle.getMessage(BasicBrandingPanel.class, (String)"LBL_BasicTab"), model);
        this.initComponents();
        this.refresh();
        this.checkValidity();
        UIUtil.DocumentAdapter textFieldChangeListener = new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BasicBrandingPanel.this.checkValidity();
                BasicBrandingPanel.this.setModified();
                BasicBrandingPanel.this.titleValueModified = true;
            }
        };
        this.titleValue.getDocument().addDocumentListener(textFieldChangeListener);
        this.titleValueModified = false;
    }

    protected void checkValidity() {
        boolean panelValid = true;
        if (panelValid && this.titleValue.getText().trim().length() == 0) {
            this.setErrorMessage(NbBundle.getMessage(BasicBrandingPanel.class, (String)"ERR_EmptyTitle"));
            panelValid = false;
        }
        if (panelValid) {
            this.setErrorMessage(null);
        }
        this.setValid(panelValid);
    }

    void refresh() {
        BrandingModel model = this.getBranding();
        model.brandingEnabledRefresh();
        model.initTitle(true);
        this.titleValue.setText(model.getTitle());
        this.iconSource48 = model.getIconSource(48);
        if (this.iconSource48 != null) {
            ((ImagePreview)this.iconPreview48).setImage(new ImageIcon(this.iconSource48));
        }
        this.iconSource32 = model.getIconSource(32);
        if (this.iconSource32 != null) {
            ((ImagePreview)this.iconPreview32).setImage(new ImageIcon(this.iconSource32));
        }
        this.iconSource16 = model.getIconSource(16);
        if (this.iconSource16 != null) {
            ((ImagePreview)this.iconPreview16).setImage(new ImageIcon(this.iconSource16));
        }
        this.browse16.setEnabled(null != this.iconSource16 && model.isBrandingEnabled());
        this.browse32.setEnabled(null != this.iconSource32 && model.isBrandingEnabled());
        this.browse48.setEnabled(null != this.iconSource48 && model.isBrandingEnabled());
        this.titleValue.setEnabled(model.isBrandingEnabled());
    }

    @Override
    public void store() {
        if (this.titleValueModified) {
            this.getBranding().setTitle(this.titleValue.getText());
        }
        this.getBranding().setIconSource(48, this.iconSource48);
        this.getBranding().setIconSource(32, this.iconSource32);
        this.getBranding().setIconSource(16, this.iconSource16);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.title = new JLabel();
        this.titleValue = new JTextField();
        this.iconPreview48 = new ImagePreview(48, 48);
        this.browse48 = new JButton();
        this.icon48 = new JLabel();
        this.icon16 = new JLabel();
        this.iconPreview16 = new ImagePreview(16, 16);
        this.browse16 = new JButton();
        this.icon32 = new JLabel();
        this.iconPreview32 = new ImagePreview(32, 32);
        this.browse32 = new JButton();
        this.lblSpacer = new JLabel();
        this.setLayout(new GridBagLayout());
        this.title.setLabelFor(this.titleValue);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/branding/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.title, (String)bundle.getString("LBL_AppTitle"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.title, gridBagConstraints);
        this.title.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Title"));
        this.titleValue.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.titleValue, gridBagConstraints);
        this.iconPreview48.setLabelFor(this.iconPreview48);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.iconPreview48, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browse48, (String)bundle.getString("CTL_Browse"));
        this.browse48.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicBrandingPanel.this.browse48ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.browse48, gridBagConstraints);
        this.browse48.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Browse"));
        Mnemonics.setLocalizedText((JLabel)this.icon48, (String)bundle.getString("LBL_AppIcon48"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 12);
        this.add((Component)this.icon48, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.icon16, (String)bundle.getString("LBL_AppIcon16"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(23, 10, 0, 12);
        this.add((Component)this.icon16, gridBagConstraints);
        this.iconPreview16.setLabelFor(this.iconPreview48);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(23, 0, 0, 12);
        this.add((Component)this.iconPreview16, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browse16, (String)bundle.getString("CTL_Browse"));
        this.browse16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicBrandingPanel.this.browse16ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(23, 0, 0, 0);
        this.add((Component)this.browse16, gridBagConstraints);
        this.browse16.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicBrandingPanel.class, (String)"ACS_Browse"));
        Mnemonics.setLocalizedText((JLabel)this.icon32, (String)bundle.getString("LBL_AppIcon32"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 12);
        this.add((Component)this.icon32, gridBagConstraints);
        this.iconPreview32.setLabelFor(this.iconPreview48);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.iconPreview32, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browse32, (String)bundle.getString("CTL_Browse"));
        this.browse32.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicBrandingPanel.this.browse32ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.browse32, gridBagConstraints);
        this.browse32.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicBrandingPanel.class, (String)"ACS_Browse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.add((Component)this.lblSpacer, gridBagConstraints);
    }

    private void browse48ActionPerformed(ActionEvent evt) {
        this.iconSource48 = this.browseIcon((ImagePreview)this.iconPreview48);
    }

    private void browse16ActionPerformed(ActionEvent evt) {
        this.iconSource16 = this.browseIcon((ImagePreview)this.iconPreview16);
    }

    private void browse32ActionPerformed(ActionEvent evt) {
        this.iconSource32 = this.browseIcon((ImagePreview)this.iconPreview32);
    }

    private URL browseIcon(ImagePreview preview) {
        URL res = null;
        JFileChooser chooser = UIUtil.getIconFileChooser();
        int ret = chooser.showDialog(this, NbBundle.getMessage(this.getClass(), (String)"LBL_Select"));
        if (ret == 0) {
            File file = chooser.getSelectedFile();
            try {
                res = file.toURI().toURL();
                preview.setImage(new ImageIcon(res));
                this.setModified();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return res;
    }

    static class ImagePreview
    extends JLabel {
        private ImageIcon image = null;
        private int width;
        private int height;

        ImagePreview(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g;
            if (!this.isEnabled()) {
                g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
            }
            if (this.getWidth() >= this.width && this.getHeight() >= this.height && this.image != null) {
                int x = 0;
                int y = 0;
                g.drawImage(this.image.getImage(), x, y, this.width, this.height, this.getBackground(), null);
            }
        }

        private void setImage(ImageIcon image) {
            this.image = image;
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }
    }
}

