/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.modules.Dependency;

public final class ManifestManager {
    private static final Logger LOG = Logger.getLogger(ManifestManager.class.getName());
    private String codeNameBase;
    private String releaseVersion;
    private String specificationVersion;
    private String implementationVersion;
    private String[] provTokens;
    private String provTokensString;
    private String[] requiredTokens;
    private String[] neededTokens;
    private String localizingBundle;
    private String layer;
    private String generatedLayer;
    private String classPath;
    private PackageExport[] publicPackages;
    private String[] friendNames;
    private String moduleDependencies;
    private boolean deprecated;
    private Boolean autoUpdateShowInClient;
    public static final String OPENIDE_MODULE = "OpenIDE-Module";
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String OPENIDE_MODULE_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String OPENIDE_MODULE_IMPLEMENTATION_VERSION = "OpenIDE-Module-Implementation-Version";
    public static final String OPENIDE_MODULE_PROVIDES = "OpenIDE-Module-Provides";
    public static final String OPENIDE_MODULE_REQUIRES = "OpenIDE-Module-Requires";
    public static final String OPENIDE_MODULE_NEEDS = "OpenIDE-Module-Needs";
    public static final String OPENIDE_MODULE_LAYER = "OpenIDE-Module-Layer";
    public static final String OPENIDE_MODULE_LOCALIZING_BUNDLE = "OpenIDE-Module-Localizing-Bundle";
    public static final String OPENIDE_MODULE_PUBLIC_PACKAGES = "OpenIDE-Module-Public-Packages";
    public static final String BUNDLE_EXPORT_PACKAGE = "Export-Package";
    public static final String BUNDLE_IMPORT_PACKAGE = "Import-Package";
    public static final String BUNDLE_REQUIRE_BUNDLE = "Require-Bundle";
    public static final String BUNDLE_LOCALIZATION = "Bundle-Localization";
    public static final String OPENIDE_MODULE_FRIENDS = "OpenIDE-Module-Friends";
    public static final String OPENIDE_MODULE_MODULE_DEPENDENCIES = "OpenIDE-Module-Module-Dependencies";
    public static final String CLASS_PATH = "Class-Path";
    public static final String AUTO_UPDATE_SHOW_IN_CLIENT = "AutoUpdate-Show-In-Client";
    public static final String GENERATED_LAYER_PATH = "META-INF/generated-layer.xml";
    public static final PackageExport[] EMPTY_EXPORTED_PACKAGES = new PackageExport[0];
    public static final ManifestManager NULL_INSTANCE = new ManifestManager();

    private ManifestManager() {
        this.provTokens = new String[0];
        this.requiredTokens = new String[0];
        this.neededTokens = new String[0];
    }

    private ManifestManager(String cnb, String releaseVersion, String specVer, String implVer, String provTokensString, String requiredTokens, String neededTokens, String locBundle, String layer, boolean withGeneratedLayer, String classPath, PackageExport[] publicPackages, String[] friendNames, boolean deprecated, Boolean autoUpdateShowInClient, String moduleDependencies) {
        this.codeNameBase = cnb;
        this.releaseVersion = releaseVersion;
        this.specificationVersion = specVer;
        this.implementationVersion = implVer;
        this.provTokensString = provTokensString;
        this.provTokens = this.parseTokens(provTokensString);
        this.requiredTokens = this.parseTokens(requiredTokens);
        this.neededTokens = this.parseTokens(neededTokens);
        this.localizingBundle = locBundle;
        this.layer = layer;
        if (withGeneratedLayer) {
            this.generatedLayer = GENERATED_LAYER_PATH;
        }
        this.classPath = classPath;
        this.publicPackages = publicPackages == null ? EMPTY_EXPORTED_PACKAGES : publicPackages;
        this.friendNames = friendNames;
        this.deprecated = deprecated;
        this.autoUpdateShowInClient = autoUpdateShowInClient;
        this.moduleDependencies = moduleDependencies;
    }

    private String[] parseTokens(String tokens) {
        if (tokens == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(tokens, ",");
        String[] result = new String[st.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = st.nextToken().trim();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManifestManager getInstance(File manifest, boolean loadPublicPackages) {
        if (manifest.exists()) {
            ManifestManager manifestManager;
            FileInputStream mis = new FileInputStream(manifest);
            try {
                Manifest mf = new Manifest(mis);
                manifestManager = ManifestManager.getInstance(mf, loadPublicPackages);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)mis).close();
                    throw throwable;
                }
                catch (IOException x) {
                    LOG.log(Level.INFO, "While opening: " + manifest, x);
                }
            }
            ((InputStream)mis).close();
            return manifestManager;
        }
        return NULL_INSTANCE;
    }

    public static ManifestManager getInstanceFromJAR(File jar) {
        return ManifestManager.getInstanceFromJAR(jar, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManifestManager getInstanceFromJAR(File jar, boolean withGeneratedLayer) {
        ManifestManager manifestManager;
        if (!jar.isFile()) {
            throw new IOException("No such JAR: " + jar);
        }
        JarFile jf = new JarFile(jar, false);
        try {
            String cp;
            Manifest m = jf.getManifest();
            if (m == null) {
                throw new IOException("No manifest in " + jar);
            }
            ManifestManager mm = ManifestManager.getInstance(m, true, withGeneratedLayer = withGeneratedLayer && jf.getJarEntry(GENERATED_LAYER_PATH) != null);
            if (Arrays.asList(mm.getProvidedTokens()).contains("org.osgi.framework.launch.FrameworkFactory") && (cp = m.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                for (String piece : cp.split("[, ]+")) {
                    File ext;
                    if (piece.isEmpty() || !(ext = new File(jar.getParentFile().toURI().resolve(piece.trim()))).isFile()) continue;
                    ManifestManager mm2 = ManifestManager.getInstanceFromJAR(ext);
                    ArrayList<String> toks = new ArrayList<String>(Arrays.asList(mm.provTokens));
                    toks.addAll(Arrays.asList(mm2.provTokens));
                    mm.provTokens = toks.toArray(new String[toks.size()]);
                }
            }
            manifestManager = mm;
        }
        catch (Throwable throwable) {
            try {
                jf.close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "While opening: " + jar, e);
                return NULL_INSTANCE;
            }
        }
        jf.close();
        return manifestManager;
    }

    @NonNull
    public static ManifestManager getInstance(@NonNull Manifest manifest, boolean loadPublicPackages) {
        return ManifestManager.getInstance(manifest, loadPublicPackages, false);
    }

    @NonNull
    public static ManifestManager getInstance(@NonNull Manifest manifest, boolean loadPublicPackages, boolean withGeneratedLayer) {
        Attributes attr = manifest.getMainAttributes();
        String codename = attr.getValue(OPENIDE_MODULE);
        if (codename == null && attr.getValue(BUNDLE_SYMBOLIC_NAME) != null) {
            return ManifestManager.getOSGiInstance(manifest, loadPublicPackages, withGeneratedLayer);
        }
        String codenamebase = null;
        String releaseVersion = null;
        if (codename != null) {
            int slash = codename.lastIndexOf(47);
            if (slash == -1) {
                codenamebase = codename;
            } else {
                codenamebase = codename.substring(0, slash);
                releaseVersion = codename.substring(slash + 1);
            }
        }
        PackageExport[] publicPackages = null;
        String[] friendNames = null;
        if (loadPublicPackages) {
            String friends;
            publicPackages = EMPTY_EXPORTED_PACKAGES;
            String pp = attr.getValue(OPENIDE_MODULE_PUBLIC_PACKAGES);
            if (pp != null) {
                publicPackages = ManifestManager.parseExportedPackages(pp);
            }
            if ((friends = attr.getValue(OPENIDE_MODULE_FRIENDS)) != null && (friendNames = ManifestManager.parseFriends(friends)).length > 0 && publicPackages.length == 0) {
                throw new IllegalArgumentException("No use specifying OpenIDE-Module-Friends without any public packages: " + friends);
            }
        }
        boolean deprecated = "true".equals(attr.getValue("OpenIDE-Module-Deprecated"));
        String autoUpdateShowInClient = attr.getValue(AUTO_UPDATE_SHOW_IN_CLIENT);
        return new ManifestManager(codenamebase, releaseVersion, attr.getValue(OPENIDE_MODULE_SPECIFICATION_VERSION), attr.getValue(OPENIDE_MODULE_IMPLEMENTATION_VERSION), attr.getValue(OPENIDE_MODULE_PROVIDES), attr.getValue(OPENIDE_MODULE_REQUIRES), attr.getValue(OPENIDE_MODULE_NEEDS), attr.getValue(OPENIDE_MODULE_LOCALIZING_BUNDLE), attr.getValue(OPENIDE_MODULE_LAYER), withGeneratedLayer, attr.getValue(CLASS_PATH), publicPackages, friendNames, deprecated, autoUpdateShowInClient != null ? Boolean.valueOf(autoUpdateShowInClient) : null, attr.getValue(OPENIDE_MODULE_MODULE_DEPENDENCIES));
    }

    private static ManifestManager getOSGiInstance(Manifest manifest, boolean loadPublicPackages, boolean withGeneratedLayer) {
        Attributes attr = manifest.getMainAttributes();
        String codenamebase = attr.getValue(BUNDLE_SYMBOLIC_NAME);
        int semicolon = codenamebase.indexOf(59);
        if (semicolon >= 0) {
            codenamebase = codenamebase.substring(0, semicolon);
        }
        codenamebase = codenamebase.replace('-', '_');
        String requires = null;
        String provides = null;
        PackageExport[] publicPackages = EMPTY_EXPORTED_PACKAGES;
        if (loadPublicPackages) {
            String pp = attr.getValue(BUNDLE_EXPORT_PACKAGE);
            StringBuilder sb = new StringBuilder();
            sb.append(codenamebase);
            if (pp != null) {
                ArrayList<PackageExport> arr = new ArrayList<PackageExport>();
                for (String p : pp.replaceAll("\"[^\"]*\"", "").split(",")) {
                    PackageExport pe = new PackageExport(p.replaceAll(";.*$", "").trim(), false);
                    arr.add(pe);
                    sb.append(',').append(pe.getPackage());
                }
                publicPackages = arr.toArray(new PackageExport[0]);
            }
            provides = sb.toString();
        }
        StringBuffer sb = new StringBuffer();
        String sep = "";
        String pp = attr.getValue(BUNDLE_IMPORT_PACKAGE);
        if (pp != null) {
            for (String p : pp.replaceAll("\"[^\"]*\"", "").split(",")) {
                String pkg = p.replaceAll(";.*$", "").trim();
                if (pkg.startsWith("javax.")) continue;
                sb.append(sep).append(pkg);
                sep = ",";
            }
        }
        if ((pp = attr.getValue(BUNDLE_REQUIRE_BUNDLE)) != null) {
            for (String p : pp.replaceAll("\"[^\"]*\"", "").split(",")) {
                sb.append(sep).append(p.replaceAll(";.*$", "").trim());
                sep = ",";
            }
        }
        requires = sb.length() == 0 ? null : sb.toString().replace('-', '_');
        return new ManifestManager(codenamebase, null, ManifestManager.just3dots(attr.getValue(BUNDLE_VERSION)), attr.getValue(BUNDLE_VERSION), provides, requires, null, attr.getValue(BUNDLE_LOCALIZATION) + ".properties", attr.getValue(OPENIDE_MODULE_LAYER), withGeneratedLayer, attr.getValue(CLASS_PATH), publicPackages, null, false, null, attr.getValue(OPENIDE_MODULE_MODULE_DEPENDENCIES));
    }

    private static String just3dots(String v) {
        if (v == null) {
            return null;
        }
        String[] segments = v.split("\\.");
        int max = 3;
        int[] version = new int[segments.length > 3 ? 3 : segments.length];
        for (int i = 0; i < version.length; ++i) {
            version[i] = Integer.parseInt(segments[i]);
        }
        StringBuilder sb = new StringBuilder();
        String conditionalDot = "";
        for (int i = 0; i < version.length; ++i) {
            sb.append(conditionalDot);
            sb.append(version[i]);
            conditionalDot = ".";
        }
        return sb.toString();
    }

    private static PackageExport[] parseExportedPackages(String exportsS) {
        PackageExport[] exportedPackages = null;
        if (exportsS.trim().equals("-")) {
            exportedPackages = EMPTY_EXPORTED_PACKAGES;
        } else {
            StringTokenizer tok = new StringTokenizer(exportsS, ", ");
            ArrayList<PackageExport> exports = new ArrayList<PackageExport>(Math.max(tok.countTokens(), 1));
            while (tok.hasMoreTokens()) {
                String pkg;
                String piece = tok.nextToken();
                if (piece.endsWith(".*")) {
                    pkg = piece.substring(0, piece.length() - 2);
                    Dependency.create((int)1, (String)pkg);
                    if (pkg.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    exports.add(new PackageExport(pkg, false));
                    continue;
                }
                if (piece.endsWith(".**")) {
                    pkg = piece.substring(0, piece.length() - 3);
                    Dependency.create((int)1, (String)pkg);
                    if (pkg.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    exports.add(new PackageExport(pkg, true));
                    continue;
                }
                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
            }
            if (exports.isEmpty()) {
                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
            }
            exportedPackages = exports.toArray(new PackageExport[exports.size()]);
        }
        return exportedPackages;
    }

    private static String[] parseFriends(String friends) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(friends, ", ");
        while (tok.hasMoreTokens()) {
            String piece = tok.nextToken();
            if (piece.indexOf(47) != -1) {
                throw new IllegalArgumentException("May specify only module code name bases in OpenIDE-Module-Friends, not major release versions: " + piece);
            }
            Dependency.create((int)1, (String)piece);
            set.add(piece);
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Empty OpenIDE-Module-Friends: " + friends);
        }
        return set.toArray(new String[set.size()]);
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getProvidedTokensString() {
        return this.provTokensString;
    }

    public String[] getProvidedTokens() {
        return this.provTokens;
    }

    public String[] getRequiredTokens() {
        return this.requiredTokens;
    }

    public String[] getNeededTokens() {
        return this.neededTokens;
    }

    public String getLocalizingBundle() {
        return this.localizingBundle;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getGeneratedLayer() {
        return this.generatedLayer;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    public String[] getFriends() {
        return this.friendNames;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Boolean getAutoUpdateShowInClient() {
        return this.autoUpdateShowInClient;
    }

    public Set<Dependency> getModuleDependencies() {
        if (this.moduleDependencies != null) {
            return Dependency.create((int)1, (String)this.moduleDependencies);
        }
        return Collections.emptySet();
    }

    public static final class PackageExport {
        private final String pkg;
        private final boolean recursive;

        public PackageExport(String pkg, boolean recursive) {
            this.pkg = pkg;
            this.recursive = recursive;
        }

        public String getPackage() {
            return this.pkg;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "/**" : "") + "]";
        }
    }
}

