/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.deployment.deviceanywhere;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.deployment.deviceanywhere.DeviceAnywhereDeploymentPlugin;
import org.netbeans.modules.deployment.deviceanywhere.DeviceChooser;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIDeviceWrapper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

public class DeviceAnywhereCustomizerPanel
extends JPanel {
    private List<ApplicationAPIDeviceWrapper> devices;
    private DeviceAnywhereDeploymentPlugin.PropertyEvaluator evaluator;
    private JTextField allDevices;
    private JComboBox devicesComboBox;
    private JPanel inputPasswordPanel;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPasswordField passwordField;
    private JButton retriveButton;
    private JTextField selectedDevice;
    private JTextField selectedDeviceCareer;
    ItemListener il = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (DeviceAnywhereCustomizerPanel.this.devices == null) {
                return;
            }
            String deviceName = (String)DeviceAnywhereCustomizerPanel.this.devicesComboBox.getSelectedItem();
            for (ApplicationAPIDeviceWrapper elem : DeviceAnywhereCustomizerPanel.this.devices) {
                assert (deviceName != null) : "Device name must not be null here";
                if (!deviceName.equals(elem.getName())) continue;
                DeviceAnywhereCustomizerPanel.this.selectedDevice.setText(String.valueOf(elem.getId()));
                DeviceAnywhereCustomizerPanel.this.selectedDeviceCareer.setText(elem.getCarrier());
                return;
            }
        }
    };
    DocumentListener dl = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }
    };

    DeviceAnywhereCustomizerPanel(DeviceAnywhereDeploymentPlugin.PropertyEvaluator evaluator) {
        this.initComponents();
        this.allDevices.setVisible(false);
        this.selectedDevice.setVisible(false);
        this.selectedDeviceCareer.setVisible(false);
        this.add(this.allDevices);
        this.add(this.selectedDevice);
        this.add(this.selectedDeviceCareer);
        this.retriveButton.addActionListener(new DeviceListener());
        this.evaluator = evaluator;
    }

    @Override
    public void addNotify() {
        String input = this.allDevices.getText();
        if (input.length() != 0) {
            this.devicesComboBox.removeAllItems();
            this.devices = new ArrayList<ApplicationAPIDeviceWrapper>();
            try {
                StringTokenizer st = new StringTokenizer(input, ";");
                while (st.hasMoreElements()) {
                    String token = st.nextToken();
                    StringTokenizer item = new StringTokenizer(token, ",");
                    String s = item.nextToken();
                    int deviceId = Integer.parseInt(s.substring(s.indexOf("=") + 1));
                    s = item.nextToken();
                    String deviceName = s.substring(s.indexOf("=") + 1);
                    s = item.nextToken();
                    String deviceCareer = s.substring(s.indexOf("=") + 1);
                    ApplicationAPIDeviceWrapper wrapper = new ApplicationAPIDeviceWrapper();
                    wrapper.setId(deviceId);
                    wrapper.setName(deviceName);
                    wrapper.setCarrier(deviceCareer);
                    this.devices.add(wrapper);
                    this.devicesComboBox.addItem(deviceName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.devices == null || this.devices.size() == 0) {
            this.selectedDevice.setText("-1");
            this.devicesComboBox.addItem(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"MSG_NoDevice"));
        } else {
            String deviceId = this.selectedDevice.getText();
            for (ApplicationAPIDeviceWrapper elem : this.devices) {
                if (!deviceId.equals(String.valueOf(elem.getId()))) continue;
                this.devicesComboBox.setSelectedItem(elem.getName());
                break;
            }
            if (this.devicesComboBox.getSelectedIndex() == -1) {
                this.devicesComboBox.setSelectedIndex(0);
            }
        }
        this.retriveButton.setEnabled(true);
        this.devicesComboBox.addItemListener(this.il);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.devicesComboBox.removeItemListener(this.il);
    }

    private void initComponents() {
        this.allDevices = new JTextField();
        this.selectedDevice = new JTextField();
        this.selectedDeviceCareer = new JTextField();
        this.inputPasswordPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.passwordField = new JPasswordField();
        this.devicesComboBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.retriveButton = new JButton();
        this.allDevices.setName("deployment.deviceanywhere.availabledevices");
        this.selectedDevice.setName("deployment.deviceanywhere.device");
        this.selectedDeviceCareer.setName("deployment.deviceanywhere.career");
        this.jLabel1.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"MSG_InsertPass"));
        GroupLayout inputPasswordPanelLayout = new GroupLayout(this.inputPasswordPanel);
        this.inputPasswordPanel.setLayout(inputPasswordPanelLayout);
        inputPasswordPanelLayout.setHorizontalGroup(inputPasswordPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPasswordPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordField, -1, 274, Short.MAX_VALUE).addContainerGap()));
        inputPasswordPanelLayout.setVerticalGroup(inputPasswordPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPasswordPanelLayout.createSequentialGroup().addContainerGap().addGroup(inputPasswordPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.passwordField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"ACSN_InsertPass"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"ACSD_InsertPass"));
        this.jLabel5.setLabelFor(this.devicesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"LBL_Device"));
        Mnemonics.setLocalizedText((AbstractButton)this.retriveButton, (String)NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"LBL_RetriveDevices"));
        this.retriveButton.setActionCommand(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"LBL_RetriveDevices"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.devicesComboBox, 0, 316, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.retriveButton).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.retriveButton).addComponent(this.jLabel5).addComponent(this.devicesComboBox, -2, -1, -2)).addContainerGap(173, Short.MAX_VALUE)));
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"ACSN_Device"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"ACSD_Device"));
        this.retriveButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"ACSN_RetriveDevices"));
        this.retriveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"ACSD_RetriveDevices"));
    }

    private class DeviceListener
    implements ActionListener {
        protected final JButton okButton = new JButton(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"LBL_ChooseOK"));

        DeviceListener() {
            this.okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"ACSN_ChooseOK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"ACSD_ChooseOK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String password;
            String user = DeviceAnywhereCustomizerPanel.this.evaluator.evaluateGlobalProperty("deployment.deviceanywhere.userid", DeviceAnywhereCustomizerPanel.this.evaluator.evaluateProperty("deployment.instance"));
            if (user.trim().length() == 0) {
                NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"MSG_InsertUsername"), NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"TITLE_InsertUsername"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)input);
                if (input.getValue() == NotifyDescriptor.OK_OPTION) {
                    user = input.getInputText();
                } else {
                    return;
                }
            }
            if ((password = DeviceAnywhereCustomizerPanel.this.evaluator.evaluateGlobalProperty("deployment.deviceanywhere.password", DeviceAnywhereCustomizerPanel.this.evaluator.evaluateProperty("deployment.instance"))).trim().length() == 0) {
                DialogDescriptor input = new DialogDescriptor((Object)DeviceAnywhereCustomizerPanel.this.inputPasswordPanel, NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"TITLE_InsertPass"));
                DialogDisplayer.getDefault().createDialog(input).setVisible(true);
                if (input.getValue() == NotifyDescriptor.OK_OPTION) {
                    password = new String(DeviceAnywhereCustomizerPanel.this.passwordField.getPassword());
                } else {
                    return;
                }
            }
            final DeviceChooser panel = new DeviceChooser(user, password, null);
            Object[] options = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                        DeviceListener.this.okButton.doClick();
                    } else {
                        DeviceListener.this.okButton.setEnabled(panel.getSelectedDevice() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(DeviceAnywhereCustomizerPanel.class, (String)"TITLE_ChooseDevice"), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                DeviceAnywhereCustomizerPanel.this.devicesComboBox.removeItemListener(DeviceAnywhereCustomizerPanel.this.il);
                DeviceAnywhereCustomizerPanel.this.devices = panel.getLockedDevices();
                DeviceAnywhereCustomizerPanel.this.devicesComboBox.removeAllItems();
                int i = 0;
                StringBuffer sb = new StringBuffer();
                for (ApplicationAPIDeviceWrapper elem : DeviceAnywhereCustomizerPanel.this.devices) {
                    DeviceAnywhereCustomizerPanel.this.devicesComboBox.addItem(elem.getName());
                    sb.append("DeviceID-");
                    sb.append(i);
                    sb.append("=");
                    sb.append(elem.getId());
                    sb.append(",");
                    sb.append("DeviceName-");
                    sb.append(i);
                    sb.append("=");
                    sb.append(elem.getName());
                    sb.append(",");
                    sb.append("DeviceCareer-");
                    sb.append(i);
                    sb.append("=");
                    sb.append(elem.getCarrier());
                    sb.append(";");
                    ++i;
                }
                ApplicationAPIDeviceWrapper selected = panel.getSelectedDevice();
                DeviceAnywhereCustomizerPanel.this.devicesComboBox.setSelectedItem(selected.getName());
                DeviceAnywhereCustomizerPanel.this.selectedDevice.setText(String.valueOf(selected.getId()));
                DeviceAnywhereCustomizerPanel.this.selectedDeviceCareer.setText(selected.getCarrier());
                DeviceAnywhereCustomizerPanel.this.allDevices.setText(sb.toString());
                DeviceAnywhereCustomizerPanel.this.devicesComboBox.addItemListener(DeviceAnywhereCustomizerPanel.this.il);
            }
            dlg.dispose();
        }
    }
}

