/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.SchemaNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class SchemaNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Catalog> catalogHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private SchemaNodeProvider(Lookup lookup) {
        super(lookup, new SchemaComparator());
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Catalog cat = (Catalog)SchemaNodeProvider.this.catalogHandle.resolve(metaData);
                        if (cat != null) {
                            Schema syntheticSchema = cat.getSyntheticSchema();
                            if (syntheticSchema != null) {
                                SchemaNodeProvider.this.updateNode(newList, syntheticSchema);
                            } else {
                                Collection schemas = cat.getSchemas();
                                for (Schema schema : schemas) {
                                    SchemaNodeProvider.this.updateNode(newList, schema);
                                }
                            }
                            if (syntheticSchema != null) {
                                SchemaNodeProvider.this.setProxyNodes(newList);
                            } else {
                                SchemaNodeProvider.this.setNodes(newList);
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        } else {
            this.setNodes(newList);
        }
    }

    private void updateNode(List<Node> newList, Schema schema) {
        MetadataElementHandle schemaHandle = MetadataElementHandle.create((MetadataElement)schema);
        Collection<Node> matches = this.getNodes(schemaHandle);
        if (matches.size() > 0) {
            newList.addAll(matches);
        } else {
            NodeDataLookup lookup = new NodeDataLookup();
            lookup.add(this.connection);
            lookup.add(schemaHandle);
            newList.add((Node)SchemaNode.create(lookup, this));
        }
    }

    static class SchemaComparator
    implements Comparator<Node> {
        SchemaComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            assert (node1.getDisplayName() != null) : node1 + " has display name.";
            assert (node2.getDisplayName() != null) : node2 + " has display name.";
            return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public SchemaNodeProvider createInstance(Lookup lookup) {
                SchemaNodeProvider provider = new SchemaNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

