/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.api.ui.ConnectionNotifier;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

public class ConnectionNotifierDelegate
implements ConnectionListener {
    private static final Map<ExecutionEnvironment, ConnectionNotifierDelegate> instances = new HashMap<ExecutionEnvironment, ConnectionNotifierDelegate>();
    private static RequestProcessor RP_WORKER = new RequestProcessor("Connection worker", 2);
    private static RequestProcessor RP_NOTIFIER = new RequestProcessor("Connection notifier", 1);
    private final ExecutionEnvironment env;
    private boolean shown;
    private Notification notification;
    private final Set<ConnectionNotifier.NamedRunnable> tasks = new HashSet<ConnectionNotifier.NamedRunnable>();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionNotifierDelegate getInstance(ExecutionEnvironment env) {
        Map<ExecutionEnvironment, ConnectionNotifierDelegate> map = instances;
        synchronized (map) {
            ConnectionNotifierDelegate instance = instances.get(env);
            if (instance == null) {
                instance = new ConnectionNotifierDelegate(env);
                instances.put(env, instance);
            }
            return instance;
        }
    }

    public ConnectionNotifierDelegate(ExecutionEnvironment execEnv) {
        this.env = execEnv;
        this.shown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ConnectionNotifier.NamedRunnable task) {
        Set<ConnectionNotifier.NamedRunnable> set = this.tasks;
        synchronized (set) {
            this.tasks.add(task);
            this.showIfNeed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(ConnectionNotifier.NamedRunnable task) {
        Set<ConnectionNotifier.NamedRunnable> set = this.tasks;
        synchronized (set) {
            this.tasks.remove(task);
        }
    }

    public void connected(ExecutionEnvironment env) {
        if (this.env.equals(env)) {
            ConnectionManager.getInstance().removeConnectionListener((ConnectionListener)this);
            RP_WORKER.post((Runnable)new ConnectionNotifier.NamedRunnable("Connection notifier for " + env.getDisplayName()){

                protected void runImpl() {
                    ConnectionNotifierDelegate.this.onConnect();
                }
            });
        }
    }

    public void disconnected(ExecutionEnvironment env) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnect() {
        ArrayList<ConnectionNotifier.NamedRunnable> toLaunch;
        Notification n;
        Object object = this.lock;
        synchronized (object) {
            n = this.notification;
            this.shown = false;
        }
        if (n != null) {
            n.clear();
        }
        Set<ConnectionNotifier.NamedRunnable> set = this.tasks;
        synchronized (set) {
            toLaunch = new ArrayList<ConnectionNotifier.NamedRunnable>(this.tasks);
            this.tasks.clear();
        }
        for (ConnectionNotifier.NamedRunnable task : toLaunch) {
            RP_NOTIFIER.post((Runnable)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showIfNeed() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shown) {
                return;
            }
            this.shown = true;
            ConnectionManager cm = ConnectionManager.getInstance();
            cm.addConnectionListener((ConnectionListener)this);
            this.show(null);
        }
    }

    private void show(final Exception error) {
        final ActionListener onClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RP_WORKER.post((Runnable)new ConnectionNotifier.NamedRunnable("Requesting connection for " + ConnectionNotifierDelegate.this.env.getDisplayName()){

                    protected void runImpl() {
                        ConnectionNotifierDelegate.this.connect();
                    }
                });
            }
        };
        Runnable edtRunner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String details;
                ImageIcon icon;
                String title;
                String envString = ConnectionNotifierDelegate.this.env.getDisplayName();
                String text = null;
                if (error == null) {
                    StringBuilder reasons = new StringBuilder();
                    for (ConnectionNotifier.NamedRunnable task : ConnectionNotifierDelegate.this.tasks) {
                        reasons.append(task.getName());
                        reasons.append(' ');
                    }
                    text = reasons.toString();
                    title = NbBundle.getMessage(ConnectionNotifierDelegate.class, (String)"ConnectionNotifier.TITLE", (Object)envString);
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/remote/impl/fs/ui/exclamation.gif", (boolean)false);
                    details = NbBundle.getMessage(ConnectionNotifierDelegate.class, (String)"ConnectionNotifier.DETAILS", (Object)envString);
                } else {
                    title = NbBundle.getMessage(this.getClass(), (String)"ConnectionNotifier.error.TITLE", (Object)envString);
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/remote/impl/fs/ui/error.png", (boolean)false);
                    String errMsg = error.getMessage() == null ? "" : error.getMessage();
                    details = NbBundle.getMessage(this.getClass(), (String)"ConnectionNotifier.error.DETAILS", (Object)errMsg, (Object)envString);
                }
                JComponent baloonComponent = ConnectionNotifierDelegate.this.createDetails(text, details, onClickAction);
                JComponent popupComponent = ConnectionNotifierDelegate.this.createDetails(text, details, onClickAction);
                Notification n = NotificationDisplayer.getDefault().notify(title, (Icon)icon, baloonComponent, popupComponent, NotificationDisplayer.Priority.HIGH);
                Object object = ConnectionNotifierDelegate.this.lock;
                synchronized (object) {
                    ConnectionNotifierDelegate.this.notification = n;
                }
            }
        };
        SwingUtilities.invokeLater(edtRunner);
    }

    private JComponent createDetails(String explanationText, String buttonText, ActionListener action) {
        Parameters.notNull((CharSequence)"action", (Object)action);
        try {
            buttonText = "<html><u>" + XMLUtil.toElementContent((String)buttonText);
        }
        catch (CharConversionException ex) {
            throw new IllegalArgumentException(ex);
        }
        JButton btn = new JButton(buttonText);
        btn.setFocusable(false);
        btn.setBorder(BorderFactory.createEmptyBorder());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setOpaque(false);
        btn.setContentAreaFilled(false);
        btn.addActionListener(action);
        btn.setCursor(Cursor.getPredefinedCursor(12));
        btn.setForeground(Color.blue);
        if (explanationText == null || explanationText.length() == 0) {
            return btn;
        }
        JPanel res = new JPanel(new BorderLayout());
        JLabel text = new JLabel(explanationText);
        text.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        res.add((Component)text, "Center");
        res.add((Component)btn, "South");
        res.setOpaque(false);
        return res;
    }

    private void connect() {
        try {
            ConnectionManager.getInstance().connectTo(this.env);
        }
        catch (IOException ex) {
            this.reShow(ex);
        }
        catch (ConnectionManager.CancellationException ex) {
            this.reShow(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reShow(Exception error) {
        Object object = this.lock;
        synchronized (object) {
            this.shown = false;
        }
        this.show(error);
    }
}

