/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.util.HashSet;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.openide.filesystems.FileObject;

public final class RemoteLink
extends RemoteLinkBase {
    private String normalizedTargetPath;

    public static RemoteLink createNew(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath, String link) {
        RemoteLink res = new RemoteLink(fileSystem, execEnv, parent, remotePath, link);
        return res;
    }

    private RemoteLink(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath, String link) {
        super(fileSystem, execEnv, parent, remotePath);
        this.setLink(link, parent);
    }

    private static String normalize(String link, FileObject parent) {
        if (link.startsWith("/")) {
            return link;
        }
        String parentPath = parent.getPath();
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        return PathUtilities.normalizeUnixPath((String)(parentPath + '/' + link));
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getType() {
        return FileInfoProvider.StatInfo.FileType.SymbolicLink;
    }

    @Override
    public RemoteFileObjectBase getDelegate() {
        HashSet<String> antiLoop = new HashSet<String>();
        antiLoop.add(this.getPath());
        RemoteFileObjectBase delegate = this.getFileSystem().findResource(this.normalizedTargetPath, antiLoop);
        return delegate;
    }

    @Override
    protected String getDelegateNormalizedPath() {
        return this.normalizedTargetPath;
    }

    final void setLink(String link, FileObject parent) {
        this.normalizedTargetPath = RemoteLink.normalize(link, parent);
    }

    @Override
    protected void postDeleteChild(FileObject child) {
        this.getDelegate().postDeleteChild(child);
    }

    @Override
    protected void deleteImpl() throws IOException {
        RemoteFileSystemUtils.delete(this.getExecutionEnvironment(), this.getPath(), false);
    }
}

