/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.api.ui.FileObjectBasedFile;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RecursiveListener;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public abstract class RemoteFileObjectBase
extends FileObject
implements Serializable {
    private final RemoteFileSystem fileSystem;
    private final RemoteFileObjectBase parent;
    private volatile String remotePath;
    private final File cache;
    private CopyOnWriteArrayList<FileChangeListener> listeners = new CopyOnWriteArrayList();
    private final FileLock lock = new FileLock();
    static final long serialVersionUID = 1931650016889811086L;
    private volatile byte flags;
    private static final byte MASK_VALID = 1;
    private static final byte CHECK_CAN_WRITE = 2;
    private static final byte BEING_UPLOADED = 4;
    protected static final byte CONNECTION_ISSUES = 8;
    static final boolean RETURN_JAVA_IO_FILE = Boolean.getBoolean("remote.java.io.file");

    protected RemoteFileObjectBase(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath, File cache) {
        RemoteLogger.assertTrue(execEnv.isRemote());
        this.fileSystem = fileSystem;
        this.parent = parent;
        this.remotePath = remotePath;
        this.cache = cache;
        this.setFlag((byte)1, true);
    }

    protected boolean getFlag(byte mask) {
        return (this.flags & mask) == mask;
    }

    protected final void setFlag(byte mask, boolean value) {
        this.flags = value ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    boolean isPendingRemoteDelivery() {
        return this.getFlag((byte)4);
    }

    void setPendingRemoteDelivery(boolean value) {
        this.setFlag((byte)4, value);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.fileSystem.getExecutionEnvironment();
    }

    protected final File getCache() {
        return this.cache;
    }

    public String getPath() {
        return this.remotePath;
    }

    public void addFileChangeListener(FileChangeListener fcl) {
        this.listeners.add(fcl);
    }

    public void removeFileChangeListener(FileChangeListener fcl) {
        this.listeners.remove(fcl);
    }

    protected final Enumeration<FileChangeListener> getListeners() {
        return Collections.enumeration(this.listeners);
    }

    protected final Enumeration<FileChangeListener> getListenersWithParent() {
        RemoteFileObjectBase p = this.getParent();
        if (p == null) {
            return this.getListeners();
        }
        Enumeration<FileChangeListener> parentListeners = p.getListeners();
        if (!parentListeners.hasMoreElements()) {
            return this.getListeners();
        }
        ArrayList<FileChangeListener> result = new ArrayList<FileChangeListener>(this.listeners);
        while (parentListeners.hasMoreElements()) {
            result.add(parentListeners.nextElement());
        }
        return Collections.enumeration(result);
    }

    public void addRecursiveListener(FileChangeListener fcl) {
        if (!this.isFolder()) {
            this.addFileChangeListener(fcl);
            return;
        }
        this.getFileSystem().addFileChangeListener(new RecursiveListener(this, fcl, false));
    }

    public void removeRecursiveListener(FileChangeListener fcl) {
        if (this.isFolder()) {
            this.getFileSystem().removeFileChangeListener(new RecursiveListener(this, fcl, false));
        } else {
            this.removeFileChangeListener(fcl);
        }
    }

    protected abstract void deleteImpl() throws IOException;

    protected abstract void postDeleteChild(FileObject var1);

    public void delete(FileLock lock) throws IOException {
        this.deleteImpl();
        this.invalidate();
        RemoteFileObjectBase p = this.getParent();
        if (p != null) {
            p.postDeleteChild(this);
        }
    }

    public String getExt() {
        String nameExt = this.getNameExt();
        int pointPos = nameExt.lastIndexOf(46);
        return pointPos < 0 ? "" : nameExt.substring(pointPos + 1);
    }

    public RemoteFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getName() {
        String nameExt = this.getNameExt();
        int pointPos = nameExt.lastIndexOf(46);
        return pointPos < 0 ? nameExt : nameExt.substring(0, pointPos);
    }

    public String getNameExt() {
        int slashPos = this.getPath().lastIndexOf(47);
        return slashPos < 0 ? "" : this.getPath().substring(slashPos + 1);
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new ReadOnlyException();
    }

    public abstract RemoteFileObjectBase getFileObject(String var1);

    public abstract RemoteFileObjectBase getFileObject(String var1, String var2);

    public abstract RemoteFileObjectBase[] getChildren();

    protected RemoteFileObjectBase[] getExistentChildren() {
        return new RemoteFileObjectBase[0];
    }

    public RemoteFileObjectBase getParent() {
        return this.parent;
    }

    public long getSize() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent != null) {
                return canonicalParent.getSize(this);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return 0L;
    }

    @Deprecated
    public boolean isReadOnly() {
        return !this.canRead();
    }

    public boolean canRead() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent == null) {
                return true;
            }
            return canonicalParent.canRead(this.getNameExt());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return true;
        }
    }

    public boolean canExecute() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent == null) {
                return true;
            }
            return canonicalParent.canExecute(this.getNameExt());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return true;
        }
    }

    void connectionChanged() {
        if (this.getFlag((byte)2)) {
            this.setFlag((byte)2, false);
            this.fireFileAttributeChangedEvent(this.getListeners(), new FileAttributeEvent((FileObject)this, (FileObject)this, "DataEditorSupport.read-only.refresh", null, null));
        }
    }

    public boolean canWrite() {
        this.setFlag((byte)2, true);
        if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            this.getFileSystem().addReadOnlyConnectNotification(this);
            return false;
        }
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent == null) {
                return false;
            }
            boolean result = canonicalParent.canWrite(this.getNameExt());
            if (!result) {
                this.setFlag((byte)2, false);
            }
            return result;
        }
        catch (ConnectException ex) {
            return false;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    protected void refreshImpl(boolean recursive, Set<String> antiLoop) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
    }

    public void refresh(boolean expected) {
        try {
            this.refreshImpl(true, null);
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex, this);
        }
        catch (IOException ex) {
            RemoteLogger.info(ex, this);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex, this);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex, this);
        }
        catch (ExecutionException ex) {
            RemoteLogger.info(ex, this);
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isValid() {
        if (this.getFlag((byte)1)) {
            RemoteFileObjectBase p = this.getParent();
            return p == null || p.isValid();
        }
        return false;
    }

    void invalidate() {
        this.setFlag((byte)1, false);
    }

    public boolean isVirtual() {
        return false;
    }

    public Date lastModified() {
        if (this.isPendingRemoteDelivery()) {
            return new Date(-1L);
        }
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent != null) {
                return canonicalParent.lastModified(this);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new Date(0L);
    }

    public FileLock lock() throws IOException {
        return this.lock;
    }

    public void rename(FileLock lock, String name, String ext) throws IOException {
        RemoteFileObjectBase p = this.getParent();
        if (p != null) {
            String newNameExt = RemoteFileObjectBase.composeName(name, ext);
            if (newNameExt.equals(this.getNameExt())) {
                return;
            }
            if (!p.isValid()) {
                throw new IOException("Can not rename in " + p.getPath());
            }
            if (!p.canWrite()) {
                throw new IOException("Can not rename in read only " + p.getPath());
            }
            if (p.getFileObject(newNameExt) != null) {
                throw new IOException("Can not rename to " + newNameExt);
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                throw new IOException("No connection: Can not rename in " + p.getPath());
            }
            try {
                p.renameChild(lock, this, newNameExt);
            }
            catch (ConnectException ex) {
                throw new IOException("No connection: Can not rename in " + p.getPath(), ex);
            }
            catch (InterruptedException ex) {
                InterruptedIOException outEx = new InterruptedIOException("interrupted: Can not rename in " + p.getPath());
                outEx.initCause(ex);
                throw outEx;
            }
            catch (CancellationException ex) {
                throw new IOException("cancelled: Can not rename in " + p.getPath(), ex);
            }
            catch (ExecutionException ex) {
                throw new IOException("Can not rename to " + newNameExt + ": exception occurred", ex);
            }
        }
    }

    public Object getAttribute(String attrName) {
        if (attrName.equals("isRemoteAndSlow")) {
            return Boolean.TRUE;
        }
        if (RETURN_JAVA_IO_FILE && attrName.equals("java.io.File")) {
            return new FileObjectBasedFile(this.getExecutionEnvironment(), (FileObject)this);
        }
        return this.getFileSystem().getAttribute(this, attrName);
    }

    public Enumeration<String> getAttributes() {
        return this.getFileSystem().getAttributes(this);
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        this.getFileSystem().setAttribute(this, attrName, value);
    }

    @Deprecated
    public void setImportant(boolean b) {
    }

    public abstract FileInfoProvider.StatInfo.FileType getType();

    protected abstract void renameChild(FileLock var1, RemoteFileObjectBase var2, String var3) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    final void renamePath(String newPath) {
        this.remotePath = newPath;
    }

    public String toString() {
        String validity = this.isValid() ? " [valid]" : (this.getFlag((byte)1) ? " [invalid] (flagged)" : " [invalid]");
        return this.getExecutionEnvironment().toString() + ":" + this.getPath() + validity;
    }

    public boolean equals(Object obj) {
        String otherPath;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteFileObjectBase other = (RemoteFileObjectBase)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (!(this.getFileSystem() == other.getFileSystem() || this.getFileSystem() != null && ((Object)((Object)this.fileSystem)).equals((Object)other.fileSystem))) {
            return false;
        }
        if (!(this.getExecutionEnvironment() == other.getExecutionEnvironment() || this.getExecutionEnvironment() != null && this.getExecutionEnvironment().equals(other.getExecutionEnvironment()))) {
            return false;
        }
        String thisPath = this.getPath();
        return thisPath == (otherPath = other.getPath()) || thisPath != null && thisPath.equals(otherPath);
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + (this.getFileSystem() != null ? ((Object)((Object)this.getFileSystem())).hashCode() : 0);
        hash = 11 * hash + (this.getExecutionEnvironment() != null ? this.getExecutionEnvironment().hashCode() : 0);
        String thisPath = this.getPath();
        hash = 11 * hash + (thisPath != null ? thisPath.hashCode() : 0);
        return hash;
    }

    protected static String composeName(String name, String ext) {
        return ext != null && ext.length() > 0 ? name + "." + ext : name;
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.getExecutionEnvironment(), this.getPath());
    }

    private static class SerializedForm
    implements Serializable {
        private final ExecutionEnvironment env;
        private final String remotePath;

        public SerializedForm(ExecutionEnvironment env, String remotePath) {
            this.env = env;
            this.remotePath = remotePath;
        }

        Object readResolve() throws ObjectStreamException {
            RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(this.env);
            RemoteFileObjectBase fo = fs.findResource(this.remotePath);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fs, (CharSequence)this.remotePath);
            }
            return fo;
        }
    }

    private static class ReadOnlyException
    extends IOException {
        public ReadOnlyException() {
            super("The remote file system is read-only");
        }
    }
}

