/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.FormatException;
import org.openide.util.Exceptions;

public class DirEntrySftp
implements DirEntry {
    private final FileInfoProvider.StatInfo statInfo;
    private String cache;

    public DirEntrySftp(FileInfoProvider.StatInfo statInfo, String cache) {
        this.statInfo = statInfo;
        this.cache = cache;
    }

    @Override
    public boolean canExecute(ExecutionEnvironment execEnv) {
        return this.statInfo.canExecute(execEnv);
    }

    @Override
    public boolean canRead(ExecutionEnvironment execEnv) {
        return this.statInfo.canRead(execEnv);
    }

    @Override
    public boolean canWrite(ExecutionEnvironment execEnv) {
        return this.statInfo.canWrite(execEnv);
    }

    @Override
    public String getAccessAsString() {
        return this.statInfo.getAccessAsString();
    }

    @Override
    public String getCache() {
        return this.cache;
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getFileType() {
        if (this.statInfo.isDirectory()) {
            return FileInfoProvider.StatInfo.FileType.Directory;
        }
        if (this.statInfo.isLink()) {
            return FileInfoProvider.StatInfo.FileType.SymbolicLink;
        }
        if (this.statInfo.isPlainFile()) {
            return FileInfoProvider.StatInfo.FileType.Regular;
        }
        return this.statInfo.getFileType();
    }

    @Override
    public String getLinkTarget() {
        return this.statInfo.getLinkTarget();
    }

    @Override
    public String getName() {
        return this.statInfo.getName();
    }

    @Override
    public long getSize() {
        return this.statInfo.getSize();
    }

    @Override
    public boolean isDirectory() {
        return this.statInfo.isDirectory();
    }

    @Override
    public boolean isLink() {
        return this.statInfo.isLink();
    }

    @Override
    public boolean isPlainFile() {
        return this.statInfo.isPlainFile();
    }

    @Override
    public boolean isSameType(DirEntry other) {
        return this.isLink() == other.isLink() && this.isDirectory() == other.isDirectory() && this.isPlainFile() == other.isPlainFile();
    }

    @Override
    public boolean isSameUser(DirEntry other) {
        if (other instanceof DirEntrySftp) {
            return this.statInfo.getUserId() == ((DirEntrySftp)other).statInfo.getUserId();
        }
        return false;
    }

    @Override
    public boolean isSameLastModified(DirEntry other) {
        if (other instanceof DirEntrySftp) {
            return this.statInfo.getLastModified().equals(((DirEntrySftp)other).statInfo.getLastModified());
        }
        return false;
    }

    @Override
    public Date getLastModified() {
        return this.statInfo.getLastModified();
    }

    @Override
    public boolean isSameGroup(DirEntry other) {
        if (other instanceof DirEntrySftp) {
            return this.statInfo.getGropupId() == ((DirEntrySftp)other).statInfo.getGropupId();
        }
        return false;
    }

    @Override
    public void setCache(String cache) {
        this.cache = cache;
    }

    @Override
    public String toExternalForm() {
        return DirEntrySftp.escape(this.cache) + ' ' + this.statInfo.toExternalForm();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static DirEntrySftp fromExternalForm(String externalForm) throws FormatException {
        try {
            int pos = externalForm.indexOf(32);
            if (pos < 1) {
                throw new FormatException("Wrong directory entry format: " + externalForm, false);
            }
            String cache = DirEntrySftp.unescape(externalForm.substring(0, pos));
            FileInfoProvider.StatInfo statInfo = FileInfoProvider.StatInfo.fromExternalForm((String)externalForm.substring(pos + 1));
            return new DirEntrySftp(statInfo, cache);
        }
        catch (Exception ex) {
            throw new FormatException("Wrong directory entry format: " + externalForm, ex);
        }
    }

    private static String escape(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            text = text.replace(" ", "\\ ");
            return text;
        }
    }

    private static String unescape(String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            text = text.replace("\\ ", " ");
            return text;
        }
    }

    public String toString() {
        return this.statInfo.toString() + " (" + this.cache + ')' + (this.isValid() ? "[valid]" : "[invalid]");
    }
}

