/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.lucene.search.BooleanQuery;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.QueryRequest;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.repository.FindInRepoPanel;
import org.netbeans.modules.maven.repository.VersionNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class FindResultsPanel
extends JPanel
implements ExplorerManager.Provider,
Observer {
    private BeanTreeView btv;
    private ExplorerManager manager;
    private ActionListener close;
    private DialogDescriptor dd;
    private QueryRequest queryRequest;
    private ResultsRootNode resultsRootNode;
    private static final RequestProcessor queryRP = new RequestProcessor(FindResultsPanel.class.getName(), 10);
    private static Node noResultsNode;
    private static Node searchingNode;
    private static Node tooGeneralNode;
    private JButton btnClose;
    private JButton btnModify;
    private JToolBar jToolBar1;

    private FindResultsPanel() {
        this.initComponents();
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.manager = new ExplorerManager();
        this.queryRequest = null;
        this.resultsRootNode = new ResultsRootNode();
        this.manager.setRootContext((Node)this.resultsRootNode);
        this.add((Component)this.btv, "Center");
    }

    FindResultsPanel(ActionListener actionListener, DialogDescriptor d) {
        this();
        this.close = actionListener;
        this.dd = d;
    }

    void find(List<QueryField> fields) {
        if (null != this.queryRequest) {
            this.queryRequest.deleteObserver((Observer)this);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindResultsPanel.this.resultsRootNode.setOneChild(FindResultsPanel.getSearchingNode());
            }
        });
        this.queryRequest = new QueryRequest(fields, RepositoryPreferences.getInstance().getRepositoryInfos(), (Observer)this);
        queryRP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    RepositoryQueries.find((QueryRequest)FindResultsPanel.this.queryRequest);
                }
                catch (BooleanQuery.TooManyClauses exc) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FindResultsPanel.this.resultsRootNode.setOneChild(FindResultsPanel.getTooGeneralNode());
                        }
                    });
                }
                catch (OutOfMemoryError oome) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FindResultsPanel.this.resultsRootNode.setOneChild(FindResultsPanel.getTooGeneralNode());
                        }
                    });
                }
            }
        });
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.btnModify = new JButton();
        this.btnClose = new JButton();
        this.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.btnModify, (String)NbBundle.getMessage(FindResultsPanel.class, (String)"FindResultsPanel.btnModify.text"));
        this.btnModify.setFocusable(false);
        this.btnModify.setHorizontalTextPosition(0);
        this.btnModify.setVerticalTextPosition(3);
        this.btnModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindResultsPanel.this.btnModifyActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnModify);
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(FindResultsPanel.class, (String)"FindResultsPanel.btnClose.text"));
        this.btnClose.setFocusable(false);
        this.btnClose.setHorizontalTextPosition(0);
        this.btnClose.setVerticalTextPosition(3);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindResultsPanel.this.btnCloseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnClose);
        this.add((Component)this.jToolBar1, "First");
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        if (null != this.queryRequest) {
            this.queryRequest.deleteObserver((Observer)this);
        }
        if (this.close != null) {
            this.close.actionPerformed(evt);
        }
    }

    private void btnModifyActionPerformed(ActionEvent evt) {
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)this.dd);
        if (ret == DialogDescriptor.OK_OPTION) {
            this.find(((FindInRepoPanel)this.dd.getMessage()).getQuery());
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (null == o || !(o instanceof QueryRequest)) {
            return;
        }
        List infos = ((QueryRequest)o).getResults();
        final HashMap<String, ArrayList<NBVersionInfo>> map = new HashMap<String, ArrayList<NBVersionInfo>>();
        if (infos != null) {
            for (NBVersionInfo nbvi : infos) {
                String key = nbvi.getGroupId() + " : " + nbvi.getArtifactId();
                ArrayList<NBVersionInfo> get = (ArrayList<NBVersionInfo>)map.get(key);
                if (get == null) {
                    get = new ArrayList<NBVersionInfo>();
                    map.put(key, get);
                }
                get.add(nbvi);
            }
        }
        final ArrayList keyList = new ArrayList(map.keySet());
        Collections.sort(keyList);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindResultsPanel.this.updateResultNodes(keyList, map);
            }
        });
    }

    private void updateResultNodes(List<String> keyList, Map<String, List<NBVersionInfo>> map) {
        if (keyList.size() > 0) {
            HashMap<String, Node> currentNodes = new HashMap<String, Node>();
            for (Object nd : this.resultsRootNode.getChildren().getNodes()) {
                currentNodes.put(nd.getName(), (Node)nd);
            }
            ArrayList<Node> newNodes = new ArrayList<Node>(keyList.size());
            if (null != this.queryRequest && !this.queryRequest.isFinished()) {
                newNodes.add(FindResultsPanel.getSearchingNode());
            }
            for (String key : keyList) {
                Object nd;
                nd = (Node)currentNodes.get(key);
                if (null != nd) {
                    ((ArtifactNode)((Object)nd)).setVersionInfos(map.get(key));
                } else {
                    nd = new ArtifactNode(key, map.get(key));
                }
                newNodes.add((Node)nd);
            }
            this.resultsRootNode.setNewChildren(newNodes);
        } else if (null != this.queryRequest && !this.queryRequest.isFinished()) {
            this.resultsRootNode.setOneChild(FindResultsPanel.getSearchingNode());
        } else {
            this.resultsRootNode.setOneChild(FindResultsPanel.getNoResultsNode());
        }
    }

    private static Node getNoResultsNode() {
        if (noResultsNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/empty.png");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Empty");
            nd.setDisplayName(NbBundle.getMessage(FindResultsPanel.class, (String)"LBL_Node_Empty"));
            noResultsNode = nd;
        }
        return new FilterNode(noResultsNode, Children.LEAF);
    }

    private static Node getSearchingNode() {
        if (searchingNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/wait.gif");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Searching");
            nd.setDisplayName(NbBundle.getMessage(FindResultsPanel.class, (String)"LBL_Node_Searching"));
            searchingNode = nd;
        }
        return new FilterNode(searchingNode, Children.LEAF);
    }

    private static Node getTooGeneralNode() {
        if (tooGeneralNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/empty.png");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Too General");
            nd.setDisplayName(NbBundle.getMessage(FindResultsPanel.class, (String)"LBL_Node_TooGeneral"));
            tooGeneralNode = nd;
        }
        return new FilterNode(tooGeneralNode, Children.LEAF);
    }

    private class ResultsRootChildren
    extends Children.Keys<Node> {
        List<Node> myNodes = Collections.EMPTY_LIST;

        private void setNewChildren(List<Node> ch) {
            this.myNodes = ch;
            this.refreshList();
        }

        protected void addNotify() {
            this.refreshList();
        }

        private void refreshList() {
            ArrayList<Node> keys = new ArrayList<Node>();
            for (Node node : this.myNodes) {
                keys.add(node);
            }
            this.setKeys(keys);
        }

        protected Node[] createNodes(Node key) {
            return new Node[]{key};
        }
    }

    private class ResultsRootNode
    extends AbstractNode {
        private ResultsRootChildren resultsChildren;

        public ResultsRootNode() {
            this(new InstanceContent());
        }

        private ResultsRootNode(InstanceContent content) {
            super((Children)new ResultsRootChildren(), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
            content.add((Object)this);
            this.resultsChildren = (ResultsRootChildren)this.getChildren();
        }

        public void setOneChild(Node n) {
            ArrayList<Node> ch = new ArrayList<Node>(1);
            ch.add(n);
            this.setNewChildren(ch);
        }

        public void setNewChildren(List<Node> ch) {
            this.resultsChildren.setNewChildren(ch);
        }
    }

    private static class ArtifactNode
    extends AbstractNode {
        private List<NBVersionInfo> versionInfos;
        private ArtifactNodeChildren myChildren = (ArtifactNodeChildren)this.getChildren();

        public ArtifactNode(String name, List<NBVersionInfo> list) {
            super((Children)new ArtifactNodeChildren(list));
            this.versionInfos = list;
            this.setName(name);
            this.setDisplayName(name);
        }

        public Image getIcon(int arg0) {
            Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/ArtifactBadge.png", (boolean)true);
            return badge;
        }

        public Image getOpenedIcon(int arg0) {
            return this.getIcon(arg0);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public List<NBVersionInfo> getVersionInfos() {
            return new ArrayList<NBVersionInfo>(this.versionInfos);
        }

        public void setVersionInfos(List<NBVersionInfo> infos) {
            this.versionInfos = infos;
            this.myChildren.setNewKeys(infos);
        }

        static class ArtifactNodeChildren
        extends Children.Keys<NBVersionInfo> {
            private List<NBVersionInfo> keys;

            public ArtifactNodeChildren(List<NBVersionInfo> keys) {
                this.keys = keys;
            }

            protected Node[] createNodes(NBVersionInfo info) {
                RepositoryInfo rinf = RepositoryPreferences.getInstance().getRepositoryInfoById(info.getRepoId());
                return new Node[]{new VersionNode(rinf, info, info.isJavadocExists(), info.isSourcesExists(), true)};
            }

            protected void addNotify() {
                this.setKeys(this.keys);
            }

            protected void setNewKeys(List<NBVersionInfo> keys) {
                this.keys = keys;
                this.setKeys(keys);
            }
        }
    }
}

