/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.RenamePanel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private final String oldName;
    private final String dispOldName;
    private String newName;
    private RenamePanel panel;
    private final boolean fromListener;
    private final CsmObject origObject;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;

    public RenameRefactoringUI(CsmObject csmObject, String newName) {
        FileObject fo;
        this.origObject = csmObject;
        this.dispOldName = this.oldName = CsmRefactoringUtils.getSimpleText(this.origObject);
        this.newName = newName;
        this.fromListener = newName != null;
        Lookup lkp = null;
        if (CsmKindUtilities.isFile((CsmObject)csmObject) && (fo = CsmUtilities.getFileObject((CsmFile)((CsmFile)csmObject))) != null) {
            lkp = Lookups.fixed((Object[])new Object[]{csmObject, fo});
        }
        if (lkp == null) {
            lkp = Lookups.singleton((Object)csmObject);
        }
        this.refactoring = new RenameRefactoring(lkp);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            String name = this.fromListener ? this.newName : this.oldName;
            String title = NbBundle.getMessage(RenamePanel.class, (String)"LBL_RenamePanelTitle", (Object)"", (Object)this.oldName);
            this.panel = new RenamePanel(this.origObject, name, parent, title, !this.fromListener, this.fromListener && !this.byPassPakageRename);
        }
        return this.panel;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)key);
    }

    public Problem setParameters() {
        if (!this.panel.isUpdateReferences()) {
            return null;
        }
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            ((RenameRefactoring)this.refactoring).setSearchInComments(this.panel.searchInComments());
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (!this.panel.isUpdateReferences()) {
            return null;
        }
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RenamePanel.class, (String)"DSC_Rename")).format(new Object[]{this.dispOldName, this.newName});
    }

    public String getName() {
        return NbBundle.getMessage(RenamePanel.class, (String)"LBL_RefactoringRenameName", (Object)this.oldName, (Object)this.newName);
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        String postfix = "";
        return new HelpCtx(RenameRefactoringUI.class.getName() + postfix);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        Object dob = null;
        dob = this.byPassFolder != null ? DataFolder.findFolder((FileObject)this.byPassFolder) : DataObject.find((FileObject)((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)));
        dob.rename(this.panel.getNameValue());
    }
}

