/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.spi.CheckModificationHook;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;

public abstract class CsmModificationRefactoringPlugin
extends CsmRefactoringPlugin {
    private final CsmObject startReferenceObject;
    private final CsmContext editorContext;
    private final AbstractRefactoring refactoring;
    private final Collection<CheckModificationHook> modificationHooks;

    protected CsmModificationRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
        this.startReferenceObject = (CsmObject)refactoring.getRefactoringSource().lookup(CsmObject.class);
        this.editorContext = (CsmContext)refactoring.getRefactoringSource().lookup(CsmContext.class);
        assert (this.startReferenceObject != null || this.editorContext != null) : "no start reference or editor context";
        this.modificationHooks = new ArrayList<CheckModificationHook>(refactoring.getContext().lookupAll(CheckModificationHook.class));
        if (this.modificationHooks.isEmpty()) {
            this.modificationHooks.add(new DefaultHookImpl());
        }
    }

    protected final CsmObject getStartReferenceObject() {
        return this.startReferenceObject;
    }

    protected final CsmContext getEditorContext() {
        return this.editorContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Problem prepare(RefactoringElementsBag elements) {
        Problem out = null;
        try {
            Collection<CsmFile> files = this.getRefactoredFiles();
            this.fireProgressListenerStart(1, files.size());
            out = this.createAndAddElements(files, elements, this.refactoring);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return out;
    }

    protected abstract Collection<CsmFile> getRefactoredFiles();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Problem checkIfModificationPossible(Problem problem, CsmObject referencedObject) {
        this.fireProgressListenerStep();
        try {
            for (CheckModificationHook hook : this.modificationHooks) {
                problem = hook.appendProblem(this.refactoring, problem, referencedObject);
                if (problem == null || !problem.isFatal()) continue;
                Problem problem2 = problem;
                return problem2;
            }
        }
        finally {
            this.fireProgressListenerStep();
        }
        return problem;
    }

    @Override
    protected final ModificationResult processFiles(Collection<CsmFile> files, AtomicReference<Problem> outProblem) {
        ModificationResult out = null;
        for (CsmFile csmFile : files) {
            if (this.isCancelled()) {
                return null;
            }
            if (out == null) {
                out = new ModificationResult(csmFile.getProject());
            }
            this.processFile(csmFile, out, outProblem);
            this.fireProgressListenerStep();
        }
        return out;
    }

    protected abstract void processFile(CsmFile var1, ModificationResult var2, AtomicReference<Problem> var3);

    private static final class DefaultHookImpl
    extends CheckModificationHook {
        private DefaultHookImpl() {
        }

        @Override
        public Problem appendProblem(AbstractRefactoring refactoring, Problem problem, CsmObject referencedObject) {
            return super.defaultCheckIfModificationPossible(problem, referencedObject);
        }
    }
}

