/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.openide.nodes.Node;

public class GridBagInfoProvider
implements GridInfoProvider {
    private static final BufferedImage TILE_REMAINDER = GridUtils.loadBufferedImage("org/netbeans/modules/form/layoutsupport/griddesigner/resources/tile_remainder.png", false);
    private static final BufferedImage TILE_RELATIVE = GridUtils.loadBufferedImage("org/netbeans/modules/form/layoutsupport/griddesigner/resources/tile_relative.png", false);
    private static final int THICKNESS_REMAINDER = 3;
    private static final int THICKNESS_RELATIVE = 3;
    private static final int INSETS_COLOR_ALPHA = 128;
    private static final int IPADDING_COLOR_ALPHA = 64;
    private Container container;
    private LayoutSupportManager layoutManager;
    private Field tempXField;
    private Field tempYField;
    private Field tempWidthField;
    private Field tempHeightField;
    private Color containerEmphColor;

    public GridBagInfoProvider(Container container, LayoutSupportManager layoutManager) {
        this.container = container;
        this.layoutManager = layoutManager;
        LayoutManager containerLayout = container.getLayout();
        if (!(containerLayout instanceof GridBagLayout)) {
            throw new IllegalArgumentException();
        }
        try {
            this.tempXField = GridBagConstraints.class.getDeclaredField("tempX");
            this.tempXField.setAccessible(true);
            this.tempYField = GridBagConstraints.class.getDeclaredField("tempY");
            this.tempYField.setAccessible(true);
            this.tempHeightField = GridBagConstraints.class.getDeclaredField("tempHeight");
            this.tempHeightField.setAccessible(true);
            this.tempWidthField = GridBagConstraints.class.getDeclaredField("tempWidth");
            this.tempWidthField.setAccessible(true);
        }
        catch (NoSuchFieldException nsfex) {
            FormUtils.LOGGER.log(Level.INFO, nsfex.getMessage(), nsfex);
        }
        this.containerEmphColor = GridBagInfoProvider.deriveEmphColor(container);
    }

    private GridBagLayout getLayout() {
        return (GridBagLayout)this.container.getLayout();
    }

    public Object getLayoutProperty(String propertyName) {
        Node.Property property = this.layoutManager.getLayoutProperty(propertyName);
        Object layoutProp = null;
        try {
            layoutProp = property.getValue();
        }
        catch (IllegalAccessException iaex) {
            FormUtils.LOGGER.log(Level.WARNING, iaex.getMessage(), iaex);
        }
        catch (InvocationTargetException itex) {
            FormUtils.LOGGER.log(Level.WARNING, itex.getMessage(), itex);
        }
        return layoutProp;
    }

    public int getGapXArrayLength() {
        Object objXArray = this.getLayoutProperty("columnWidths");
        if (objXArray == null) {
            return 0;
        }
        if (objXArray instanceof int[]) {
            int[] gapXArray = (int[])objXArray;
            return gapXArray.length;
        }
        return 0;
    }

    public int getGapYArrayLength() {
        Object objYArray = this.getLayoutProperty("rowHeights");
        if (objYArray == null) {
            return 0;
        }
        if (objYArray instanceof int[]) {
            int[] gapYArray = (int[])objYArray;
            return gapYArray.length;
        }
        return 0;
    }

    public boolean isGapArray(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof int[]) {
            int[] arr = (int[])obj;
            return arr.length != 0;
        }
        return false;
    }

    @Override
    public boolean hasGaps() {
        Object objXArray = this.getLayoutProperty("columnWidths");
        if (objXArray == null) {
            return false;
        }
        Object objYArray = this.getLayoutProperty("rowHeights");
        if (objYArray == null) {
            return false;
        }
        if (!this.isGapArray(objXArray)) {
            return false;
        }
        return this.isGapArray(objYArray);
    }

    @Override
    public int getGapWidth() {
        Object objXArray = this.getLayoutProperty("columnWidths");
        if (objXArray == null) {
            return -1;
        }
        if (objXArray instanceof int[]) {
            int[] gapXArray = (int[])objXArray;
            if (gapXArray.length < 2) {
                return -1;
            }
            return gapXArray[1];
        }
        return -1;
    }

    @Override
    public int getGapHeight() {
        Object objYArray = this.getLayoutProperty("rowHeights");
        if (objYArray == null) {
            return -1;
        }
        if (objYArray instanceof int[]) {
            int[] gapYArray = (int[])objYArray;
            if (gapYArray.length < 2) {
                return -1;
            }
            return gapYArray[1];
        }
        return -1;
    }

    @Override
    public boolean isGapColumn(int columnIndex) {
        return this.hasGaps() && columnIndex % 2 == 1 && columnIndex >= 0;
    }

    @Override
    public boolean isGapRow(int rowIndex) {
        return this.hasGaps() && rowIndex % 2 == 1 && rowIndex >= 0;
    }

    @Override
    public int getLastGapColumn() {
        int gapXArrayLength = this.getGapXArrayLength();
        return gapXArrayLength >= 3 ? gapXArrayLength - 1 : -1;
    }

    @Override
    public int getLastGapRow() {
        int gapYArrayLength = this.getGapYArrayLength();
        return gapYArrayLength >= 3 ? gapYArrayLength - 1 : -1;
    }

    @Override
    public boolean isGapEvent(FormModelEvent event) {
        String propName;
        return event.getChangeType() == 5 && ((propName = event.getPropertyName()).equals("columnWidths") || propName.equals("columnHeights"));
    }

    @Override
    public int getX() {
        return this.getLayout().getLayoutOrigin().x;
    }

    @Override
    public int getY() {
        return this.getLayout().getLayoutOrigin().y;
    }

    @Override
    public int getWidth() {
        int[] widths = this.getLayout().getLayoutDimensions()[0];
        int sum = 0;
        for (int width : widths) {
            sum += width;
        }
        return sum;
    }

    @Override
    public int getHeight() {
        int[] heights = this.getLayout().getLayoutDimensions()[1];
        int sum = 0;
        for (int height : heights) {
            sum += height;
        }
        return sum;
    }

    @Override
    public int getColumnCount() {
        return this.getLayout().getLayoutDimensions()[0].length;
    }

    @Override
    public int getRowCount() {
        return this.getLayout().getLayoutDimensions()[1].length;
    }

    @Override
    public int[] getColumnBounds() {
        int[] widths = this.getLayout().getLayoutDimensions()[0];
        int[] bounds = new int[widths.length + 1];
        bounds[0] = this.getX();
        for (int i = 0; i < widths.length; ++i) {
            bounds[i + 1] = bounds[i] + widths[i];
        }
        return bounds;
    }

    @Override
    public int[] getRowBounds() {
        int[] heights = this.getLayout().getLayoutDimensions()[1];
        int[] bounds = new int[heights.length + 1];
        bounds[0] = this.getY();
        for (int i = 0; i < heights.length; ++i) {
            bounds[i + 1] = bounds[i] + heights[i];
        }
        return bounds;
    }

    private int getIntFieldValue(Field intField, Object object) {
        int value = -1;
        try {
            value = intField.getInt(object);
        }
        catch (IllegalAccessException iaex) {
            FormUtils.LOGGER.log(Level.INFO, iaex.getMessage(), iaex);
        }
        return value;
    }

    @Override
    public int getGridX(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        int gridx = this.getIntFieldValue(this.tempXField, constraints);
        int columns = this.getColumnCount();
        return Math.min(gridx, columns - 1);
    }

    public boolean getGridXRelative(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridx == -1;
    }

    @Override
    public int getGridY(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        int gridy = this.getIntFieldValue(this.tempYField, constraints);
        int rows = this.getRowCount();
        return Math.min(gridy, rows - 1);
    }

    public boolean getGridYRelative(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridy == -1;
    }

    @Override
    public int getGridWidth(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        int gridWidth = this.getIntFieldValue(this.tempWidthField, constraints);
        int columns = this.getColumnCount();
        int gridx = this.getGridX(component);
        return Math.min(gridWidth, columns - gridx);
    }

    public boolean getGridWidthRelative(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridwidth == -1;
    }

    public boolean getGridWidthRemainder(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridwidth == 0;
    }

    @Override
    public int getGridHeight(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        int gridHeight = this.getIntFieldValue(this.tempHeightField, constraints);
        int rows = this.getRowCount();
        int gridy = this.getGridY(component);
        return Math.min(gridHeight, rows - gridy);
    }

    public boolean getGridHeightRelative(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridheight == -1;
    }

    public boolean getGridHeightRemainder(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridheight == 0;
    }

    public int getAnchor(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.anchor;
    }

    public int getFill(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.fill;
    }

    public double getWeightX(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.weightx;
    }

    public double getWeightY(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.weighty;
    }

    public int getIPadX(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.ipadx;
    }

    public int getIPadY(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.ipady;
    }

    public Insets getInsets(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.insets;
    }

    @Override
    public void paintConstraints(Graphics g, Component component, boolean selected) {
        assert (g instanceof Graphics2D);
        Graphics2D gg = (Graphics2D)g.create();
        Color emphColor = this.containerEmphColor;
        Rectangle inner = component.getBounds();
        int[] columnBounds = this.getColumnBounds();
        int[] rowBounds = this.getRowBounds();
        int gridX = this.getGridX(component);
        int gridY = this.getGridY(component);
        int gridWidth = this.getGridWidth(component);
        int gridHeight = this.getGridHeight(component);
        Rectangle outer = new Rectangle();
        outer.x = columnBounds[gridX];
        outer.width = columnBounds[gridX + gridWidth] - outer.x;
        outer.y = rowBounds[gridY];
        outer.height = rowBounds[gridY + gridHeight] - outer.y;
        Insets insets = this.getInsets(component);
        if (insets.top > 0 || insets.left > 0 || insets.bottom > 0 || insets.right > 0) {
            Color emphColorTransparent = new Color(emphColor.getRed(), emphColor.getGreen(), emphColor.getBlue(), 128);
            if (insets.top > 0) {
                gg.setColor(emphColorTransparent);
                gg.fillRect(inner.x - insets.left, inner.y - insets.top, inner.width + insets.left + insets.right, insets.top);
                gg.setColor(emphColor);
                gg.drawLine(inner.x - insets.left, inner.y - insets.top, inner.x + inner.width + insets.right, inner.y - insets.top);
                gg.drawLine(inner.x - insets.left, inner.y - insets.top, inner.x, inner.y);
                gg.drawLine(inner.x + inner.width + insets.right, inner.y - insets.top, inner.x + inner.width, inner.y);
            }
            if (insets.bottom > 0) {
                gg.setColor(emphColorTransparent);
                gg.fillRect(inner.x - insets.left, inner.y + inner.height, inner.width + insets.left + insets.right, insets.bottom);
                gg.setColor(emphColor);
                gg.drawLine(inner.x - insets.left, inner.y + inner.height + insets.bottom, inner.x + inner.width + insets.right, inner.y + inner.height + insets.bottom);
                gg.drawLine(inner.x - insets.left, inner.y + inner.height + insets.bottom, inner.x, inner.y + inner.height);
                gg.drawLine(inner.x + inner.width + insets.right, inner.y + inner.height + insets.bottom, inner.x + inner.width, inner.y + inner.height);
            }
            if (insets.left > 0) {
                gg.setColor(emphColorTransparent);
                gg.fillRect(inner.x - insets.left, inner.y, insets.left, inner.height);
                gg.setColor(emphColor);
                gg.drawLine(inner.x - insets.left, inner.y - insets.top, inner.x - insets.left, inner.y + inner.height + insets.bottom);
                if (insets.top <= 0) {
                    gg.drawLine(inner.x - insets.left, inner.y, inner.x, inner.y);
                }
                if (insets.bottom <= 0) {
                    gg.drawLine(inner.x - insets.left, inner.y + inner.height, inner.x, inner.y + inner.height);
                }
            }
            if (insets.right > 0) {
                gg.setColor(emphColorTransparent);
                gg.fillRect(inner.x + inner.width, inner.y, insets.right, inner.height);
                gg.setColor(emphColor);
                gg.drawLine(inner.x + inner.width + insets.right, inner.y - insets.top, inner.x + inner.width + insets.right, inner.y + inner.height + insets.bottom);
                if (insets.top <= 0) {
                    gg.drawLine(inner.x + inner.width + insets.right, inner.y, inner.x + inner.width, inner.y);
                }
                if (insets.bottom <= 0) {
                    gg.drawLine(inner.x + inner.width + insets.right, inner.y + inner.height, inner.x + inner.width, inner.y + inner.height);
                }
            }
        }
        boolean hRemainder = this.getGridWidthRemainder(component);
        boolean vRemainder = this.getGridHeightRemainder(component);
        if (hRemainder || vRemainder) {
            Rectangle remainderTextureRectangle = new Rectangle(0, 0, TILE_REMAINDER.getWidth(), TILE_REMAINDER.getHeight());
            TexturePaint remainderTexture = new TexturePaint(TILE_REMAINDER, remainderTextureRectangle);
            gg.setPaint(remainderTexture);
            if (hRemainder && outer.width >= 3) {
                gg.fillRect(outer.x + outer.width - 3, outer.y, 3, outer.height);
            }
            if (vRemainder && outer.height >= 3) {
                gg.fillRect(outer.x, outer.y + outer.height - 3, outer.width, 3);
            }
        }
        boolean hRelative = this.getGridWidthRelative(component);
        boolean vRelative = this.getGridHeightRelative(component);
        if (hRelative || vRelative) {
            Rectangle relativeTextureRectangle = new Rectangle(0, 0, TILE_RELATIVE.getWidth(), TILE_RELATIVE.getHeight());
            TexturePaint relativeTexture = new TexturePaint(TILE_RELATIVE, relativeTextureRectangle);
            gg.setPaint(relativeTexture);
            if (hRelative && outer.width >= 3) {
                gg.fillRect(outer.x + outer.width - 3, outer.y, 3, outer.height);
            }
            if (vRelative && outer.height >= 3) {
                gg.fillRect(outer.x, outer.y + outer.height - 3, outer.width, 3);
            }
        }
        int hPad = this.getIPadX(component);
        int vPad = this.getIPadY(component);
        if (hPad > 0 || vPad > 0) {
            Color padEmphColor = GridBagInfoProvider.deriveEmphColor(component);
            gg.setColor(new Color(padEmphColor.getRed(), padEmphColor.getGreen(), padEmphColor.getBlue(), 64));
            int padTop = vPad / 2;
            int padBottom = vPad - padTop;
            int padLeft = hPad / 2;
            int padRight = hPad - padLeft;
            if (padTop > 0) {
                gg.fillRect(inner.x, inner.y, inner.width, padTop);
            }
            if (padBottom > 0) {
                gg.fillRect(inner.x, inner.y + inner.height - padBottom, inner.width, padBottom);
            }
            if (padLeft > 0) {
                gg.fillRect(inner.x, inner.y + padTop, padLeft, inner.height - padTop - padBottom);
            }
            if (padRight > 0) {
                gg.fillRect(inner.x + inner.width - padRight, inner.y + padTop, padRight, inner.height - padTop - padBottom);
            }
        }
        gg.dispose();
    }

    private static Color deriveEmphColor(Component component) {
        Color backColor = component.getBackground();
        int backBrightness = (30 * backColor.getRed() + 59 * backColor.getGreen() + 11 * backColor.getBlue()) / 100;
        Color emphColor = backBrightness >= 128 ? backColor.darker() : backColor.brighter().brighter();
        return emphColor;
    }
}

