/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutAligner;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDragger;
import org.netbeans.modules.form.layoutdesign.LayoutFeeder;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutOperations;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutTestUtils;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.netbeans.modules.form.layoutdesign.VisualMapper;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;

public final class LayoutDesigner
implements LayoutModel.RemoveHandler,
LayoutModel.ResizeHandler,
LayoutConstants {
    private LayoutModel layoutModel;
    private VisualMapper visualMapper;
    private LayoutDragger dragger;
    private LayoutOperations operations;
    private boolean updateDataAfterBuild = true;
    private boolean preferredSizeChanged;
    private boolean visualStateUpToDate;
    private Collection<LayoutInterval>[] unresizedOnRemove;
    private Image warningImage;
    private Image linkBadgeBoth = null;
    private Image linkBadgeHorizontal = null;
    private Image linkBadgeVertical = null;
    private static final int BOTH_DIMENSIONS = 2;
    private int[] cursorPos = new int[]{0, 0};
    static final String TEST_SWITCH = "netbeans.form.layout_test";
    public List<String> testCode = new ArrayList<String>();
    private List<String> testCode0 = new ArrayList<String>();
    private List<String> beforeMove = new ArrayList<String>();
    private List<String> move1 = new ArrayList<String>();
    private List<String> move2 = new ArrayList<String>();
    private boolean isMoving = false;
    private int modelCounter = -1;
    private Point lastMovePoint = new Point(0, 0);

    public LayoutDesigner(LayoutModel model, VisualMapper mapper) {
        this.layoutModel = model;
        this.visualMapper = mapper;
        this.operations = new LayoutOperations(model, mapper);
        this.layoutModel.setRemoveHandler(this);
        this.layoutModel.setResizeHandler(this);
    }

    public void setActive(boolean active) {
        if (active) {
            this.layoutModel.setRemoveHandler(this);
            this.layoutModel.setResizeHandler(this);
        } else {
            if (this.layoutModel.getRemoveHandler() == this) {
                this.layoutModel.setRemoveHandler(null);
            }
            if (this.layoutModel.getResizeHandler() == this) {
                this.layoutModel.setResizeHandler(null);
            }
        }
    }

    public boolean updateCurrentState() {
        if (this.logTestCode()) {
            this.testCode.add("// > UPDATE CURRENT STATE");
        }
        Object changeMark = this.layoutModel.getChangeMark();
        LinkedList<LayoutComponent> updatedContainers = this.updateDataAfterBuild ? new LinkedList<LayoutComponent>() : null;
        this.updateCurrentState(updatedContainers);
        this.preferredSizeChanged = false;
        this.updateDataAfterBuild = false;
        if (updatedContainers != null && !updatedContainers.isEmpty()) {
            for (LayoutComponent comp : updatedContainers) {
                this.rebuildLayoutRecursively(comp);
            }
            this.updateCurrentState(null);
        }
        if (this.logTestCode()) {
            this.testCode.add("ld.updateCurrentState();");
            this.testCode.add("// < UPDATE CURRENT STATE");
        }
        this.visualStateUpToDate = true;
        return !changeMark.equals(this.layoutModel.getChangeMark());
    }

    private void rebuildLayoutRecursively(LayoutComponent container) {
        for (int i = 0; i < container.getSubComponentCount(); ++i) {
            LayoutComponent sub = container.getSubComponent(i);
            if (!sub.isLayoutContainer()) continue;
            this.rebuildLayoutRecursively(sub);
        }
        this.visualMapper.rebuildLayout(container.getId());
    }

    public void externalSizeChangeHappened() {
        this.visualStateUpToDate = false;
        this.updateDataAfterBuild = true;
        if (this.logTestCode()) {
            this.testCode.add("ld.externalSizeChangeHappened();");
        }
    }

    public boolean isPreferredSizeChanged() {
        return this.preferredSizeChanged;
    }

    private void requireStructureOptimization(LayoutComponent container) {
        if (container != null) {
            for (LayoutInterval[] roots : container.getLayoutRoots()) {
                for (int dim = 0; dim < 2; ++dim) {
                    roots[dim].unsetAttribute(2048);
                }
            }
        }
    }

    public void componentDefaultSizeChanged(String compId) {
        if (this.layoutModel.isUndoRedoInProgress()) {
            return;
        }
        LayoutComponent comp = this.layoutModel.getLayoutComponent(compId);
        if (comp == null || comp.getParent() == null) {
            return;
        }
        Dimension prefSize = null;
        boolean rebuild = false;
        for (int dim = 0; dim < 2; ++dim) {
            int currSize;
            LayoutInterval li = comp.getLayoutInterval(dim);
            if (LayoutInterval.wantResize(li) || li.getPreferredSize() != -1 || (currSize = LayoutInterval.getCurrentSize(li, dim)) == Integer.MIN_VALUE) continue;
            if (prefSize == null) {
                prefSize = this.visualMapper.getComponentPreferredSize(compId);
            }
            if (prefSize == null) {
                return;
            }
            int grow = (dim == 0 ? prefSize.width : prefSize.height) - currSize;
            if (grow <= 0) continue;
            LayoutInterval p = li.getParent();
            do {
                if (!(LayoutInterval.canResize(p) && p.getParent() != null || p.getDiffToDefaultSize() <= 0)) {
                    grow -= p.getDiffToDefaultSize();
                }
                li = p;
            } while ((p = p.getParent()) != null);
            if (grow <= 0) continue;
            this.preferredSizeChanged = true;
            if (li.getDiffToDefaultSize() <= 0) continue;
            this.setDefaultSizeInContainer(li, false);
            rebuild = true;
        }
        if (rebuild) {
            this.visualMapper.rebuildLayout(comp.getParent().getId());
        }
    }

    private void updateCurrentState(Collection<LayoutComponent> updatedContainers) {
        LinkedList<LayoutComponent> l = new LinkedList<LayoutComponent>();
        for (LayoutComponent cont : this.layoutModel.getTopContainers()) {
            l.add(cont);
            while (!l.isEmpty() && this.visualMapper.getComponentBounds((cont = (LayoutComponent)l.remove(0)).getId()) == null) {
                for (int i = 0; i < cont.getSubComponentCount(); ++i) {
                    LayoutComponent sub = cont.getSubComponent(i);
                    if (!sub.isLayoutContainer()) continue;
                    l.add(sub);
                }
                cont = null;
            }
            l.clear();
            if (cont == null) continue;
            Object mark = this.layoutModel.getChangeMark();
            this.updateContainerAfterBuild(cont, true);
            if (updatedContainers == null || this.layoutModel.getChangeMark().equals(mark)) continue;
            updatedContainers.add(cont);
        }
    }

    private void updateCurrentSpaceOfGroups(LayoutInterval group, int dimension, int[] parentEdgePositions) {
        if (group.getSubIntervalCount() == 0) {
            return;
        }
        LayoutRegion groupSpace = group.getCurrentSpace();
        if (group.getParent() != null) {
            assert (!groupSpace.isSet(dimension));
            LayoutRegion parentSpace = group.getParent().getCurrentSpace();
            for (int e = 0; e <= 1; ++e) {
                if (!parentSpace.isSet(dimension, e) || !LayoutInterval.isAlignedAtBorder(group, e)) continue;
                groupSpace.setPos(dimension, e, parentSpace.positions[dimension][e]);
            }
        }
        if (group.getGroupAlignment() == 3) {
            groupSpace.positions[dimension][3] = Integer.MIN_VALUE;
        }
        LayoutRegion space = new LayoutRegion();
        boolean[] def = new boolean[]{false, false};
        boolean[] undef = new boolean[]{false, false};
        int[] endGapSize = new int[]{-1, -1};
        int[] groupEdgePositions = LayoutDesigner.getGroupPositionLimits(group, dimension, parentEdgePositions);
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            LayoutInterval sub = group.getSubInterval(i);
            if (sub.isEmptySpace()) {
                int align;
                if (!group.isSequential() || i != 0 && i != group.getSubIntervalCount() - 1) continue;
                int n = align = i == 0 ? 0 : 1;
                if (groupSpace.isSet(dimension, align)) continue;
                if (!LayoutInterval.canResize(sub)) {
                    endGapSize[align] = sub.getPreferredSize() != -1 ? sub.getPreferredSize() : LayoutUtils.getSizeOfDefaultGap(sub, this.visualMapper);
                }
                if (endGapSize[align] >= 0) {
                    def[align] = true;
                    continue;
                }
                undef[align] = true;
                continue;
            }
            LayoutRegion subSpace = sub.getCurrentSpace();
            if (sub.isGroup()) {
                subSpace.reset();
                this.updateCurrentSpaceOfGroups(sub, dimension, groupEdgePositions);
            } else if (sub.isComponent() && group.getGroupAlignment() == 3 && groupSpace.positions[dimension][3] == Integer.MIN_VALUE) {
                groupSpace.positions[dimension][3] = subSpace.positions[dimension][3];
            }
            space.expand(subSpace, dimension);
            groupSpace.expand(subSpace, dimension ^ 1);
            for (int e = 0; e <= 1; ++e) {
                if (groupSpace.isSet(dimension, e)) continue;
                if (subSpace.isSet(dimension, e)) {
                    if (def[e] || !LayoutInterval.isAlignedAtBorder(sub, e)) continue;
                    def[e] = true;
                    continue;
                }
                if (def[e] || undef[e] || !LayoutInterval.isAlignedAtBorder(sub, e)) continue;
                undef[e] = true;
            }
        }
        for (int e = 0; e <= 1; ++e) {
            int d;
            if (groupSpace.isSet(dimension, e)) continue;
            int n = d = e == 0 ? -1 : 1;
            if (space.isSet(dimension, e) && (def[e] || !undef[e])) {
                int limitPos;
                groupSpace.setPos(dimension, e, space.positions[dimension][e]);
                if (endGapSize[e] < 0) continue;
                int change = endGapSize[e] * d;
                int gapPos = groupSpace.positions[dimension][e] + change;
                int n2 = limitPos = parentEdgePositions != null ? parentEdgePositions[e] : Integer.MIN_VALUE;
                if (limitPos != Integer.MIN_VALUE && gapPos * d > limitPos * d) {
                    change = (limitPos - gapPos + change) * d;
                }
                if (change == 0) continue;
                groupSpace.reshape(dimension, e, change);
                continue;
            }
            if (!group.isParallel()) continue;
            int outPos = Integer.MIN_VALUE;
            for (LayoutInterval comp : LayoutUtils.getSideComponents(group, e, false, false)) {
                int pos = group.getSubInterval((int)LayoutInterval.getIndexInParent((LayoutInterval)comp, (LayoutInterval)group)).getCurrentSpace().positions[dimension][e];
                if (pos == Integer.MIN_VALUE) {
                    pos = comp.getCurrentSpace().positions[dimension][e];
                    LayoutInterval borderGap = LayoutInterval.getNeighbor(comp, e, false, true, false);
                    if (borderGap != null && borderGap.isEmptySpace() && group.isParentOf(borderGap)) {
                        int gapSize = borderGap.getPreferredSize();
                        if (gapSize == -1) {
                            gapSize = LayoutUtils.getSizeOfDefaultGap(borderGap, this.visualMapper);
                        }
                        if (gapSize >= 0) {
                            pos += gapSize * d;
                        } else {
                            outPos = Integer.MIN_VALUE;
                            break;
                        }
                    }
                }
                if (outPos != Integer.MIN_VALUE && pos * d <= outPos * d) continue;
                outPos = pos;
            }
            if (outPos == Integer.MIN_VALUE) continue;
            groupSpace.setPos(dimension, e, outPos);
        }
        LayoutDesigner.completeUknownGroupPositions(group, dimension);
    }

    private static int[] getGroupPositionLimits(LayoutInterval group, int dimension, int[] parentEdgePositions) {
        int[] pos = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
        for (int e = 0; e <= 1; ++e) {
            List<LayoutInterval> l;
            pos[e] = group.getParent() == null ? group.getCurrentSpace().positions[dimension][e] : (parentEdgePositions != null && parentEdgePositions[e] != Integer.MIN_VALUE && LayoutInterval.isAlignedAtBorder(group, e) ? parentEdgePositions[e] : (!(l = LayoutUtils.getSideComponents(group, e, true, true)).isEmpty() ? l.get((int)0).getCurrentSpace().positions[dimension][e] : parentEdgePositions[e]));
        }
        return pos;
    }

    private static void completeUknownGroupPositions(LayoutInterval group, int dimension) {
        LayoutRegion groupSpace = group.getCurrentSpace();
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            LayoutInterval sub = group.getSubInterval(i);
            if (!sub.isGroup()) continue;
            LayoutRegion subSpace = sub.getCurrentSpace();
            boolean subSpaceCompleted = false;
            for (int e = 0; e <= 1; ++e) {
                if (subSpace.isSet(dimension, e)) continue;
                if (group.isSequential()) {
                    if (i == 0 && e == 0 || i == group.getSubIntervalCount() - 1 && e == 1) {
                        if (groupSpace.isSet(dimension, e)) {
                            subSpace.setPos(dimension, e, groupSpace.positions[dimension][e]);
                        }
                    } else {
                        LayoutInterval neighbor = group.getSubInterval(i + (e == 0 ? -1 : 1));
                        LayoutRegion nSpace = neighbor.getCurrentSpace();
                        assert (nSpace.isSet(dimension, e ^ 1));
                        subSpace.setPos(dimension, e, nSpace.positions[dimension][e ^ 1]);
                    }
                } else if (groupSpace.isSet(dimension, e)) {
                    assert (LayoutInterval.isAlignedAtBorder(sub, group, e) || group.getSubIntervalCount() == 1);
                    subSpace.setPos(dimension, e, groupSpace.positions[dimension][e]);
                }
                if (!subSpace.isSet(dimension, e)) continue;
                subSpaceCompleted = true;
            }
            if (!subSpaceCompleted) continue;
            LayoutDesigner.completeUknownGroupPositions(sub, dimension);
        }
    }

    private int collectResizingDiffs(LayoutInterval group, int dimension) {
        int groupDiff = 0;
        int biggestDefSize = Integer.MIN_VALUE;
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            LayoutInterval sub = group.getSubInterval(i);
            int diff = 0;
            if (sub.isGroup()) {
                diff = this.collectResizingDiffs(sub, dimension);
            } else if (LayoutInterval.wantResize(sub)) {
                int defaultSize;
                if (sub.isEmptySpace()) {
                    int min = sub.getMinimumSize();
                    defaultSize = min == -1 ? LayoutUtils.getSizeOfDefaultGap(sub, this.visualMapper) : min;
                } else {
                    Dimension prefSize = this.visualMapper.getComponentPreferredSize(sub.getComponent().getId());
                    defaultSize = dimension == 0 ? prefSize.width : prefSize.height;
                }
                int currentSize = LayoutInterval.getCurrentSize(sub, dimension);
                diff = currentSize - defaultSize;
                sub.setDiffToDefaultSize(diff);
                if (sub.getPreferredSize() == currentSize || sub.getPreferredSize() == -1 && diff == 0) {
                    sub.unsetAttribute(512);
                } else {
                    sub.setAttribute(512);
                }
                diff = diff < 0 ? currentSize : LayoutInterval.getDiffToDefaultSize(sub, true);
            } else {
                sub.setDiffToDefaultSize(0);
                sub.unsetAttribute(512);
            }
            if (group.isSequential()) {
                groupDiff += diff;
                continue;
            }
            int defSize = LayoutInterval.getCurrentSize(sub, dimension) - diff;
            if (defSize <= biggestDefSize) continue;
            biggestDefSize = defSize;
        }
        if (group.isParallel() && biggestDefSize != Integer.MIN_VALUE) {
            groupDiff = group.getCurrentSpace().size(dimension) - biggestDefSize;
        }
        group.setDiffToDefaultSize(groupDiff);
        return groupDiff;
    }

    private boolean updateToActualSize(LayoutInterval group, int dimension, int sizeUpdate) {
        HashSet<LayoutInterval> defaultCandidates = new HashSet<LayoutInterval>();
        boolean r = this.updateToActualSize(group, dimension, sizeUpdate, defaultCandidates, false);
        for (LayoutInterval li : defaultCandidates) {
            int pref = LayoutInterval.getDefaultSizeDef(li);
            int min = li.isEmptySpace() ? pref : li.getMinimumSize();
            this.layoutModel.setIntervalSize(li, min, pref, li.getMaximumSize());
        }
        return r;
    }

    private boolean updateToActualSize(LayoutInterval group, int dimension, int sizeUpdate, Set<LayoutInterval> defaultCandidates, boolean parentFlexSizeDef) {
        boolean forceAtSecond;
        if (sizeUpdate == 2 && group.isParallel() && (group.getParent() == null || !LayoutInterval.canResize(group))) {
            forceAtSecond = true;
            sizeUpdate = 1;
        } else {
            forceAtSecond = false;
        }
        boolean updated = false;
        boolean updateMissing = false;
        do {
            LayoutInterval repInt = null;
            int minDiff = Integer.MAX_VALUE;
            if (sizeUpdate == 2 && group.isParallel()) {
                Iterator<LayoutInterval> it = group.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval sub = it.next();
                    int diff = LayoutInterval.getDiffToDefaultSize(sub, true);
                    if (diff < 0) {
                        diff = 100 - diff;
                    }
                    if (diff <= 0 || !LayoutInterval.canResize(sub) || diff >= minDiff && (diff != minDiff || repInt != null && (sub.getPreferredSize() == -1 || repInt.getPreferredSize() != -1))) continue;
                    minDiff = diff;
                    repInt = sub;
                }
            }
            boolean sizeDefined = false;
            Iterator<LayoutInterval> it = group.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval sub = it.next();
                boolean forceUpdate = sizeUpdate == 2 && (group.isSequential() || sub == repInt);
                boolean updatedSub = false;
                int diff = LayoutInterval.getDiffToDefaultSize(sub, true);
                if (diff == 0 && forceAtSecond && sizeUpdate == 1 && !sizeDefined && LayoutInterval.getCurrentSize(sub, dimension) == LayoutInterval.getCurrentSize(group, dimension)) {
                    sizeDefined = true;
                }
                if (sub.isGroup()) {
                    int subUpdate = diff == 0 ? 0 : (forceUpdate || !LayoutInterval.canResize(sub) ? 2 : (sizeUpdate == 0 ? 0 : 1));
                    updatedSub = this.updateToActualSize(sub, dimension, subUpdate, defaultCandidates, parentFlexSizeDef);
                } else {
                    boolean single;
                    if (sub.isComponent() && sub.getComponent().isLayoutContainer()) {
                        LayoutComponent subContainer = sub.getComponent();
                        LayoutInterval root = subContainer.getDefaultLayoutRoot(dimension);
                        int subUpdate = diff == 0 || subContainer.getDiffToMinimumSize(dimension) < 0 ? 0 : (forceUpdate || !LayoutInterval.canResize(sub) ? 2 : (sizeUpdate == 0 ? 0 : 1));
                        updatedSub = this.updateToActualSize(root, dimension, subUpdate, defaultCandidates, parentFlexSizeDef || sub.hasAttribute(1024));
                        boolean bl = single = subContainer.getDiffToMinimumSize(dimension) < 0;
                        if (!single && LayoutInterval.wantResize(sub)) {
                            if (updatedSub || diff == 0) {
                                sub.unsetAttribute(512);
                            } else {
                                sub.setAttribute(512);
                            }
                        }
                    } else {
                        single = true;
                    }
                    if (single && LayoutInterval.wantResize(sub)) {
                        boolean pretendDefault;
                        int min = sub.getMinimumSize();
                        int pref = sub.getPreferredSize();
                        int max = sub.getMaximumSize();
                        int defaultPref = LayoutInterval.getDefaultSizeDef(sub);
                        boolean bl = pretendDefault = pref != defaultPref && diff != 0 && pref <= 0 || parentFlexSizeDef || sub.hasAttribute(1024);
                        if (pretendDefault) {
                            pref = defaultPref;
                        }
                        int currentSize = LayoutInterval.getCurrentSize(sub, dimension);
                        int lastSize = sub.getLastActualSize();
                        if (lastSize < 0) {
                            sub.setLastActualSize(currentSize);
                        }
                        if (sizeUpdate == 0 || diff == 0) {
                            this.layoutModel.setIntervalSize(sub, min, defaultPref, max);
                            pretendDefault = false;
                        } else if (forceUpdate || pref != defaultPref && pref != currentSize && (lastSize >= Short.MAX_VALUE || lastSize >= 0 && lastSize != currentSize)) {
                            this.layoutModel.setIntervalSize(sub, min, currentSize, max);
                            pretendDefault = false;
                            sub.setLastActualSize(Integer.MAX_VALUE);
                        }
                        if (pretendDefault) {
                            defaultCandidates.add(sub);
                        } else {
                            defaultCandidates.remove(sub);
                            pref = sub.getPreferredSize();
                            if (sizeUpdate > 0 && pref == currentSize) {
                                updatedSub = true;
                            }
                        }
                        if (diff == 0 || pref == currentSize) {
                            sub.unsetAttribute(512);
                        } else {
                            sub.setAttribute(512);
                        }
                    }
                }
                if (!LayoutInterval.canResize(sub)) continue;
                if (updatedSub) {
                    updated = true;
                    continue;
                }
                if (!group.isSequential() || diff == 0) continue;
                updateMissing = true;
            }
            if (!forceAtSecond) continue;
            if (sizeUpdate == 1 && !updated && !sizeDefined) {
                sizeUpdate = 2;
                continue;
            }
            forceAtSecond = false;
        } while (forceAtSecond);
        return updated && !updateMissing;
    }

    public void dumpTestcode(DataObject form) {
        LayoutTestUtils.dumpTestcode(this.testCode, form, this.getModelCounter());
        this.testCode = new ArrayList<String>();
        this.testCode0 = new ArrayList<String>();
        this.beforeMove = new ArrayList<String>();
        this.move1 = new ArrayList<String>();
        this.move2 = new ArrayList<String>();
        this.isMoving = false;
    }

    public List<String> getDraggableComponents(List<String> componentIds) {
        LayoutComponent container = null;
        List<String> draggable = null;
        int commonLayer = -1;
        for (String compId : componentIds) {
            LayoutComponent comp = this.layoutModel.getLayoutComponent(compId);
            if (comp == null || comp.getParent() == null) continue;
            if (container == null) {
                container = comp.getParent();
            } else if (comp.getParent() != container) {
                return Collections.emptyList();
            }
            int layerIndex = container.getLayoutRootsIndex(comp.getLayoutInterval(0));
            assert (layerIndex >= 0);
            if (layerIndex < commonLayer) continue;
            if (commonLayer < 0) {
                draggable = new ArrayList<String>(componentIds.size());
            } else if (layerIndex > commonLayer) {
                draggable.clear();
            }
            commonLayer = layerIndex;
            draggable.add(compId);
        }
        if (draggable == null) {
            draggable = Collections.emptyList();
        }
        return draggable;
    }

    public boolean isUnplacedComponent(String compId) {
        LayoutComponent comp = this.layoutModel.getLayoutComponent(compId);
        if (comp != null) {
            LayoutComponent cont = comp.getParent();
            return cont != null && comp.getParentRoots()[0] != cont.getDefaultLayoutRoot(0);
        }
        return false;
    }

    public void startAdding(LayoutComponent[] comps, Rectangle[] bounds, Point hotspot, String defaultContId) {
        if (this.logTestCode()) {
            this.testCode.add("// > START ADDING");
        }
        this.prepareDragger(comps, bounds, hotspot, LayoutDragger.ALL_EDGES);
        if (this.logTestCode()) {
            this.testCode.add("{");
            LayoutTestUtils.writeLayoutComponentArray(this.testCode, "comps", "lc");
            LayoutTestUtils.writeRectangleArray(this.testCode, "bounds", bounds);
            LayoutTestUtils.writeString(this.testCode, "defaultContId", defaultContId);
            this.testCode.add("Point hotspot = new Point(" + new Double(hotspot.getX()).intValue() + "," + new Double(hotspot.getY()).intValue() + ");");
            this.testCode.add("ld.startAdding(comps, bounds, hotspot, defaultContId);");
            this.testCode.add("}");
        }
        if (defaultContId != null) {
            this.setDragTarget(this.layoutModel.getLayoutComponent(defaultContId), comps, false);
        }
        if (this.logTestCode()) {
            this.testCode.add("// < START ADDING");
        }
    }

    public void startMoving(String[] compIds, Rectangle[] bounds, Point hotspot) {
        if (this.logTestCode()) {
            this.testCode.add("// > START MOVING");
        }
        LayoutComponent[] comps = new LayoutComponent[compIds.length];
        for (int i = 0; i < compIds.length; ++i) {
            comps[i] = this.layoutModel.getLayoutComponent(compIds[i]);
        }
        this.prepareDragger(comps, bounds, hotspot, LayoutDragger.ALL_EDGES);
        if (this.logTestCode()) {
            this.testCode.add("{");
            LayoutTestUtils.writeStringArray(this.testCode, "compIds", compIds);
            LayoutTestUtils.writeRectangleArray(this.testCode, "bounds", bounds);
            this.testCode.add("Point hotspot = new Point(" + new Double(hotspot.getX()).intValue() + "," + new Double(hotspot.getY()).intValue() + ");");
            this.testCode.add("ld.startMoving(compIds, bounds, hotspot);");
            this.testCode.add("}");
        }
        this.setDragTarget(comps[0].getParent(), comps, false);
        if (this.logTestCode()) {
            this.testCode.add("// < START MOVING");
        }
    }

    public void startResizing(String[] compIds, Rectangle[] bounds, Point hotspot, int[] resizeEdges, boolean inLayout) {
        if (this.logTestCode()) {
            this.testCode.add("// > START RESIZING");
        }
        LayoutComponent[] comps = new LayoutComponent[compIds.length];
        for (int i = 0; i < compIds.length; ++i) {
            comps[i] = this.layoutModel.getLayoutComponent(compIds[i]);
        }
        int[] edges = new int[2];
        for (int i = 0; i < 2; ++i) {
            edges[i] = resizeEdges[i] == 0 || resizeEdges[i] == 1 ? resizeEdges[i] : Integer.MIN_VALUE;
        }
        this.prepareDragger(comps, bounds, hotspot, edges);
        if (this.logTestCode()) {
            this.testCode.add("{");
            LayoutTestUtils.writeStringArray(this.testCode, "compIds", compIds);
            LayoutTestUtils.writeRectangleArray(this.testCode, "bounds", bounds);
            this.testCode.add("Point hotspot = new Point(" + new Double(hotspot.getX()).intValue() + "," + new Double(hotspot.getY()).intValue() + ");");
            LayoutTestUtils.writeIntArray(this.testCode, "resizeEdges", resizeEdges);
            this.testCode.add("boolean inLayout = " + inLayout + ";");
            this.testCode.add("ld.startResizing(compIds, bounds, hotspot, resizeEdges, inLayout);");
            this.testCode.add("}");
        }
        if (inLayout) {
            this.setDragTarget(comps[0].getParent(), comps, true);
        } else {
            this.setDragTarget(null, null, true);
        }
        if (this.logTestCode()) {
            this.testCode.add("// < START RESIZING");
        }
    }

    private void prepareDragger(LayoutComponent[] comps, Rectangle[] bounds, Point hotspot, int[] edges) {
        if (comps.length != bounds.length) {
            throw new IllegalArgumentException();
        }
        LayoutRegion[] movingFormation = new LayoutRegion[bounds.length];
        for (int i = 0; i < bounds.length; ++i) {
            int baseline = this.visualMapper.getBaselinePosition(comps[i].getId(), bounds[i].width, bounds[i].height);
            int baselinePos = baseline > 0 ? bounds[i].y + baseline : Integer.MIN_VALUE;
            movingFormation[i] = new LayoutRegion();
            movingFormation[i].set(bounds[i], baselinePos);
        }
        this.dragger = new LayoutDragger(comps, movingFormation, new int[]{hotspot.x, hotspot.y}, edges, this.visualMapper);
    }

    public void move(Point p, String containerId, boolean autoPositioning, boolean lockDimension, Rectangle[] bounds) {
        int y;
        int x = p != null ? p.x : 0;
        int n = y = p != null ? p.y : 0;
        if (this.logTestCode()) {
            if (!this.isMoving) {
                this.isMoving = true;
                this.beforeMove = new ArrayList<String>();
                this.beforeMove.addAll(this.testCode);
                this.testCode = new ArrayList<String>();
                this.lastMovePoint = new Point(0, 0);
            }
            if (x != this.lastMovePoint.x || y != this.lastMovePoint.y) {
                this.lastMovePoint = new Point(x, y);
                this.move1 = this.move2;
                this.testCode0 = this.testCode;
            }
            this.move2 = new ArrayList<String>();
            this.move2.add("// > MOVE");
            this.testCode = new ArrayList<String>();
        }
        if (!this.visualStateUpToDate || this.dragger == null) {
            return;
        }
        if (!(this.dragger.isResizing() || lockDimension && this.dragger.getTargetContainer() != null)) {
            this.setDragTarget(this.layoutModel.getLayoutComponent(containerId), this.dragger.getMovingComponents(), false);
        }
        this.cursorPos[0] = p.x;
        this.cursorPos[1] = p.y;
        this.dragger.move(this.cursorPos, autoPositioning, lockDimension);
        p.x = this.cursorPos[0];
        p.y = this.cursorPos[1];
        if (bounds != null) {
            LayoutRegion[] current = this.dragger.getMovingBounds();
            for (int i = 0; i < current.length; ++i) {
                current[i].toRectangle(bounds[i]);
            }
        }
        if (this.logTestCode()) {
            this.move2.add("{");
            this.move2.add("Point p = new Point(" + x + "," + y + ");");
            LayoutTestUtils.writeString(this.move2, "containerId", containerId);
            this.move2.add("boolean autoPositioning = " + autoPositioning + ";");
            this.move2.add("boolean lockDimension = " + lockDimension + ";");
            LayoutTestUtils.writeRectangleArray(this.move2, "bounds", bounds);
            this.move2.add("ld.move(p, containerId, autoPositioning, lockDimension, bounds);");
            this.move2.add("}");
            this.move2.add("// < MOVE");
        }
    }

    private void setDragTarget(LayoutComponent targetContainer, LayoutComponent[] movingComps, boolean resizing) {
        LayoutComponent prevContainer = this.dragger.getTargetContainer();
        LayoutInterval[] roots = targetContainer != null ? (resizing && movingComps.length > 0 ? movingComps[0].getParentRoots() : this.getActiveLayoutRoots(targetContainer)) : null;
        this.dragger.setTargetContainer(targetContainer, roots);
        if (prevContainer != targetContainer) {
            this.updateDraggingVisibility(prevContainer, movingComps, resizing, false);
            this.updateDraggingVisibility(targetContainer, movingComps, resizing, true);
        }
    }

    public String getDragTargetContainer() {
        LayoutComponent comp = this.dragger.getTargetContainer();
        return comp != null ? comp.getId() : null;
    }

    private void updateDraggingVisibility(LayoutComponent container, LayoutComponent[] movingComps, boolean resizing, boolean draggingIn) {
        if (container != null) {
            LayoutInterval[] targetRoots = resizing && movingComps.length > 0 ? movingComps[0].getParentRoots() : this.getActiveLayoutRoots(container);
            for (LayoutComponent comp : container.getSubcomponents()) {
                for (LayoutComponent m : movingComps) {
                    if (m != comp) continue;
                    comp = null;
                    break;
                }
                if (comp == null || LayoutInterval.getRoot(comp.getLayoutInterval(0)) == targetRoots[0]) continue;
                this.visualMapper.setComponentVisibility(comp.getId(), !draggingIn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endMoving(boolean committed) {
        block29: {
            if (this.dragger == null) {
                return;
            }
            if (this.logTestCode()) {
                if (committed) {
                    this.beforeMove.addAll(this.testCode0);
                    this.beforeMove.addAll(this.move1);
                    this.beforeMove.addAll(this.testCode);
                    this.beforeMove.addAll(this.move2);
                    this.testCode = this.beforeMove;
                }
                this.testCode.add("// > END MOVING");
                this.isMoving = false;
            }
            try {
                LayoutComponent targetContainer = this.dragger.getTargetContainer();
                LayoutComponent[] components = this.dragger.getMovingComponents();
                this.updateDraggingVisibility(targetContainer, components, this.dragger.isResizing(), false);
                if (!committed) break block29;
                if (targetContainer != null) {
                    LayoutInterval[] addingInts;
                    boolean newComponents;
                    LayoutFeeder f = null;
                    boolean bl = newComponents = components[0].getParent() == null;
                    if (components.length > 1) {
                        if (newComponents) {
                            LayoutRegion movingSpace = this.dragger.getMovingSpace();
                            int dx = movingSpace.positions[0][0];
                            int dy = movingSpace.positions[1][0];
                            LayoutRegion[] movingBounds = this.dragger.getMovingBounds();
                            HashMap<LayoutComponent, Rectangle> compToRect = new HashMap<LayoutComponent, Rectangle>();
                            for (int i = 0; i < components.length; ++i) {
                                for (int dim = 0; dim < 2; ++dim) {
                                    components[i].getLayoutInterval(dim).getCurrentSpace().set(dim, movingBounds[i]);
                                }
                                Rectangle r = movingBounds[i].toRectangle(new Rectangle());
                                r.x -= dx;
                                r.y -= dy;
                                compToRect.put(components[i], r);
                            }
                            addingInts = LayoutModel.createIntervalsFromBounds(compToRect);
                        } else {
                            int dim;
                            f = new LayoutFeeder(components, targetContainer, this.operations, this.dragger);
                            LayoutInterval[] commonParents = new LayoutInterval[2];
                            HashMap<LayoutComponent, LayoutComponent> compMap = new HashMap<LayoutComponent, LayoutComponent>();
                            LayoutRegion origSpace = new LayoutRegion();
                            for (LayoutComponent comp : components) {
                                for (int dim2 = 0; dim2 < 2; ++dim2) {
                                    commonParents[dim2] = commonParents[dim2] == null ? comp.getLayoutInterval(dim2) : LayoutInterval.getCommonParent(commonParents[dim2], comp.getLayoutInterval(dim2));
                                }
                                compMap.put(comp, comp);
                                origSpace.expand(comp.getLayoutInterval(0).getCurrentSpace());
                            }
                            this.unresizedOnRemove = null;
                            addingInts = new LayoutInterval[2];
                            for (dim = 0; dim < 2; ++dim) {
                                Object start = this.layoutModel.getChangeMark();
                                addingInts[dim] = this.restrictedCopy(commonParents[dim], compMap, origSpace, dim, null);
                                this.afterRemoveSpaceUpdate(components[0].getParent().getDefaultLayoutRoot(dim), dim);
                                Object end = this.layoutModel.getChangeMark();
                                f.setUndo(start, end, dim);
                            }
                            for (int i = 0; i < components.length; ++i) {
                                LayoutRegion bounds = this.dragger.getMovingBounds()[i];
                                for (int dim3 = 0; dim3 < 2; ++dim3) {
                                    components[i].getLayoutInterval(dim3).getCurrentSpace().set(dim3, bounds);
                                }
                            }
                            for (dim = 0; dim < 2; ++dim) {
                                addingInts[dim].getCurrentSpace().set(this.dragger.getMovingSpace());
                                this.updateCurrentSpaceOfGroups(addingInts[dim], dim, null);
                            }
                            f.setUp(origSpace, this.unresizedOnRemove);
                            this.unresizedOnRemove = null;
                            for (LayoutComponent comp : components) {
                                if (comp.getParent() == targetContainer) continue;
                                this.layoutModel.removeComponent(comp, false);
                                this.layoutModel.addComponent(comp, targetContainer, -1);
                            }
                        }
                    } else {
                        addingInts = new LayoutInterval[2];
                        LayoutComponent comp = components[0];
                        for (int dim = 0; dim < 2; ++dim) {
                            addingInts[dim] = comp.getLayoutInterval(dim);
                        }
                    }
                    if (newComponents) {
                        LayoutRegion[] movingBounds = this.dragger.getMovingBounds();
                        for (int i = 0; i < components.length; ++i) {
                            LayoutComponent comp = components[i];
                            Dimension preferred = this.visualMapper.getComponentPreferredSize(comp.getId());
                            for (int dim = 0; dim < 2; ++dim) {
                                LayoutInterval li = comp.getLayoutInterval(dim);
                                li.setAttribute(1024);
                                int size = movingBounds[i].size(dim);
                                if (preferred != null && size == (dim == 0 ? preferred.width : preferred.height)) continue;
                                li.setPreferredSize(size);
                            }
                        }
                    }
                    this.addComponents(components, targetContainer, addingInts, newComponents, f);
                } else {
                    assert (this.dragger.isResizing());
                    LayoutRegion space = this.dragger.getMovingBounds()[0];
                    for (int dim = 0; dim < 2; ++dim) {
                        components[0].getLayoutInterval(dim).setCurrentSpace(space);
                    }
                    if (components[0].isLayoutContainer()) {
                        this.updateContainerAfterChange(components[0], this.dragger.getSizes());
                    }
                }
                this.visualStateUpToDate = false;
                this.updateDataAfterBuild = true;
            }
            finally {
                this.dragger = null;
                if (this.logTestCode()) {
                    this.testCode.add("ld.endMoving(" + committed + ");");
                    this.testCode.add("// < END MOVING");
                }
            }
        }
    }

    private void addComponents(LayoutComponent[] components, LayoutComponent targetContainer, LayoutInterval[] addingInts, boolean freshComponents, LayoutFeeder f) {
        LayoutFeeder layoutFeeder;
        if (f != null) {
            layoutFeeder = f;
        } else {
            layoutFeeder = this.createFeeder(components, targetContainer);
            for (int dim = 0; dim < 2; ++dim) {
                LayoutRegion space = new LayoutRegion();
                space.set(this.dragger.getMovingSpace());
                addingInts[dim].setCurrentSpace(space);
            }
        }
        layoutFeeder.add(addingInts);
        if (this.dragger.isResizing()) {
            for (LayoutComponent comp : components) {
                if (comp.isLayoutContainer()) {
                    this.updateContainerAfterChange(components[0], this.dragger.getSizes());
                    continue;
                }
                for (int dim = 0; dim < 2; ++dim) {
                    LayoutInterval compInt = comp.getLayoutInterval(dim);
                    int size = compInt.getPreferredSize();
                    if (!this.dragger.isResizing(dim) || size == -1) continue;
                    boolean setToDefault = false;
                    if (this.dragger.snappedToDefaultSize(dim)) {
                        setToDefault = true;
                    } else if (compInt.getAlignment() == 2 || compInt.getAlignment() == 3) {
                        int defaultSize;
                        Dimension prefSize = this.visualMapper.getComponentPreferredSize(comp.getId());
                        int n = defaultSize = dim == 0 ? prefSize.width : prefSize.height;
                        if (defaultSize == size) {
                            setToDefault = true;
                        }
                    }
                    if (!setToDefault) continue;
                    this.operations.resizeInterval(comp.getLayoutInterval(dim), -1);
                }
            }
        }
        if (layoutFeeder.optimizeStructure) {
            this.requireStructureOptimization(targetContainer);
        }
    }

    private LayoutFeeder createFeeder(LayoutComponent[] components, LayoutComponent targetContainer) {
        assert (components.length == 1 || components.length > 1 && components[0].getParent() == null);
        LayoutFeeder feeder = new LayoutFeeder(components, targetContainer, this.operations, this.dragger);
        this.unresizedOnRemove = null;
        LayoutRegion origSpace = null;
        for (LayoutComponent comp : components) {
            if (comp.getParent() != null) {
                if (origSpace == null) {
                    origSpace = new LayoutRegion();
                    origSpace.set(comp.getCurrentSpace());
                } else {
                    origSpace.expand(comp.getCurrentSpace());
                }
                for (int dim = 0; dim < 2; ++dim) {
                    LayoutInterval compInt = comp.getLayoutInterval(dim);
                    if (compInt.getParent() == null) continue;
                    Object start = this.layoutModel.getChangeMark();
                    this.removeComponentInterval(compInt, dim);
                    this.afterRemoveSpaceUpdate(comp.getParent().getDefaultLayoutRoot(dim), dim);
                    if (this.dragger.isResizing(dim)) {
                        this.layoutModel.removeComponentFromLinkSizedGroup(comp, dim);
                    }
                    Object end = this.layoutModel.getChangeMark();
                    feeder.setUndo(start, end, dim);
                }
                if (comp.getParent() != targetContainer) {
                    this.layoutModel.removeComponent(comp, false);
                }
            }
            if (comp.getParent() != null) continue;
            this.layoutModel.addComponent(comp, targetContainer, -1);
        }
        feeder.setUp(origSpace, this.unresizedOnRemove);
        this.unresizedOnRemove = null;
        return feeder;
    }

    private void addUnspecified(LayoutComponent[] components, LayoutComponent targetContainer, LayoutInterval[] addingInts) {
        for (LayoutComponent comp : components) {
            this.layoutModel.addComponent(comp, targetContainer, -1);
        }
        LayoutInterval[] targetRoots = this.layoutModel.addNewLayoutRoots(targetContainer);
        for (int dim = 0; dim < 2; ++dim) {
            LayoutInterval interval = addingInts[dim];
            LayoutInterval seq = interval.isSequential() ? interval : new LayoutInterval(102);
            LayoutInterval gap = new LayoutInterval(101);
            boolean resizing = LayoutInterval.wantResize(interval);
            if (!resizing) {
                gap.setSizes(0, 0, Short.MAX_VALUE);
            }
            seq.add(gap, 0);
            if (interval != seq) {
                this.layoutModel.addInterval(interval, seq, -1);
                this.layoutModel.setIntervalAlignment(interval, -1);
            }
            gap = new LayoutInterval(101);
            if (!resizing) {
                gap.setSizes(0, 0, Short.MAX_VALUE);
            }
            seq.add(gap, -1);
            this.layoutModel.addInterval(seq, targetRoots[dim], -1);
        }
    }

    private void addToEmpty(LayoutComponent[] components, LayoutComponent targetContainer, LayoutInterval[] addingInts) {
        assert (targetContainer.getSubComponentCount() == 0);
        for (LayoutComponent comp : components) {
            this.layoutModel.addComponent(comp, targetContainer, -1);
        }
        LayoutInterval[] roots = this.getActiveLayoutRoots(targetContainer);
        for (int dim = 0; dim < 2; ++dim) {
            LayoutInterval root = roots[dim];
            assert (root.isParallel());
            LayoutInterval interval = addingInts[dim];
            if (!interval.isParallel()) {
                this.layoutModel.addInterval(interval, root, -1);
                continue;
            }
            while (interval.getSubIntervalCount() > 0) {
                this.layoutModel.addInterval(interval.remove(0), root, -1);
            }
        }
    }

    private LayoutInterval restrictedCopy(LayoutInterval interval, Map<LayoutComponent, LayoutComponent> componentMap, LayoutRegion space, int dimension, List<Object> temp) {
        boolean processTemp;
        boolean bl = processTemp = temp == null;
        if (temp == null) {
            temp = new LinkedList<Object>();
        }
        if (interval.isGroup()) {
            boolean parallel = interval.isParallel();
            LayoutInterval copy = LayoutInterval.cloneInterval(interval, null);
            Iterator<Object> iter = interval.getSubIntervals();
            int compCount = 0;
            boolean includeGap = false;
            int firstGapToInclude = 0;
            int gapStart = interval.getCurrentSpace().positions[dimension][0];
            while (iter.hasNext()) {
                LayoutInterval sub = iter.next();
                LayoutInterval subCopy = this.restrictedCopy(sub, componentMap, space, dimension, temp);
                if (subCopy != null) {
                    if (!sub.isEmptySpace()) {
                        if (includeGap) {
                            gapStart = Math.max(space.positions[dimension][0], gapStart);
                            int size = sub.getCurrentSpace().positions[dimension][0] - gapStart;
                            this.integrateGap(copy, size, firstGapToInclude);
                            includeGap = false;
                        }
                        gapStart = sub.getCurrentSpace().positions[dimension][1];
                        firstGapToInclude = copy.getSubIntervalCount();
                    }
                    if (sub.isComponent()) {
                        temp.add(subCopy);
                        temp.add(copy);
                        temp.add(new Integer(subCopy.getRawAlignment()));
                        temp.add(new Integer(copy.getSubIntervalCount() + compCount));
                        ++compCount;
                        continue;
                    }
                    this.layoutModel.addInterval(subCopy, copy, -1);
                    continue;
                }
                if (parallel) continue;
                includeGap = true;
            }
            if (includeGap) {
                gapStart = Math.max(space.positions[dimension][0], gapStart);
                int gapEnd = Math.min(space.positions[dimension][1], interval.getCurrentSpace().positions[dimension][1]);
                this.integrateGap(copy, gapEnd - gapStart, firstGapToInclude);
            }
            if (copy.getSubIntervalCount() + compCount > 0) {
                if (processTemp) {
                    LayoutInterval parent;
                    iter = temp.iterator();
                    while (iter.hasNext()) {
                        LayoutInterval comp = (LayoutInterval)iter.next();
                        parent = (LayoutInterval)iter.next();
                        int alignment = (Integer)iter.next();
                        int index = (Integer)iter.next();
                        if (comp.getParent() != null) {
                            this.removeComponentInterval(comp, dimension);
                        }
                        this.layoutModel.setIntervalAlignment(comp, alignment);
                        this.layoutModel.addInterval(comp, parent, index);
                    }
                    iter = temp.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        LayoutInterval group = (LayoutInterval)iter.next();
                        iter.next();
                        iter.next();
                        parent = group.getParent();
                        while (group.getSubIntervalCount() == 1 && parent != null) {
                            LayoutInterval sub = group.getSubInterval(0);
                            this.layoutModel.removeInterval(sub);
                            int alignment = group.getAlignment();
                            int index = this.layoutModel.removeInterval(group);
                            this.layoutModel.setIntervalAlignment(sub, alignment);
                            this.layoutModel.addInterval(sub, parent, index);
                            group = sub;
                        }
                    }
                    compCount = 0;
                }
                if (copy.getSubIntervalCount() == 1 && compCount == 0) {
                    LayoutInterval subCopy = copy.getSubInterval(0);
                    this.layoutModel.removeInterval(subCopy);
                    this.layoutModel.setIntervalAlignment(subCopy, copy.getAlignment());
                    copy = copy.isSequential() && subCopy.isEmptySpace() ? null : subCopy;
                }
                return copy;
            }
            return null;
        }
        if (interval.isComponent()) {
            LayoutComponent comp = componentMap.get(interval.getComponent());
            if (comp != null) {
                if (comp != interval.getComponent()) {
                    interval = LayoutInterval.cloneInterval(interval, comp.getLayoutInterval(dimension));
                }
                return interval;
            }
            return null;
        }
        assert (interval.isEmptySpace());
        int[] bounds = LayoutInterval.getCurrentPositions(interval, dimension);
        int rangeStart = space.positions[dimension][0];
        int rangeEnd = space.positions[dimension][1];
        if (bounds[0] < rangeEnd && bounds[1] > rangeStart) {
            LayoutInterval gap = new LayoutInterval(101);
            gap.setAttributes(interval.getAttributes());
            if (bounds[0] < rangeStart || bounds[1] > rangeEnd) {
                int min = interval.getMinimumSize();
                if (min >= 0) {
                    min = -2;
                }
                int pref = Math.min(bounds[1], rangeEnd) - Math.max(bounds[0], rangeStart);
                int max = interval.getMaximumSize();
                if (max >= 0) {
                    max = -2;
                }
                gap.setSizes(min, pref, max);
            } else {
                gap.setSizes(interval.getMinimumSize(), interval.getPreferredSize(), interval.getMaximumSize());
                gap.setPaddingType(interval.getPaddingType());
            }
            return gap;
        }
        return null;
    }

    private void integrateGap(LayoutInterval seqGroup, int size, int boundary) {
        while (seqGroup.getSubIntervalCount() > boundary && seqGroup.getSubInterval(seqGroup.getSubIntervalCount() - 1).isEmptySpace()) {
            this.layoutModel.removeInterval(seqGroup.getSubInterval(seqGroup.getSubIntervalCount() - 1));
        }
        if (size > 0) {
            LayoutInterval gap = new LayoutInterval(101);
            gap.setSize(size);
            this.layoutModel.addInterval(gap, seqGroup, -1);
        }
    }

    public void removeDraggedComponents() {
        if (this.dragger != null) {
            this.removeComponentsFromParent(this.dragger.getMovingComponents());
            this.endMoving(false);
        }
    }

    public void paintMoveFeedback(Graphics2D g) {
        if (this.dragger != null) {
            this.dragger.paintMoveFeedback(g);
        }
    }

    public void paintSelection(Graphics2D g, String componentId) {
        LayoutComponent comp = this.layoutModel.getLayoutComponent(componentId);
        if (comp != null && comp.getParent() != null) {
            this.paintSelection(g, comp, 0);
            this.paintSelection(g, comp, 1);
            if (this.isUnplacedComponent(componentId)) {
                LayoutRegion region = comp.getCurrentSpace();
                Rectangle rect = region.toRectangle(new Rectangle());
                Image image = this.getWarningImage();
                g.drawImage(image, rect.x + rect.width - image.getWidth(null), rect.y, null);
            }
        }
    }

    private Image getWarningImage() {
        if (this.warningImage == null) {
            this.warningImage = ImageUtilities.loadImage((String)"org/netbeans/modules/form/layoutsupport/resources/warning.png");
        }
        return this.warningImage;
    }

    private void paintSelection(Graphics2D g, LayoutComponent component, int dimension) {
        LayoutInterval interval = component.getLayoutInterval(dimension);
        if (component.isLinkSized(0) || component.isLinkSized(1)) {
            this.paintLinks(g, component);
        }
        if (interval.getAlignment() == 3) {
            LayoutInterval alignedParent = interval.getParent();
            int oppDimension = dimension == 0 ? 1 : 0;
            LayoutRegion region = alignedParent.getCurrentSpace();
            int x = region.positions[dimension][3];
            int y1 = region.positions[oppDimension][0];
            int y2 = region.positions[oppDimension][1];
            if (y1 != Integer.MIN_VALUE && y2 != Integer.MIN_VALUE) {
                if (dimension == 0) {
                    g.drawLine(x, y1, x, y2);
                } else {
                    g.drawLine(y1, x, y2, x);
                }
            }
        }
        int lastAlignment = -1;
        while (interval.getParent() != null) {
            int alignment;
            LayoutInterval parent = interval.getParent();
            if (parent.getType() == 102) {
                int end;
                alignment = LayoutInterval.getEffectiveAlignment(interval);
                int index = parent.indexOf(interval);
                block0 : switch (alignment) {
                    case 0: {
                        int start = 0;
                        end = index;
                        lastAlignment = 0;
                        break;
                    }
                    case 1: {
                        int start = index + 1;
                        end = parent.getSubIntervalCount();
                        lastAlignment = 1;
                        break;
                    }
                    default: {
                        int start;
                        switch (lastAlignment) {
                            case 0: {
                                start = 0;
                                end = index;
                                break block0;
                            }
                            case 1: {
                                start = index + 1;
                                end = parent.getSubIntervalCount();
                                break block0;
                            }
                        }
                        start = 0;
                        end = parent.getSubIntervalCount();
                    }
                }
                for (int i = start; i < end; ++i) {
                    LayoutInterval candidate = parent.getSubInterval(i);
                    if (!candidate.isEmptySpace()) continue;
                    this.paintAlignment(g, candidate, dimension, LayoutInterval.getEffectiveAlignment(candidate));
                }
            } else {
                alignment = interval.getAlignment();
                if (!LayoutInterval.wantResizeInLayout(interval)) {
                    lastAlignment = alignment;
                }
                this.paintAlignment(g, interval, dimension, lastAlignment);
            }
            interval = interval.getParent();
        }
    }

    private void paintLinks(Graphics2D g, LayoutComponent component) {
        if (component.isLinkSized(0) && component.isLinkSized(1)) {
            int i;
            Map<Integer, List<String>> linkGroupsH = this.layoutModel.getLinkSizeGroups(0);
            Map<Integer, List<String>> linkGroupsV = this.layoutModel.getLinkSizeGroups(1);
            Integer linkIdH = new Integer(component.getLinkSizeId(0));
            Integer linkIdV = new Integer(component.getLinkSizeId(1));
            List<String> lH = linkGroupsH.get(linkIdH);
            List<String> lV = linkGroupsV.get(linkIdV);
            HashSet<String> merged = new HashSet<String>();
            for (i = 0; i < lH.size(); ++i) {
                merged.add(lH.get(i));
            }
            for (i = 0; i < lV.size(); ++i) {
                merged.add(lV.get(i));
            }
            for (String id : merged) {
                LayoutComponent lc = this.layoutModel.getLayoutComponent(id);
                LayoutInterval interval = lc.getLayoutInterval(0);
                LayoutRegion region = interval.getCurrentSpace();
                Image badge = null;
                if (lV.contains(id) && lH.contains(id)) {
                    badge = this.getLinkBadge(2);
                } else {
                    if (lH.contains(lc.getId())) {
                        badge = this.getLinkBadge(0);
                    }
                    if (lV.contains(lc.getId())) {
                        badge = this.getLinkBadge(1);
                    }
                }
                int x = region.positions[0][1] - region.size(0) / 4 - badge.getWidth(null) / 2;
                int y = region.positions[1][0] - badge.getHeight(null);
                g.drawImage(badge, x, y, null);
            }
        } else {
            int dimension = component.isLinkSized(0) ? 0 : 1;
            Map<Integer, List<String>> map = this.layoutModel.getLinkSizeGroups(dimension);
            Integer linkId = new Integer(component.getLinkSizeId(dimension));
            List<String> l = map.get(linkId);
            for (String id : l) {
                LayoutComponent lc = this.layoutModel.getLayoutComponent(id);
                LayoutInterval interval = lc.getLayoutInterval(dimension);
                LayoutRegion region = interval.getCurrentSpace();
                Image badge = this.getLinkBadge(dimension);
                int x = region.positions[0][1] - region.size(0) / 4 - badge.getWidth(null) / 2;
                int y = region.positions[1][0] - badge.getHeight(null);
                g.drawImage(badge, x, y, null);
            }
        }
    }

    private Image getLinkBadge(int dimension) {
        if (dimension == 2) {
            if (this.linkBadgeBoth == null) {
                this.linkBadgeBoth = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/sameboth.png");
            }
            return this.linkBadgeBoth;
        }
        if (dimension == 0) {
            if (this.linkBadgeHorizontal == null) {
                this.linkBadgeHorizontal = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/samewidth.png");
            }
            return this.linkBadgeHorizontal;
        }
        if (dimension == 1) {
            if (this.linkBadgeVertical == null) {
                this.linkBadgeVertical = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/sameheight.png");
            }
            return this.linkBadgeVertical;
        }
        return null;
    }

    private void paintAlignment(Graphics2D g, LayoutInterval interval, int dimension, int alignment) {
        int y;
        int x2;
        int x1;
        int opposite;
        LayoutInterval parent = interval.getParent();
        boolean baseline = parent.isParallel() && parent.getGroupAlignment() == 3;
        LayoutRegion group = parent.getCurrentSpace();
        int n = opposite = dimension == 0 ? 1 : 0;
        if (interval.isEmptySpace()) {
            boolean x2group;
            int[] yb;
            boolean x1group;
            int[] ya;
            int index = parent.indexOf(interval);
            if (index == 0) {
                x1 = group.positions[dimension][baseline ? 3 : 0];
                ya = this.visualIntervalPosition(parent, opposite, 0);
                x1group = LayoutInterval.getFirstParent(interval, 103).getParent() != null;
            } else {
                LayoutInterval x1int = parent.getSubInterval(index - 1);
                if (x1int.isParallel() && x1int.getGroupAlignment() == 3) {
                    x1 = x1int.getCurrentSpace().positions[dimension][3];
                } else {
                    if (x1int.isEmptySpace()) {
                        return;
                    }
                    x1 = x1int.getCurrentSpace().positions[dimension][1];
                }
                ya = this.visualIntervalPosition(x1int, opposite, 1);
                x1group = x1int.isGroup();
            }
            if (index + 1 == parent.getSubIntervalCount()) {
                x2 = group.positions[dimension][baseline ? 3 : 1];
                yb = this.visualIntervalPosition(parent, opposite, 1);
                x2group = LayoutInterval.getFirstParent(interval, 103).getParent() != null;
            } else {
                LayoutInterval x2int = parent.getSubInterval(index + 1);
                if (x2int.isParallel() && x2int.getGroupAlignment() == 3) {
                    x2 = x2int.getCurrentSpace().positions[dimension][3];
                } else {
                    if (x2int.isEmptySpace()) {
                        return;
                    }
                    x2 = x2int.getCurrentSpace().positions[dimension][0];
                }
                yb = this.visualIntervalPosition(x2int, opposite, 0);
                x2group = x2int.isGroup();
            }
            if (x1 == Integer.MIN_VALUE || x2 == Integer.MIN_VALUE) {
                return;
            }
            int y1 = Math.min(ya[1], yb[1]);
            int y2 = Math.max(ya[0], yb[0]);
            y = (y1 + y2) / 2;
            if (ya[1] < yb[0] || yb[1] < ya[0]) {
                if (dimension == 0) {
                    g.drawLine(x1, ya[0], x1, y);
                    g.drawLine(x1, ya[0], x1, ya[1]);
                    g.drawLine(x2, yb[0], x2, y);
                    g.drawLine(x2, yb[0], x2, yb[1]);
                } else {
                    g.drawLine(ya[0], x1, y, x1);
                    g.drawLine(ya[0], x1, ya[1], x1);
                    g.drawLine(yb[0], x2, y, x2);
                    g.drawLine(yb[0], x2, yb[1], x2);
                }
            } else if (dimension == 0) {
                if (x1group) {
                    g.drawLine(x1, ya[0], x1, ya[1]);
                }
                if (x2group) {
                    g.drawLine(x2, yb[0], x2, yb[1]);
                }
            } else {
                if (x1group) {
                    g.drawLine(ya[0], x1, ya[1], x1);
                }
                if (x2group) {
                    g.drawLine(yb[0], x2, yb[1], x2);
                }
            }
        } else {
            LayoutRegion child = interval.getCurrentSpace();
            if (alignment == 0 || alignment == 1) {
                x1 = group.positions[dimension][baseline ? 3 : alignment];
                x2 = interval.isParallel() && interval.getAlignment() == 3 ? child.positions[dimension][3] : child.positions[dimension][alignment];
            } else {
                return;
            }
            if (x1 == Integer.MIN_VALUE || x2 == Integer.MIN_VALUE) {
                return;
            }
            int[] pos = this.visualIntervalPosition(parent, opposite, alignment);
            y = (pos[0] + pos[1]) / 2;
            int xa = group.positions[dimension][0];
            int xb = group.positions[dimension][1];
            if (parent.getParent() != null) {
                if (dimension == 0) {
                    if (alignment == 0) {
                        g.drawLine(xa, pos[0], xa, pos[1]);
                    } else if (alignment == 1) {
                        g.drawLine(xb, pos[0], xb, pos[1]);
                    }
                } else if (alignment == 0) {
                    g.drawLine(pos[0], xa, pos[1], xa);
                } else if (alignment == 1) {
                    g.drawLine(pos[0], xb, pos[1], xb);
                }
            }
        }
        if (x2 - x1 > 1 && Math.abs(y) <= Short.MAX_VALUE && Math.abs(x1) <= Short.MAX_VALUE && Math.abs(x2) <= Short.MAX_VALUE) {
            int angle;
            int x;
            if (alignment == 0) {
                x = x1;
                angle = 180;
            } else {
                x = x2;
                angle = 0;
            }
            int diam = Math.min(4, --x2 - x1);
            BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f);
            Stroke oldStroke = g.getStroke();
            g.setStroke(stroke);
            if (dimension == 0) {
                g.drawLine(x1, y, x2, y);
                angle += 90;
            } else {
                g.drawLine(y, x1, y, x2);
                int temp = x;
                x = y;
                y = temp;
            }
            g.setStroke(oldStroke);
            if (alignment == 0 || alignment == 1) {
                Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fillArc(x - diam, y - diam, 2 * diam, 2 * diam, angle, 180);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
            }
        }
    }

    private int[] visualIntervalPosition(LayoutInterval interval, int dimension, int alignment) {
        int min = Short.MAX_VALUE;
        int max = Short.MIN_VALUE;
        if (interval.isParallel() && interval.getGroupAlignment() != 3) {
            Iterator<LayoutInterval> iter = interval.getSubIntervals();
            while (iter.hasNext()) {
                int imax;
                int imin;
                int oppDim;
                LayoutInterval subInterval = iter.next();
                int n = oppDim = dimension == 0 ? 1 : 0;
                if (LayoutInterval.isPlacedAtBorder(subInterval, oppDim, alignment)) {
                    if (subInterval.isParallel()) {
                        int[] ipos = this.visualIntervalPosition(subInterval, dimension, alignment);
                        imin = ipos[0];
                        imax = ipos[1];
                    } else if (!subInterval.isEmptySpace()) {
                        LayoutRegion region = subInterval.getCurrentSpace();
                        imin = region.positions[dimension][0];
                        imax = region.positions[dimension][1];
                    } else {
                        imin = min;
                        imax = max;
                    }
                } else {
                    imin = min;
                    imax = max;
                }
                if (min > imin) {
                    min = imin;
                }
                if (max >= imax) continue;
                max = imax;
            }
        }
        if (!interval.isParallel() || min == Short.MAX_VALUE) {
            LayoutRegion region = interval.getCurrentSpace();
            min = region.positions[dimension][0];
            max = region.positions[dimension][1];
        }
        return new int[]{min, max};
    }

    public void copyLayout(LayoutModel sourceModel, Map<String, String> sourceToTargetId, String targetContainerId) {
        LayoutComponent targetContainer;
        Map.Entry<String, String> firstEntry;
        LayoutComponent sourceContainer;
        if (sourceToTargetId.isEmpty()) {
            return;
        }
        if (sourceModel == null) {
            sourceModel = this.layoutModel;
        }
        if ((sourceContainer = sourceModel.getLayoutComponent((firstEntry = sourceToTargetId.entrySet().iterator().next()).getKey()).getParent()) != (targetContainer = this.layoutModel.getLayoutComponent(targetContainerId)) && sourceContainer.getSubComponentCount() == sourceToTargetId.size() && (targetContainer == null || targetContainer.getSubComponentCount() == 0)) {
            if (sourceModel != this.layoutModel || !firstEntry.getKey().equals(firstEntry.getValue())) {
                this.layoutModel.copyContainerLayout(sourceContainer, sourceToTargetId, targetContainer);
            } else {
                this.layoutModel.moveContainerLayout(sourceContainer, targetContainer);
                LayoutInterval[] sourceRoots = this.getActiveLayoutRoots(sourceContainer);
                for (int i = 0; i < 2; ++i) {
                    if (!sourceRoots[i].getCurrentSpace().isSet(i)) continue;
                    this.propEmptyContainer(sourceRoots[i], i);
                }
            }
        } else {
            HashMap<LayoutComponent, LayoutComponent> sourceToTargetComp = new HashMap<LayoutComponent, LayoutComponent>();
            LayoutComponent[] sourceComponents = new LayoutComponent[sourceToTargetId.size()];
            LayoutComponent[] targetComponents = new LayoutComponent[sourceToTargetId.size()];
            Rectangle[] bounds = new Rectangle[sourceToTargetId.size()];
            LayoutRegion overallSpace = new LayoutRegion();
            LayoutInterval[] commonParents = new LayoutInterval[2];
            int i = 0;
            for (Map.Entry<String, String> entry : sourceToTargetId.entrySet()) {
                String sourceId = entry.getKey();
                LayoutComponent sourceLC = sourceModel.getLayoutComponent(sourceId);
                String targetId = entry.getValue();
                LayoutComponent targetLC = this.layoutModel.getLayoutComponent(targetId);
                if (targetLC == null) {
                    targetLC = new LayoutComponent(targetId, false);
                } else if (targetLC.getParent() == targetContainer) {
                    throw new IllegalArgumentException("The component is already placed in the target layout container");
                }
                sourceToTargetComp.put(sourceLC, targetLC);
                targetComponents[i] = targetLC;
                LayoutRegion space = sourceLC.getLayoutInterval(0).getCurrentSpace();
                overallSpace.expand(space);
                bounds[i] = space.toRectangle(new Rectangle());
                sourceComponents[i] = sourceLC;
                ++i;
                for (int dim = 0; dim < 2; ++dim) {
                    commonParents[dim] = commonParents[dim] == null ? sourceLC.getLayoutInterval(dim) : LayoutInterval.getCommonParent(commonParents[dim], sourceLC.getLayoutInterval(dim));
                }
            }
            LayoutInterval[] addingInts = new LayoutInterval[2];
            for (int dim = 0; dim < 2; ++dim) {
                addingInts[dim] = this.restrictedCopy(commonParents[dim], sourceToTargetComp, overallSpace, dim, null);
            }
            int[] shift = LayoutDesigner.getCopyShift(sourceComponents, targetContainer, overallSpace, sourceContainer == targetContainer);
            if (shift != null) {
                if (targetComponents.length > 1) {
                    for (LayoutComponent comp : targetComponents) {
                        if (comp.getParent() == null) continue;
                        this.layoutModel.removeComponent(comp, false);
                    }
                }
                this.prepareDragger(targetComponents, bounds, new Point(0, 0), LayoutDragger.ALL_EDGES);
                this.dragger.setTargetContainer(targetContainer, this.getTargetRootsForCopy(targetContainer));
                this.dragger.move(shift, false, false);
                this.addComponents(targetComponents, targetContainer, addingInts, false, null);
                this.dragger = null;
            } else {
                this.removeComponents(targetComponents, false);
                this.addUnspecified(targetComponents, targetContainer, addingInts);
            }
        }
        this.visualStateUpToDate = false;
        this.updateDataAfterBuild = true;
    }

    public void copyLayoutFromOutside(Map<String, Rectangle> idToBounds, String targetContainerId, boolean relative) {
        LayoutComponent targetContainer = this.layoutModel.getLayoutComponent(targetContainerId);
        if (targetContainer.getSubComponentCount() > 0) {
            relative = true;
        }
        HashMap<LayoutComponent, Rectangle> compToBounds = new HashMap<LayoutComponent, Rectangle>();
        LayoutComponent[] components = new LayoutComponent[idToBounds.size()];
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int i = 0;
        for (Map.Entry<String, Rectangle> entry : idToBounds.entrySet()) {
            String targetId = entry.getKey();
            LayoutComponent targetLC = this.layoutModel.getLayoutComponent(targetId);
            if (targetLC == null) {
                targetLC = new LayoutComponent(targetId, false);
            } else if (targetLC.getParent() != null) {
                throw new IllegalArgumentException("Target component already exists and is placed in the layout");
            }
            Rectangle r = new Rectangle(entry.getValue());
            compToBounds.put(targetLC, r);
            components[i] = targetLC;
            LayoutRegion compSpace = new LayoutRegion(r, Integer.MIN_VALUE);
            Dimension preferred = this.visualMapper.getComponentPreferredSize(targetId);
            for (int dim = 0; dim < 2; ++dim) {
                LayoutInterval li = targetLC.getLayoutInterval(dim);
                li.setAttribute(1024);
                int size = compSpace.size(dim);
                if (preferred != null && size == (dim == 0 ? preferred.width : preferred.height)) continue;
                li.setPreferredSize(compSpace.size(dim));
            }
            if (relative) {
                minX = Math.min(minX, compSpace.positions[0][0]);
                minY = Math.min(minY, compSpace.positions[1][0]);
            }
            ++i;
        }
        if (relative) {
            for (Rectangle r : compToBounds.values()) {
                r.x -= minX;
                r.y -= minY;
            }
        }
        LayoutInterval[] addingInts = LayoutModel.createIntervalsFromBounds(compToBounds);
        if (relative) {
            this.addUnspecified(components, targetContainer, addingInts);
        } else {
            this.addToEmpty(components, targetContainer, addingInts);
        }
        this.visualStateUpToDate = false;
        this.updateDataAfterBuild = true;
    }

    public void duplicateLayout(String[] sourceIds, String[] targetIds, int dimension, int direction) {
        if (this.logTestCode()) {
            this.testCode.add("// > DUPLICATE");
            this.testCode.add("{");
            LayoutTestUtils.writeStringArray(this.testCode, "sourceIds", sourceIds);
            LayoutTestUtils.writeStringArray(this.testCode, "targetIds", targetIds);
            this.testCode.add("int dimension = " + dimension + ";");
            this.testCode.add("int direction = " + direction + ";");
            this.testCode.add("ld.duplicateLayout(sourceIds, targetIds, dimension, direction);");
            this.testCode.add("}");
            this.testCode.add("// < DUPLICATE");
        }
        LayoutComponent[] sourceComps = new LayoutComponent[sourceIds.length];
        LayoutInterval[][] sourceIntervals = new LayoutInterval[2][sourceIds.length];
        LayoutComponent[] targetComps = new LayoutComponent[targetIds.length];
        HashMap<LayoutComponent, LayoutComponent> compMap = new HashMap<LayoutComponent, LayoutComponent>();
        LayoutComponent container = null;
        for (int i = 0; i < sourceComps.length; ++i) {
            LayoutComponent sourceLC = this.layoutModel.getLayoutComponent(sourceIds[i]);
            LayoutComponent parent = sourceLC.getParent();
            if (i == 0) {
                container = parent;
            } else if (parent != container) {
                throw new IllegalArgumentException("Duplicated components must be in the same container.");
            }
            sourceComps[i] = sourceLC;
            LayoutComponent targetLC = this.layoutModel.getLayoutComponent(targetIds[i]);
            if (targetLC == null) {
                targetLC = new LayoutComponent(targetIds[i], false);
            } else if (targetLC.getParent() != null) {
                throw new IllegalArgumentException("Target component already exists and is placed in the layout");
            }
            this.layoutModel.addComponent(targetLC, container, -1);
            compMap.put(sourceLC, targetLC);
            targetComps[i] = targetLC;
            for (int dim = 0; dim < 2; ++dim) {
                LayoutInterval li;
                sourceIntervals[dim][i] = li = sourceLC.getLayoutInterval(dim);
            }
        }
        int seqDim = dimension < 0 ? LayoutDesigner.getSeqDuplicatingDimension(sourceComps) : dimension;
        int seqDir = direction < 0 ? LayoutDesigner.getSeqDuplicatingDirection(sourceComps, seqDim) : direction;
        int parDim = seqDim ^ 1;
        this.duplicateSequentially(sourceIntervals[seqDim], compMap, seqDim, seqDir);
        this.duplicateInParallel(sourceIntervals[parDim], compMap, parDim);
        this.requireStructureOptimization(container);
        this.visualStateUpToDate = false;
        this.updateDataAfterBuild = true;
    }

    private static int getSeqDuplicatingDimension(LayoutComponent[] components) {
        return 1;
    }

    private static int getSeqDuplicatingDirection(LayoutComponent[] components, int dimension) {
        return 1;
    }

    private void duplicateSequentially(LayoutInterval[] intervals, Map<LayoutComponent, LayoutComponent> componentMap, int dimension, int direction) {
        HashSet<LayoutInterval> dupRoots = new HashSet<LayoutInterval>();
        for (LayoutInterval li : intervals) {
            LayoutInterval parent;
            for (parent = li.getParent(); parent != null && !dupRoots.contains(parent); parent = parent.getParent()) {
            }
            if (parent != null) continue;
            parent = li.getParent();
            while (parent != null) {
                if (LayoutDesigner.shouldDuplicateWholeGroup(parent, li, intervals)) {
                    li = parent;
                    parent = li.getParent();
                    continue;
                }
                if (li.isGroup()) {
                    Iterator it = dupRoots.iterator();
                    while (it.hasNext()) {
                        LayoutInterval dRoot = (LayoutInterval)it.next();
                        if (!li.isParentOf(dRoot)) continue;
                        it.remove();
                    }
                }
                dupRoots.add(li);
                break;
            }
            if (parent != null) continue;
            dupRoots.clear();
            dupRoots.add(li);
            break;
        }
        while (!dupRoots.isEmpty()) {
            LayoutInterval seq;
            LayoutInterval dRoot = (LayoutInterval)dupRoots.iterator().next();
            LayoutInterval parent = dRoot.getParent();
            if (parent != null) {
                if (dRoot.isSequential()) {
                    seq = dRoot;
                } else if (parent.isSequential()) {
                    seq = parent;
                } else {
                    seq = new LayoutInterval(102);
                    this.layoutModel.addInterval(seq, parent, this.layoutModel.removeInterval(dRoot));
                    this.layoutModel.addInterval(dRoot, seq, -1);
                }
            } else {
                LayoutInterval group = new LayoutInterval(103);
                group.setGroupAlignment(dRoot.getGroupAlignment());
                while (dRoot.getSubIntervalCount() > 0) {
                    this.layoutModel.addInterval(this.layoutModel.removeInterval(dRoot, 0), group, -1);
                }
                seq = new LayoutInterval(102);
                this.layoutModel.addInterval(seq, dRoot, -1);
                this.layoutModel.addInterval(group, seq, -1);
            }
            int start = -1;
            boolean wholeSeq = dupRoots.remove(seq);
            LayoutRegion space = seq.getParent().getCurrentSpace();
            for (int i = 0; i < seq.getSubIntervalCount(); ++i) {
                boolean last;
                LayoutInterval sub = seq.getSubInterval(i);
                boolean duplicate = !sub.isEmptySpace() && (wholeSeq || dupRoots.remove(sub));
                boolean bl = last = i + 1 == seq.getSubIntervalCount();
                if (duplicate && start < 0) {
                    start = i;
                }
                if (start < 0 || (duplicate || sub.isEmptySpace()) && !last) continue;
                int count = i - start;
                if (last && duplicate) {
                    ++count;
                } else if (seq.getSubInterval(i - 1).isEmptySpace()) {
                    --count;
                }
                if (count > 0) {
                    int gapIndex;
                    for (int j = start; j < start + count; ++j) {
                        LayoutInterval li = seq.getSubInterval(j);
                        LayoutInterval copy = this.restrictedCopy(li, componentMap, space, dimension, null);
                        if (direction == 0) {
                            this.layoutModel.addInterval(copy, seq, start);
                            ++start;
                            ++i;
                            ++j;
                            continue;
                        }
                        this.layoutModel.addInterval(copy, seq, j + count);
                        ++i;
                    }
                    LayoutInterval gap = null;
                    if (direction == 0) {
                        gapIndex = start + count;
                        if (gapIndex < seq.getSubIntervalCount()) {
                            gap = seq.getSubInterval(gapIndex);
                        }
                        gapIndex = start;
                    } else {
                        gapIndex = start - 1;
                        if (gapIndex >= 0) {
                            gap = seq.getSubInterval(gapIndex);
                        }
                        gapIndex = start + count;
                    }
                    LayoutInterval newGap = new LayoutInterval(101);
                    if (gap != null && gap.isEmptySpace()) {
                        LayoutInterval.cloneInterval(gap, newGap);
                    }
                    this.layoutModel.addInterval(newGap, seq, gapIndex);
                    ++i;
                }
                start = -1;
            }
            dupRoots.remove(dRoot);
        }
    }

    private static boolean shouldDuplicateWholeGroup(LayoutInterval group, LayoutInterval knownSub, LayoutInterval[] dupIntervals) {
        assert (group.isGroup());
        if (group.isParallel() && knownSub != null && knownSub.getAlignment() != 0 && knownSub.getAlignment() != 1) {
            return true;
        }
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            boolean included;
            LayoutInterval sub = it.next();
            if (sub == knownSub || sub.isEmptySpace()) continue;
            if (sub.isGroup()) {
                included = LayoutDesigner.shouldDuplicateWholeGroup(sub, null, dupIntervals);
            } else {
                assert (sub.isComponent());
                included = false;
                for (LayoutInterval li : dupIntervals) {
                    if (li != sub) continue;
                    included = true;
                    break;
                }
            }
            if (included && group.isParallel()) {
                return true;
            }
            if (included || !group.isSequential()) continue;
            return false;
        }
        return group.isSequential();
    }

    private void duplicateInParallel(LayoutInterval[] intervals, Map<LayoutComponent, LayoutComponent> componentMap, int dimension) {
        HashMap<LayoutInterval, LayoutInterval> intMap = new HashMap<LayoutInterval, LayoutInterval>();
        for (LayoutInterval li : intervals) {
            intMap.put(li, componentMap.get(li.getComponent()).getLayoutInterval(dimension));
        }
        for (LayoutInterval li : intervals) {
            LayoutInterval copy = (LayoutInterval)intMap.get(li);
            if (copy == null) continue;
            LayoutInterval parent = li.getParent();
            if (parent.isParallel()) {
                LayoutInterval.cloneInterval(li, copy);
                this.layoutModel.setIntervalAlignment(copy, li.getRawAlignment());
                this.layoutModel.addInterval(copy, parent, -1);
                continue;
            }
            int index = parent.indexOf(li);
            int start = LayoutDesigner.getDuplicationBoundary(parent, index, intMap.keySet(), 0);
            int end = LayoutDesigner.getDuplicationBoundary(parent, index, intMap.keySet(), 1);
            int gapStart = LayoutUtils.getVisualPosition(parent.getSubInterval(start), dimension, 0);
            LayoutInterval normalGap = null;
            boolean substGap = false;
            LayoutInterval parSeq = new LayoutInterval(102);
            for (int i = start; i <= end; ++i) {
                LayoutInterval sub = parent.getSubInterval(i);
                copy = (LayoutInterval)intMap.remove(sub);
                if (copy != null) {
                    LayoutInterval.cloneInterval(sub, copy);
                    if (normalGap != null) {
                        LayoutInterval copyGap = new LayoutInterval(101);
                        LayoutInterval.cloneInterval(normalGap, copyGap);
                        this.layoutModel.addInterval(copyGap, parSeq, -1);
                        normalGap = null;
                    } else if (substGap) {
                        LayoutInterval gap = new LayoutInterval(101);
                        int gapEnd = sub.getCurrentSpace().positions[dimension][0];
                        gap.setSize(gapEnd - gapStart);
                        this.layoutModel.addInterval(gap, parSeq, -1);
                        substGap = false;
                    }
                    this.layoutModel.addInterval(copy, parSeq, -1);
                    gapStart = sub.getCurrentSpace().positions[dimension][1];
                    continue;
                }
                if (!sub.isEmptySpace()) {
                    normalGap = null;
                    substGap = true;
                    continue;
                }
                if (substGap) continue;
                normalGap = sub;
            }
            if (normalGap != null) {
                LayoutInterval copyGap = new LayoutInterval(101);
                LayoutInterval.cloneInterval(normalGap, copyGap);
                this.layoutModel.addInterval(copyGap, parSeq, -1);
            } else if (substGap) {
                LayoutInterval gap = new LayoutInterval(101);
                int gapEnd = LayoutUtils.getVisualPosition(parent.getSubInterval(end), dimension, 1);
                gap.setSize(gapEnd - gapStart);
                this.layoutModel.addInterval(gap, parSeq, -1);
            }
            this.operations.addParallelWithSequence(parSeq, parent, start, end, dimension);
        }
    }

    private static int getDuplicationBoundary(LayoutInterval seq, int index, Set<LayoutInterval> dupIntervals, int direction) {
        LayoutInterval sub;
        assert (seq.isSequential());
        int d = direction == 0 ? -1 : 1;
        index += d;
        while (index >= 0 && index < seq.getSubIntervalCount() && !(sub = seq.getSubInterval(index)).isParallel()) {
            index += d;
        }
        return index - d;
    }

    public void encloseInContainer(String[] compIds, String contId) {
        int dim;
        LayoutComponent enclosingCont = this.layoutModel.getLayoutComponent(contId);
        if (enclosingCont == null) {
            enclosingCont = new LayoutComponent(contId, true);
        } else {
            if (enclosingCont.getParent() != null) {
                throw new IllegalArgumentException("Target container already exists and is placed in the layout.");
            }
            if (enclosingCont.getSubComponentCount() > 0) {
                throw new IllegalArgumentException("Target container is not empty.");
            }
        }
        LayoutComponent parentCont = null;
        LayoutComponent[] components = new LayoutComponent[compIds.length];
        LayoutInterval[] commonParents = new LayoutInterval[2];
        boolean[] resizing = new boolean[2];
        HashMap<LayoutComponent, LayoutComponent> compMap = new HashMap<LayoutComponent, LayoutComponent>();
        LayoutRegion overallSpace = new LayoutRegion();
        int i = 0;
        for (String id : compIds) {
            LayoutComponent comp = this.layoutModel.getLayoutComponent(id);
            components[i++] = comp;
            compMap.put(comp, comp);
            if (parentCont == null) {
                parentCont = comp.getParent();
            }
            for (int dim2 = 0; dim2 < 2; ++dim2) {
                LayoutInterval compInt = comp.getLayoutInterval(dim2);
                overallSpace.expand(compInt.getCurrentSpace(), dim2);
                commonParents[dim2] = commonParents[dim2] == null ? compInt : LayoutInterval.getCommonParent(commonParents[dim2], compInt);
            }
        }
        LayoutInterval[] parentRoots = new LayoutInterval[2];
        for (int dim3 = 0; dim3 < 2; ++dim3) {
            LayoutInterval compParent = commonParents[dim3];
            parentRoots[dim3] = LayoutInterval.getRoot(compParent);
            resizing[dim3] = LayoutInterval.wantResize(compParent);
        }
        this.prepareDragger(new LayoutComponent[]{enclosingCont}, new Rectangle[]{overallSpace.toRectangle(new Rectangle())}, new Point(0, 0), LayoutDragger.ALL_EDGES);
        this.dragger.setTargetContainer(parentCont, parentRoots);
        if (enclosingCont.isLayoutContainer()) {
            LayoutInterval[] extractedInts = new LayoutInterval[2];
            for (dim = 0; dim < 2; ++dim) {
                LayoutInterval extract = commonParents[dim];
                if (extract.isComponent()) {
                    this.removeComponentInterval(extract, dim);
                    extractedInts[dim] = extract;
                } else {
                    extractedInts[dim] = this.restrictedCopy(extract, compMap, overallSpace, dim, null);
                }
                this.afterRemoveSpaceUpdate(parentCont.getDefaultLayoutRoot(dim), dim);
            }
            for (LayoutComponent comp : components) {
                this.layoutModel.removeComponent(comp, false);
                this.layoutModel.addComponent(comp, enclosingCont, -1);
            }
            for (dim = 0; dim < 2; ++dim) {
                LayoutInterval root = enclosingCont.getDefaultLayoutRoot(dim);
                for (int n = root.getSubIntervalCount(); n > 0; --n) {
                    root.remove(n - 1);
                }
                assert (root.isParallel());
                LayoutInterval seq = new LayoutInterval(102);
                seq.add(new LayoutInterval(101), -1);
                this.layoutModel.addInterval(extractedInts[dim], seq, -1);
                seq.add(new LayoutInterval(101), -1);
                this.layoutModel.addInterval(seq, root, -1);
            }
        } else {
            this.removeComponentsFromParent(components);
        }
        LayoutInterval[] addingInts = new LayoutInterval[2];
        for (dim = 0; dim < 2; ++dim) {
            LayoutInterval interval;
            addingInts[dim] = interval = enclosingCont.getLayoutInterval(dim);
            interval.setSizes(-2, -1, resizing[dim] ? Short.MAX_VALUE : -2);
        }
        this.dragger.move(new int[]{10, 10}, true, false);
        this.dragger.move(new int[]{0, 0}, true, false);
        this.addComponents(new LayoutComponent[]{enclosingCont}, parentCont, addingInts, false, null);
        this.dragger = null;
        this.visualStateUpToDate = false;
        this.updateDataAfterBuild = true;
    }

    public void addUnspecifiedComponent(String targetId, String sourceId, Dimension compSize, String targetContainerId) {
        LayoutComponent targetContainer = this.layoutModel.getLayoutComponent(targetContainerId);
        LayoutComponent targetLC = this.layoutModel.getLayoutComponent(targetId);
        if (targetLC == null) {
            targetLC = new LayoutComponent(targetId, false);
        } else if (targetLC.getParent() != null) {
            if (targetLC.getParent() != targetContainer && targetId.equals(sourceId)) {
                this.removeComponents(new LayoutComponent[]{targetLC}, false);
            } else {
                throw new IllegalArgumentException("Target component already exists and is placed in the layout");
            }
        }
        LayoutComponent sourceLC = this.layoutModel.getLayoutComponent(sourceId);
        LayoutInterval[] addingInts = new LayoutInterval[2];
        if (sourceLC != null) {
            for (int dim = 0; dim < 2; ++dim) {
                LayoutInterval li = sourceLC.getLayoutInterval(dim);
                addingInts[dim] = LayoutInterval.cloneInterval(li, targetLC.getLayoutInterval(dim));
            }
        } else {
            Dimension preferred = compSize != null ? this.visualMapper.getComponentPreferredSize(targetId) : null;
            for (int dim = 0; dim < 2; ++dim) {
                int pref;
                LayoutInterval li;
                addingInts[dim] = li = targetLC.getLayoutInterval(dim);
                if (preferred == null) continue;
                int size = dim == 0 ? compSize.width : compSize.height;
                int n = pref = dim == 0 ? preferred.width : preferred.height;
                if (size == pref) continue;
                li.setPreferredSize(size);
            }
        }
        this.addUnspecified(new LayoutComponent[]{targetLC}, targetContainer, addingInts);
        this.visualStateUpToDate = false;
        this.updateDataAfterBuild = true;
    }

    public void addUnspecifiedComponent(LayoutComponent component, String targetContainerId) {
        if (component.getParent() != null) {
            throw new IllegalArgumentException("The component already exists and is placed in the layout");
        }
        LayoutComponent targetContainer = this.layoutModel.getLayoutComponent(targetContainerId);
        if (targetContainer == null) {
            this.layoutModel.addRootComponent(component);
            this.updateDataAfterBuild = true;
        } else {
            LayoutInterval[] addingInts = new LayoutInterval[2];
            for (int dim = 0; dim < 2; ++dim) {
                addingInts[dim] = component.getLayoutInterval(dim);
            }
            this.addUnspecified(new LayoutComponent[]{component}, targetContainer, addingInts);
            this.visualStateUpToDate = false;
        }
    }

    private LayoutInterval[] getTargetRootsForCopy(LayoutComponent targetContainer) {
        LayoutInterval[] roots = this.layoutModel.addNewLayoutRoots(targetContainer);
        LayoutRegion space = LayoutDesigner.getContainerSpace(targetContainer);
        for (int i = 0; i < 2; ++i) {
            roots[i].setCurrentSpace(space);
        }
        return roots;
    }

    private static int[] getCopyShift(LayoutComponent[] sourceComponents, LayoutComponent targetContainer, LayoutRegion compSpace, boolean relative) {
        LayoutRegion contSpace = LayoutDesigner.getContainerSpace(targetContainer);
        if (!compSpace.isSet() || !contSpace.isSet()) {
            return null;
        }
        int[] move = new int[2];
        if (relative) {
            for (int dim = 0; dim < 2; ++dim) {
                move[dim] = LayoutDesigner.suggestCopyShift(sourceComponents, dim);
            }
            if (move[0] == 0 && move[1] == 0) {
                move[1] = 10;
                move[0] = 10;
            }
        } else {
            for (int dim = 0; dim < 2; ++dim) {
                move[dim] = (contSpace.size(dim) - compSpace.size(dim)) / 2 - compSpace.positions[dim][0] + contSpace.positions[dim][0];
            }
        }
        return move;
    }

    private static int suggestCopyShift(LayoutComponent[] sourceComponents, int dimension) {
        if (!LayoutDesigner.isAnyComponentSnappedToRoot(sourceComponents, dimension, 1)) {
            return 10;
        }
        if (!LayoutDesigner.isAnyComponentSnappedToRoot(sourceComponents, dimension, 0)) {
            return -10;
        }
        return 0;
    }

    private static boolean isAnyComponentSnappedToRoot(LayoutComponent[] components, int dimension, int alignment) {
        LayoutInterval root = null;
        for (LayoutComponent comp : components) {
            LayoutInterval compInt = comp.getLayoutInterval(dimension);
            if (root == null) {
                root = LayoutInterval.getRoot(compInt);
            }
            if (!LayoutInterval.isPlacedAtBorder(compInt, root, dimension, alignment) && !LayoutDesigner.isSnappedNextToInParent(compInt, root, dimension, alignment)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSnappedNextToInParent(LayoutInterval interval, LayoutInterval parent, int dimension, int alignment) {
        LayoutInterval back;
        LayoutInterval gap = LayoutInterval.getNeighbor(interval, alignment, false, true, false);
        return gap != null && LayoutInterval.isFixedDefaultPadding(gap) && parent.isParentOf(gap) && ((back = LayoutInterval.getDirectNeighbor(gap, alignment ^ 1, true)) == interval || LayoutInterval.isPlacedAtBorder(interval, back, dimension, alignment)) && LayoutInterval.getNeighbor(gap, alignment, true, true, false) == null && LayoutInterval.isPlacedAtBorder(gap.getParent(), parent, dimension, alignment);
    }

    private static LayoutRegion getContainerSpace(LayoutComponent container) {
        return container.getDefaultLayoutRoot(0).getCurrentSpace();
    }

    private LayoutInterval[] getActiveLayoutRoots(LayoutComponent container) {
        return container.getLayoutRoots().get(0);
    }

    private boolean isComponentResizable(LayoutComponent comp, int dimension) {
        boolean[] res = comp.getResizability();
        if (res == null) {
            res = this.visualMapper.getComponentResizability(comp.getId(), new boolean[2]);
            comp.setResizability(res);
        }
        return res[dimension];
    }

    public void adjustComponentAlignment(LayoutComponent comp, int dimension, int alignment) {
        LayoutInterval parent;
        if (this.logTestCode()) {
            this.testCode.add("// > ADJUST COMPONENT ALIGNMENT");
            this.testCode.add("{");
            this.testCode.add("LayoutComponent comp = lm.getLayoutComponent(\"" + comp.getId() + "\");");
            this.testCode.add("int dimension = " + dimension + ";");
            this.testCode.add("int alignment = " + alignment + ";");
            this.testCode.add("ld.adjustComponentAlignment(comp, dimension, alignment);");
            this.testCode.add("}");
        }
        LayoutInterval interval = comp.getLayoutInterval(dimension);
        for (parent = interval.getParent(); parent != null; parent = parent.getParent()) {
            if (LayoutInterval.canResize(parent)) continue;
            interval = parent;
        }
        assert (!LayoutInterval.wantResize(interval));
        boolean changed = false;
        for (parent = interval.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.isParallel()) {
                if (LayoutInterval.wantResize(parent) && !LayoutInterval.wantResize(interval)) {
                    int alg = interval.getAlignment();
                    if (alg != alignment) {
                        int size = LayoutInterval.getCurrentSize(parent, dimension) - LayoutInterval.getCurrentSize(interval, dimension);
                        if (size > 0) {
                            if (!interval.isSequential()) {
                                LayoutInterval seq = new LayoutInterval(102);
                                this.layoutModel.setIntervalAlignment(interval, -1);
                                int i = this.layoutModel.removeInterval(interval);
                                this.layoutModel.addInterval(interval, seq, -1);
                                this.layoutModel.addInterval(seq, parent, i);
                                interval = seq;
                            }
                            int index = alg == 0 ? -1 : 0;
                            LayoutInterval gap = new LayoutInterval(101);
                            gap.setSize(size);
                            this.layoutModel.addInterval(gap, interval, index);
                        }
                        this.layoutModel.setIntervalAlignment(interval, alignment);
                    }
                    changed = true;
                }
            } else {
                boolean before = true;
                boolean seqChanged = false;
                for (int i = 0; i < parent.getSubIntervalCount(); ++i) {
                    LayoutInterval li = parent.getSubInterval(i);
                    if (li == interval) {
                        before = false;
                        continue;
                    }
                    if (!LayoutInterval.wantResize(li) || (!before || alignment != 0) && (before || alignment != 1)) continue;
                    assert (li.isEmptySpace());
                    int expCurrentSize = -1;
                    if (li.getDiffToDefaultSize() != 0 && li.getPreferredSize() <= 0) {
                        expCurrentSize = LayoutInterval.getCurrentSize(li, dimension);
                    }
                    this.operations.setIntervalResizing(li, false);
                    if (expCurrentSize > 0) {
                        this.operations.resizeInterval(li, expCurrentSize);
                    } else if (this.operations.eliminateUnwantedZeroGap(li)) {
                        --i;
                    }
                    seqChanged = true;
                }
                if (!changed && seqChanged) {
                    boolean insertGap = false;
                    int index = parent.indexOf(interval);
                    if (alignment == 0) {
                        LayoutInterval candidate;
                        if (parent.getSubIntervalCount() <= index + 1) {
                            insertGap = true;
                            index = -1;
                        } else if ((candidate = parent.getSubInterval(++index)).isEmptySpace()) {
                            this.operations.setIntervalResizing(candidate, true);
                        } else {
                            insertGap = true;
                        }
                    } else {
                        assert (alignment == 1);
                        if (index == 0) {
                            insertGap = true;
                        } else {
                            LayoutInterval candidate = parent.getSubInterval(index - 1);
                            if (candidate.isEmptySpace()) {
                                this.operations.setIntervalResizing(candidate, true);
                            } else {
                                insertGap = true;
                            }
                        }
                    }
                    if (insertGap) {
                        LayoutInterval gap = new LayoutInterval(101);
                        this.operations.setIntervalResizing(gap, true);
                        this.layoutModel.setIntervalSize(gap, 0, 0, gap.getMaximumSize());
                        this.layoutModel.addInterval(gap, parent, index);
                        if (parent.getAlignment() != alignment) {
                            this.layoutModel.setIntervalAlignment(parent, alignment);
                        }
                        this.operations.optimizeGaps2(parent.getParent(), dimension);
                        parent = interval.getParent();
                    }
                    changed = true;
                }
            }
            interval = parent;
        }
        this.visualStateUpToDate = false;
        this.updateDataAfterBuild = true;
        if (this.logTestCode()) {
            this.testCode.add("// < ADJUST COMPONENT ALIGNMENT");
        }
    }

    public int[] getAdjustableComponentAlignment(LayoutComponent comp, int dimension) {
        if (comp == null) {
            return new int[]{-1, 0};
        }
        LayoutInterval interval = comp.getLayoutInterval(dimension);
        boolean leadingFixed = true;
        boolean trailingFixed = true;
        boolean leadingAdjustable = true;
        boolean trailingAdjustable = true;
        if (LayoutInterval.wantResize(interval)) {
            trailingAdjustable = false;
            leadingAdjustable = false;
            trailingFixed = false;
            leadingFixed = false;
        }
        for (LayoutInterval parent = interval.getParent(); parent != null; parent = parent.getParent()) {
            block10: {
                block11: {
                    int alignment;
                    block12: {
                        block9: {
                            if (LayoutInterval.canResize(parent)) break block9;
                            trailingAdjustable = true;
                            leadingAdjustable = true;
                            trailingFixed = true;
                            leadingFixed = true;
                            break block10;
                        }
                        if (!parent.isParallel()) break block11;
                        if (!LayoutInterval.wantResize(parent) || LayoutInterval.wantResize(interval)) break block10;
                        alignment = interval.getAlignment();
                        if (alignment != 0) break block12;
                        trailingFixed = false;
                        break block10;
                    }
                    if (alignment != 1) break block10;
                    leadingFixed = false;
                    break block10;
                }
                boolean before = true;
                Iterator<LayoutInterval> iter = parent.getSubIntervals();
                while (iter.hasNext()) {
                    LayoutInterval li = iter.next();
                    if (li == interval) {
                        before = false;
                        continue;
                    }
                    if (!LayoutInterval.wantResize(li)) continue;
                    boolean space = li.isEmptySpace();
                    if (before) {
                        leadingFixed = false;
                        if (space) continue;
                        leadingAdjustable = false;
                        continue;
                    }
                    trailingFixed = false;
                    if (space) continue;
                    trailingAdjustable = false;
                }
            }
            interval = parent;
        }
        int adjustable = (leadingAdjustable ? 1 : 0) + (trailingAdjustable ? 2 : 0);
        if (leadingFixed && trailingFixed) {
            if (0 == interval.getGroupAlignment()) {
                trailingFixed = false;
            } else {
                leadingFixed = false;
            }
        }
        int alignment = leadingFixed ? 0 : (trailingFixed ? 1 : -1);
        return new int[]{alignment, adjustable};
    }

    public boolean isComponentResizing(LayoutComponent comp, int dimension) {
        return LayoutInterval.wantResizeInLayout(comp.getLayoutInterval(dimension));
    }

    private int prefSizeOfInterval(LayoutInterval interval) {
        int prefSize;
        block11: {
            int dimension = -1;
            if (interval.isComponent()) {
                LayoutComponent comp = interval.getComponent();
                int n = dimension = interval == comp.getLayoutInterval(0) ? 0 : 1;
                if (comp.isLinkSized(dimension)) {
                    Collection linked = this.layoutModel.getLinkSizeGroups(dimension).get(new Integer(comp.getLinkSizeId(dimension)));
                    Iterator iter = linked.iterator();
                    int prefSize2 = 0;
                    while (iter.hasNext()) {
                        String compId = (String)iter.next();
                        LayoutComponent component = this.layoutModel.getLayoutComponent(compId);
                        LayoutInterval intr = component.getLayoutInterval(dimension);
                        int pref = intr.getPreferredSize();
                        if (pref == -1) {
                            Dimension prefDim = this.visualMapper.getComponentPreferredSize(compId);
                            pref = dimension == 0 ? prefDim.width : prefDim.height;
                        }
                        prefSize2 = Math.max(pref, prefSize2);
                    }
                    return prefSize2;
                }
            }
            if ((prefSize = interval.getPreferredSize()) != -1) break block11;
            if (interval.isComponent()) {
                LayoutComponent comp = interval.getComponent();
                Dimension pref = this.visualMapper.getComponentPreferredSize(comp.getId());
                return dimension == 0 ? pref.width : pref.height;
            }
            if (interval.isEmptySpace()) {
                return LayoutUtils.getSizeOfDefaultGap(interval, this.visualMapper);
            }
            assert (interval.isGroup());
            prefSize = 0;
            Iterator<LayoutInterval> iter = interval.getSubIntervals();
            if (interval.isSequential()) {
                while (iter.hasNext()) {
                    LayoutInterval subInterval = iter.next();
                    prefSize += this.prefSizeOfInterval(subInterval);
                }
            } else {
                while (iter.hasNext()) {
                    LayoutInterval subInterval = iter.next();
                    prefSize = Math.max(prefSize, this.prefSizeOfInterval(subInterval));
                }
            }
        }
        return prefSize;
    }

    public void setComponentResizing(LayoutComponent comp, int dimension, boolean resizing) {
        int prefSize;
        int currSize;
        if (this.logTestCode()) {
            this.testCode.add("// > SET COMPONENT RESIZING");
            this.testCode.add("{");
            this.testCode.add("LayoutComponent comp = lm.getLayoutComponent(\"" + comp.getId() + "\");");
            this.testCode.add("int dimension = " + dimension + ";");
            this.testCode.add("boolean resizing = " + resizing + ";");
            this.testCode.add("ld.setComponentResizing(comp, dimension, resizing);");
            this.testCode.add("}");
        }
        LayoutInterval interval = comp.getLayoutInterval(dimension);
        if (resizing && comp.isLinkSized(dimension)) {
            List<String> linked = this.layoutModel.getLinkSizeGroups(dimension).get(new Integer(comp.getLinkSizeId(dimension)));
            List<String> toChange = linked.size() == 2 ? linked : Collections.singletonList(comp.getId());
            for (String compId : toChange) {
                LayoutComponent component = this.layoutModel.getLayoutComponent(compId);
                LayoutInterval intr = component.getLayoutInterval(dimension);
                Dimension prefDim = this.visualMapper.getComponentPreferredSize(compId);
                int prefSize2 = dimension == 0 ? prefDim.width : prefDim.height;
                int currSize2 = intr.getCurrentSpace().size(dimension);
                if (currSize2 == prefSize2) {
                    currSize2 = -1;
                }
                this.layoutModel.setIntervalSize(intr, intr.getMinimumSize(), currSize2, intr.getMaximumSize());
            }
        }
        LayoutInterval parent = interval.getParent();
        this.operations.setIntervalResizing(interval, resizing);
        int delta = 0;
        if (!resizing && (delta = (currSize = LayoutInterval.getCurrentSize(interval, dimension)) - (prefSize = this.prefSizeOfInterval(interval))) != 0) {
            this.layoutModel.setIntervalSize(interval, interval.getMinimumSize(), currSize, interval.getMaximumSize());
        }
        LayoutInterval intr = interval;
        for (LayoutInterval par = parent; par != null; par = par.getParent()) {
            if (par.isParallel() && resizing) {
                int currSize3;
                int groupCurrSize = LayoutInterval.getCurrentSize(par, dimension);
                if (groupCurrSize != (currSize3 = LayoutInterval.getCurrentSize(intr, dimension))) {
                    int index;
                    LayoutInterval seqGroup = intr;
                    LayoutInterval space = new LayoutInterval(101);
                    space.setSize(groupCurrSize - currSize3);
                    int alignment = intr.getAlignment();
                    int n = index = alignment == 0 ? -1 : 0;
                    if (intr.isSequential()) {
                        int spaceIndex = alignment == 0 ? intr.getSubIntervalCount() - 1 : 0;
                        LayoutInterval adjacentSpace = intr.getSubInterval(spaceIndex);
                        if (adjacentSpace.isEmptySpace()) {
                            int spaceSize = LayoutInterval.getCurrentSize(adjacentSpace, dimension);
                            this.layoutModel.removeInterval(adjacentSpace);
                            space.setSize(groupCurrSize - currSize3 + spaceSize);
                        }
                    } else {
                        seqGroup = new LayoutInterval(102);
                        this.layoutModel.setIntervalAlignment(intr, -1);
                        seqGroup.setAlignment(alignment);
                        int i = this.layoutModel.removeInterval(intr);
                        this.layoutModel.addInterval(intr, seqGroup, -1);
                        this.layoutModel.addInterval(seqGroup, par, i);
                    }
                    this.layoutModel.addInterval(space, seqGroup, index);
                    seqGroup.getCurrentSpace().set(dimension, par.getCurrentSpace());
                }
            } else if (par.isSequential()) {
                int currSize4;
                LayoutInterval candidate;
                boolean parentSeq = parent == par;
                LinkedList<LayoutInterval> resizableList = new LinkedList<LayoutInterval>();
                int alignment = parentSeq ? LayoutInterval.getEffectiveAlignment(interval) : 0;
                LayoutInterval leadingGap = null;
                LayoutInterval trailingGap = null;
                boolean afterDefining = false;
                for (int i = 0; i < par.getSubIntervalCount(); ++i) {
                    candidate = par.getSubInterval(i);
                    if (candidate == interval) {
                        afterDefining = true;
                    }
                    if (candidate.isEmptySpace()) {
                        boolean glue;
                        if (resizing) {
                            currSize4 = LayoutInterval.getCurrentSize(candidate, dimension);
                            this.operations.setIntervalResizing(candidate, false);
                            int prefSize3 = this.prefSizeOfInterval(candidate);
                            if (currSize4 != prefSize3) {
                                this.layoutModel.setIntervalSize(candidate, candidate.getMinimumSize(), currSize4, candidate.getMaximumSize());
                                delta += currSize4 - prefSize3;
                            }
                            if (!this.operations.eliminateUnwantedZeroGap(candidate)) continue;
                            --i;
                            continue;
                        }
                        if (!parentSeq) continue;
                        boolean bl = glue = candidate.getPreferredSize() != -1;
                        if (glue) {
                            trailingGap = candidate;
                        } else if (afterDefining && (trailingGap == null || trailingGap.getPreferredSize() == -1)) {
                            trailingGap = candidate;
                        }
                        if (leadingGap == null && !afterDefining) {
                            leadingGap = candidate;
                            continue;
                        }
                        if (!glue || leadingGap != null && leadingGap.getPreferredSize() != -1) continue;
                        leadingGap = candidate;
                        continue;
                    }
                    if (candidate.getMaximumSize() != Short.MAX_VALUE) continue;
                    resizableList.add(candidate);
                }
                if (resizableList.size() > 0) {
                    Iterator iter = resizableList.iterator();
                    delta = (LayoutInterval.getCurrentSize(par, dimension) - this.prefSizeOfInterval(par) + delta) / resizableList.size();
                    while (iter.hasNext()) {
                        candidate = (LayoutInterval)iter.next();
                        if (candidate.isGroup()) continue;
                        if (candidate == interval) {
                            if (delta == 0) continue;
                            int prefSize4 = this.prefSizeOfInterval(candidate);
                            this.layoutModel.setIntervalSize(candidate, candidate.getMinimumSize(), Math.max(0, prefSize4 - delta), candidate.getMaximumSize());
                            continue;
                        }
                        currSize4 = LayoutInterval.getCurrentSize(candidate, dimension);
                        this.layoutModel.setIntervalSize(candidate, candidate.getMinimumSize(), Math.max(0, currSize4 - delta), candidate.getMaximumSize());
                    }
                }
                if (parentSeq) {
                    if (!LayoutInterval.wantResize(par)) {
                        LayoutInterval gap = null;
                        if (alignment == 1 && leadingGap != null) {
                            gap = leadingGap;
                            this.operations.setIntervalResizing(leadingGap, !resizing);
                        }
                        if (alignment == 0 && trailingGap != null) {
                            gap = trailingGap;
                            this.operations.setIntervalResizing(trailingGap, !resizing);
                        }
                        if (gap != null && delta != 0 && gap.getPreferredSize() != -1) {
                            this.layoutModel.setIntervalSize(gap, gap.getMinimumSize(), Math.max(0, gap.getPreferredSize() - delta), gap.getMaximumSize());
                        }
                        this.operations.eliminateUnwantedZeroGap(gap);
                    }
                    parent = par.getParent();
                }
            }
            intr = par;
        }
        if (resizing) {
            this.layoutModel.unsetSameSize(Collections.singletonList(comp.getId()), dimension);
        }
        if (resizing) {
            while (parent != null) {
                if (!LayoutInterval.canResize(parent)) {
                    this.operations.enableGroupResizing(parent);
                }
                parent = parent.getParent();
            }
        }
        this.requireStructureOptimization(comp.getParent());
        this.visualStateUpToDate = false;
        this.updateDataAfterBuild = true;
        if (this.logTestCode()) {
            this.testCode.add("// < SET COMPONENT RESIZING");
        }
    }

    public boolean canAlign(Collection<String> componentIds) {
        if (componentIds != null && componentIds.size() > 1) {
            LayoutInterval commonRoot = null;
            for (String id : componentIds) {
                LayoutComponent component = this.layoutModel.getLayoutComponent(id);
                if (component == null || component.getParent() == null) {
                    return false;
                }
                LayoutInterval root = LayoutInterval.getRoot(component.getLayoutInterval(0));
                if (commonRoot == null) {
                    commonRoot = root;
                    continue;
                }
                if (root == commonRoot) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void align(Collection componentIds, boolean closed, int dimension, int alignment) {
        if (this.logTestCode()) {
            this.testCode.add("// > ALIGN");
            this.testCode.add("{");
            LayoutTestUtils.writeCollection(this.testCode, "componentIds", componentIds);
            this.testCode.add("boolean closed = " + closed + ";");
            this.testCode.add("int dimension = " + dimension + ";");
            this.testCode.add("int alignment = " + alignment + ";");
            this.testCode.add("ld.align(componentIds, closed, dimension, alignment);");
            this.testCode.add("}");
        }
        LayoutComponent container = null;
        LayoutInterval[] intervals = new LayoutInterval[componentIds.size()];
        int counter = 0;
        for (String id : componentIds) {
            LayoutComponent component = this.layoutModel.getLayoutComponent(id);
            if (container == null) {
                container = component.getParent();
            }
            intervals[counter++] = component.getLayoutInterval(dimension);
        }
        new LayoutAligner(this, this.layoutModel, this.operations).alignIntervals(intervals, closed, dimension, alignment);
        this.requireStructureOptimization(container);
        this.visualStateUpToDate = false;
        this.updateDataAfterBuild = true;
        if (this.logTestCode()) {
            this.testCode.add("// < ALIGN");
        }
    }

    private boolean destroyRedundantGroups(LayoutInterval interval) {
        boolean updated = false;
        for (int i = interval.getSubIntervalCount() - 1; i >= 0; --i) {
            LayoutInterval subInterval;
            if (i >= interval.getSubIntervalCount() || !(subInterval = interval.getSubInterval(i)).isGroup()) continue;
            this.destroyRedundantGroups(subInterval);
            this.destroyGroupIfRedundant(subInterval, interval);
            updated |= subInterval.getParent() == null;
        }
        return updated;
    }

    void destroyGroupIfRedundant(LayoutInterval group, LayoutInterval boundary) {
        if (group == null || !group.isGroup() || group == boundary) {
            return;
        }
        LayoutInterval parent = group.getParent();
        if (parent == null) {
            return;
        }
        if (LayoutInterval.getCount(group, Integer.MAX_VALUE, true) == 0) {
            this.takeOutInterval(group, boundary);
            return;
        }
        if (this.operations.dissolveRedundantGroup(group)) {
            this.destroyGroupIfRedundant(parent, boundary);
        }
    }

    void takeOutInterval(LayoutInterval interval, LayoutInterval boundary) {
        LayoutInterval parent = interval.getParent();
        int index = parent.indexOf(interval);
        LinkedList<LayoutInterval> toRemove = new LinkedList<LayoutInterval>();
        toRemove.add(interval);
        if (parent.isSequential()) {
            LayoutInterval li;
            if (index > 0 && (li = parent.getSubInterval(index - 1)).isEmptySpace()) {
                toRemove.add(li);
            }
            if (index + 1 < parent.getSubIntervalCount() && (li = parent.getSubInterval(index + 1)).isEmptySpace()) {
                toRemove.add(li);
            }
            if (toRemove.size() == 3 && parent.getSubIntervalCount() > 3) {
                LayoutInterval gap = new LayoutInterval(101);
                if (interval.isComponent() && interval.getComponent().getLayoutInterval(1) == interval) {
                    int alignment = LayoutInterval.getEffectiveAlignment(interval);
                    int size = 0;
                    for (int i = 0; i < 3; ++i) {
                        size += LayoutInterval.getCurrentSize((LayoutInterval)toRemove.get(i), 1);
                    }
                    gap.setSizes(-1, size, alignment == 1 ? Short.MAX_VALUE : -2);
                }
                this.layoutModel.addInterval(gap, parent, index);
            }
        }
        for (LayoutInterval remove : toRemove) {
            this.layoutModel.removeInterval(remove);
        }
        this.destroyGroupIfRedundant(parent, boundary);
    }

    void createRemainderGroup(List list, LayoutInterval seq, int index, int position, int mainAlignment, int dimension) {
        assert (seq.isSequential() && (position == 0 || position == 1));
        if (position == 1) {
            ++index;
        }
        LayoutInterval gap = null;
        LayoutInterval leadingGap = null;
        LayoutInterval trailingGap = null;
        boolean onlyGaps = true;
        boolean gapLeads = true;
        boolean gapTrails = true;
        for (int i = list.size() - 1; i >= 0; --i) {
            List subList = (List)list.get(i);
            if (subList.size() != 2) continue;
            int alignment = (Integer)subList.get(0);
            LayoutInterval li = (LayoutInterval)subList.get(1);
            if (li.isEmptySpace()) {
                if (gap == null || li.getMaximumSize() > gap.getMaximumSize()) {
                    gap = li;
                }
                if (LayoutDesigner.isFixedPadding(li)) {
                    if (alignment == 0) {
                        leadingGap = li;
                        gapTrails = false;
                    } else if (alignment == 1) {
                        trailingGap = li;
                        gapLeads = false;
                    }
                } else {
                    gapLeads = false;
                    gapTrails = false;
                }
                list.remove(i);
                continue;
            }
            onlyGaps = false;
        }
        if (list.size() == 1) {
            List subList = (List)list.get(0);
            Iterator itr = subList.iterator();
            itr.next();
            do {
                LayoutInterval li = (LayoutInterval)itr.next();
                this.layoutModel.addInterval(li, seq, index++);
            } while (itr.hasNext());
            return;
        }
        for (List subList : list) {
            if (subList.size() == 2) continue;
            onlyGaps = false;
            boolean first = true;
            Iterator itr = subList.iterator();
            itr.next();
            do {
                LayoutInterval li = (LayoutInterval)itr.next();
                if (first) {
                    first = false;
                    if (LayoutDesigner.isFixedPadding(li)) {
                        leadingGap = li;
                        continue;
                    }
                    gapLeads = false;
                    continue;
                }
                if (itr.hasNext()) continue;
                if (LayoutDesigner.isFixedPadding(li)) {
                    trailingGap = li;
                    continue;
                }
                gapTrails = false;
            } while (itr.hasNext());
        }
        if (onlyGaps) {
            this.operations.insertGapIntoSequence(gap, seq, index, dimension);
            return;
        }
        LayoutInterval group = new LayoutInterval(103);
        if (position == mainAlignment) {
            group.setMinimumSize(-2);
            group.setMaximumSize(-2);
        }
        for (List subList : list) {
            LayoutInterval interval;
            if (gapLeads) {
                subList.remove(1);
            }
            if (gapTrails) {
                subList.remove(subList.size() - 1);
            }
            if (subList.size() == 2) {
                int alignment = (Integer)subList.get(0);
                interval = (LayoutInterval)subList.get(1);
                if (alignment == 0 || alignment == 1) {
                    this.layoutModel.setIntervalAlignment(interval, alignment);
                }
            } else {
                interval = new LayoutInterval(102);
                Iterator itr = subList.iterator();
                int alignment = (Integer)itr.next();
                if (alignment == 0 || alignment == 1) {
                    interval.setAlignment(alignment);
                }
                do {
                    LayoutInterval li = (LayoutInterval)itr.next();
                    this.layoutModel.addInterval(li, interval, -1);
                } while (itr.hasNext());
            }
            this.layoutModel.addInterval(interval, group, -1);
        }
        if (gapLeads) {
            this.layoutModel.addInterval(leadingGap, seq, index++);
        }
        this.layoutModel.addInterval(group, seq, index++);
        if (gapTrails) {
            this.layoutModel.addInterval(trailingGap, seq, index);
        }
    }

    static boolean isFixedPadding(LayoutInterval interval) {
        return !(!interval.isEmptySpace() || interval.getMinimumSize() != -1 && interval.getMinimumSize() != -2 || interval.getPreferredSize() != -1 || interval.getMaximumSize() != -1 && interval.getMaximumSize() != -2);
    }

    private int optimizeGaps(LayoutInterval group, int dimension, boolean recursive) {
        assert (group.isParallel());
        if (recursive) {
            for (int i = 0; i < group.getSubIntervalCount(); ++i) {
                LayoutInterval li = group.getSubInterval(i);
                if (li.isParallel()) {
                    this.optimizeGaps(li, dimension, recursive);
                    continue;
                }
                if (!li.isSequential()) continue;
                for (int ii = 0; ii < li.getSubIntervalCount(); ++ii) {
                    int idx;
                    LayoutInterval llii = li.getSubInterval(ii);
                    if (!llii.isParallel() || (idx = this.optimizeGaps(llii, dimension, recursive)) < 0) continue;
                    ii = idx;
                }
            }
        }
        if (group.getGroupAlignment() == 3) {
            return -1;
        }
        int nonEmptyCount = LayoutInterval.getCount(group, Integer.MAX_VALUE, true);
        if (nonEmptyCount <= 1) {
            if (group.getParent() == null) {
                if (group.getSubIntervalCount() > 1) {
                    for (int i = group.getSubIntervalCount() - 1; i >= 0; --i) {
                        if (!group.getSubInterval(i).isEmptySpace()) continue;
                        this.layoutModel.removeInterval(group, i);
                        break;
                    }
                } else if (group.getSubIntervalCount() == 0) {
                    this.propEmptyContainer(group, dimension);
                }
            } else {
                assert (nonEmptyCount == 1);
                assert (group.getSubIntervalCount() == 1);
                LayoutInterval interval = group.getSubInterval(0);
                this.layoutModel.removeInterval(interval);
                this.layoutModel.setIntervalAlignment(interval, group.getAlignment());
                LayoutInterval parent = group.getParent();
                int index = this.layoutModel.removeInterval(group);
                if (parent.isSequential() && interval.isSequential()) {
                    for (int i = interval.getSubIntervalCount() - 1; i >= 0; --i) {
                        LayoutInterval subInterval = interval.getSubInterval(i);
                        this.layoutModel.removeInterval(subInterval);
                        this.layoutModel.addInterval(subInterval, parent, index);
                    }
                    this.eliminateConsecutiveGaps(parent, dimension);
                } else {
                    this.layoutModel.addInterval(interval, parent, index);
                }
            }
            return -1;
        }
        return this.operations.optimizeGaps(group, dimension);
    }

    public void setDefaultSize(String compId) {
        LayoutComponent component;
        if (this.logTestCode()) {
            this.testCode.add("// > SET DEFAULT SIZE");
            this.testCode.add("ld.setDefaultSize(\"" + compId + "\");");
        }
        if ((component = this.layoutModel.getLayoutComponent(compId)) != null) {
            this.setDefaultSize(component);
        }
        if (this.logTestCode()) {
            this.testCode.add("// < SET DEFAULT SIZE");
        }
    }

    private void setDefaultSize(LayoutComponent component) {
        if (component.isLayoutContainer()) {
            for (LayoutComponent comp : component.getSubcomponents()) {
                if (!comp.isLayoutContainer()) continue;
                this.setDefaultSize(comp);
            }
            for (LayoutInterval[] roots : component.getLayoutRoots()) {
                for (int dim = 0; dim < 2; ++dim) {
                    this.setDefaultSizeInContainer(roots[dim], true);
                }
            }
        }
        if (component.getParent() != null) {
            Dimension prefSize = null;
            for (int dim = 0; dim < 2; ++dim) {
                LayoutInterval li = component.getLayoutInterval(dim);
                int currSize = LayoutInterval.getCurrentSize(li, dim);
                if (currSize != Integer.MIN_VALUE) {
                    if (prefSize == null) {
                        prefSize = this.visualMapper.getComponentPreferredSize(component.getId());
                    }
                    if (prefSize != null && (dim == 0 ? prefSize.width : prefSize.height) < currSize && LayoutInterval.canResize(li)) {
                        this.enableShrinking(li);
                        this.preferredSizeChanged = true;
                    }
                }
                this.operations.resizeInterval(li, -1);
            }
        }
        this.updateDataAfterBuild = true;
    }

    private void setDefaultSizeInContainer(LayoutInterval interval, boolean complete) {
        block3: {
            block2: {
                if (interval.isGroup()) break block2;
                if (!LayoutInterval.canResize(interval)) break block3;
                this.operations.resizeInterval(interval, interval.getMinimumSize() != -2 ? interval.getMinimumSize() : -1);
                if (!complete) break block3;
                this.layoutModel.changeIntervalAttribute(interval, 1024, true);
                break block3;
            }
            if (complete || LayoutInterval.canResize(interval)) {
                Iterator<LayoutInterval> it = interval.getSubIntervals();
                while (it.hasNext()) {
                    this.setDefaultSizeInContainer(it.next(), complete);
                }
            }
        }
    }

    private static void cleanRefreshAttrs(LayoutInterval group) {
        group.unsetAttribute(708);
        int n = group.getSubIntervalCount();
        for (int i = 0; i < n; ++i) {
            LayoutInterval li = group.getSubInterval(i);
            if (li.isGroup()) {
                LayoutDesigner.cleanRefreshAttrs(li);
                continue;
            }
            li.unsetAttribute(708);
        }
    }

    private void findContainerResizingGap(LayoutInterval rootInterval, int dimension) {
        if (!LayoutInterval.wantResize(rootInterval) && LayoutInterval.getCurrentSize(rootInterval, dimension) != this.prefSizeOfInterval(rootInterval)) {
            return;
        }
        int gapPosition = 1;
        LayoutInterval resGap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, gapPosition);
        if (resGap == null) {
            gapPosition = 0;
            resGap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, gapPosition);
            if (resGap == null && (resGap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, gapPosition = -1)) == null) {
                return;
            }
        } else if (!LayoutInterval.canResize(resGap)) {
            LayoutInterval gap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, 0);
            if (gap != null && LayoutInterval.canResize(gap)) {
                resGap = gap;
                gapPosition = 0;
            } else {
                gap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, -1);
                if (gap != null && LayoutInterval.canResize(gap)) {
                    resGap = gap;
                    gapPosition = -1;
                }
            }
        }
        resGap.setAttribute(4);
    }

    private static LayoutInterval findContainerResizingGap(LayoutInterval group, int dimension, int alignment) {
        assert (group.isParallel());
        LayoutInterval theGap = null;
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval sub = it.next();
            LayoutInterval gap = null;
            if (sub.isSequential()) {
                int n = sub.getSubIntervalCount();
                if (alignment == 0 || alignment == 1) {
                    LayoutInterval li = sub.getSubInterval(alignment == 0 ? 0 : n - 1);
                    if (li.isEmptySpace()) {
                        if (LayoutInterval.canResize(li) || alignment == 1 && (li.getPreferredSize() != -1 || LayoutInterval.wantResize(sub))) {
                            gap = li;
                        }
                    } else if (li.isParallel()) {
                        gap = LayoutDesigner.findContainerResizingGap(li, dimension, alignment);
                    }
                } else {
                    for (int i = n - 2; i > 0; --i) {
                        LayoutInterval li = sub.getSubInterval(i);
                        if (!li.isEmptySpace() || !LayoutInterval.canResize(li)) continue;
                        gap = li;
                        break;
                    }
                }
            } else if (sub.isParallel()) {
                gap = LayoutDesigner.findContainerResizingGap(sub, dimension, alignment);
            }
            if (gap == null) continue;
            if (theGap == null) {
                theGap = gap;
                continue;
            }
            return null;
        }
        return theGap;
    }

    private void updateContainerAfterBuild(LayoutComponent container, boolean top) {
        container.setCurrentInterior(this.visualMapper.getContainerInterior(container.getId()));
        for (LayoutComponent subComp : container.getSubcomponents()) {
            Rectangle bounds = this.visualMapper.getComponentBounds(subComp.getId());
            int baseline = this.visualMapper.getBaselinePosition(subComp.getId(), bounds.width, bounds.height);
            subComp.setCurrentBounds(bounds, baseline);
            if (!subComp.isLayoutContainer()) continue;
            this.updateContainerAfterBuild(subComp, false);
        }
        Dimension minimum = this.visualMapper.getComponentMinimumSize(container.getId());
        Rectangle bounds = this.visualMapper.getComponentBounds(container.getId());
        container.setDiffToMinimumSize(0, bounds.width - minimum.width);
        container.setDiffToMinimumSize(1, bounds.height - minimum.height);
        boolean updateContSize = !top && this.updateDataAfterBuild && container.getParent() != null;
        Dimension preferred = updateContSize ? this.visualMapper.getComponentPreferredSize(container.getId()) : null;
        for (int i = 0; i < 2; ++i) {
            LayoutInterval defaultRoot = this.getActiveLayoutRoots(container)[i];
            for (LayoutInterval[] roots : container.getLayoutRoots()) {
                LayoutInterval root = roots[i];
                if (this.updateDataAfterBuild) {
                    this.optimizeStructure1(root, root == defaultRoot, i);
                    this.updateCurrentSpaceOfGroups(root, i, null);
                    this.optimizeStructure2(root, i);
                    LayoutDesigner.cleanRefreshAttrs(root);
                    this.findContainerResizingGap(root, i);
                    int diffFromDefault = this.collectResizingDiffs(root, i);
                    if (!top) continue;
                    this.updateToActualSize(root, i, diffFromDefault != 0 ? 2 : 0);
                    continue;
                }
                this.updateCurrentSpaceOfGroups(root, i, null);
                this.collectResizingDiffs(root, i);
            }
            if (!updateContSize) continue;
            LayoutInterval outer = container.getLayoutInterval(i);
            int currentSize = outer.getCurrentSpace().size(i);
            int pref = i == 0 ? preferred.width : preferred.height;
            boolean externalSize = this.visualMapper.hasExplicitPreferredSize(container.getId()) && currentSize != pref || container.getDiffToMinimumSize(i) < 0 && currentSize != pref;
            this.operations.resizeInterval(outer, externalSize ? currentSize : -1);
        }
    }

    private void updateContainerAfterChange(LayoutComponent container, LayoutDragger.SizeDef[] resizingDef) {
        container.setCurrentInterior(this.visualMapper.getContainerInterior(container.getId()));
        for (LayoutComponent subComp : container.getSubcomponents()) {
            Rectangle bounds = this.visualMapper.getComponentBounds(subComp.getId());
            int baseline = this.visualMapper.getBaselinePosition(subComp.getId(), bounds.width, bounds.height);
            subComp.setCurrentBounds(bounds, baseline);
        }
        for (int i = 0; i < 2; ++i) {
            LayoutInterval outer = container.getLayoutInterval(i);
            int currentSize = outer.getCurrentSpace().size(i);
            for (LayoutInterval[] roots : container.getLayoutRoots()) {
                LayoutInterval root = roots[i];
                if (root.getSubIntervalCount() <= 0 || resizingDef == null || resizingDef[i] == null) continue;
                this.updateContainerGapResizing(root, resizingDef[i], currentSize, i);
            }
        }
    }

    private void updateContainerGapResizing(LayoutInterval root, LayoutDragger.SizeDef resizingDef, int currentSize, int dim) {
        LayoutInterval resGap = resizingDef.getResizingGap();
        if (resGap != null) {
            assert (resGap.getParent().isSequential());
            LayoutInterval seqRoot = LayoutInterval.getRoot(resGap, 102);
            int size = resizingDef.getResizingGapSize(currentSize);
            LayoutInterval gapParent = resGap.getParent();
            int index = gapParent.indexOf(resGap);
            if (size == 0 && (index == 0 || index == gapParent.getSubIntervalCount() - 1)) {
                LayoutInterval otherGap;
                this.layoutModel.removeInterval(resGap);
                if (gapParent.getSubIntervalCount() == 1) {
                    LayoutInterval last = this.layoutModel.removeInterval(gapParent, 0);
                    this.operations.addContent(last, gapParent.getParent(), this.layoutModel.removeInterval(gapParent));
                } else if (LayoutInterval.canResize(resGap) && !LayoutInterval.wantResize(seqRoot) && (otherGap = gapParent.getSubInterval(index = index == 0 ? gapParent.getSubIntervalCount() - 1 : 0)).isEmptySpace()) {
                    this.layoutModel.setIntervalSize(otherGap, -1, otherGap.getPreferredSize(), Short.MAX_VALUE);
                }
            } else if (size != Integer.MIN_VALUE) {
                if (!LayoutInterval.canResize(resGap) && !LayoutInterval.wantResize(seqRoot)) {
                    this.layoutModel.setIntervalSize(resGap, -1, size, Short.MAX_VALUE);
                } else {
                    this.operations.resizeInterval(resGap, size);
                    if (size == -1 && LayoutInterval.canResize(resGap)) {
                        resGap.setMaximumSize(-2);
                        boolean layoutResizing = LayoutInterval.wantResize(seqRoot);
                        resGap.setMaximumSize(Short.MAX_VALUE);
                        if (layoutResizing) {
                            this.layoutModel.setIntervalSize(resGap, -1, -1, -2);
                        }
                    }
                }
            }
        } else if (!LayoutInterval.wantResize(root)) {
            int minLayoutSize = this.computeMinimumDesignSize(root);
            int growth = root.getCurrentSpace().size(dim) - minLayoutSize;
            if (growth > 0) {
                LayoutInterval endGap = new LayoutInterval(101);
                endGap.setSizes(-1, growth, Short.MAX_VALUE);
                this.operations.insertGap(endGap, root, minLayoutSize, dim, 1);
            }
        }
    }

    private void optimizeStructure1(LayoutInterval root, boolean defaultRoot, int dimension) {
        if (!root.hasAttribute(2048)) {
            if (root.getSubIntervalCount() == 0) {
                if (defaultRoot) {
                    this.propEmptyContainer(root, dimension);
                }
            } else {
                this.fixGroupSizes(root);
                this.destroyRedundantGroups(root);
                this.operations.fixSurplusOrMissingGaps(root, dimension);
            }
        }
    }

    private void optimizeStructure2(LayoutInterval root, int dimension) {
        if (!root.hasAttribute(2048)) {
            Object mark = this.layoutModel.getChangeMark();
            this.optimizeGaps(root, dimension, true);
            this.destroyRedundantGroups(root);
            if (!this.layoutModel.getChangeMark().equals(mark)) {
                this.updateCurrentSpaceOfGroups(root, dimension, null);
            }
            root.setAttribute(2048);
        }
    }

    private void fixGroupSizes(LayoutInterval group) {
        int max;
        int pref;
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            LayoutInterval li = group.getSubInterval(i);
            if (!li.isGroup()) continue;
            this.fixGroupSizes(li);
        }
        int min = group.getMinimumSize();
        if (min != -1) {
            min = -1;
        }
        if ((pref = group.getPreferredSize()) != -1) {
            pref = -1;
        }
        if (!((max = group.getMaximumSize()) == -1 || group.isParallel() && group.getMaximumSize() == -2)) {
            max = -1;
        }
        if (min != group.getMinimumSize() || pref != group.getPreferredSize() || max != group.getMaximumSize()) {
            this.layoutModel.setIntervalSize(group, min, pref, max);
        }
    }

    private void propEmptyContainer(LayoutInterval root, int dimension) {
        assert (root.getParent() == null && root.getSubIntervalCount() == 0);
        LayoutInterval gap = new LayoutInterval(101);
        gap.setSizes(0, root.getCurrentSpace().size(dimension), Short.MAX_VALUE);
        this.layoutModel.addInterval(gap, root, 0);
    }

    private int computeMinimumDesignSize(LayoutInterval interval) {
        int size;
        block7: {
            block6: {
                size = 0;
                if (!interval.isSingle()) break block6;
                int min = interval.getMinimumSize();
                int n = size = min == -2 ? interval.getPreferredSize() : min;
                if (size != -1) break block7;
                if (interval.isComponent()) {
                    LayoutComponent comp = interval.getComponent();
                    Dimension dim = min == -2 ? this.visualMapper.getComponentPreferredSize(comp.getId()) : this.visualMapper.getComponentMinimumSize(comp.getId());
                    size = interval == comp.getLayoutInterval(0) ? dim.width : dim.height;
                } else {
                    size = LayoutUtils.getSizeOfDefaultGap(interval, this.visualMapper);
                }
                break block7;
            }
            if (interval.isSequential()) {
                int n = interval.getSubIntervalCount();
                for (int i = 0; i < n; ++i) {
                    size += this.computeMinimumDesignSize(interval.getSubInterval(i));
                }
            } else {
                int n = interval.getSubIntervalCount();
                for (int i = 0; i < n; ++i) {
                    size = Math.max(size, this.computeMinimumDesignSize(interval.getSubInterval(i)));
                }
            }
        }
        return size;
    }

    public void removeComponents(String ... compIds) {
        LayoutComponent[] components = new LayoutComponent[compIds.length];
        for (int i = 0; i < compIds.length; ++i) {
            components[i] = this.layoutModel.getLayoutComponent(compIds[i]);
        }
        this.removeComponents(components, true);
    }

    public void removeComponentsFromParent(String ... compIds) {
        LayoutComponent[] components = new LayoutComponent[compIds.length];
        for (int i = 0; i < compIds.length; ++i) {
            components[i] = this.layoutModel.getLayoutComponent(compIds[i]);
        }
        this.removeComponentsFromParent(components);
    }

    @Override
    public void removeComponents(LayoutComponent[] components, boolean fromModel) {
        HashSet<LayoutComponent> conts = new HashSet<LayoutComponent>();
        for (LayoutComponent comp : components) {
            if (comp == null) continue;
            if (this.logTestCode() && fromModel) {
                this.testCode.add("lm.removeComponent(\"" + comp.getId() + "\", true);");
            }
            if (comp.getParent() != null) {
                conts.add(comp.getParent());
            }
            this.removeComponentIntervals(comp);
            this.layoutModel.removeComponent(comp, fromModel);
        }
        for (LayoutComponent cont : conts) {
            for (int dim = 0; dim < 2; ++dim) {
                this.afterRemoveSpaceUpdate(cont.getDefaultLayoutRoot(dim), dim);
            }
        }
    }

    private void removeComponentsFromParent(LayoutComponent[] components) {
        for (LayoutComponent comp : components) {
            if (comp == null) continue;
            this.removeComponentIntervals(comp);
            this.layoutModel.removeComponent(comp, !comp.isLayoutContainer());
        }
    }

    private void removeComponentIntervals(LayoutComponent comp) {
        if (comp.getParent() != null) {
            for (int dim = 0; dim < 2; ++dim) {
                LayoutInterval interval = comp.getLayoutInterval(dim);
                if (interval.getParent() == null) continue;
                this.removeComponentInterval(interval, dim);
            }
        }
    }

    private void removeComponentInterval(LayoutInterval interval, int dimension) {
        LayoutComponent comp = interval.getComponent();
        assert (comp != null);
        LayoutInterval parent = interval.getParent();
        int index = this.layoutModel.removeInterval(interval);
        LayoutInterval root = LayoutInterval.getRoot(parent);
        this.intervalRemoved(parent, index, LayoutInterval.wantResize(interval), dimension);
        LayoutComponent container = comp.getParent();
        if (container != null && root.getSubIntervalCount() == 0) {
            if (root == this.getActiveLayoutRoots(container)[dimension]) {
                if (container.getLayoutRootCount() == 2 && (this.dragger == null || this.dragger.getTargetContainer() != container)) {
                    this.layoutModel.removeLayoutRoots(container, root);
                } else {
                    this.propEmptyContainer(root, dimension);
                }
            } else {
                boolean eliminate;
                if (this.dragger == null) {
                    eliminate = true;
                } else {
                    LayoutInterval[] targetRoots = this.dragger.getTargetRoots();
                    boolean bl = eliminate = targetRoots == null || root != targetRoots[0] && root != targetRoots[1];
                }
                if (eliminate) {
                    this.layoutModel.removeLayoutRoots(container, root);
                }
            }
        }
    }

    private void intervalRemoved(LayoutInterval parent, int index, boolean wasResizing, int dimension) {
        Collection<LayoutInterval> unresized = null;
        if (parent.isSequential()) {
            boolean losingResizing;
            LayoutInterval trailingNeighbor;
            LayoutInterval trailingGap;
            LayoutInterval leadingNeighbor;
            LayoutInterval leadingGap;
            if (index > 0) {
                LayoutInterval li = parent.getSubInterval(index - 1);
                if (li.isEmptySpace()) {
                    leadingGap = li;
                    this.layoutModel.removeInterval(li);
                    leadingNeighbor = --index > 0 ? parent.getSubInterval(index - 1) : null;
                } else {
                    leadingGap = null;
                    leadingNeighbor = li;
                }
            } else {
                leadingGap = null;
                leadingNeighbor = null;
            }
            if (index < parent.getSubIntervalCount()) {
                LayoutInterval li = parent.getSubInterval(index);
                if (li.isEmptySpace()) {
                    trailingGap = li;
                    this.layoutModel.removeInterval(li);
                    trailingNeighbor = index < parent.getSubIntervalCount() ? parent.getSubInterval(index) : null;
                } else {
                    trailingGap = null;
                    trailingNeighbor = li;
                }
            } else {
                trailingGap = null;
                trailingNeighbor = null;
            }
            if (!wasResizing && (leadingGap != null && LayoutInterval.canResize(leadingGap) || trailingGap != null && LayoutInterval.canResize(trailingGap))) {
                wasResizing = true;
            }
            LayoutInterval superParent = parent.getParent();
            if (parent.getSubIntervalCount() == 0) {
                int idx = this.layoutModel.removeInterval(parent);
                this.intervalRemoved(superParent, idx, wasResizing, dimension);
                return;
            }
            boolean bl = losingResizing = wasResizing && !LayoutInterval.contentWantResize(parent);
            if (leadingNeighbor != null && trailingNeighbor != null || leadingNeighbor != null && (trailingGap != null && LayoutInterval.canResize(trailingGap) || !losingResizing && LayoutInterval.getEffectiveAlignment(leadingNeighbor, 1, true) == 1) || trailingNeighbor != null && (leadingGap != null && LayoutInterval.canResize(leadingGap) || !losingResizing && LayoutInterval.getEffectiveAlignment(trailingNeighbor, 0, true) == 0)) {
                int min;
                int max;
                int pref = Integer.MIN_VALUE;
                if (!losingResizing) {
                    max = -2;
                    min = -2;
                } else {
                    min = leadingNeighbor == null && leadingGap != null && leadingGap.getMinimumSize() == 0 || trailingNeighbor == null && trailingGap != null && trailingGap.getMinimumSize() == 0 ? 0 : -1;
                    max = Short.MAX_VALUE;
                }
                if (pref == Integer.MIN_VALUE) {
                    pref = LayoutRegion.distance((leadingNeighbor != null ? leadingNeighbor : parent).getCurrentSpace(), (trailingNeighbor != null ? trailingNeighbor : parent).getCurrentSpace(), dimension, leadingNeighbor != null ? 1 : 0, trailingNeighbor != null ? 0 : 1);
                }
                LayoutInterval gap = new LayoutInterval(101);
                gap.setSizes(min, pref, max);
                gap.setAttribute(1024);
                this.layoutModel.addInterval(gap, parent, index);
                if (trailingNeighbor != null && trailingNeighbor.isParallel() && trailingGap == null) {
                    this.operations.eliminateEndingGaps(trailingNeighbor, new LayoutInterval[]{gap, null}, dimension);
                }
                if (gap.getParent() == parent && leadingNeighbor != null && leadingNeighbor.isParallel() && leadingGap == null) {
                    this.operations.eliminateEndingGaps(leadingNeighbor, new LayoutInterval[]{null, gap}, dimension);
                }
                if (leadingNeighbor == null && leadingGap == null || trailingNeighbor == null && trailingGap == null) {
                    this.operations.optimizeGaps2(superParent, dimension);
                }
                this.destroyRedundantGroups(superParent);
            } else {
                LayoutInterval parentResizingAgain;
                LayoutInterval exclude;
                int resizingAlignment = -1;
                if (losingResizing) {
                    if (leadingNeighbor == null && parent.getAlignment() == 0) {
                        this.layoutModel.setIntervalAlignment(parent, 1);
                        resizingAlignment = 0;
                    } else if (trailingNeighbor == null && parent.getAlignment() == 1) {
                        this.layoutModel.setIntervalAlignment(parent, 0);
                        resizingAlignment = 1;
                    }
                }
                if (leadingNeighbor != null && trailingGap != null) {
                    this.layoutModel.addInterval(trailingGap, parent, -1);
                } else if (trailingNeighbor != null && leadingGap != null) {
                    this.layoutModel.addInterval(leadingGap, parent, 0);
                }
                if (parent.getSubIntervalCount() == 1) {
                    LayoutInterval last = this.layoutModel.removeInterval(parent, 0);
                    this.layoutModel.addInterval(last, superParent, this.layoutModel.removeInterval(parent));
                    this.layoutModel.setIntervalAlignment(last, parent.getRawAlignment());
                    exclude = last;
                } else {
                    int l = (trailingNeighbor != null && leadingNeighbor == null ? trailingNeighbor : parent).getCurrentSpace().positions[dimension][0];
                    int t = (leadingNeighbor != null && trailingNeighbor == null ? leadingNeighbor : parent).getCurrentSpace().positions[dimension][1];
                    parent.getCurrentSpace().set(dimension, l, t);
                    exclude = parent;
                }
                LayoutInterval adjusted = this.operations.maintainSize(superParent, losingResizing, dimension, exclude, exclude.getCurrentSpace().size(dimension), true);
                if (adjusted != null) {
                    this.operations.optimizeGaps2(adjusted, dimension);
                } else {
                    unresized = this.operations.eliminateRedundantSuppressedResizing(superParent, dimension);
                    if ((unresized == null || unresized.isEmpty()) && this.operations.completeGroupResizing(superParent, dimension)) {
                        LayoutInterval seq;
                        int idx;
                        LayoutInterval p = superParent;
                        while (p.getParent() != null && (idx = this.operations.optimizeGaps(p, dimension)) >= 0 && (!(seq = p.getParent()).isSequential() || idx >= 1 && seq.getSubInterval(0).isEmptySpace() || idx + 1 < seq.getSubIntervalCount() && seq.getSubInterval(idx + 1).isEmptySpace())) {
                            p = LayoutInterval.getFirstParent(p, 103);
                        }
                    }
                }
                if (losingResizing && resizingAlignment != -1 && (parentResizingAgain = (resizingAlignment == 0 ? trailingNeighbor : leadingNeighbor).getParent()) != null && parentResizingAgain.isSequential() && LayoutInterval.wantResizeInLayout(parentResizingAgain)) {
                    this.layoutModel.setIntervalAlignment(parentResizingAgain, resizingAlignment);
                }
            }
            if (losingResizing && !LayoutInterval.canResize(superParent) && !LayoutInterval.contentWantResize(superParent)) {
                this.operations.enableGroupResizing(superParent);
            }
        } else {
            if (parent.getParent() == null && parent.getSubIntervalCount() == 0) {
                return;
            }
            int groupAlign = parent.getGroupAlignment();
            if (groupAlign == 0 || groupAlign == 1) {
                unresized = this.operations.eliminateRedundantSuppressedResizing(parent, dimension);
                LayoutInterval adjusted = this.operations.maintainSize(parent, wasResizing, dimension, true);
                this.operations.optimizeGaps2(adjusted != null ? adjusted : parent, dimension);
            } else {
                this.preventParallelCollapse(parent, dimension);
            }
            if (parent.getParent() != null) {
                LayoutInterval superParent = LayoutInterval.getFirstParent(parent, 103);
                if (this.operations.dissolveRedundantGroup(parent)) {
                    parent = superParent;
                }
                if (parent.getParent() != null && parent.getSubIntervalCount() > 1 && wasResizing && !LayoutInterval.contentWantResize(parent)) {
                    this.operations.enableGroupResizing(parent);
                }
            }
        }
        if (unresized != null && !unresized.isEmpty()) {
            if (this.unresizedOnRemove == null) {
                this.unresizedOnRemove = new Collection[2];
            }
            this.unresizedOnRemove[dimension] = unresized;
        }
    }

    private void afterRemoveSpaceUpdate(LayoutInterval root, int dimension) {
        this.updateCurrentSpaceOfGroups(root, dimension, null);
        if (this.collectResizingDiffs(root, dimension) != 0) {
            this.updateToActualSize(root, dimension, 2);
        }
    }

    private void eliminateConsecutiveGaps(LayoutInterval group, int dimension) {
        int index = 0;
        while (index < group.getSubIntervalCount() - 1) {
            if (this.operations.mergeConsecutiveGaps(group, index, dimension)) continue;
            ++index;
        }
    }

    private void preventParallelCollapse(LayoutInterval group, int dimension) {
        LayoutInterval parent;
        assert (group.getGroupAlignment() == 2 || group.getGroupAlignment() == 3);
        LayoutRegion groupSpace = group.getCurrentSpace();
        LayoutRegion reducedSpace = new LayoutRegion();
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            reducedSpace.expand(li.getCurrentSpace(), dimension);
        }
        if (reducedSpace.size(dimension) >= groupSpace.size(dimension)) {
            return;
        }
        ArrayList<LayoutInterval> seqListL = null;
        ArrayList<LayoutInterval> seqListT = null;
        int minDistL = Integer.MAX_VALUE;
        int minDistT = Integer.MAX_VALUE;
        boolean found = false;
        for (parent = group.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isParallel()) continue;
            if (parent.getGroupAlignment() == 2 || parent.getGroupAlignment() == 3) break;
            it = parent.getSubIntervals();
            while (it.hasNext()) {
                LayoutRegion neighborSpace;
                LayoutInterval li = it.next();
                if (li == group || li.isParentOf(group) || li.isEmptySpace() || !LayoutRegion.overlap(neighborSpace = li.getCurrentSpace(), groupSpace, dimension ^ 1, 0) || !LayoutRegion.overlap(neighborSpace, groupSpace, dimension, 0) || LayoutRegion.overlap(neighborSpace, reducedSpace, dimension, 0)) continue;
                int dist = LayoutRegion.distance(neighborSpace, reducedSpace, dimension, 1, 0);
                if (dist >= 0) {
                    if (seqListL == null) {
                        seqListL = new ArrayList<LayoutInterval>();
                    }
                    seqListL.add(li);
                    if (dist >= minDistL) continue;
                    minDistL = dist;
                    continue;
                }
                dist = LayoutRegion.distance(reducedSpace, neighborSpace, dimension, 1, 0);
                if (seqListT == null) {
                    seqListT = new ArrayList<LayoutInterval>();
                }
                seqListT.add(li);
                if (dist >= minDistT) continue;
                minDistT = dist;
            }
            boolean bl = found = seqListL != null && !seqListL.isEmpty() || seqListT != null && !seqListT.isEmpty();
            if (found) break;
        }
        if (found) {
            LayoutInterval seqIntT;
            assert (parent.isParallel());
            LayoutInterval seq = null;
            if (group.getParent().isParallel()) {
                parent = group.getParent();
                int index = this.layoutModel.removeInterval(group);
                seq = new LayoutInterval(102);
                seq.setAlignment(group.getAlignment());
                this.layoutModel.setIntervalAlignment(group, -1);
                this.layoutModel.addInterval(seq, parent, index);
                this.layoutModel.addInterval(group, seq, -1);
            } else {
                LayoutInterval li;
                LayoutInterval sub;
                int indexInSeq = 0;
                LayoutInterval p = group;
                do {
                    LayoutInterval li2 = p;
                    if (!(p = p.getParent()).isSequential()) continue;
                    indexInSeq = p.indexOf(li2);
                    seq = p;
                    break;
                } while (p != parent);
                if (seqListL != null && !seqListL.isEmpty()) {
                    sub = null;
                    while (indexInSeq > 0) {
                        li = this.layoutModel.removeInterval(seq, 0);
                        if (li.isEmptySpace() && --indexInSeq <= 0) continue;
                        if (sub == null) {
                            sub = new LayoutInterval(102);
                            seqListL.add(sub);
                        }
                        this.layoutModel.addInterval(li, sub, -1);
                    }
                }
                if (seqListT != null && !seqListT.isEmpty()) {
                    sub = null;
                    while (indexInSeq + 1 < seq.getSubIntervalCount()) {
                        li = this.layoutModel.removeInterval(seq, seq.getSubIntervalCount() - 1);
                        if (li.isEmptySpace() && indexInSeq + 1 >= seq.getSubIntervalCount()) continue;
                        if (sub == null) {
                            sub = new LayoutInterval(102);
                            seqListT.add(sub);
                        }
                        this.layoutModel.addInterval(li, sub, 0);
                    }
                }
            }
            LayoutInterval seqIntL = this.createIntervalFromList((List<LayoutInterval>)seqListL, 0);
            if (seqIntL != null) {
                LayoutInterval gap = new LayoutInterval(101);
                gap.setSize(minDistL);
                this.layoutModel.addInterval(gap, seq, 0);
                this.layoutModel.setIntervalAlignment(seqIntL, -1);
                this.operations.addContent(seqIntL, seq, 0);
            }
            if ((seqIntT = this.createIntervalFromList((List<LayoutInterval>)seqListT, 1)) != null) {
                LayoutInterval gap = new LayoutInterval(101);
                gap.setSize(minDistT);
                this.layoutModel.addInterval(gap, seq, -1);
                this.layoutModel.setIntervalAlignment(seqIntT, -1);
                this.operations.addContent(seqIntT, seq, -1);
            }
            if (parent.getSubIntervalCount() == 1 && parent.getParent() != null) {
                LayoutInterval remaining = parent.getSubInterval(0);
                this.layoutModel.removeInterval(remaining);
                this.layoutModel.setIntervalAlignment(remaining, parent.getAlignment());
                LayoutInterval superParent = parent.getParent();
                int i = this.layoutModel.removeInterval(parent);
                this.operations.addContent(remaining, superParent, i, dimension);
            }
        } else {
            for (int e = 0; e <= 1; ++e) {
                LayoutInterval gap = LayoutInterval.getNeighbor(group, e, false, true, false);
                if (gap == null || !gap.isEmptySpace() || LayoutInterval.isDefaultPadding(gap)) continue;
                if (gap.getParent() == group.getParent()) {
                    LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(gap, e, true);
                    int npos = neighbor != null ? neighbor.getCurrentSpace().positions[dimension][e ^ 1] : LayoutInterval.getFirstParent((LayoutInterval)gap, (int)103).getCurrentSpace().positions[dimension][e];
                    int dist = reducedSpace.positions[dimension][e] - npos;
                    if (e == 1) {
                        dist *= -1;
                    }
                    if (dist <= LayoutInterval.getCurrentSize(gap, dimension)) continue;
                    this.operations.resizeInterval(gap, dist);
                    continue;
                }
                LayoutInterval superGroup = LayoutInterval.getDirectNeighbor(gap, e ^ 1, true);
                LayoutInterval li = group;
                while (li.getParent() != superGroup) {
                    li = li.getParent();
                }
                int diff = LayoutRegion.distance(groupSpace, reducedSpace, dimension, e, e);
                if (e == 1) {
                    diff *= -1;
                }
                this.operations.maintainSize(superGroup, false, dimension, li, li.getCurrentSpace().size(dimension) - diff, true);
            }
        }
    }

    private LayoutInterval createIntervalFromList(List<LayoutInterval> seqList, int alignment) {
        LayoutInterval seqInt = null;
        if (seqList != null && !seqList.isEmpty()) {
            if (seqList.size() == 1) {
                LayoutInterval li = seqList.get(0);
                if (li.getParent() != null) {
                    this.layoutModel.removeInterval(li);
                }
                seqInt = li;
            } else {
                seqInt = new LayoutInterval(103);
                seqInt.setGroupAlignment(alignment);
                for (LayoutInterval li : seqList) {
                    if (li.getParent() != null) {
                        this.layoutModel.removeInterval(li);
                    }
                    this.layoutModel.addInterval(li, seqInt, -1);
                }
            }
        }
        return seqInt;
    }

    @Override
    public void setIntervalSize(LayoutInterval interval, int dimension, int min, int pref, int max) {
        if (this.logTestCode() && interval.isComponent()) {
            this.testCode.add("ld.setIntervalSize(lm.getLayoutComponent(\"" + interval.getComponent().getId() + "\").getLayoutInterval(" + dimension + "), " + dimension + ", " + min + ", " + pref + ", " + max + ");");
        }
        int oldSize = interval.getPreferredSize();
        if (this.layoutModel.setIntervalSize(interval, min, pref, max)) {
            this.intervalResized(interval, dimension, oldSize, pref);
        }
    }

    private void intervalResized(LayoutInterval interval, int dimension, int oldSize, int newSize) {
        if (LayoutInterval.wantResizeInLayout(interval)) {
            if (newSize > 0 && newSize < LayoutInterval.getCurrentSize(interval, dimension)) {
                this.enableShrinking(interval);
            }
        } else {
            for (LayoutInterval parent = interval.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.isSequential()) continue;
                for (int i = 0; i < parent.getSubIntervalCount(); ++i) {
                    LayoutInterval li = parent.getSubInterval(i);
                    if (!li.isEmptySpace() || !LayoutInterval.canResize(li) || li.getPreferredSize() == LayoutInterval.getDefaultSizeDef(li)) continue;
                    return;
                }
            }
        }
        this.preferredSizeChanged = true;
    }

    private void enableShrinking(LayoutInterval interval) {
        LayoutInterval parent = LayoutInterval.getFirstParent(interval, 103);
        while (parent != null) {
            Iterator<LayoutInterval> it = parent.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval li = it.next();
                if (li == interval || li.isParentOf(interval)) continue;
                this.resetResizingIntervals(li);
            }
            interval = parent;
            parent = LayoutInterval.getFirstParent(interval, 103);
        }
    }

    private void resetResizingIntervals(LayoutInterval interval) {
        if (interval.isGroup()) {
            if (LayoutInterval.canResize(interval)) {
                Iterator<LayoutInterval> it = interval.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval sub = it.next();
                    this.resetResizingIntervals(sub);
                }
            }
        } else if (LayoutInterval.wantResize(interval)) {
            this.resetResizingPrefSize(interval);
        }
    }

    private void resetResizingPrefSize(LayoutInterval interval) {
        if (interval.isEmptySpace()) {
            this.operations.resizeInterval(interval, LayoutInterval.getDefaultSizeDef(interval));
        } else {
            int minSize = interval.getMinimumSize();
            int prefSize = interval.getPreferredSize();
            int accommodatingSize = minSize < 0 ? 0 : minSize;
            this.operations.resizeInterval(interval, accommodatingSize);
            if (prefSize != 0 && accommodatingSize == 0) {
                interval.setAttribute(1024);
            }
        }
    }

    public String[] positionCode() {
        return this.dragger != null ? this.dragger.positionCode() : new String[2];
    }

    public int getModelCounter() {
        return this.modelCounter;
    }

    public void setModelCounter(int modelCounter) {
        this.modelCounter = modelCounter;
    }

    public static boolean testMode() {
        return Boolean.getBoolean(TEST_SWITCH);
    }

    public boolean logTestCode() {
        return this.modelCounter > -1 && Boolean.getBoolean(TEST_SWITCH);
    }
}

