/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class EncloseAction
extends NodeAction {
    public String getName() {
        return NbBundle.getBundle(EncloseAction.class).getString("ACT_EncloseInContainer");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] nodes) {
        List<RADComponent> comps = EncloseAction.getComponents(nodes);
        return comps != null && EncloseAction.getContainer(comps) != null;
    }

    protected void performAction(Node[] nodes) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        ContainersMenu menu = new ContainersMenu(this.getName(), EncloseAction.getComponents(this.getActivatedNodes()));
        menu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)menu, (String)EncloseAction.class.getName());
        return menu;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static List<RADComponent> getComponents(Node[] nodes) {
        return FormUtils.getSelectedLayoutComponents(nodes);
    }

    private static RADVisualContainer getContainer(List components) {
        RADVisualContainer commonParent = null;
        for (Object comp : components) {
            if (comp instanceof RADVisualComponent) {
                RADVisualContainer parent = ((RADVisualComponent)comp).getParentContainer();
                if (parent == null || commonParent != null && parent != commonParent) {
                    return null;
                }
                if (commonParent != null) continue;
                commonParent = parent;
                continue;
            }
            return null;
        }
        return commonParent;
    }

    private static PaletteItem[] getAllContainers(Node subMenuNode) {
        ArrayList<PaletteItem> list = new ArrayList<PaletteItem>();
        for (Node itemNode : PaletteUtils.getItemNodes(subMenuNode, true)) {
            Class cls;
            PaletteItem item = (PaletteItem)itemNode.getLookup().lookup(PaletteItem.class);
            if (item == null || "chooseBean".equals(item.getExplicitComponentType()) || (cls = item.getComponentClass()) == null || !JComponent.class.isAssignableFrom(cls) || MenuElement.class.isAssignableFrom(cls) || !FormUtils.isContainer(cls)) continue;
            list.add(item);
        }
        Collections.sort(list, new Comparator<PaletteItem>(){

            @Override
            public int compare(PaletteItem o1, PaletteItem o2) {
                return o1.getNode().getDisplayName().compareTo(o2.getNode().getDisplayName());
            }
        });
        return list.toArray(new PaletteItem[list.size()]);
    }

    private static class ContainersMenu
    extends JMenu {
        private boolean initialized = false;
        private List<RADComponent> components;

        private ContainersMenu(String name, List<RADComponent> components) {
            super(name);
            this.components = components;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            final JPopupMenu popup = super.getPopupMenu();
            if (!this.initialized) {
                popup.removeAll();
                String waitTxt = NbBundle.getBundle(EncloseAction.class).getString("MSG_EncloseInPleaseWait");
                JMenuItem waitItem = new JMenuItem(waitTxt);
                waitItem.setEnabled(false);
                popup.add(waitItem);
                FormUtils.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                popup.removeAll();
                                ContainersMenu.this.fillPaletteCategoriesSubMenu();
                                popup.pack();
                            }
                        });
                    }
                });
                this.initialized = true;
            }
            return popup;
        }

        private void fillPaletteCategoriesSubMenu() {
            Node[] nodes = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), true);
            if (nodes.length > 0) {
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i].isLeaf()) continue;
                    JMenu item = new JMenu(nodes[i].getDisplayName());
                    PaletteItem[] items = EncloseAction.getAllContainers(nodes[i]);
                    if (items.length <= 0) continue;
                    for (PaletteItem item2 : items) {
                        JMenuItem mi = new JMenuItem(item2.getNode().getDisplayName());
                        HelpCtx.setHelpIDString((JComponent)mi, (String)EncloseAction.class.getName());
                        item.add(mi);
                        mi.addActionListener(new EncloseActionListener(item2));
                    }
                    this.add(item);
                }
            }
            if (this.getMenuComponentCount() == 1) {
                JMenu menu = (JMenu)this.getMenuComponent(0);
                this.remove(menu);
                for (Component menuItem : menu.getMenuComponents()) {
                    this.add(menuItem);
                }
            }
        }

        private class EncloseActionListener
        implements ActionListener {
            private PaletteItem paletteItem;

            EncloseActionListener(PaletteItem paletteItem) {
                this.paletteItem = paletteItem;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                RADVisualContainer metacont = EncloseAction.getContainer(ContainersMenu.this.components);
                if (metacont != null) {
                    FormModel formModel = metacont.getFormModel();
                    MetaComponentCreator creator = formModel.getComponentCreator();
                    if (metacont.getLayoutSupport() == null) {
                        LayoutModel layoutModel = formModel.getLayoutModel();
                        Object layoutUndoMark = null;
                        UndoableEdit layoutEdit = null;
                        boolean autoUndo = true;
                        try {
                            RADComponent newComp = creator.createComponent(this.paletteItem, (RADComponent)metacont, null);
                            boolean success = newComp instanceof RADVisualContainer;
                            if (!success) {
                                String msg = NbBundle.getMessage(EncloseAction.class, (String)"MSG_EncloseInNotEmpty");
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                            } else {
                                RADVisualContainer newCont = (RADVisualContainer)newComp;
                                layoutUndoMark = layoutModel.getChangeMark();
                                layoutEdit = layoutModel.getUndoableEdit();
                                layoutModel.removeComponent(newCont.getId(), false);
                                String[] compIds = new String[ContainersMenu.this.components.size()];
                                int i = 0;
                                for (RADComponent metacomp : ContainersMenu.this.components) {
                                    compIds[i++] = metacomp.getId();
                                }
                                for (RADComponent metacomp : ContainersMenu.this.components) {
                                    formModel.removeComponent(metacomp, false);
                                }
                                success = creator.addComponents(ContainersMenu.this.components, newCont);
                                if (success) {
                                    FormEditor.getFormDesigner(formModel).getLayoutDesigner().encloseInContainer(compIds, newCont.getId());
                                } else {
                                    String msg = NbBundle.getMessage(EncloseAction.class, (String)"MSG_EncloseInFailed");
                                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                                }
                            }
                            boolean bl = autoUndo = !success;
                            if (layoutUndoMark != null && !layoutUndoMark.equals(layoutModel.getChangeMark())) {
                                formModel.addUndoableEdit(layoutEdit);
                            }
                            if (autoUndo) {
                                formModel.forceUndoOfCompoundEdit();
                            }
                        }
                        catch (Throwable throwable) {
                            if (layoutUndoMark != null && !layoutUndoMark.equals(layoutModel.getChangeMark())) {
                                formModel.addUndoableEdit(layoutEdit);
                            }
                            if (autoUndo) {
                                formModel.forceUndoOfCompoundEdit();
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
    }
}

