/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class CustomizeEmptySpaceAction
extends CookieAction {
    private static String name;
    private Dialog dialog;

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{RADComponentCookie.class};
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        if (name == null) {
            name = NbBundle.getBundle(CustomizeEmptySpaceAction.class).getString("ACT_CustomizeEmptySpace");
        }
        return name;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/empty.gif";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] activatedNodes) {
        List<RADComponent> comps = FormUtils.getSelectedLayoutComponents(activatedNodes);
        if (comps == null || comps.size() != 1) {
            return;
        }
        RADComponent metacomp = comps.get(0);
        FormModel formModel = metacomp.getFormModel();
        LayoutModel model = formModel.getLayoutModel();
        final EmptySpaceCustomizer customizer = new EmptySpaceCustomizer(model, metacomp.getId());
        DialogDescriptor dd = new DialogDescriptor((Object)customizer, NbBundle.getMessage(CustomizeEmptySpaceAction.class, (String)"TITLE_CustomizeEmptySpace"), true, 2, NotifyDescriptor.OK_OPTION, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == NotifyDescriptor.OK_OPTION && customizer.checkValues()) {
                    CustomizeEmptySpaceAction.this.dialog.dispose();
                }
            }
        });
        dd.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        this.dialog = DialogDisplayer.getDefault().createDialog(dd);
        this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizeEmptySpaceAction.class, (String)"ACSD_EmptySpace"));
        this.dialog.setVisible(true);
        this.dialog = null;
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            Object layoutUndoMark = model.getChangeMark();
            UndoableEdit ue = model.getUndoableEdit();
            boolean autoUndo = true;
            try {
                customizer.applyValues();
                autoUndo = false;
            }
            finally {
                formModel.fireContainerLayoutChanged(((RADVisualComponent)metacomp).getParentContainer(), null, null, null);
                if (!layoutUndoMark.equals(model.getChangeMark())) {
                    formModel.addUndoableEdit(ue);
                }
                if (autoUndo) {
                    formModel.forceUndoOfCompoundEdit();
                }
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (super.enable(activatedNodes)) {
            List<RADComponent> comps = FormUtils.getSelectedLayoutComponents(activatedNodes);
            return comps != null && comps.size() == 1;
        }
        return false;
    }

    private static class EmptySpaceCustomizer
    extends JPanel {
        JComboBox leftSize = new JComboBox();
        JComboBox rightSize = new JComboBox();
        JComboBox topSize = new JComboBox();
        JComboBox bottomSize = new JComboBox();
        JCheckBox leftResizable = new JCheckBox();
        JCheckBox rightResizable = new JCheckBox();
        JCheckBox topResizable = new JCheckBox();
        JCheckBox bottomResizable = new JCheckBox();
        LayoutModel model;
        String compId;

        EmptySpaceCustomizer(LayoutModel model, String compId) {
            this.model = model;
            this.compId = compId;
            this.initComponents();
            LayoutComponent comp = model.getLayoutComponent(compId);
            this.initValues(comp, 0, 0, this.leftSize, this.leftResizable);
            this.initValues(comp, 0, 1, this.rightSize, this.rightResizable);
            this.initValues(comp, 1, 0, this.topSize, this.topResizable);
            this.initValues(comp, 1, 1, this.bottomSize, this.bottomResizable);
        }

        private void initValues(LayoutComponent comp, int dimension, int direction, JComboBox size, JCheckBox resizable) {
            LayoutInterval space = LayoutUtils.getAdjacentEmptySpace(comp, dimension, direction);
            if (space != null) {
                ResourceBundle bundle = NbBundle.getBundle(EmptySpaceCustomizer.class);
                String[] paddings = LayoutUtils.hasAdjacentComponent(comp, dimension, direction) ? new String[]{bundle.getString("VALUE_PaddingRelated"), bundle.getString("VALUE_PaddingUnrelated"), bundle.getString("VALUE_PaddingSeparate")} : new String[]{bundle.getString("VALUE_PaddingDefault")};
                size.setModel(new DefaultComboBoxModel<String>(paddings));
                int pref = space.getPreferredSize();
                int max = space.getMaximumSize();
                if (pref == -1) {
                    size.setSelectedItem(EmptySpaceCustomizer.getPaddingString(paddings, space.getPaddingType()));
                } else {
                    size.setSelectedItem(Integer.toString(pref));
                }
                resizable.setSelected(max != -2 && max != pref);
            } else {
                size.setSelectedItem(NbBundle.getMessage(CustomizeEmptySpaceAction.class, (String)"VALUE_NoEmptySpace"));
                size.setEnabled(false);
                resizable.setEnabled(false);
            }
        }

        private static String getPaddingString(String[] paddingStrings, LayoutConstants.PaddingType paddingType) {
            if (paddingType == LayoutConstants.PaddingType.UNRELATED) {
                return paddingStrings[1];
            }
            if (paddingType == LayoutConstants.PaddingType.SEPARATE) {
                return paddingStrings[2];
            }
            return paddingStrings[0];
        }

        private static LayoutConstants.PaddingType getSelectedPaddingType(JComboBox combo) {
            Object selSize;
            if (combo.getItemCount() == 3 && (selSize = combo.getSelectedItem()) != null) {
                if (selSize.equals(combo.getItemAt(0))) {
                    return LayoutConstants.PaddingType.RELATED;
                }
                if (selSize.equals(combo.getItemAt(1))) {
                    return LayoutConstants.PaddingType.UNRELATED;
                }
                if (selSize.equals(combo.getItemAt(2))) {
                    return LayoutConstants.PaddingType.SEPARATE;
                }
            }
            return null;
        }

        private static boolean isDefaultSizeSelected(JComboBox combo) {
            Object selSize = combo.getSelectedItem();
            if (selSize != null) {
                for (int i = 0; i < combo.getItemCount(); ++i) {
                    if (!selSize.equals(combo.getItemAt(i))) continue;
                    return true;
                }
            }
            return false;
        }

        boolean checkValues() {
            return this.checkValue(this.leftSize) && this.checkValue(this.rightSize) && this.checkValue(this.topSize) && this.checkValue(this.bottomSize);
        }

        private boolean checkValue(JComboBox size) {
            Object selSize = size.getSelectedItem();
            if (size.isEnabled() && !EmptySpaceCustomizer.isDefaultSizeSelected(size)) {
                try {
                    int newPref = Integer.parseInt((String)selSize);
                    if (newPref < 0) {
                        this.notify("MSG_NegativeSpaceSize");
                        return false;
                    }
                    if (newPref > Short.MAX_VALUE) {
                        this.notify("MSG_TooLargeSpaceSize");
                        return false;
                    }
                }
                catch (NumberFormatException nfex) {
                    this.notify("MSG_CorruptedSpaceSize");
                    return false;
                }
            }
            return true;
        }

        private void notify(String messageKey) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getBundle(CustomizeEmptySpaceAction.class).getString(messageKey));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        }

        void applyValues() {
            LayoutComponent comp = this.model.getLayoutComponent(this.compId);
            this.applyValues(comp, 0, 0, this.leftSize, this.leftResizable);
            this.applyValues(comp, 0, 1, this.rightSize, this.rightResizable);
            this.applyValues(comp, 1, 0, this.topSize, this.topResizable);
            this.applyValues(comp, 1, 1, this.bottomSize, this.bottomResizable);
        }

        private void applyValues(LayoutComponent comp, int dimension, int direction, JComboBox size, JCheckBox resizable) {
            LayoutInterval space = LayoutUtils.getAdjacentEmptySpace(comp, dimension, direction);
            if (space != null) {
                LayoutConstants.PaddingType newPadType;
                int newPref;
                int pref = space.getPreferredSize();
                boolean newResizable = resizable.isSelected();
                Object selSize = size.getSelectedItem();
                LayoutConstants.PaddingType oldPadType = space.getPaddingType();
                if (EmptySpaceCustomizer.isDefaultSizeSelected(size)) {
                    newPref = -1;
                    newPadType = EmptySpaceCustomizer.getSelectedPaddingType(size);
                } else {
                    try {
                        newPref = Integer.parseInt((String)selSize);
                        if (newPref < 0) {
                            newPref = pref;
                        }
                    }
                    catch (NumberFormatException nfex) {
                        newPref = pref;
                    }
                    newPadType = null;
                }
                this.model.setUserIntervalSize(space, dimension, newPref, newResizable);
                if (oldPadType != null || newPadType != LayoutConstants.PaddingType.RELATED) {
                    this.model.setPaddingType(space, newPadType);
                }
            }
        }

        private void initComponents() {
            ResourceBundle bundle = NbBundle.getBundle(EmptySpaceCustomizer.class);
            this.setLayout(new GridBagLayout());
            this.setBorder(new TitledBorder(bundle.getString("TITLE_EmptySpace")));
            JLabel leftLabel = new JLabel();
            JLabel rightLabel = new JLabel();
            JLabel topLabel = new JLabel();
            JLabel bottomLabel = new JLabel();
            JLabel sizeLabel = new JLabel(bundle.getString("NAME_SpaceSize"));
            JLabel resizableLabel = new JLabel(bundle.getString("NAME_SpaceResizable"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(3, 6, 3, 0);
            this.add((Component)leftLabel, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.add((Component)rightLabel, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.add((Component)topLabel, gridBagConstraints);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(3, 6, 6, 0);
            this.add((Component)bottomLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 6, 3, 6);
            this.add((Component)sizeLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(0, 6, 3, 6);
            this.add((Component)resizableLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.leftResizable, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.add((Component)this.rightResizable, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.add((Component)this.topResizable, gridBagConstraints);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(0, 0, 3, 0);
            this.add((Component)this.bottomResizable, gridBagConstraints);
            leftLabel.setLabelFor(this.leftSize);
            rightLabel.setLabelFor(this.rightSize);
            topLabel.setLabelFor(this.topSize);
            bottomLabel.setLabelFor(this.bottomSize);
            Mnemonics.setLocalizedText((JLabel)leftLabel, (String)bundle.getString("NAME_LeftSpace"));
            Mnemonics.setLocalizedText((JLabel)rightLabel, (String)bundle.getString("NAME_RightSpace"));
            Mnemonics.setLocalizedText((JLabel)topLabel, (String)bundle.getString("NAME_TopSpace"));
            Mnemonics.setLocalizedText((JLabel)bottomLabel, (String)bundle.getString("NAME_BottomSpace"));
            this.leftSize.setEditable(true);
            this.rightSize.setEditable(true);
            this.topSize.setEditable(true);
            this.bottomSize.setEditable(true);
            this.leftResizable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_LeftResizable"));
            this.rightResizable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_RightResizable"));
            this.topResizable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TopResizable"));
            this.bottomResizable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_BottomResizable"));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(3, 6, 3, 6);
            this.add((Component)this.leftSize, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.add((Component)this.rightSize, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.add((Component)this.topSize, gridBagConstraints);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(3, 6, 6, 6);
            this.add((Component)this.bottomSize, gridBagConstraints);
        }
    }
}

