/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.junit.output.JUnitTestMethodNode;
import org.netbeans.modules.junit.output.JUnitTestSuite;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public final class OutputUtils {
    static final Action[] NO_ACTIONS = new Action[0];

    private OutputUtils() {
    }

    static void openTestsuite(TestsuiteNode node) {
        FileObject fo;
        TestSuite suite = node.getSuite();
        if (suite != null && suite instanceof JUnitTestSuite && (fo = ((JUnitTestSuite)suite).getSuiteFO()) != null) {
            final long[] line = new long[]{0L};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Trees trees = compilationController.getTrees();
                            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                            List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                            for (Tree tree : typeDecls) {
                                Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                                if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo.getName())) continue;
                                long pos = trees.getSourcePositions().getStartPosition(compilationUnitTree, tree);
                                line[0] = compilationUnitTree.getLineMap().getLineNumber(pos);
                                break;
                            }
                        }
                    }, true);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
            Utils.openFile(fo, (int)line[0]);
        }
    }

    static void openTestMethod(final JUnitTestMethodNode node) {
        final FileObject fo = node.getTestcase().getClassFileObject();
        if (fo != null) {
            final long[] line = new long[]{0L};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Trees trees = compilationController.getTrees();
                            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                            List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                            block0: for (Tree tree : typeDecls) {
                                Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                                if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo.getName())) continue;
                                List<ExecutableElement> methodElements = ElementFilter.methodsIn(element.getEnclosedElements());
                                for (ExecutableElement child : methodElements) {
                                    if (!child.getSimpleName().contentEquals(node.getTestcase().getName())) continue;
                                    long pos = trees.getSourcePositions().getStartPosition(compilationUnitTree, trees.getTree((Element)child));
                                    line[0] = compilationUnitTree.getLineMap().getLineNumber(pos);
                                    break block0;
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
            Utils.openFile(fo, (int)line[0]);
        }
    }

    static void openCallstackFrame(Node node, String frameInfo) {
        String[] st;
        JUnitTestMethodNode methodNode = OutputUtils.getTestMethodNode(node);
        LineConvertors.FileLocator locator = methodNode.getTestcase().getSession().getFileLocator();
        if (locator == null) {
            return;
        }
        int[] lineNumStorage = new int[1];
        FileObject file = OutputUtils.getFile(frameInfo, lineNumStorage, locator);
        if (file == null && methodNode.getTestcase().getTrouble() != null && (st = methodNode.getTestcase().getTrouble().getStackTrace()) != null && st.length > 0) {
            file = OutputUtils.getFile(st[st.length - 1], lineNumStorage, locator);
        }
        Utils.openFile(file, lineNumStorage[0]);
    }

    static String determineStackFrame(Trouble trouble) {
        String[] frames = trouble.getStackTrace();
        return frames != null && frames.length != 0 ? frames[frames.length - 1] : null;
    }

    private static JUnitTestMethodNode getTestMethodNode(Node node) {
        while (!(node instanceof JUnitTestMethodNode)) {
            node = node.getParentNode();
        }
        return (JUnitTestMethodNode)node;
    }

    private static FileObject getFile(String callstackLine, int[] lineNumStorage, LineConvertors.FileLocator locator) {
        String ending;
        String slashName;
        int lastSlashIndex;
        int lineNum;
        String fileName;
        String clsName;
        block13: {
            int bracketIndex;
            String line = RegexpUtils.specialTrim(callstackLine);
            if (line.startsWith("[catch] ")) {
                line = line.substring("[catch] ".length());
            }
            if (line.startsWith("at ")) {
                line = line.substring("at ".length());
            }
            String beforeBrackets = (bracketIndex = line.indexOf(40)) == -1 ? line : line.substring(0, bracketIndex).trim();
            String inBrackets = bracketIndex == -1 ? (String)null : line.substring(bracketIndex + 1, line.lastIndexOf(41));
            int lastDotIndex = beforeBrackets.lastIndexOf(46);
            clsName = lastDotIndex == -1 ? beforeBrackets : beforeBrackets.substring(0, lastDotIndex);
            fileName = null;
            lineNum = -1;
            if (inBrackets != null && RegexpUtils.getInstance().getLocationInFilePattern().matcher(inBrackets).matches()) {
                int ddotIndex = inBrackets.lastIndexOf(58);
                if (ddotIndex == -1) {
                    fileName = inBrackets;
                } else {
                    fileName = inBrackets.substring(0, ddotIndex);
                    try {
                        lineNum = Integer.parseInt(inBrackets.substring(ddotIndex + 1));
                        if (lineNum <= 0) {
                            lineNum = 1;
                        }
                    }
                    catch (NumberFormatException ex) {
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError();
                    }
                }
            }
        }
        String clsNameSlash = clsName.replace('.', '/');
        if (fileName == null) {
            lastSlashIndex = clsNameSlash.length();
            slashName = clsNameSlash;
            ending = ".java";
        } else {
            lastSlashIndex = clsNameSlash.lastIndexOf(47);
            slashName = lastSlashIndex != -1 ? clsNameSlash.substring(0, lastSlashIndex) : clsNameSlash;
            ending = '/' + fileName;
        }
        String thePath = slashName + ending;
        FileObject file = locator.find(thePath);
        while (file == null && lastSlashIndex != -1) {
            thePath = (slashName = slashName.substring(0, lastSlashIndex)) + ending;
            file = locator.find(thePath);
            if (file != null) continue;
            lastSlashIndex = slashName.lastIndexOf(47, lastSlashIndex - 1);
        }
        if (file == null && fileName != null) {
            thePath = fileName;
            file = locator.find(thePath);
        }
        if (file == null) {
            lineNum = -1;
        }
        lineNumStorage[0] = lineNum;
        return file;
    }

    public static ActionProvider getActionProvider(FileObject fileObject) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (owner == null) {
            return null;
        }
        return (ActionProvider)owner.getLookup().lookup(ActionProvider.class);
    }
}

