/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.actions.CMakeAction;
import org.netbeans.modules.cnd.actions.MakeAction;
import org.netbeans.modules.cnd.actions.QMakeAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.builds.CMakeExecSupport;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.builds.MakeExecSupport;
import org.netbeans.modules.cnd.builds.QMakeExecSupport;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildTraceSupport;
import org.netbeans.modules.cnd.discovery.projectimport.ExecuteCommand;
import org.netbeans.modules.cnd.discovery.projectimport.FollowUp;
import org.netbeans.modules.cnd.discovery.services.DiscoveryManagerImpl;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.discovery.wizard.support.impl.DiscoveryProjectGeneratorImpl;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.remote.api.RfsListener;
import org.netbeans.modules.cnd.remote.api.RfsListenerSupport;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ImportProject
implements PropertyChangeListener {
    private static final String BUILD_COMMAND = "${MAKE} -f Makefile";
    private static final String CLEAN_COMMAND = "${MAKE} -f Makefile clean";
    private static final boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    public static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportProject");
    private static final RequestProcessor RP;
    private final String nativeProjectPath;
    private final FileObject nativeProjectFO;
    private final File projectFolder;
    private String projectName;
    private String makefilePath;
    private String configurePath;
    private String configureRunFolder;
    private String configureArguments;
    private boolean runConfigure = false;
    private boolean manualCA = false;
    private boolean buildArifactWasAnalyzed = false;
    private boolean setAsMain;
    private final String hostUID;
    private final ExecutionEnvironment executionEnvironment;
    private final ExecutionEnvironment fileSystemExecutionEnvironment;
    private final boolean fullRemote;
    private final MakeProjectOptions.PathMode pathMode;
    private CompilerSet toolchain;
    private boolean defaultToolchain;
    private String workingDir;
    private String buildCommand = "${MAKE} -f Makefile";
    private String cleanCommand = "${MAKE} -f Makefile clean";
    private String buildResult = "";
    private Project makeProject;
    private boolean runMake;
    private String includeDirectories = "";
    private String macros = "";
    private String consolidationStrategy = "file";
    private Iterator<SourceFolderInfo> sources;
    private Iterator<SourceFolderInfo> tests;
    private String sourceFoldersFilter = null;
    private FileObject configureFileObject;
    private Map<Step, State> importResult = new EnumMap<Step, State>(Step.class);
    private static final String configureCteatePattern = " creating ";
    private boolean isFinished = false;
    private boolean isUILessMode = false;
    private File configureLog = null;
    private File makeLog = null;
    private File execLog = null;
    private String remoteExecLog = null;
    private Map<String, Item> normalizedItems;
    private static final Map<CsmProject, CsmProgressListener> listeners;

    public ImportProject(WizardDescriptor wizard) {
        Boolean b = (Boolean)wizard.getProperty("fullRemote");
        this.fullRemote = b == null ? false : b;
        this.pathMode = this.fullRemote ? MakeProjectOptions.PathMode.ABS : MakeProjectOptions.getPathMode();
        this.projectFolder = FileUtil.normalizeFile((File)((File)wizard.getProperty("projdir")));
        this.nativeProjectPath = (String)wizard.getProperty("nativeProjDir");
        this.nativeProjectFO = (FileObject)wizard.getProperty("nativeProjFO");
        if (Boolean.TRUE.equals(wizard.getProperty("simpleMode"))) {
            this.simpleSetup(wizard);
        } else {
            this.customSetup(wizard);
        }
        this.hostUID = (String)wizard.getProperty("hostUID");
        this.executionEnvironment = this.hostUID == null ? ServerList.getDefaultRecord().getExecutionEnvironment() : ExecutionEnvironmentFactory.fromUniqueID((String)this.hostUID);
        ExecutionEnvironment executionEnvironment = this.fileSystemExecutionEnvironment = this.fullRemote ? this.executionEnvironment : ExecutionEnvironmentFactory.getLocal();
        assert (this.nativeProjectPath != null);
    }

    private void simpleSetup(WizardDescriptor wizard) {
        this.projectName = this.projectFolder.getName();
        this.workingDir = this.nativeProjectPath;
        this.configurePath = (String)wizard.getProperty("configureName");
        if (this.configurePath != null) {
            this.configureArguments = (String)wizard.getProperty("realFlags");
            this.runConfigure = true;
            this.makefilePath = (String)wizard.getProperty("makefileName");
            if (this.makefilePath == null) {
                this.makefilePath = this.nativeProjectPath + "/Makefile";
            }
            this.configureRunFolder = (String)wizard.getProperty("configureRunFolder");
        } else {
            this.makefilePath = (String)wizard.getProperty("makefileName");
        }
        this.runMake = Boolean.TRUE.equals(wizard.getProperty("buildProject"));
        this.setAsMain = Boolean.TRUE.equals(wizard.getProperty("setMain"));
        this.toolchain = (CompilerSet)wizard.getProperty("toolchain");
        this.defaultToolchain = Boolean.TRUE.equals(wizard.getProperty("toolchainDefault"));
        ArrayList<1> list = new ArrayList<1>();
        list.add(new SourceFolderInfo(){

            public FileObject getFileObject() {
                return ImportProject.this.nativeProjectFO;
            }

            public String getFolderName() {
                return ImportProject.this.nativeProjectFO.getNameExt();
            }

            public boolean isAddSubfoldersSelected() {
                return true;
            }
        });
        this.sources = list.iterator();
        this.sourceFoldersFilter = "^(nbproject)$";
    }

    private void customSetup(WizardDescriptor wizard) {
        Iterator it2;
        Iterator it;
        this.projectName = (String)wizard.getProperty("name");
        this.workingDir = (String)wizard.getProperty("buildCommandWorkingDirTextField");
        this.buildCommand = (String)wizard.getProperty("buildCommandTextField");
        this.cleanCommand = (String)wizard.getProperty("cleanCommandTextField");
        this.buildResult = (String)wizard.getProperty("outputTextField");
        this.includeDirectories = (String)wizard.getProperty("includeTextField");
        this.macros = (String)wizard.getProperty("macroTextField");
        this.makefilePath = (String)wizard.getProperty("makefileName");
        this.configurePath = (String)wizard.getProperty("configureName");
        this.configureRunFolder = (String)wizard.getProperty("configureRunFolder");
        this.configureArguments = (String)wizard.getProperty("configureArguments");
        this.consolidationStrategy = (String)wizard.getProperty("consolidationLevel");
        this.sources = it = (Iterator)wizard.getProperty("sourceFolders");
        this.tests = it2 = (Iterator)wizard.getProperty("testFolders");
        this.sourceFoldersFilter = (String)wizard.getProperty("sourceFoldersFilter");
        this.runConfigure = "true".equals(wizard.getProperty("runConfigure"));
        this.runMake = this.runConfigure ? true : "true".equals(wizard.getProperty("makeProject"));
        this.manualCA = "true".equals(wizard.getProperty("manualCA"));
        this.setAsMain = Boolean.TRUE.equals(wizard.getProperty("setAsMain"));
        this.toolchain = (CompilerSet)wizard.getProperty("toolchain");
        this.defaultToolchain = Boolean.TRUE.equals(wizard.getProperty("toolchainDefault"));
    }

    public Set<FileObject> create() throws IOException {
        Iterator importantItemsIterator;
        StringTokenizer tokenizer;
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        MakeConfiguration extConf = new MakeConfiguration(this.projectFolder.getPath(), "Default", 0, this.hostUID, this.toolchain, this.defaultToolchain);
        String workingDirRel = this.fullRemote ? this.nativeProjectFO.getPath() : ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.workingDir), (MakeProjectOptions.PathMode)this.pathMode);
        workingDirRel = CndPathUtilitities.normalizeSlashes((String)workingDirRel);
        extConf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(workingDirRel);
        extConf.getMakefileConfiguration().getBuildCommand().setValue(this.buildCommand);
        extConf.getMakefileConfiguration().getCleanCommand().setValue(this.cleanCommand);
        if (this.buildResult != null && this.buildResult.length() > 0) {
            this.buildResult = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.buildResult), (MakeProjectOptions.PathMode)this.pathMode);
            this.buildResult = CndPathUtilitities.normalizeSlashes((String)this.buildResult);
            extConf.getMakefileConfiguration().getOutput().setValue(this.buildResult);
        }
        extConf.getProfile().setRunDirectory(workingDirRel);
        if (this.includeDirectories != null && this.includeDirectories.length() > 0) {
            tokenizer = new StringTokenizer(this.includeDirectories, ";");
            ArrayList<String> includeDirectoriesVector = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String includeDirectory = tokenizer.nextToken();
                includeDirectory = CndPathUtilitities.toRelativePath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)includeDirectory));
                includeDirectory = CndPathUtilitities.normalizeSlashes((String)includeDirectory);
                includeDirectoriesVector.add(includeDirectory);
            }
            extConf.getCCompilerConfiguration().getIncludeDirectories().setValue(includeDirectoriesVector);
            extConf.getCCCompilerConfiguration().getIncludeDirectories().setValue(new ArrayList(includeDirectoriesVector));
        }
        if (this.macros != null && this.macros.length() > 0) {
            tokenizer = new StringTokenizer(this.macros, "; ");
            ArrayList<String> list = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
            extConf.getCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(list);
            extConf.getCCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(list);
        }
        ArrayList<String> importantItems = new ArrayList<String>();
        if (this.makefilePath != null && this.makefilePath.length() > 0) {
            if (this.fullRemote) {
                CndUtils.assertAbsolutePathInConsole((String)this.makefilePath);
            } else {
                this.makefilePath = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.makefilePath), (MakeProjectOptions.PathMode)this.pathMode);
                this.makefilePath = CndPathUtilitities.normalizeSlashes((String)this.makefilePath);
            }
        }
        if (this.configurePath != null && this.configurePath.length() > 0) {
            String normPath = RemoteFileUtil.normalizeAbsolutePath((String)this.configurePath, (ExecutionEnvironment)this.fileSystemExecutionEnvironment);
            this.configureFileObject = RemoteFileUtil.getFileObject((String)normPath, (ExecutionEnvironment)this.fileSystemExecutionEnvironment);
            this.configurePath = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.configurePath), (MakeProjectOptions.PathMode)this.pathMode);
            this.configurePath = CndPathUtilitities.normalizeSlashes((String)this.configurePath);
            importantItems.add(this.configurePath);
        }
        if (!(importantItemsIterator = importantItems.iterator()).hasNext()) {
            importantItemsIterator = null;
        }
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(this.projectName, this.projectFolder);
        prjParams.setConfiguration(extConf).setSourceFolders(this.sources).setSourceFoldersFilter(this.sourceFoldersFilter).setTestFolders(this.tests).setImportantFiles(importantItemsIterator).setFullRemote(this.fullRemote).setFullRemoteNativeProjectPath(this.nativeProjectPath).setHostUID(this.hostUID);
        if (this.makefilePath != null) {
            prjParams.setMakefileName(this.makefilePath);
        } else {
            prjParams.setMakefileName("");
        }
        this.makeProject = ProjectGenerator.createProject((ProjectGenerator.ProjectParameters)prjParams);
        FileObject dir = CndFileUtils.toFileObject((File)this.projectFolder);
        this.importResult.put(Step.Project, State.Successful);
        this.switchModel(false);
        resultSet.add(dir);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        return resultSet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects = (Project[])evt.getNewValue();
            if (projects.length == 0) {
                return;
            }
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ImportProject.this.doWork();
                }
            });
        }
    }

    boolean isProjectOpened() {
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            if (p != this.makeProject) continue;
            return true;
        }
        return false;
    }

    private void doWork() {
        try {
            if (this.makeProject instanceof Runnable) {
                ((Runnable)this.makeProject).run();
            }
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            pdp.getConfigurationDescriptor();
            if (pdp.gotDescriptor()) {
                if (pdp.getConfigurationDescriptor().getActiveConfiguration() != null) {
                    if (this.runConfigure && this.configurePath != null && this.configurePath.length() > 0 && this.configureFileObject != null && this.configureFileObject.isValid()) {
                        this.postConfigure();
                    } else if (this.runMake) {
                        this.makeProject(null);
                    } else {
                        this.discovery(0, null, null);
                    }
                } else {
                    this.isFinished = true;
                }
            } else {
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static File createTempFile(String prefix) {
        try {
            File file = File.createTempFile(prefix, ".log");
            file.deleteOnExit();
            return file;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void postConfigure() {
        try {
            Future task;
            String mime;
            Node node;
            BufferedWriter outputListener;
            block37: {
                if (!this.isProjectOpened()) {
                    this.isFinished = true;
                    return;
                }
                if (this.configureLog == null) {
                    this.configureLog = ImportProject.createTempFile("configure");
                }
                outputListener = null;
                try {
                    outputListener = new BufferedWriter(new FileWriter(this.configureLog));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                DataObject dObj = DataObject.find((FileObject)this.configureFileObject);
                node = dObj.getNodeDelegate();
                mime = FileUtil.getMIMEType((FileObject)this.configureFileObject);
                if (this.configureArguments != null) {
                    List vars;
                    ShellExecSupport ses;
                    if ("text/sh".equals(mime)) {
                        ses = (ShellExecSupport)node.getCookie(ShellExecSupport.class);
                        try {
                            ses.setArguments(new String[]{this.configureArguments});
                            vars = ImportUtils.parseEnvironment((String)this.configureArguments);
                            ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                            if (this.configureRunFolder != null) {
                                FileObject createdFolder = this.mkDir(this.configureFileObject.getParent(), this.configureRunFolder);
                                if (createdFolder != null) {
                                    ses.setRunDirectory(createdFolder.getPath());
                                }
                                break block37;
                            }
                            ses.setRunDirectory(this.configureFileObject.getParent().getPath());
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else if ("text/x-cmake".equals(mime)) {
                        ses = (CMakeExecSupport)node.getCookie(CMakeExecSupport.class);
                        try {
                            vars = ImportUtils.parseEnvironment((String)this.configureArguments);
                            for (String s : ImportUtils.quoteList((List)vars)) {
                                int i = this.configureArguments.indexOf(s);
                                if (i < 0) continue;
                                this.configureArguments = this.configureArguments.substring(0, i) + this.configureArguments.substring(i + s.length());
                            }
                            ses.setArguments(new String[]{this.configureArguments});
                            ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                            if (this.configureRunFolder != null) {
                                FileObject createdFolder = this.mkDir(this.configureFileObject.getParent(), this.configureRunFolder);
                                if (createdFolder != null) {
                                    ses.setRunDirectory(createdFolder.getPath());
                                }
                                break block37;
                            }
                            ses.setRunDirectory(this.configureFileObject.getParent().getPath());
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else if ("text/x-qtproject".equals(mime)) {
                        ses = (QMakeExecSupport)node.getCookie(QMakeExecSupport.class);
                        try {
                            ses.setArguments(new String[]{this.configureArguments});
                            if (this.configureRunFolder != null) {
                                FileObject createdFolder = this.mkDir(this.configureFileObject.getParent(), this.configureRunFolder);
                                if (createdFolder != null) {
                                    ses.setRunDirectory(createdFolder.getPath());
                                }
                            } else {
                                ses.setRunDirectory(this.configureFileObject.getParent().getPath());
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
            ExecutionListener listener = new ExecutionListener(){
                private RfsListenerImpl listener;

                public void executionStarted(int pid) {
                    if (ImportProject.this.executionEnvironment.isRemote()) {
                        this.listener = new RfsListenerImpl(ImportProject.this.executionEnvironment);
                        RfsListenerSupport.addListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                    }
                }

                public void executionFinished(int rc) {
                    if (rc == 0) {
                        ImportProject.this.importResult.put(Step.Configure, State.Successful);
                    } else {
                        ImportProject.this.importResult.put(Step.Configure, State.Fail);
                    }
                    if (this.listener != null) {
                        this.listener.download();
                        RfsListenerSupport.removeListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                    }
                    if (ImportProject.this.runMake && rc == 0) {
                        ImportProject.this.makeProject(ImportProject.this.configureLog);
                    } else {
                        ImportProject.this.switchModel(true);
                        ImportProject.this.postModelDiscovery(true);
                    }
                }
            };
            if (TRACE) {
                logger.log(Level.INFO, "#{0} {1}", new Object[]{this.configureFileObject, this.configureArguments});
            }
            if ("text/sh".equals(mime)) {
                task = ShellRunAction.performAction((Node)node, (ExecutionListener)listener, (Writer)outputListener, (Project)this.makeProject, null);
                if (task == null) {
                    throw new Exception("Cannot execute configure script");
                }
            } else if ("text/x-cmake".equals(mime)) {
                task = CMakeAction.performAction((Node)node, (ExecutionListener)listener, null, (Project)this.makeProject, null);
                if (task == null) {
                    throw new Exception("Cannot execute cmake");
                }
            } else if ("text/x-qtproject".equals(mime)) {
                task = QMakeAction.performAction((Node)node, (ExecutionListener)listener, null, (Project)this.makeProject, null);
                if (task == null) {
                    throw new Exception("Cannot execute qmake");
                }
            } else {
                if (TRACE) {
                    logger.log(Level.INFO, "#Configure script does not supported");
                }
                this.importResult.put(Step.Configure, State.Fail);
                this.importResult.put(Step.MakeClean, State.Skiped);
                this.switchModel(true);
                this.postModelDiscovery(true);
            }
        }
        catch (Throwable e) {
            logger.log(Level.INFO, "Cannot configure project", e);
            this.importResult.put(Step.Configure, State.Fail);
            this.importResult.put(Step.MakeClean, State.Skiped);
            this.switchModel(true);
            this.postModelDiscovery(true);
        }
    }

    private FileObject mkDir(FileObject parent, String relative) {
        if (relative != null) {
            try {
                relative = relative.replace('\\', '/');
                for (String segment : relative.split("/")) {
                    FileObject test;
                    if (parent == null) {
                        return null;
                    }
                    if (segment.isEmpty() || ".".equals(segment)) continue;
                    parent = "..".equals(segment) ? parent.getParent() : ((test = parent.getFileObject(segment, null)) != null ? test : parent.createFolder(segment));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            return parent;
        }
        return null;
    }

    private void downloadRemoteFile(File file) {
        if (file != null && !file.exists() && this.executionEnvironment.isRemote()) {
            String remoteFile = HostInfoProvider.getMapper((ExecutionEnvironment)this.executionEnvironment).getRemotePath(file.getAbsolutePath());
            try {
                if (HostInfoUtils.fileExists((ExecutionEnvironment)this.executionEnvironment, (String)remoteFile)) {
                    Future task = CommonTasksSupport.downloadFile((String)remoteFile, (ExecutionEnvironment)this.executionEnvironment, (String)file.getAbsolutePath(), null);
                    if (TRACE) {
                        logger.log(Level.INFO, "#download file {0}", file.getAbsolutePath());
                    }
                    task.get();
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (Throwable ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanConfigureLog(File logFile) {
        if (logFile != null && logFile.exists() && logFile.canRead()) {
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new FileReader(logFile));
                while ((line = in.readLine()) != null) {
                    int i = line.indexOf(configureCteatePattern);
                    if (i <= 0) continue;
                    String f = line.substring(i + configureCteatePattern.length()).trim();
                    this.downloadRemoteFile(CndFileUtils.createLocalFile((File)this.projectFolder, (String)f));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    private void makeProject(File logFile) {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        FileObject makeFileObject = null;
        if (this.makefilePath != null && this.makefilePath.length() > 0) {
            if (this.fullRemote) {
                CndUtils.assertAbsolutePathInConsole((String)this.makefilePath);
                makeFileObject = RemoteFileUtil.getFileObject((String)this.makefilePath, (ExecutionEnvironment)this.executionEnvironment);
            } else {
                makeFileObject = CndFileUtils.toFileObject((CharSequence)FileUtil.normalizePath((String)CndPathUtilitities.toAbsolutePath((String)this.projectFolder.getAbsolutePath(), (String)this.makefilePath)));
            }
        }
        if (!this.fullRemote && makeFileObject != null) {
            this.downloadRemoteFile(CndFileUtils.createLocalFile((String)makeFileObject.getPath()));
            makeFileObject = CndFileUtils.toFileObject((CharSequence)FileUtil.normalizePath((String)CndPathUtilitities.toAbsolutePath((String)this.projectFolder.getAbsolutePath(), (String)this.makefilePath)));
        }
        this.scanConfigureLog(logFile);
        if (CLEAN_COMMAND.equals(this.cleanCommand) && BUILD_COMMAND.equals(this.buildCommand)) {
            if (makeFileObject != null && makeFileObject.isValid()) {
                try {
                    DataObject dObj = DataObject.find((FileObject)makeFileObject);
                    Node node = dObj.getNodeDelegate();
                    MakeExecSupport mes = (MakeExecSupport)node.getCookie(MakeExecSupport.class);
                    if (mes != null) {
                        mes.setBuildDirectory(makeFileObject.getParent().getPath());
                    }
                    this.postClean(node);
                }
                catch (DataObjectNotFoundException ex) {
                    this.isFinished = true;
                }
            } else {
                this.switchModel(true);
                this.postModelDiscovery(true);
            }
        } else {
            this.postClean();
        }
    }

    private void postClean(final Node node) {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
            }

            public void executionFinished(int rc) {
                if (rc == 0) {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Fail);
                }
                ImportProject.this.postMake(node);
            }
        };
        String arguments = "";
        if (this.cleanCommand != null) {
            arguments = this.getArguments(this.cleanCommand);
        }
        if (arguments.length() == 0) {
            arguments = "clean";
        }
        if (TRACE) {
            logger.log(Level.INFO, "#make {0}", arguments);
        }
        try {
            Future task = MakeAction.execute((Node)node, (String)arguments, (ExecutionListener)listener, null, (Project)this.makeProject, null, null);
            if (task == null) {
                logger.log(Level.INFO, "Cannot execute make clean");
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void postClean() {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
            }

            public void executionFinished(int rc) {
                if (rc == 0) {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Fail);
                }
                ImportProject.this.postMake();
            }
        };
        if (TRACE) {
            logger.log(Level.INFO, "#{0}", this.cleanCommand);
        }
        try {
            ExecuteCommand ec = new ExecuteCommand(this.makeProject, this.workingDir, this.cleanCommand);
            Future<Integer> task = ec.performAction(listener, null, null);
            if (task == null) {
                logger.log(Level.INFO, "Cannot execute clean command");
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private ExecutionListener createMakeExecutionListener() {
        if (this.makeLog == null) {
            this.makeLog = ImportProject.createTempFile("make");
        }
        if (BuildTraceSupport.useBuildTrace() && BuildTraceSupport.supportedPlatforms(this.executionEnvironment)) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
                this.execLog = ImportProject.createTempFile("exec");
                this.execLog.deleteOnExit();
                if (this.executionEnvironment.isRemote()) {
                    this.remoteExecLog = hostInfo.getTempDir() + "/" + this.execLog.getName();
                }
            }
            catch (IOException ex) {
            }
            catch (ConnectionManager.CancellationException cancellationException) {
                // empty catch block
            }
        }
        return new ExecutionListener(){
            private RfsListenerImpl listener;

            public void executionStarted(int pid) {
                if (ImportProject.this.executionEnvironment.isRemote()) {
                    this.listener = new RfsListenerImpl(ImportProject.this.executionEnvironment);
                    RfsListenerSupport.addListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                }
            }

            public void executionFinished(int rc) {
                if (this.listener != null) {
                    this.listener.download();
                    RfsListenerSupport.removeListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                }
                if (rc == 0) {
                    ImportProject.this.importResult.put(Step.Make, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.Make, State.Fail);
                }
                if (ImportProject.this.executionEnvironment.isRemote() && ImportProject.this.execLog != null) {
                    try {
                        if (HostInfoUtils.fileExists((ExecutionEnvironment)ImportProject.this.executionEnvironment, (String)ImportProject.this.remoteExecLog)) {
                            Future task = CommonTasksSupport.downloadFile((String)ImportProject.this.remoteExecLog, (ExecutionEnvironment)ImportProject.this.executionEnvironment, (String)ImportProject.this.execLog.getAbsolutePath(), null);
                            if (TRACE) {
                                logger.log(Level.INFO, "#download file {0}", ImportProject.this.makeLog.getAbsolutePath());
                            }
                            task.get();
                        }
                    }
                    catch (Throwable ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        ImportProject.this.execLog = null;
                    }
                }
                ImportProject.this.discovery(rc, ImportProject.this.makeLog, ImportProject.this.execLog);
            }
        };
    }

    private void postMake(Node node) {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        ExecutionListener listener = this.createMakeExecutionListener();
        BufferedWriter outputListener = null;
        if (this.makeLog != null) {
            try {
                outputListener = new BufferedWriter(new FileWriter(this.makeLog));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        String arguments = "";
        if (this.buildCommand != null) {
            arguments = this.getArguments(this.buildCommand);
        }
        ExecutionSupport ses = (ExecutionSupport)node.getCookie(ExecutionSupport.class);
        List vars = ImportUtils.parseEnvironment((String)this.configureArguments);
        if (ses != null) {
            try {
                ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                if (this.execLog != null) {
                    vars.add("__CND_TOOLS__=" + BuildTraceSupport.CND_TOOLS_VALUE);
                    if (this.executionEnvironment.isLocal()) {
                        vars.add("__CND_BUILD_LOG__=" + this.execLog.getAbsolutePath());
                    } else {
                        vars.add("__CND_BUILD_LOG__=" + this.remoteExecLog);
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (TRACE) {
            logger.log(Level.INFO, "#make {0}", arguments);
        }
        try {
            Future task = MakeAction.execute((Node)node, (String)arguments, (ExecutionListener)listener, (Writer)outputListener, (Project)this.makeProject, (List)vars, null);
            if (task == null) {
                logger.log(Level.INFO, "Cannot execute make");
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void postMake() {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        ExecutionListener listener = this.createMakeExecutionListener();
        BufferedWriter outputListener = null;
        if (this.makeLog != null) {
            try {
                outputListener = new BufferedWriter(new FileWriter(this.makeLog));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        List vars = ImportUtils.parseEnvironment((String)this.configureArguments);
        if (this.execLog != null) {
            vars.add("__CND_TOOLS__=" + BuildTraceSupport.CND_TOOLS_VALUE);
            if (this.executionEnvironment.isLocal()) {
                vars.add("__CND_BUILD_LOG__=" + this.execLog.getAbsolutePath());
            } else {
                vars.add("__CND_BUILD_LOG__=" + this.remoteExecLog);
            }
        }
        if (TRACE) {
            logger.log(Level.INFO, "#{0}", this.buildCommand);
        }
        try {
            ExecuteCommand ec = new ExecuteCommand(this.makeProject, this.workingDir, this.buildCommand);
            Future<Integer> task = ec.performAction(listener, outputListener, vars);
            if (task == null) {
                logger.log(Level.INFO, "Cannot execute build command");
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String getArguments(String command) {
        String arguments = this._getArguments(command);
        int i = arguments.indexOf("-f ");
        if (i >= 0) {
            String res = arguments.substring(0, i);
            int j = (arguments = arguments.substring(i + 3).trim()).indexOf(32);
            if (j < 0) {
                return res;
            }
            return res + arguments.substring(j).trim();
        }
        return arguments;
    }

    private String _getArguments(String command) {
        if (command.startsWith("\"")) {
            int i = command.indexOf(34, 1);
            if (i > 0) {
                return command.substring(i).trim();
            }
            return "";
        }
        if (command.startsWith("'")) {
            int i = command.indexOf(39, 1);
            if (i > 0) {
                return command.substring(i).trim();
            }
            return "";
        }
        int i = command.indexOf(32);
        if (i > 0) {
            return command.substring(i).trim();
        }
        return "";
    }

    private DiscoveryProvider getProvider(String id) {
        Lookup.Result providers = Lookup.getDefault().lookup(new Lookup.Template(DiscoveryProvider.class));
        for (DiscoveryProvider provider : providers.allInstances()) {
            provider.clean();
            if (!id.equals(provider.getID())) continue;
            return provider;
        }
        return null;
    }

    private void waitConfigurationDescriptor() {
        ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        provider.getConfigurationDescriptor(true);
    }

    private void discovery(int rc, File makeLog, File execLog) {
        try {
            if (!this.isProjectOpened()) {
                this.isFinished = true;
                return;
            }
            this.waitConfigurationDescriptor();
            boolean done = false;
            boolean exeLogDone = false;
            if (!this.manualCA) {
                HashMap<String, Object> map;
                DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
                if (rc == 0) {
                    if (execLog != null && extension != null) {
                        map = new HashMap<String, Object>();
                        map.put("DW:rootFolder", this.nativeProjectPath);
                        map.put("DW:execLogFile", execLog.getAbsolutePath());
                        map.put("DW:consolidationLevel", this.consolidationStrategy);
                        if (extension.canApply(map, this.makeProject)) {
                            if (TRACE) {
                                logger.log(Level.INFO, "#start discovery by exec log file {0}", execLog.getAbsolutePath());
                            }
                            try {
                                done = true;
                                exeLogDone = true;
                                extension.apply(map, this.makeProject);
                                this.importResult.put(Step.DiscoveryLog, State.Successful);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                            }
                        } else if (TRACE) {
                            logger.log(Level.INFO, "#discovery cannot be done by exec log file {0}", execLog.getAbsolutePath());
                        }
                        map.put("DW:execLogFile", null);
                    }
                    if (extension != null && !done) {
                        block41: {
                            map = new HashMap();
                            map.put("DW:rootFolder", this.nativeProjectPath);
                            map.put("DW:consolidationLevel", this.consolidationStrategy);
                            if (extension.canApply(map, this.makeProject)) {
                                DiscoveryProvider provider = (DiscoveryProvider)map.get("DW:provider");
                                if (provider != null && "make-log".equals(provider.getID())) {
                                    if (TRACE) {
                                        logger.log(Level.INFO, "#start discovery by log file {0}", provider.getProperty("make-log-file").getValue());
                                    }
                                } else if (TRACE) {
                                    logger.log(Level.INFO, "#start discovery by object files");
                                }
                                try {
                                    done = true;
                                    extension.apply(map, this.makeProject);
                                    if (provider != null && "make-log".equals(provider.getID())) {
                                        this.importResult.put(Step.DiscoveryLog, State.Successful);
                                        break block41;
                                    }
                                    this.importResult.put(Step.DiscoveryDwarf, State.Successful);
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace(System.err);
                                }
                            } else if (TRACE) {
                                logger.log(Level.INFO, "#no dwarf information found in object files");
                            }
                        }
                        this.buildArifactWasAnalyzed = true;
                    }
                }
                if (!done && makeLog != null) {
                    if (extension != null) {
                        map = new HashMap();
                        map.put("DW:rootFolder", this.nativeProjectPath);
                        map.put("DW:logFile", makeLog.getAbsolutePath());
                        map.put("DW:consolidationLevel", this.consolidationStrategy);
                        if (extension.canApply(map, this.makeProject)) {
                            if (TRACE) {
                                logger.log(Level.INFO, "#start discovery by log file {0}", makeLog.getAbsolutePath());
                            }
                            try {
                                done = true;
                                extension.apply(map, this.makeProject);
                                this.importResult.put(Step.DiscoveryLog, State.Successful);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                            }
                        } else if (TRACE) {
                            logger.log(Level.INFO, "#discovery cannot be done by log file {0}", makeLog.getAbsolutePath());
                        }
                    }
                } else if (done && makeLog != null && !exeLogDone) {
                    if (!this.isProjectOpened()) {
                        return;
                    }
                    if (extension != null) {
                        map = new HashMap();
                        map.put("DW:rootFolder", this.nativeProjectPath);
                        map.put("DW:logFile", makeLog.getAbsolutePath());
                        map.put("DW:consolidationLevel", this.consolidationStrategy);
                        if (extension.canApply(map, this.makeProject)) {
                            if (TRACE) {
                                logger.log(Level.INFO, "#start fix macros by log file {0}", makeLog.getAbsolutePath());
                            }
                            List confs = (List)map.get("DW:configurations");
                            this.fixMacros(confs);
                            this.importResult.put(Step.FixMacros, State.Successful);
                        } else if (TRACE) {
                            logger.log(Level.INFO, "#fix macros cannot be done by log file {0}", makeLog.getAbsolutePath());
                        }
                    }
                }
            }
            this.switchModel(true);
            if (!done) {
                this.postModelDiscovery(true);
            } else {
                this.postModelDiscovery(false);
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void fixMacros(List<ProjectConfiguration> confs) {
        for (ProjectConfiguration conf : confs) {
            List<FileConfiguration> files = conf.getFiles();
            for (FileConfiguration fileConf : files) {
                Item item;
                if (fileConf.getUserMacros().size() <= 0 || (item = this.findByNormalizedName(new File(fileConf.getFilePath()))) == null) continue;
                if (TRACE) {
                    logger.log(Level.FINE, "#fix macros for file {0}", fileConf.getFilePath());
                }
                ProjectBridge.fixFileMacros(fileConf.getUserMacros(), item);
            }
        }
        this.saveMakeConfigurationDescriptor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMakeConfigurationDescriptor(ProjectBase p) {
        if (p != null) {
            p.enableProjectListeners(false);
        }
        try {
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
            makeConfigurationDescriptor.setModified();
            makeConfigurationDescriptor.save();
            makeConfigurationDescriptor.checkForChangedItems(this.makeProject, null, null);
        }
        finally {
            if (p != null) {
                p.enableProjectListeners(true);
            }
        }
        if (TRACE) {
            logger.log(Level.INFO, "#save configuration descriptor");
        }
    }

    private void postModelDiscovery(final boolean isFull) {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        CsmModel model = CsmModelAccessor.getModel();
        if (model instanceof ModelImpl && this.makeProject != null) {
            final NativeProject np = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            final CsmProject p = model.getProject((Object)np);
            if (p == null) {
                if (TRACE) {
                    logger.log(Level.INFO, "#discovery cannot be done by model");
                }
                this.isFinished = true;
                return;
            }
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject project) {
                    if (project.equals(p)) {
                        try {
                            listeners.remove(p);
                            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                            if (TRACE) {
                                logger.log(Level.INFO, "#model ready, explore model");
                            }
                            if (isFull) {
                                ImportProject.this.modelDiscovery();
                            } else {
                                ImportProject.this.fixExcludedHeaderFiles();
                            }
                            ImportProject.this.showFollwUp(np);
                        }
                        catch (Throwable ex) {
                            ImportProject.this.isFinished = true;
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            };
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
            listeners.put(p, (CsmProgressListener)listener);
        } else {
            this.isFinished = true;
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public Map<Step, State> getState() {
        return new EnumMap<Step, State>(this.importResult);
    }

    public Project getProject() {
        return this.makeProject;
    }

    public void setUILessMode() {
        this.isUILessMode = true;
    }

    public void setConfigureLog(File configureLog) {
        this.configureLog = configureLog;
    }

    public void setMakeLog(File makeLog) {
        this.makeLog = makeLog;
    }

    private void showFollwUp(final NativeProject project) {
        this.isFinished = true;
        if (this.isUILessMode) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FollowUp.showFollowUp(ImportProject.this, project);
            }
        });
    }

    Project getMakeProject() {
        return this.makeProject;
    }

    Map<Step, State> getImportResult() {
        return this.importResult;
    }

    private void fixExcludedHeaderFiles() {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        if (TRACE) {
            logger.log(Level.INFO, "#start fixing excluded header files by model");
        }
        DiscoveryManagerImpl.fixExcludedHeaderFiles(this.makeProject, logger);
        this.importResult.put(Step.FixExcluded, State.Successful);
    }

    private Item findByNormalizedName(File file) {
        if (this.normalizedItems == null) {
            this.normalizedItems = DiscoveryManagerImpl.initNormalizedNames(this.makeProject);
        }
        String path = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
        return this.normalizedItems.get(path);
    }

    private void modelDiscovery() {
        DiscoveryExtensionInterface extension;
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DW:rootFolder", this.nativeProjectPath);
        map.put("DW:invokeProvider", Boolean.TRUE);
        map.put("DW:consolidationLevel", this.consolidationStrategy);
        boolean does = false;
        if (!this.manualCA && !this.buildArifactWasAnalyzed && (extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class)) != null) {
            if (extension.canApply(map, this.makeProject)) {
                if (TRACE) {
                    logger.log(Level.INFO, "#start discovery by object files");
                }
                try {
                    extension.apply(map, this.makeProject);
                    this.importResult.put(Step.DiscoveryDwarf, State.Successful);
                    does = true;
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            } else if (TRACE) {
                logger.log(Level.INFO, "#no dwarf information found in object files");
            }
        }
        if (!does) {
            if (!this.isProjectOpened() || !this.isModelAvaliable()) {
                this.isFinished = true;
                return;
            }
            if (TRACE) {
                logger.log(Level.INFO, "#start discovery by model");
            }
            map.put("DW:rootFolder", this.nativeProjectPath);
            DiscoveryProvider provider = this.getProvider("model-folder");
            provider.getProperty("folder").setValue(this.nativeProjectPath);
            if (this.manualCA) {
                provider.getProperty("prefer-local").setValue(Boolean.TRUE);
            }
            map.put("DW:provider", provider);
            map.put("DW:invokeProvider", Boolean.TRUE);
            DiscoveryDescriptor descriptor = DiscoveryWizardDescriptor.adaptee(map);
            descriptor.setProject(this.makeProject);
            SelectConfigurationPanel.buildModel(descriptor);
            try {
                DiscoveryProjectGeneratorImpl generator = new DiscoveryProjectGeneratorImpl(descriptor);
                generator.makeProject();
                this.importResult.put(Step.DiscoveryModel, State.Successful);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void switchModel(boolean state) {
        CsmModel model = CsmModelAccessor.getModel();
        if (model instanceof ModelImpl && this.makeProject != null) {
            NativeProject np = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            if (state) {
                if (TRACE) {
                    logger.log(Level.INFO, "#enable model for {0}", np.getProjectDisplayName());
                }
                ((ModelImpl)model).enableProject(np);
            } else {
                if (TRACE) {
                    logger.log(Level.INFO, "#disable model for {0}", np.getProjectDisplayName());
                }
                ((ModelImpl)model).disableProject(np);
            }
        }
    }

    private boolean isModelAvaliable() {
        CsmModel model = CsmModelAccessor.getModel();
        if (model != null && this.makeProject != null) {
            return CsmModelAccessor.getModel().getProject((Object)this.makeProject) != null;
        }
        return false;
    }

    static {
        if (TRACE) {
            logger.setLevel(Level.ALL);
        }
        RP = new RequestProcessor(ImportProject.class.getName(), 2);
        listeners = new WeakHashMap<CsmProject, CsmProgressListener>();
    }

    static final class RfsListenerImpl
    implements RfsListener {
        private final Map<String, File> storage = new HashMap<String, File>();
        private final ExecutionEnvironment execEnv;

        RfsListenerImpl(ExecutionEnvironment execEnv) {
            this.execEnv = execEnv;
        }

        public void fileChanged(ExecutionEnvironment env, File localFile, String remotePath) {
            if (env.equals(this.execEnv)) {
                this.storage.put(remotePath, localFile);
            }
        }

        void download() {
            HashMap<String, File> copy = new HashMap<String, File>(this.storage);
            for (Map.Entry entry : copy.entrySet()) {
                this.downloadImpl((String)entry.getKey(), (File)entry.getValue());
            }
        }

        private void downloadImpl(String remoteFile, File localFile) {
            try {
                Future task = CommonTasksSupport.downloadFile((String)remoteFile, (ExecutionEnvironment)this.execEnv, (String)localFile.getAbsolutePath(), null);
                if (TRACE) {
                    logger.log(Level.INFO, "#download file {0}", localFile.getAbsolutePath());
                }
                task.get();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static enum Step {
        Project,
        Configure,
        MakeClean,
        Make,
        DiscoveryDwarf,
        DiscoveryLog,
        FixMacros,
        DiscoveryModel,
        FixExcluded;

    }

    public static enum State {
        Successful,
        Fail,
        Skiped;

    }
}

