/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class LegalCombinationOfAnnotations
extends JPAClassRule {
    private static Collection<IllegalCombination> illegalClassAnnotationCombinations = Arrays.asList(new IllegalCombination(Collections.singleton("javax.persistence.Entity"), Arrays.asList("javax.persistence.Embeddable", "javax.persistence.MappedSuperclass")), new IllegalCombination(Collections.singleton("javax.persistence.Table"), Collections.singleton("javax.persistence.MappedSuperclass")));
    private static Collection<IllegalCombination> illegalAttrAnnotationCombinations = Arrays.asList(new Object[0]);

    public LegalCombinationOfAnnotations() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.MAPPED_SUPERCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        ArrayList<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
        Collection<String> annotationsOnClass = ModelUtils.extractAnnotationNames(subject);
        for (IllegalCombination illegalCombination : illegalClassAnnotationCombinations) {
            illegalCombination.check(ctx, subject, problemsFound, annotationsOnClass);
        }
        for (Element element : subject.getEnclosedElements()) {
            Collection<String> annotationsOnElement = ModelUtils.extractAnnotationNames(element);
            for (IllegalCombination ic : illegalAttrAnnotationCombinations) {
                ic.check(ctx, element, problemsFound, annotationsOnElement);
            }
        }
        return problemsFound.toArray(new ErrorDescription[problemsFound.size()]);
    }

    private static class IllegalCombination {
        private Collection<String> set1;
        private Collection<String> set2;

        IllegalCombination(Collection<String> set1, Collection<String> set2) {
            this.set1 = set1;
            this.set2 = set2;
        }

        void check(ProblemContext ctx, Element elem, Collection<ErrorDescription> errorList, Collection<String> annotations) {
            for (String ann : annotations) {
                if (!this.set1.contains(ann)) continue;
                for (String forbiddenAnn : this.set2) {
                    if (!annotations.contains(forbiddenAnn)) continue;
                    ErrorDescription error = Rule.createProblem(elem, ctx, NbBundle.getMessage(LegalCombinationOfAnnotations.class, (String)"MSG_IllegalAnnotationCombination", (Object)ModelUtils.shortAnnotationName(ann), (Object)ModelUtils.shortAnnotationName(forbiddenAnn)));
                    errorList.add(error);
                }
            }
        }
    }
}

