/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.ArrayList;
import java.util.Arrays;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.JPAAnnotations;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class JPAAnnotsOnlyOnAccesor
extends JPAClassRule {
    public JPAAnnotsOnlyOnAccesor() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.MAPPED_SUPERCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        if (((JPAProblemContext)ctx).getAccessType() != AccessType.PROPERTY) {
            return null;
        }
        ArrayList<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
        block0: for (ExecutableElement method : ElementFilter.methodsIn(subject.getEnclosedElements())) {
            if (this.isAccessor(method)) continue;
            for (String annotName : ModelUtils.extractAnnotationNames(method)) {
                if (!JPAAnnotations.MEMBER_LEVEL.contains(annotName)) continue;
                ErrorDescription error = JPAAnnotsOnlyOnAccesor.createProblem(method, ctx, NbBundle.getMessage(JPAAnnotsOnlyOnAccesor.class, (String)"MSG_JPAAnnotsOnlyOnAccesor", (Object)ModelUtils.shortAnnotationName(annotName)));
                problemsFound.add(error);
                continue block0;
            }
        }
        return problemsFound.toArray(new ErrorDescription[problemsFound.size()]);
    }

    private boolean isAccessor(ExecutableElement method) {
        if (!method.getParameters().isEmpty()) {
            return false;
        }
        String methodName = method.getSimpleName().toString();
        if (methodName.startsWith("get")) {
            return true;
        }
        return this.isBoolean(((Object)method.getReturnType()).toString()) && methodName.startsWith("is");
    }

    private boolean isBoolean(String type) {
        return "boolean".equals(type) || "java.lang.Boolean".equals(type);
    }
}

