/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.hints;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.groovy.editor.actions.FixImportsHelper;
import org.netbeans.modules.groovy.editor.api.GroovyCompilerErrorID;
import org.netbeans.modules.groovy.editor.api.parser.GroovyError;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyErrorRule;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ClassNotFoundRule
extends GroovyErrorRule {
    public static final Logger LOG = Logger.getLogger(ClassNotFoundRule.class.getName());
    private final String DESC = NbBundle.getMessage(ClassNotFoundRule.class, (String)"FixImportsHintDescription");
    private final FixImportsHelper helper = new FixImportsHelper();

    @Override
    public Set<GroovyCompilerErrorID> getCodes() {
        LOG.log(Level.FINEST, "getCodes()");
        HashSet<GroovyCompilerErrorID> result = new HashSet<GroovyCompilerErrorID>();
        result.add(GroovyCompilerErrorID.CLASS_NOT_FOUND);
        return result;
    }

    @Override
    public void run(GroovyRuleContext context, GroovyError error, List<Hint> result) {
        LOG.log(Level.FINEST, "run()");
        String desc = error.getDescription();
        if (desc == null) {
            LOG.log(Level.FINEST, "desc == null");
            return;
        }
        LOG.log(Level.FINEST, "Processing : {0}", desc);
        String missingClassName = FixImportsHelper.getMissingClassName(desc);
        if (missingClassName == null) {
            return;
        }
        FileObject fo = context.parserResult.getSnapshot().getSource().getFileObject();
        List<FixImportsHelper.ImportCandidate> importCandidates = this.helper.getImportCandidate(fo, missingClassName);
        if (importCandidates.isEmpty()) {
            return;
        }
        int DEFAULT_PRIORITY = 292;
        int lineStart = 0;
        int lineEnd = 0;
        try {
            lineStart = Utilities.getRowStart((BaseDocument)context.doc, (int)error.getStartPosition());
            lineEnd = Utilities.getRowEnd((BaseDocument)context.doc, (int)error.getEndPosition());
        }
        catch (BadLocationException ex) {
            LOG.log(Level.FINEST, "Processing : {0}", ex);
            return;
        }
        OffsetRange range = new OffsetRange(lineStart, lineEnd);
        for (FixImportsHelper.ImportCandidate candidate : importCandidates) {
            ArrayList<AddImportFix> fixList = new ArrayList<AddImportFix>(1);
            String fqn = candidate.getFqnName();
            AddImportFix fixToApply = new AddImportFix(fo, fqn);
            fixList.add(fixToApply);
            Hint descriptor = new Hint((Rule)this, fixToApply.getDescription(), fo, range, fixList, DEFAULT_PRIORITY);
            result.add(descriptor);
        }
    }

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    public String getDisplayName() {
        return this.DESC;
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    private class AddImportFix
    implements HintFix {
        String HINT_PREFIX = NbBundle.getMessage(ClassNotFoundRule.class, (String)"ClassNotFoundRuleHintDescription");
        FileObject fo;
        String fqn;

        public AddImportFix(FileObject fo, String fqn) {
            this.fo = fo;
            this.fqn = fqn;
        }

        public String getDescription() {
            return this.HINT_PREFIX + " " + this.fqn;
        }

        public void implement() throws Exception {
            ClassNotFoundRule.this.helper.doImport(this.fo, this.fqn);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

