/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.reflection.CachedClass;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.java.Utilities;

public final class MetaElementHandler {
    private static final Logger LOG = Logger.getLogger(MetaElementHandler.class.getName());
    private final ParserResult info;

    private MetaElementHandler(ParserResult info) {
        this.info = info;
    }

    public static MetaElementHandler forCompilationInfo(ParserResult info) {
        return new MetaElementHandler(info);
    }

    public Map<MethodSignature, ? extends CompletionItem> getMethods(String className, String prefix, int anchor, boolean nameOnly) {
        Class<?> clz;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.FINE, "Class.forName() failed: {0}", e.getMessage());
            return Collections.emptyMap();
        }
        catch (NoClassDefFoundError err) {
            LOG.log(Level.FINE, "Class.forName() failed: {0}", err.getMessage());
            return Collections.emptyMap();
        }
        MetaClass metaClz = GroovySystem.getMetaClassRegistry().getMetaClass(clz);
        if (metaClz != null) {
            HashMap<MethodSignature, CompletionItem.MetaMethodItem> result = new HashMap<MethodSignature, CompletionItem.MetaMethodItem>();
            LOG.log(Level.FINEST, "Adding groovy methods --------------------------");
            for (MetaMethod method : metaClz.getMetaMethods()) {
                LOG.log(Level.FINEST, ((Object)method).toString());
                this.populateProposal(clz, method, prefix, anchor, result, nameOnly);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public Map<FieldSignature, ? extends CompletionItem> getFields(String className, String prefix, int anchor) {
        Class<?> clz;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.FINEST, "Class.forName() failed: {0}", e.getMessage());
            return Collections.emptyMap();
        }
        catch (NoClassDefFoundError err) {
            LOG.log(Level.FINEST, "Class.forName() failed: {0}", err.getMessage());
            return Collections.emptyMap();
        }
        MetaClass metaClz = GroovySystem.getMetaClassRegistry().getMetaClass(clz);
        if (metaClz != null) {
            HashMap<FieldSignature, CompletionItem.FieldItem> result = new HashMap<FieldSignature, CompletionItem.FieldItem>();
            LOG.log(Level.FINEST, "Adding groovy methods --------------------------");
            for (MetaProperty field : metaClz.getProperties()) {
                LOG.log(Level.FINEST, field.toString());
                MetaProperty prop = field;
                if (!prop.getName().startsWith(prefix)) continue;
                result.put(new FieldSignature(prop.getName()), new CompletionItem.FieldItem(prop.getName(), prop.getModifiers(), anchor, this.info, prop.getType().getSimpleName()));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private void populateProposal(Class clz, Object method, String prefix, int anchor, Map<MethodSignature, CompletionItem.MetaMethodItem> methodList, boolean nameOnly) {
        MetaMethod mm;
        if (method != null && method instanceof MetaMethod && (mm = (MetaMethod)method).getName().startsWith(prefix)) {
            LOG.log(Level.FINEST, "Found matching method: {0}", mm.getName());
            CompletionItem.MetaMethodItem item = new CompletionItem.MetaMethodItem(clz, mm, anchor, true, nameOnly);
            this.addOrReplaceItem(methodList, item);
        }
    }

    private void addOrReplaceItem(Map<MethodSignature, CompletionItem.MetaMethodItem> methodItemList, CompletionItem.MetaMethodItem itemToStore) {
        MetaMethod methodToStore = itemToStore.getMethod();
        int toStoreDistance = methodToStore.getDeclaringClass().getSuperClassDistance();
        for (CompletionItem.MetaMethodItem methodItem : methodItemList.values()) {
            MetaMethod listMethod = methodItem.getMethod();
            if (!listMethod.getName().equals(methodToStore.getName()) || !MetaElementHandler.isSame(listMethod, methodToStore)) continue;
            if (listMethod.getReturnType().isAssignableFrom(methodToStore.getReturnType()) && listMethod.getDeclaringClass().getSuperClassDistance() <= toStoreDistance) {
                LOG.log(Level.FINEST, "Remove existing method: {0}", methodToStore.getName());
                methodItemList.remove(this.getSignature(listMethod));
                break;
            }
            LOG.log(Level.FINEST, "Not removing existing method: {0}", listMethod.getName());
            return;
        }
        methodItemList.put(this.getSignature(methodToStore), itemToStore);
    }

    private static boolean isSame(MetaMethod listMethod, MetaMethod methodToStore) {
        if (!listMethod.getName().equals(methodToStore.getName())) {
            return false;
        }
        int mask = 15;
        if ((listMethod.getModifiers() & mask) != (methodToStore.getModifiers() & mask)) {
            return false;
        }
        return MetaElementHandler.isSame(listMethod.getParameterTypes(), methodToStore.getParameterTypes());
    }

    private static boolean isSame(CachedClass[] parameters1, CachedClass[] parameters2) {
        if (parameters1.length == parameters2.length) {
            int size = parameters1.length;
            for (int i = 0; i < size; ++i) {
                if (parameters1[i] == parameters2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private MethodSignature getSignature(MetaMethod method) {
        String[] parameters = new String[method.getParameterTypes().length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = Utilities.translateClassLoaderTypeName(method.getParameterTypes()[i].getName());
        }
        return new MethodSignature(method.getName(), parameters);
    }
}

