/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.util.Exceptions;

public class InstallUnitWizardModel
extends OperationWizardModel {
    private InstallSupport.Installer installer = null;
    private OperationWizardModel.OperationType doOperation;
    private static Set<String> approvedLicences = new HashSet<String>();
    private InstallSupport support;
    private OperationContainer<InstallSupport> updateContainer = null;
    private OperationContainer<OperationSupport> customContainer = Containers.forCustomInstall();
    private PluginManagerUI manager;
    private boolean allLicensesTouched = false;

    public InstallUnitWizardModel(OperationWizardModel.OperationType doOperation, OperationContainer<InstallSupport> updateContainer) {
        this.doOperation = doOperation;
        this.updateContainer = updateContainer;
    }

    public InstallUnitWizardModel(OperationWizardModel.OperationType doOperation) {
        this.doOperation = doOperation;
        assert (this.getBaseContainer() != null) : "The base container for operation " + (Object)((Object)doOperation) + " must exist!";
        this.updateContainer = this.getBaseContainer();
    }

    @Override
    public OperationWizardModel.OperationType getOperation() {
        return this.doOperation;
    }

    @Override
    public OperationContainer getBaseContainer() {
        OperationContainer c = this.getBaseContainerImpl();
        assert (this.support != null || c.listAll().isEmpty()) : "Non empty container: " + c + " but null support";
        return c;
    }

    private OperationContainer getBaseContainerImpl() {
        if (this.updateContainer != null) {
            this.support = (InstallSupport)this.updateContainer.getSupport();
            return this.updateContainer;
        }
        OperationContainer<InstallSupport> c = null;
        switch (this.getOperation()) {
            case INSTALL: {
                c = Containers.forAvailable();
                this.support = (InstallSupport)c.getSupport();
                break;
            }
            case UPDATE: {
                c = Containers.forUpdate();
                this.support = (InstallSupport)c.getSupport();
                break;
            }
            case LOCAL_DOWNLOAD: {
                OperationContainer<InstallSupport> forUpdateNbms = Containers.forUpdateNbms();
                OperationContainer<InstallSupport> forAvailableNbms = Containers.forAvailableNbms();
                if (forUpdateNbms.listAll().isEmpty()) {
                    c = forAvailableNbms;
                } else {
                    c = forUpdateNbms;
                    for (OperationContainer.OperationInfo i : forAvailableNbms.listAll()) {
                        c.add(i.getUpdateElement());
                    }
                    assert (forAvailableNbms.listInvalid().isEmpty()) : "Containers.forAvailableNbms().listInvalid() should be empty but " + forAvailableNbms.listInvalid();
                    forAvailableNbms.removeAll();
                }
                this.support = (InstallSupport)c.getSupport();
                this.updateContainer = c;
            }
        }
        return c;
    }

    @Override
    public OperationContainer<OperationSupport> getCustomHandledContainer() {
        return this.customContainer;
    }

    public boolean allLicensesApproved() {
        boolean res = true;
        for (UpdateElement el : this.getAllUpdateElements()) {
            if (el.getLicence() == null || approvedLicences.contains(el.getLicence())) continue;
            res = false;
            break;
        }
        this.allLicensesTouched = true;
        return res;
    }

    public boolean allLicensesTouched() {
        return this.allLicensesTouched;
    }

    public void addApprovedLicenses(Collection<String> licences) {
        approvedLicences.addAll(licences);
        this.allLicensesTouched = false;
    }

    public InstallSupport getInstallSupport() {
        return this.support;
    }

    public void setInstaller(InstallSupport.Installer i) {
        this.installer = i;
    }

    public InstallSupport.Installer getInstaller() {
        return this.installer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCleanup(boolean cancel) throws OperationException {
        try {
            if (cancel) {
                OperationSupport osupp;
                if (this.support != null) {
                    this.support.doCancel();
                }
                if (this.getBaseContainer().getSupport() instanceof InstallSupport) {
                    if (OperationWizardModel.OperationType.LOCAL_DOWNLOAD == this.getOperation()) {
                        InstallSupport usupp;
                        InstallSupport asupp = (InstallSupport)Containers.forAvailableNbms().getSupport();
                        if (asupp != null) {
                            asupp.doCancel();
                        }
                        if ((usupp = (InstallSupport)Containers.forUpdateNbms().getSupport()) != null) {
                            usupp.doCancel();
                        }
                        Containers.forAvailableNbms().removeAll();
                        Containers.forUpdateNbms().removeAll();
                    } else {
                        InstallSupport isupp = (InstallSupport)this.getBaseContainer().getSupport();
                        if (isupp != null) {
                            isupp.doCancel();
                        }
                    }
                } else {
                    osupp = (OperationSupport)this.getBaseContainer().getSupport();
                    if (osupp != null) {
                        osupp.doCancel();
                    }
                }
                osupp = (OperationSupport)this.getCustomHandledContainer().getSupport();
                if (osupp != null) {
                    osupp.doCancel();
                }
            }
        }
        catch (Exception x) {
            Exceptions.printStackTrace((Throwable)x);
        }
        finally {
            super.doCleanup(false);
        }
    }

    public PluginManagerUI getPluginManager() {
        return this.manager;
    }

    public void setPluginManager(PluginManagerUI manager) {
        this.manager = manager;
    }
}

