/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorPhoneNumber
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private String label;
    private TypeID parentTypeID;

    private PropertyEditorPhoneNumber(String label, String ucLabel, TypeID parentTypeID) {
        super(ucLabel);
        this.label = label;
        this.parentTypeID = parentTypeID;
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.label = null;
    }

    public static PropertyEditorPhoneNumber createInstance(String label, String ucLabel) {
        return new PropertyEditorPhoneNumber(label, ucLabel, null);
    }

    public static PropertyEditorPhoneNumber createInstance(String label, String ucLabel, TypeID parentTypeID) {
        return new PropertyEditorPhoneNumber(label, ucLabel, parentTypeID);
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.label);
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor();
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        Object valueValue = ((PropertyValue)super.getValue()).getPrimitiveValue();
        return String.valueOf(valueValue);
    }

    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue value) {
        if (value != null) {
            this.customEditor.setText(String.valueOf(value.getPrimitiveValue()));
        } else {
            this.customEditor.setText("");
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private void saveValue(String text) {
        text = text.replaceAll("[^0-9]", "");
        super.setValue((Object)MidpTypes.createStringValue((String)text));
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public Boolean canEditAsText() {
        PropertyValue value;
        if (!this.isCurrentValueAUserCodeType() && (value = (PropertyValue)super.getValue()) == null) {
            return false;
        }
        return false;
    }

    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            final DesignComponent[] parent = new DesignComponent[1];
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    parent[0] = _component.getParentComponent();
                }
            });
            if (parent[0] != null && this.parentTypeID.equals((Object)parent[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    DocumentListener,
    FocusListener {
        private JTextField textField;

        public CustomEditor() {
            PropertyEditorPhoneNumber.this.radioButton.addFocusListener(this);
            this.initComponents();
        }

        void cleanUp() {
            if (this.textField != null && this.textField.getDocument() != null) {
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.textField = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.textField.getAccessibleContext().setAccessibleName(PropertyEditorPhoneNumber.this.radioButton.getAccessibleContext().getAccessibleName());
            this.textField.getAccessibleContext().setAccessibleDescription(PropertyEditorPhoneNumber.this.radioButton.getAccessibleContext().getAccessibleDescription());
            this.add((Component)this.textField, "South");
        }

        public void setText(String text) {
            this.textField.setText(text);
        }

        public String getText() {
            return this.textField.getText();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                PropertyEditorPhoneNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                PropertyEditorPhoneNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        private void checkNumberStatus() {
            if (!Pattern.matches("[+\\d\\-]+", this.textField.getText())) {
                PropertyEditorPhoneNumber.this.displayWarning(NbBundle.getMessage(PropertyEditorPhoneNumber.class, (String)"LBL_PhoneNumber_Warning"));
            } else {
                PropertyEditorPhoneNumber.this.clearErrorStatus();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == PropertyEditorPhoneNumber.this.radioButton || e.getSource() == this.textField) {
                this.checkNumberStatus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            PropertyEditorPhoneNumber.this.clearErrorStatus();
        }
    }
}

