/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.support.ArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListElementEventSourceCD;
import org.netbeans.modules.vmd.midpnb.propertyeditors.PropertyEditorButtonGroup;
import org.netbeans.modules.vmd.midpnb.propertyeditors.SVGListPropertyCustomEditor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorListModel
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private SVGListPropertyCustomEditor myCustomEditor;
    private JRadioButton myRadioButton;
    private String myModelText;

    private PropertyEditorListModel(String userCodeLabel, String modelText) {
        super(userCodeLabel);
        this.myModelText = modelText;
    }

    public static PropertyEditorListModel createInstance(String label, String modelText) {
        return new PropertyEditorListModel(label, modelText);
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.myCustomEditor != null) {
            this.myCustomEditor.cleanUp();
            this.myCustomEditor = null;
        }
        this.myRadioButton = null;
    }

    public boolean executeInsideWriteTransaction() {
        return ((DesignComponent)this.component.get()).getType() != SVGListCD.TYPEID;
    }

    public boolean isExecuteInsideWriteTransactionUsed() {
        PropertyValue.Kind kind = null;
        if (this.getValue() instanceof PropertyValue) {
            kind = ((PropertyValue)this.getValue()).getKind();
        }
        if (((DesignComponent)this.component.get()).getType() == SVGListCD.TYPEID && kind != PropertyValue.Kind.USERCODE) {
            return true;
        }
        if (((DesignComponent)this.component.get()).getType() == SVGListCD.TYPEID && kind == PropertyValue.Kind.USERCODE) {
            ((DesignComponent)this.component.get()).getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    ((DesignComponent)PropertyEditorListModel.this.component.get()).writeProperty("listElements", PropertyValue.createNull());
                    HashSet children = new HashSet(((DesignComponent)PropertyEditorListModel.this.component.get()).getComponents());
                    for (DesignComponent child : children) {
                        ((DesignComponent)PropertyEditorListModel.this.component.get()).getDocument().deleteComponent(child);
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PropertyEditorListModel.this.myCustomEditor != null) {
                        PropertyEditorListModel.this.myCustomEditor.removeElemnts();
                    }
                }
            });
        }
        return false;
    }

    public Boolean canEditAsText() {
        return false;
    }

    public String getAsText() {
        PropertyValue.Kind kind = null;
        if (this.getValue() instanceof PropertyValue) {
            kind = ((PropertyValue)this.getValue()).getKind();
        }
        if (kind == PropertyValue.Kind.USERCODE) {
            return super.getAsText();
        }
        return this.myModelText;
    }

    public JComponent getCustomEditorComponent() {
        return this.myCustomEditor;
    }

    public JRadioButton getRadioButton() {
        return this.myRadioButton;
    }

    public Component getCustomEditor() {
        if (this.myCustomEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        if (((DesignComponent)this.component.get()).getType() == SVGListCD.TYPEID) {
            ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyEditorListModel.this.myCustomEditor.setValue(((DesignComponent)PropertyEditorListModel.this.component.get()).readProperty("listElements"));
                }
            });
        }
        return super.getCustomEditor();
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return true;
    }

    public void setTextForPropertyValue(String arg0) {
        assert (false);
    }

    public void updateState(final PropertyValue value) {
        if (value != null) {
            ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyEditorListModel.this.myCustomEditor.setValue(value);
                }
            });
        }
        this.myRadioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.myRadioButton.isSelected()) {
            if (SVGListCD.TYPEID != ((DesignComponent)this.component.get()).getType()) {
                this.saveValue(this.myCustomEditor.getValue());
            } else {
                ((DesignComponent)this.component.get()).getDocument().getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        block10: {
                            List array;
                            Integer index;
                            block9: {
                                index = -1;
                                array = ((DesignComponent)PropertyEditorListModel.this.component.get()).readProperty("listElements").getArray();
                                if (array != null) {
                                    index = array.size() - 1;
                                }
                                if (index == PropertyEditorListModel.this.myCustomEditor.getValue().size() - 1) {
                                    return;
                                }
                                if (index >= PropertyEditorListModel.this.myCustomEditor.getValue().size() - 1) break block9;
                                if (index == -1) {
                                    index = 0;
                                } else {
                                    Integer n = index;
                                    Integer n2 = index = Integer.valueOf(index + 1);
                                }
                                for (int i = index.intValue(); i <= PropertyEditorListModel.this.myCustomEditor.getValue().size() - 1; ++i) {
                                    DesignComponent element = ((DesignComponent)PropertyEditorListModel.this.component.get()).getDocument().createComponent(SVGListElementEventSourceCD.TYPEID);
                                    ((DesignComponent)PropertyEditorListModel.this.component.get()).addComponent(element);
                                    if (array == null) {
                                        ((DesignComponent)PropertyEditorListModel.this.component.get()).writeProperty("listElements", PropertyValue.createArray((TypeID)SVGListElementEventSourceCD.TYPEID, new ArrayList()));
                                    }
                                    ArraySupport.append((DesignComponent)((DesignComponent)PropertyEditorListModel.this.component.get()), (String)"listElements", (DesignComponent)element);
                                    array = ((DesignComponent)PropertyEditorListModel.this.component.get()).readProperty("listElements").getArray();
                                }
                                break block10;
                            }
                            if (index <= PropertyEditorListModel.this.myCustomEditor.getValue().size() - 1) break block10;
                            for (PropertyValue value : array) {
                                DesignComponent child = value.getComponent();
                                if (child.getType() != SVGListElementEventSourceCD.TYPEID) continue;
                                Integer currentIndex = array.indexOf(value);
                                if (currentIndex == null) {
                                    throw new IllegalArgumentException();
                                }
                                if (currentIndex <= PropertyEditorListModel.this.myCustomEditor.getValue().size() - 1) continue;
                                PropertyValue array_ = ((DesignComponent)PropertyEditorListModel.this.component.get()).readProperty("listElements");
                                if (array != null) {
                                    ArraySupport.remove((DesignComponent)((DesignComponent)PropertyEditorListModel.this.component.get()), (String)"listElements", (DesignComponent)child);
                                }
                                ((DesignComponent)PropertyEditorListModel.this.component.get()).getDocument().deleteComponent(child);
                            }
                        }
                    }
                });
                ((DesignComponent)this.component.get()).getDocument().getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        PropertyValue arrayValue = ((DesignComponent)PropertyEditorListModel.this.component.get()).readProperty("listElements");
                        if (arrayValue == PropertyValue.createNull()) {
                            PropertyEditorListModel.this.setValue(arrayValue);
                            return;
                        }
                        List array = arrayValue.getArray();
                        if (array != null) {
                            for (PropertyValue value : array) {
                                DesignComponent child = value.getComponent();
                                if (child.getType() != SVGListElementEventSourceCD.TYPEID) continue;
                                String string = (String)child.readProperty("name").getPrimitiveValue();
                                Integer childIndex = array.indexOf(value);
                                if (string != null && string.equals(PropertyEditorListModel.this.myCustomEditor.getValue().get(childIndex))) continue;
                                child.writeProperty("name", MidpTypes.createStringValue((String)PropertyEditorListModel.this.myCustomEditor.getValue().get(childIndex)));
                            }
                        } else {
                            PropertyValue model = PropertyValue.createEmptyArray((TypeID)MidpTypes.TYPEID_JAVA_LANG_STRING);
                            if (PropertyEditorListModel.this.component != null) {
                                DesignComponent c = (DesignComponent)PropertyEditorListModel.this.component.get();
                                c.writeProperty((String)PropertyEditorListModel.this.getPropertyNames().iterator().next(), PropertyValue.createNull());
                            }
                        }
                    }
                });
                ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        PropertyValue value = ((DesignComponent)PropertyEditorListModel.this.component.get()).readProperty("listElements");
                        PropertyEditorListModel.super.setValue(value);
                    }
                });
            }
        }
    }

    private void saveValue(List<String> modelItems) {
        ArrayList<PropertyValue> list = new ArrayList<PropertyValue>(modelItems.size());
        for (String string : modelItems) {
            PropertyValue value = MidpTypes.createStringValue((String)string);
            list.add(value);
        }
        PropertyValue model = PropertyValue.createArray((TypeID)MidpTypes.TYPEID_JAVA_LANG_STRING, list);
        super.setValue((Object)model);
    }

    private void initComponents() {
        this.myRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.myRadioButton, (String)NbBundle.getMessage(PropertyEditorButtonGroup.class, (String)"LBL_DefaultModel"));
        this.myRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorButtonGroup.class, (String)"ACSN_DefaultModel"));
        this.myRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorButtonGroup.class, (String)"ACSD_DefaultModel"));
        this.myCustomEditor = new SVGListPropertyCustomEditor();
    }
}

