/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.general;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.netbeans.modules.vmd.midp.general.FileAcceptPresenter;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGImageCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGMenuCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormSupport;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGFormImageParser;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGMenuImageParser;
import org.openide.filesystems.FileObject;

public class SVGFileAcceptPresenter
extends FileAcceptPresenter {
    public SVGFileAcceptPresenter() {
        super("svgImage", SVGImageCD.TYPEID, new String[]{"svg"});
    }

    public ComponentProducer.Result accept(Transferable transferable, AcceptSuggestion suggestion) {
        ComponentProducer.Result result = super.accept(transferable, suggestion);
        DesignComponent svgImage = (DesignComponent)result.getComponents().iterator().next();
        DesignComponent svgComponent = this.getComponent();
        FileObject fileObject = this.getNodeFileObject(transferable);
        if (fileObject == null) {
            return result;
        }
        String path = this.getFileClasspath(fileObject);
        svgImage.writeProperty("resourcePath", MidpTypes.createStringValue((String)path));
        MidpDocumentSupport.getCategoryComponent((DesignDocument)svgComponent.getDocument(), (TypeID)ResourcesCategoryCD.TYPEID).addComponent(svgImage);
        SVGComponentImageParser parser = this.getParserByComponent(svgComponent);
        this.parseSVGImageItems(transferable, svgComponent, parser);
        return result;
    }

    protected SVGComponentImageParser getParserByComponent(DesignComponent svgComponent) {
        TypeID typeID;
        DescriptorRegistry descrRegistry = svgComponent.getDocument().getDescriptorRegistry();
        if (descrRegistry.isInHierarchy(SVGMenuCD.TYPEID, typeID = svgComponent.getType())) {
            if (svgComponent.readProperty("elements").getArray().size() == 0) {
                return new SVGMenuImageParser();
            }
        } else if (descrRegistry.isInHierarchy(SVGFormCD.TYPEID, typeID)) {
            SVGFormSupport.removeAllSVGFormComponents(svgComponent);
            return new SVGFormImageParser();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseSVGImageItems(Transferable transferable, DesignComponent svgMenuComponent, SVGComponentImageParser parser) {
        if (parser == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(transferable);
            if (inputStream != null) {
                parser.parse(inputStream, svgMenuComponent);
            }
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Debug.warning((Object[])new Object[]{ioe});
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException ioe) {
            Debug.warning((Object[])new Object[]{ioe});
        }
    }
}

