/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee.wizard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class MasterDetailGenerator {
    private static final String LABEL_TEMPLATE = "LABEL_TEMPLATE";
    private static final String FIELD_TEMPLATE = "FIELD_TEMPLATE";
    private static final String MASTER_SUBBINDING_TEMPLATE = "MASTER_SUBBINDING_TEMPLATE";
    private static final String DETAIL_SUBBINDING_TEMPLATE = "DETAIL_SUBBINDING_TEMPLATE";
    private static final String V_LAYOUT_TEMPLATE = "V_LAYOUT_TEMPLATE";
    private static final String LABEL_H_LAYOUT_TEMPLATE = "LABEL_H_LAYOUT_TEMPLATE";
    private static final String FIELD_H_LAYOUT_TEMPLATE = "FIELD_H_LAYOUT_TEMPLATE";
    private static final String DETAIL_ONLY = "DETAIL_ONLY";
    private static final String MASTER_ONLY = "MASTER_ONLY";
    private static final String JDK6ONLY = "JDK6ONLY";
    private FileObject formFile;
    private FileObject javaFile;
    private String masterClass;
    private String detailClass;
    private String masterEntity;
    private String detailEntity;
    private String joinProperty;
    private String joinCollectionProperty;
    private String unit;
    private List<String> masterColumns;
    private List<String> detailColumns;
    private List<String> masterColumnTypes;
    private List<String> detailColumnTypes;

    MasterDetailGenerator(FileObject formFile, FileObject javaFile, String masterClass, String detailClass, String masterEntity, String detailEntity, String joinProperty, String joinCollectionProperty, String unit) {
        this.formFile = formFile;
        this.javaFile = javaFile;
        this.masterClass = masterClass;
        this.detailClass = detailClass;
        this.masterEntity = masterEntity;
        this.detailEntity = detailEntity;
        this.joinProperty = joinProperty;
        this.joinCollectionProperty = joinCollectionProperty;
        this.unit = unit;
    }

    void setMasterColumns(List<String> masterColumns) {
        this.masterColumns = masterColumns;
    }

    void setMasterColumnTypes(List<String> masterColumnTypes) {
        this.masterColumnTypes = masterColumnTypes;
    }

    void setDetailColumns(List<String> detailColumns) {
        this.detailColumns = detailColumns;
    }

    void setDetailColumnTypes(List<String> detailColumnTypes) {
        this.detailColumnTypes = detailColumnTypes;
    }

    void generate() throws IOException {
        String formEncoding = "UTF-8";
        String javaEncoding = FileEncodingQuery.getDefaultEncoding().name();
        String form = MasterDetailGenerator.read(this.formFile, formEncoding);
        String java = MasterDetailGenerator.read(this.javaFile, javaEncoding);
        Map<String, String> replacements = this.replacements();
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            form = form.replace(entry.getKey(), entry.getValue());
            java = java.replace(entry.getKey(), entry.getValue());
        }
        form = this.generateMasterColumns(form);
        if (this.detailEntity == null) {
            form = this.generateLabels(form);
            form = this.generateFields(form);
            form = this.generateVLayout(form);
            form = this.generateLabelsHLayout(form);
            form = this.generateFieldsHLayout(form);
            form = MasterDetailGenerator.deleteSections(form, DETAIL_ONLY, false, false);
            form = MasterDetailGenerator.deleteSections(form, MASTER_ONLY, true, false);
            java = MasterDetailGenerator.deleteSections(java, DETAIL_ONLY, false, true);
        } else {
            form = this.generateDetailColumns(form);
            java = MasterDetailGenerator.deleteSections(java, DETAIL_ONLY, true, true);
            form = MasterDetailGenerator.deleteSections(form, MASTER_ONLY, false, false);
            form = MasterDetailGenerator.deleteSections(form, DETAIL_ONLY, true, false);
        }
        java = MasterDetailGenerator.deleteSections(java, JDK6ONLY, ClassPathUtils.isJava6ProjectPlatform((FileObject)this.javaFile), true);
        MasterDetailGenerator.write(this.formFile, form, formEncoding);
        MasterDetailGenerator.write(this.javaFile, java, javaEncoding);
    }

    private String generateMasterColumns(String result) {
        TemplateInfo info = MasterDetailGenerator.findTemplate(result, MASTER_SUBBINDING_TEMPLATE);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator<String> iter = this.masterColumnTypes.iterator();
        for (String column : this.masterColumns) {
            String type;
            String binding = info.template.replace("_index_", "" + i++);
            binding = binding.replace("_fieldName_", column);
            String string = type = iter.hasNext() ? iter.next() : null;
            if (type == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Cannot determine type of {0} property!", column);
                type = "Object.class";
            }
            binding = binding.replace("_fieldType_", type);
            sb.append(binding);
        }
        StringBuilder rsb = new StringBuilder(info.form);
        rsb.insert(info.formIndex, sb.toString());
        return rsb.toString();
    }

    private String generateDetailColumns(String result) {
        TemplateInfo info = MasterDetailGenerator.findTemplate(result, DETAIL_SUBBINDING_TEMPLATE);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator<String> iter = this.detailColumnTypes.iterator();
        for (String column : this.detailColumns) {
            String binding = info.template.replace("_index_", "" + i++);
            binding = binding.replace("_fieldName_", column);
            binding = binding.replace("_fieldType_", iter.next());
            sb.append(binding);
        }
        StringBuilder rsb = new StringBuilder(info.form);
        rsb.insert(info.formIndex, sb.toString());
        return rsb.toString();
    }

    private String generateLabels(String result) {
        TemplateInfo info = MasterDetailGenerator.findTemplate(result, LABEL_TEMPLATE);
        StringBuilder sb = new StringBuilder();
        for (String column : this.detailColumns) {
            String binding = info.template.replace("_labelName_", MasterDetailGenerator.columnToLabelName(column));
            binding = binding.replace("_labelText_", MasterDetailGenerator.capitalize(column));
            sb.append(binding);
        }
        StringBuilder rsb = new StringBuilder(info.form);
        rsb.insert(info.formIndex, sb.toString());
        return rsb.toString();
    }

    private String generateFields(String result) {
        TemplateInfo info = MasterDetailGenerator.findTemplate(result, FIELD_TEMPLATE);
        StringBuilder sb = new StringBuilder();
        for (String column : this.detailColumns) {
            String binding = info.template.replace("_textFieldName_", MasterDetailGenerator.columnToFieldName(column));
            binding = binding.replace("_fieldName_", column);
            sb.append(binding);
        }
        StringBuilder rsb = new StringBuilder(info.form);
        rsb.insert(info.formIndex, sb.toString());
        return rsb.toString();
    }

    private String generateVLayout(String result) {
        TemplateInfo info = MasterDetailGenerator.findTemplate(result, V_LAYOUT_TEMPLATE);
        StringBuilder sb = new StringBuilder();
        for (String column : this.detailColumns) {
            String binding = info.template.replace("_labelName_", MasterDetailGenerator.columnToLabelName(column));
            binding = binding.replace("_textFieldName_", MasterDetailGenerator.columnToFieldName(column));
            sb.append(binding);
        }
        StringBuilder rsb = new StringBuilder(info.form);
        rsb.insert(info.formIndex, sb.toString());
        return rsb.toString();
    }

    private String generateLabelsHLayout(String result) {
        TemplateInfo info = MasterDetailGenerator.findTemplate(result, LABEL_H_LAYOUT_TEMPLATE);
        StringBuilder sb = new StringBuilder();
        for (String column : this.detailColumns) {
            String binding = info.template.replace("_labelName_", MasterDetailGenerator.columnToLabelName(column));
            sb.append(binding);
        }
        StringBuilder rsb = new StringBuilder(info.form);
        rsb.insert(info.formIndex, sb.toString());
        return rsb.toString();
    }

    private String generateFieldsHLayout(String result) {
        TemplateInfo info = MasterDetailGenerator.findTemplate(result, FIELD_H_LAYOUT_TEMPLATE);
        StringBuilder sb = new StringBuilder();
        for (String column : this.detailColumns) {
            String binding = info.template.replace("_textFieldName_", MasterDetailGenerator.columnToFieldName(column));
            sb.append(binding);
        }
        StringBuilder rsb = new StringBuilder(info.form);
        rsb.insert(info.formIndex, sb.toString());
        return rsb.toString();
    }

    private static String deleteSections(String result, String sectionName, boolean commentsOnly, boolean java) {
        String marker = MasterDetailGenerator.markerRegexp(sectionName, java);
        String delimiter = commentsOnly ? marker : "(?s)" + marker + ".*?" + marker;
        StringBuilder sb = new StringBuilder();
        for (String part : result.split(delimiter)) {
            sb.append(part);
        }
        return sb.toString();
    }

    private static String markerRegexp(String name, boolean java) {
        String open = java ? "/\\*[\\*\\s]*" : "\\<\\!\\-\\-\\s*";
        String close = java ? "[\\*\\s]*\\*/" : "\\s*\\-\\-\\>";
        return open + Pattern.quote(name) + close;
    }

    private static String columnToLabelName(String column) {
        return column + "Label";
    }

    private static String columnToFieldName(String column) {
        return column + "Field";
    }

    private static String read(FileObject file, String encoding) throws IOException {
        String s;
        InputStream is = file.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuilder sb = new StringBuilder();
        while ((s = br.readLine()) != null) {
            sb.append(s).append('\n');
        }
        br.close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(FileObject file, String content, String encoding) throws IOException {
        FileLock lock = file.lock();
        try {
            OutputStream os = file.getOutputStream(lock);
            os.write(content.getBytes(encoding));
            os.close();
        }
        finally {
            lock.releaseLock();
        }
    }

    private Map<String, String> replacements() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("_masterClass_", this.masterClass);
        map.put("_masterEntity_", this.masterEntity);
        char masterInitial = Character.toLowerCase(this.masterEntity.charAt(0));
        map.put("_unitName_", this.unit);
        if (this.detailClass != null) {
            map.put("_detailClass_", this.detailClass);
            map.put("_detailEntity_", this.detailEntity);
            char detailInitial = Character.toLowerCase(this.detailEntity.charAt(0));
            map.put("_detailEntityInitial_", Character.toString(detailInitial));
            if (detailInitial == masterInitial) {
                masterInitial = Character.toUpperCase(masterInitial);
            }
            if (this.joinCollectionProperty != null) {
                map.put("_joinCollection_", this.joinCollectionProperty);
                map.put("_joinCollectionCapital_", Character.toUpperCase(this.joinCollectionProperty.charAt(0)) + this.joinCollectionProperty.substring(1));
            }
            if (this.joinProperty != null) {
                map.put("_joinCapital_", Character.toUpperCase(this.joinProperty.charAt(0)) + this.joinProperty.substring(1));
            }
        }
        map.put("_masterEntityInitial_", Character.toString(masterInitial));
        return map;
    }

    private static TemplateInfo findTemplate(String where, String templateName) {
        String marker = MasterDetailGenerator.markerRegexp(templateName, false);
        Pattern pattern = Pattern.compile(marker + "(.*?)" + marker, 32);
        Matcher matcher = pattern.matcher(where);
        matcher.find();
        TemplateInfo info = new TemplateInfo();
        int index1 = matcher.start(1);
        int index2 = matcher.end(1);
        info.template = where.substring(index1, index2);
        index1 = matcher.start();
        index2 = matcher.end();
        info.form = where.substring(0, index1) + where.substring(index2);
        info.formIndex = index1;
        return info;
    }

    private static String capitalize(String title) {
        StringBuilder builder = new StringBuilder(title);
        boolean lastWasUpper = false;
        for (int i = 0; i < builder.length(); ++i) {
            char aChar = builder.charAt(i);
            if (i == 0) {
                builder.setCharAt(i, Character.toUpperCase(aChar));
                lastWasUpper = true;
                continue;
            }
            if (Character.isUpperCase(aChar)) {
                if (!lastWasUpper) {
                    builder.insert(i, ' ');
                }
                lastWasUpper = true;
                ++i;
                continue;
            }
            lastWasUpper = false;
        }
        return builder.toString();
    }

    private static class TemplateInfo {
        String template;
        String form;
        int formIndex;

        private TemplateInfo() {
        }
    }
}

