/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee;

import java.awt.dnd.DropTargetDragEvent;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.assistant.AssistantMessages;
import org.netbeans.modules.form.j2ee.DBColumnDrop;
import org.netbeans.modules.form.j2ee.DBConnectionDrop;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.nbform.project.ClassSourceResolver;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class DBTableDrop
extends DBConnectionDrop {
    private DatabaseMetaDataTransfer.Table table;

    public DBTableDrop(FormModel model, DatabaseMetaDataTransfer.Table table) {
        super(model, null);
        this.table = table;
    }

    @Override
    public PaletteItem getPaletteItem(DropTargetDragEvent dtde) {
        PaletteItem pItem;
        if (!this.assistantInitialized) {
            this.initAssistant();
        }
        if (!J2EEUtils.hasPrimaryKey(this.table.getDatabaseConnection(), this.table.getTableName())) {
            FormEditor.getAssistantModel((FormModel)this.model).setContext("tableWithoutPK");
            return null;
        }
        if (FormJavaSource.isInDefaultPackage((FormModel)this.model)) {
            FormEditor.getAssistantModel((FormModel)this.model).setContext("tableDefaultPackage");
            return null;
        }
        this.setBindingOnly(dtde.getDropAction() == 2);
        if (this.isBindingOnly()) {
            FormEditor.getAssistantModel((FormModel)this.model).setContext("tableDropBinding", "tableDropComponent");
            pItem = new PaletteItem(new ClassSource("javax.persistence.EntityManager", new ClassSource.Entry[]{new ClassSourceResolver.LibraryEntry(LibraryManager.getDefault().getLibrary("toplink"))}), null);
            pItem.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/j2ee/resources/binding.gif", (boolean)false).getImage());
        } else {
            pItem = new PaletteItem(new ClassSource("javax.swing.JTable", new ClassSource.Entry[0]), null);
        }
        return pItem;
    }

    private void initAssistant() {
        ResourceBundle bundle = NbBundle.getBundle(DBColumnDrop.class);
        String dropBindingMsg = bundle.getString("MSG_TableDropBinding");
        String dropComponentMsg = bundle.getString("MSG_TableDropComponent");
        String tableWithoutPKMsg = bundle.getString("MSG_TableWithoutPK");
        String tableDefaultPackageMsg = bundle.getString("MSG_TableDefaultPackage");
        AssistantMessages messages = AssistantMessages.getDefault();
        messages.setMessages("tableDropBinding", new String[]{dropBindingMsg});
        messages.setMessages("tableDropComponent", new String[]{dropComponentMsg});
        messages.setMessages("tableWithoutPK", new String[]{tableWithoutPKMsg});
        messages.setMessages("tableDefaultPackage", new String[]{tableDefaultPackageMsg});
        this.assistantInitialized = true;
    }

    @Override
    public void componentAdded(String componentId, String droppedOverId) {
        try {
            RADComponent entityManager;
            FileObject formFile = FormEditor.getFormDataObject((FormModel)this.model).getFormFile();
            this.project = FileOwnerQuery.getOwner((FileObject)formFile);
            FileObject persistenceXML = J2EEUtils.getPersistenceXML(this.project, true);
            PersistenceUnit unit = J2EEUtils.initPersistenceUnit(persistenceXML, this.table.getDatabaseConnection());
            J2EEUtils.updateProjectForUnit(formFile, unit, this.table.getJDBCDriver());
            PersistenceScope scope = PersistenceScope.getPersistenceScope((FileObject)formFile);
            MetadataModel mappings = scope.getEntityMappingsModel(unit.getName());
            String[] entityInfo = J2EEUtils.findEntity((MetadataModel<EntityMappingsMetadata>)mappings, this.table.getTableName());
            if (entityInfo == null) {
                J2EEUtils.createEntity(formFile.getParent(), scope, unit, this.table.getDatabaseConnection(), this.table.getTableName(), null);
                mappings = scope.getEntityMappingsModel(unit.getName());
                entityInfo = J2EEUtils.findEntity((MetadataModel<EntityMappingsMetadata>)mappings, this.table.getTableName());
            } else {
                J2EEUtils.addEntityToUnit(entityInfo[1], unit, this.project);
            }
            J2EEUtils.makeEntityObservable(formFile, entityInfo, (MetadataModel<EntityMappingsMetadata>)mappings);
            if (this.isBindingOnly()) {
                String unitName = unit.getName();
                entityManager = J2EEUtils.findEntityManager(this.model, unitName);
                if (entityManager == null) {
                    entityManager = this.model.getMetaComponent(componentId);
                    entityManager.getPropertyByName("persistenceUnit").setValue((Object)unitName);
                    J2EEUtils.renameComponent(entityManager, true, unitName + "EntityManager", "entityManager");
                } else {
                    this.model.removeComponent(this.model.getMetaComponent(componentId), true);
                }
            } else {
                entityManager = this.initEntityManagerBean(unit);
            }
            RADComponent queryBean = DBTableDrop.createQueryBean(this.model, entityManager, entityInfo[0]);
            RADComponent resultList = DBTableDrop.createResultListBean(this.model, queryBean, entityInfo);
            Class beanClass = JTable.class;
            if (this.isBindingOnly()) {
                RADVisualContainer cont;
                if (droppedOverId == null) {
                    return;
                }
                RADComponent comp = this.model.getMetaComponent(droppedOverId);
                if (JScrollPane.class.isAssignableFrom(comp.getBeanClass()) && comp instanceof RADVisualContainer && (cont = (RADVisualContainer)comp).getSubComponents().length > 0) {
                    comp = cont.getSubComponent(0);
                    droppedOverId = comp.getId();
                }
                if (!(JTable.class.equals((Object)(beanClass = comp.getBeanClass())) || JList.class.equals((Object)beanClass) || JComboBox.class.equals((Object)beanClass))) {
                    return;
                }
            }
            if (beanClass.equals(JTable.class)) {
                this.bindTableComponent(this.isBindingOnly() ? droppedOverId : componentId, resultList, (MetadataModel<EntityMappingsMetadata>)mappings, entityInfo);
            } else {
                this.bindListComponent(droppedOverId, resultList);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
        }
    }

    public static RADComponent createQueryBean(FormModel model, RADComponent entityManager, String entityName) throws Exception {
        RADComponent query = new RADComponent();
        FileObject formFile = FormEditor.getFormDataObject((FormModel)model).getFormFile();
        Class queryClass = ClassPathUtils.loadClass((String)"javax.persistence.Query", (FileObject)formFile);
        query.initialize(model);
        query.initInstance(queryClass);
        char c = entityName.toLowerCase().charAt(0);
        String q = "SELECT " + c + " FROM " + entityName + " " + c;
        query.getPropertyByName("query").setValue((Object)q);
        query.getPropertyByName("entityManager").setValue((Object)entityManager);
        query.setStoredName(c + entityName.substring(1) + "Query");
        model.addComponent(query, null, true);
        return query;
    }

    public static RADComponent createResultListBean(FormModel model, RADComponent query, String[] entityInfo) throws Exception {
        RADComponent resultList = new RADComponent();
        resultList.setAuxValue("JavaCodeGenerator_TypeParameters", (Object)('<' + entityInfo[1] + '>'));
        resultList.initialize(model);
        resultList.initInstance(List.class);
        char c = entityInfo[0].toLowerCase().charAt(0);
        resultList.getPropertyByName("query").setValue((Object)query);
        resultList.setStoredName(c + entityInfo[0].substring(1) + "List");
        model.addComponent(resultList, null, true);
        return resultList;
    }

    private void bindTableComponent(String tableID, RADComponent resultList, MetadataModel<EntityMappingsMetadata> mappings, String[] entityInfo) throws Exception {
        RADComponent table = this.model.getMetaComponent(tableID);
        if (JScrollPane.class.isAssignableFrom(table.getBeanClass())) {
            table = ((RADVisualContainer)table).getSubComponent(0);
        }
        BindingProperty prop = table.getBindingProperty("elements");
        MetaBinding binding = new MetaBinding(resultList, null, table, "elements");
        List<String> propertyNames = J2EEUtils.propertiesForColumns(mappings, entityInfo[0], null);
        FileObject formFile = FormEditor.getFormDataObject((FormModel)this.model).getPrimaryFile();
        List<String> propertyTypes = J2EEUtils.typesOfProperties(formFile, entityInfo[1], propertyNames);
        Iterator<String> typeIter = propertyTypes.iterator();
        for (String column : propertyNames) {
            BindingDesignSupport bindingSupport = FormEditor.getBindingSupport((FormModel)this.model);
            MetaBinding subBinding = binding.addSubBinding(bindingSupport.elWrap(column), null);
            String clazz = typeIter.next();
            if (clazz == null) continue;
            subBinding.setParameter("javax.swing.binding.ParameterKeys.COLUMN_CLASS", clazz);
        }
        prop.setValue(binding);
    }

    private void bindListComponent(String listID, RADComponent resultList) throws Exception {
        RADComponent list = this.model.getMetaComponent(listID);
        if (JScrollPane.class.isAssignableFrom(list.getBeanClass())) {
            list = ((RADVisualContainer)list).getSubComponent(0);
        }
        BindingProperty prop = list.getBindingProperty("elements");
        MetaBinding binding = new MetaBinding(resultList, null, list, "elements");
        prop.setValue(binding);
    }
}

