/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.loaders.QtUiDataObject;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;

public class QtUiDataLoader
extends UniFileLoader {
    static final long serialVersionUID = 6801389470714975682L;

    public QtUiDataLoader() {
        super("org.netbeans.modules.cnd.loaders.QtUiDataObject");
    }

    private String getMimeType() {
        return "text/qtui+xml";
    }

    protected String actionsContext() {
        return "Loaders/" + this.getMimeType() + "/Actions/";
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new QtUiDataObject(primaryFile, (MultiFileLoader)this);
    }

    protected final void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(this.getMimeType());
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new CndFormat(obj, primaryFile);
    }

    protected static boolean setTemplate(FileObject fo, boolean newTempl) throws IOException {
        boolean oldTempl = false;
        Object o = fo.getAttribute("template");
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            oldTempl = true;
        }
        if (oldTempl == newTempl) {
            return false;
        }
        fo.setAttribute("template", (Object)(newTempl ? Boolean.TRUE : null));
        return true;
    }

    private static class CndFormat
    extends FileEntry.Format {
        public CndFormat(MultiDataObject obj, FileObject primaryFile) {
            super(obj, primaryFile);
        }

        protected Format createFormat(FileObject target, String name, String ext) {
            Properties map = ((CppSettings)CppSettings.findObject(CppSettings.class, (boolean)true)).getReplaceableStringsProps();
            String packageName = target.getPath().replace('/', '_');
            if (!packageName.isEmpty()) {
                packageName = packageName + "_";
            }
            map.put("PACKAGE_AND_NAME", packageName + name);
            map.put("NAME", name);
            map.put("EXTENSION", ext);
            String fullName = name + "_" + ext;
            StringBuilder guardName = new StringBuilder();
            for (int i = 0; i < fullName.length(); ++i) {
                char c = fullName.charAt(i);
                guardName.append(Character.isJavaIdentifierPart(c) ? (char)Character.toUpperCase(c) : (char)'_');
            }
            map.put("GUARD_NAME", guardName.toString());
            int crop = name.lastIndexOf(95);
            if (crop != -1) {
                name = name.substring(0, crop);
            }
            map.put("CROPPEDNAME", name);
            map.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
            map.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
            map.put("QUOTES", "\"");
            for (CreateFromTemplateAttributesProvider provider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
                Object username;
                Map attrs = provider.attributesFor((DataObject)this.getDataObject(), DataFolder.findFolder((FileObject)target), name);
                if (attrs == null || !((username = attrs.get("user")) instanceof String)) continue;
                map.put("USER", (String)username);
                break;
            }
            MapFormat format = new MapFormat((Map)map);
            format.setLeftBrace("%<%");
            format.setRightBrace("%>%");
            return format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            String ext = this.getFile().getExt();
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)ext);
            }
            FileObject fo = f.createData(name, ext);
            Format frm = this.createFormat(f, name, ext);
            boolean remoteFS = !CndFileUtils.isLocalFileSystem((FileSystem)fo.getFileSystem());
            BufferedReader r = new BufferedReader(new InputStreamReader(this.getFile().getInputStream(), FileEncodingQuery.getEncoding((FileObject)this.getFile())));
            try {
                FileLock lock = fo.lock();
                try {
                    Charset encoding = FileEncodingQuery.getEncoding((FileObject)fo);
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter(fo.getOutputStream(lock), encoding));
                    try {
                        String current;
                        while ((current = r.readLine()) != null) {
                            w.write(frm.format(current));
                            if (remoteFS) {
                                w.write("\n");
                                continue;
                            }
                            w.newLine();
                        }
                    }
                    finally {
                        w.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
            finally {
                r.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
            QtUiDataLoader.setTemplate(fo, false);
            return fo;
        }
    }
}

