/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository.remote;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;

public class RemoteConfig
implements GitRemoteConfig {
    private final String remoteName;
    private final LinkedList<String> pushRefSpecs;
    private final LinkedList<String> pushUris;
    private final LinkedList<String> fetchRefSpecs;
    private final LinkedList<String> fetchUris;

    public RemoteConfig(String remoteName) {
        this(remoteName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private RemoteConfig(String remoteName, List<String> fetchUris, List<String> pushUris, List<String> fetchRefSpecs, List<String> pushRefSpecs) {
        this.remoteName = remoteName;
        this.fetchUris = new LinkedList<String>(fetchUris);
        this.fetchRefSpecs = new LinkedList<String>(fetchRefSpecs);
        this.pushUris = new LinkedList<String>(pushUris);
        this.pushRefSpecs = new LinkedList<String>(pushRefSpecs);
    }

    public RemoteConfig(GitRemoteConfig originalConfig) {
        this(originalConfig.getRemoteName(), originalConfig.getUris(), originalConfig.getPushUris(), originalConfig.getFetchRefSpecs(), originalConfig.getPushRefSpecs());
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public List<String> getUris() {
        return Collections.unmodifiableList(this.fetchUris);
    }

    public List<String> getPushUris() {
        return Collections.unmodifiableList(this.pushUris);
    }

    public List<String> getFetchRefSpecs() {
        return Collections.unmodifiableList(this.fetchRefSpecs);
    }

    public List<String> getPushRefSpecs() {
        return Collections.unmodifiableList(this.pushRefSpecs);
    }

    public static RemoteConfig createUpdatableRemote(File repository, String remoteName) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        Map<String, GitRemoteConfig> remotes = info.getRemotes();
        RemoteConfig config = remotes.containsKey(remoteName) ? new RemoteConfig(remotes.get(remoteName)) : new RemoteConfig(remoteName);
        return config;
    }

    public void setFetchUris(List<String> uris) {
        this.update(this.fetchUris, uris);
    }

    public void setFetchRefSpecs(List<String> refs) {
        this.update(this.fetchRefSpecs, refs);
    }

    private void update(LinkedList<String> toUpdate, List<String> newValues) {
        toUpdate.clear();
        toUpdate.addAll(newValues);
    }
}

