/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.fetch.BranchMapping;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class UpdateBranchReferencesStep
extends AbstractWizardPanel
implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    private final File repository;
    private final ItemSelector<BranchMapping> branches;
    private final JPanel panel;
    private boolean lastPanel;
    private GitRemoteConfig remote;

    public UpdateBranchReferencesStep(File repository) {
        this.repository = repository;
        this.branches = new ItemSelector(NbBundle.getMessage(UpdateBranchReferencesStep.class, (String)"UpdateBranchReferencesPanel.jLabel1.text"));
        this.branches.addChangeListener(this);
        this.panel = new JPanel();
        this.initializePanel();
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                UpdateBranchReferencesStep.this.validateBeforeNext();
            }
        });
    }

    @Override
    protected final void validateBeforeNext() {
        this.setValid(true, null);
        if (this.branches.getSelectedBranches().isEmpty()) {
            this.setValid(true, new AbstractWizardPanel.Message(NbBundle.getMessage(UpdateBranchReferencesStep.class, (String)"MSG_PushBranchesPanel.errorNoBranchSelected"), true));
        }
    }

    @Override
    protected final JComponent getJComponent() {
        return this.panel;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(UpdateBranchReferencesStep.class);
    }

    public void setRemote(GitRemoteConfig remote) {
        if (this.remote != remote && (this.remote == null || remote == null)) {
            this.remote = remote;
        }
        this.validateBeforeNext();
    }

    public void fillRemoteBranches(final Set<String> branches) {
        new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                final HashMap<String, GitBranch> localBranches = new HashMap<String, GitBranch>();
                RepositoryInfo info = RepositoryInfo.getInstance(UpdateBranchReferencesStep.this.repository);
                info.refresh();
                localBranches.putAll(info.getBranches());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateBranchReferencesStep.this.fillRemoteBranches(branches, localBranches);
                    }
                });
            }
        }.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(UpdateBranchReferencesStep.class, (String)"MSG_PushBranchesPanel.loadingLocalBranches"));
    }

    private void fillRemoteBranches(Set<String> branches, Map<String, GitBranch> localBranches) {
        ArrayList<BranchMapping> l = new ArrayList<BranchMapping>(branches.size());
        for (String branch : branches) {
            GitBranch localBranch = localBranches.get(this.remote.getRemoteName() + "/" + branch);
            BranchMapping mapping = new BranchMapping(branch, localBranch == null ? null : localBranch.getName(), this.remote, true);
            l.add(mapping);
        }
        this.branches.setBranches(l);
        this.validateBeforeNext();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.validateBeforeNext();
    }

    public List<String> getSelectedRefSpecs() {
        LinkedList<String> specs = new LinkedList<String>();
        for (BranchMapping b : this.branches.getSelectedBranches()) {
            specs.add(b.getRefSpec());
        }
        return specs;
    }

    public boolean isFinishPanel() {
        return this.lastPanel;
    }

    void setAsLastPanel(boolean isLastPanel) {
        this.lastPanel = isLastPanel;
    }

    private void initializePanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)new JLabel(NbBundle.getMessage(UpdateBranchReferencesStep.class, (String)"LBL_UpdateBranchReferences.description")), "North");
        this.panel.add((Component)this.branches.getPanel(), "Center");
        this.panel.setName(NbBundle.getMessage(UpdateBranchReferencesStep.class, (String)"LBL_UpdateBranchReferences.remoteBranches"));
    }
}

