/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.push.PushMapping;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class PushBranchesStep
extends AbstractWizardPanel
implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    private final File repository;
    private final ItemSelector<PushMapping> localObjects;
    private boolean lastPanel;

    public PushBranchesStep(File repository) {
        this.repository = repository;
        this.localObjects = new ItemSelector(NbBundle.getMessage(PushBranchesStep.class, (String)"PushBranchesPanel.jLabel1.text"));
        this.localObjects.addChangeListener(this);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                PushBranchesStep.this.validateBeforeNext();
            }
        });
        this.getJComponent().setName(NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranches.localBranches"));
    }

    @Override
    protected final void validateBeforeNext() {
        this.setValid(true, null);
        if (this.localObjects.getSelectedBranches().isEmpty()) {
            this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(PushBranchesStep.class, (String)"MSG_PushBranchesPanel.errorNoBranchSelected"), false));
        }
    }

    @Override
    protected final JComponent getJComponent() {
        return this.localObjects.getPanel();
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(PushBranchesStep.class);
    }

    public void fillRemoteBranches(final Map<String, GitBranch> branches, final Map<String, String> tags) {
        new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                final HashMap<String, GitBranch> localBranches = new HashMap<String, GitBranch>();
                final HashMap<String, GitTag> localTags = new HashMap<String, GitTag>();
                RepositoryInfo info = RepositoryInfo.getInstance(PushBranchesStep.this.repository);
                info.refresh();
                localBranches.putAll(info.getBranches());
                localTags.putAll(info.getTags());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PushBranchesStep.this.fillLocalObjects(branches, localBranches, tags, localTags);
                    }
                });
            }
        }.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(PushBranchesStep.class, (String)"MSG_PushBranchesPanel.loadingLocalBranches"));
    }

    private void fillLocalObjects(Map<String, GitBranch> branches, Map<String, GitBranch> localBranches, Map<String, String> tags, Map<String, GitTag> localTags) {
        ArrayList<PushMapping> l = new ArrayList<PushMapping>(branches.size());
        for (GitBranch branch : localBranches.values()) {
            if (branch.isRemote()) continue;
            l.add(new PushMapping.PushBranchMapping(branches.get(branch.getName()), branch));
        }
        for (GitTag tag : localTags.values()) {
            if (tags.containsKey(tag.getTagName())) continue;
            l.add(new PushMapping.PushTagMapping(tag));
        }
        this.localObjects.setBranches(l);
        this.validateBeforeNext();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.validateBeforeNext();
    }

    public boolean isFinishPanel() {
        return this.lastPanel;
    }

    void setAsLastPanel(boolean isLastPanel) {
        this.lastPanel = isLastPanel;
    }

    Collection<PushMapping> getSelectedMappings() {
        return this.localObjects.getSelectedBranches();
    }
}

