/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.ignore;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IgnoreAction
extends MultipleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(IgnoreAction.class.getName());

    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        return this.ignore(repository, roots);
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = super.enable(activatedNodes);
        if (enabled) {
            enabled = false;
            VCSContext ctx = this.getCurrentContext(activatedNodes);
            FileStatusCache cache = Git.getInstance().getFileStatusCache();
            enabled = cache.containsFiles(ctx, EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE), true);
            if (!enabled) {
                for (File root : ctx.getRootFiles()) {
                    if (!cache.getStatus(root).isDirectory()) continue;
                    enabled = true;
                    break;
                }
            }
        }
        return enabled;
    }

    public void ignoreFolders(File repository, File[] roots) {
        File[] toIgnore = this.filterFolders(repository, roots);
        this.ignore(repository, toIgnore);
    }

    private RequestProcessor.Task ignore(File repository, File[] roots) {
        final File[] toIgnore = IgnoreAction.filterRoots(roots);
        if (toIgnore.length == 0) {
            return null;
        }
        GitProgressSupport supp = new GitProgressSupport(){
            private final Set<File> notifiedFiles = new HashSet<File>();
            private File[] modifiedIgnores = new File[0];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(toIgnore));
                    client.addNotificationListener((NotificationListener)new FileListener(){

                        public void notifyFile(File file, String relativePathToRoot) {
                            notifiedFiles.add(file);
                        }
                    });
                    this.modifiedIgnores = client.ignore(toIgnore, (ProgressMonitor)this);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    if (this.modifiedIgnores.length > 0) {
                        FileUtil.refreshFor((File[])this.modifiedIgnores);
                        this.notifiedFiles.addAll(Arrays.asList(this.modifiedIgnores));
                    }
                    if (!this.notifiedFiles.isEmpty()) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), this.notifiedFiles));
                    }
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(IgnoreAction.class, (String)"LBL_IgnoreAction.progressName"));
        return supp.getTask();
    }

    private static File[] filterRoots(File[] roots) {
        LinkedList<File> toIgnore = new LinkedList<File>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (File root : roots) {
            FileInformation info = cache.getStatus(root);
            if (!info.isDirectory() && !info.containsStatus(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.NEW_HEAD_WORKING_TREE))) continue;
            toIgnore.add(root);
        }
        return toIgnore.toArray(new File[toIgnore.size()]);
    }

    private File[] filterFolders(File repository, File[] roots) {
        Map statuses;
        LinkedList<File> unignoredFolders = new LinkedList<File>();
        try {
            GitClient client = Git.getInstance().getClient(repository);
            statuses = client.getStatus(roots, ProgressMonitor.NULL_PROGRESS_MONITOR);
        }
        catch (GitException ex) {
            LOG.log(Level.INFO, null, ex);
            statuses = Collections.emptyMap();
        }
        for (File f : roots) {
            GitStatus st = (GitStatus)statuses.get(f);
            if (st == null || st.getStatusIndexWC() != GitStatus.Status.STATUS_IGNORED) {
                unignoredFolders.add(f);
                continue;
            }
            LOG.log(Level.FINE, "File {0} already ignored", f);
        }
        return unignoredFolders.toArray(new File[unignoredFolders.size()]);
    }
}

