/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.EventQueue;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;

class SearchExecutor
extends GitProgressSupport {
    static final DateFormat[] dateFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd")};
    private final SearchHistoryPanel master;
    private final int limitRevisions;
    private final boolean showAllPaths;
    private final boolean showMerges;
    private final String message;
    private final String username;
    private final String fromRevision;
    private final String toRevision;
    private final Date from;
    private final Date to;

    public SearchExecutor(SearchHistoryPanel master) {
        this.master = master;
        assert (EventQueue.isDispatchThread());
        SearchCriteriaPanel criteria = master.getCriteria();
        this.from = this.parseDate(criteria.getFrom());
        this.fromRevision = this.from == null ? criteria.getFrom() : null;
        this.to = this.parseDate(criteria.getTo());
        this.toRevision = this.to == null ? criteria.getTo() : null;
        this.username = criteria.getUsername();
        this.message = criteria.getCommitMessage();
        this.limitRevisions = criteria.getLimit();
        this.showMerges = criteria.isShowMerges();
        this.showAllPaths = master.fileInfoCheckBox.isSelected();
    }

    @Override
    public void perform() {
        if (this.isCanceled()) {
            return;
        }
        SearchCriteria sc = new SearchCriteria();
        File[] files = this.master.getRoots();
        sc.setFiles(files);
        if (files != null && files.length == 1 && files[0].isFile()) {
            sc.setFollowRenames(true);
        }
        sc.setUsername(this.username);
        sc.setMessage(this.message);
        sc.setLimit(this.limitRevisions);
        sc.setIncludeMerges(this.showMerges);
        sc.setRevisionFrom(this.fromRevision);
        sc.setRevisionTo(this.toRevision);
        sc.setFrom(this.from);
        sc.setTo(this.to);
        try {
            GitClient client = this.getClient();
            GitRevisionInfo[] messages = client.log(sc, (ProgressMonitor)this);
            if (!this.isCanceled()) {
                RepositoryInfo info = RepositoryInfo.getInstance(this.getRepositoryRoot());
                this.appendResults(messages, info.getBranches().values(), info.getTags().values());
            }
        }
        catch (GitException ex) {
            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
        }
    }

    private void appendResults(GitRevisionInfo[] logMessages, Collection<GitBranch> allBranches, Collection<GitTag> allTags) {
        final ArrayList<RepositoryRevision> results = new ArrayList<RepositoryRevision>();
        File dummyFile = null;
        String dummyFileRelativePath = null;
        if (this.master.getRoots().length == 1 && !this.showAllPaths) {
            dummyFile = this.master.getRoots()[0];
            dummyFileRelativePath = GitUtils.getRelativePath(this.getRepositoryRoot(), dummyFile);
        }
        HashMap<File, Set<File>> renames = new HashMap<File, Set<File>>();
        for (int i = 0; i < logMessages.length && !this.isCanceled(); ++i) {
            GitRevisionInfo logMessage = logMessages[i];
            HashSet<GitBranch> branches = new HashSet<GitBranch>();
            HashSet<GitTag> tags = new HashSet<GitTag>();
            for (GitBranch b : allBranches) {
                if (!b.getId().equals(logMessage.getRevision())) continue;
                branches.add(b);
            }
            for (GitTag t : allTags) {
                if (!t.getTaggedObjectId().equals(logMessage.getRevision())) continue;
                tags.add(t);
            }
            RepositoryRevision rev = this.showAllPaths ? new RepositoryRevision(logMessage, tags, branches, renames) : new RepositoryRevision(logMessage, tags, branches, dummyFile, dummyFileRelativePath);
            results.add(rev);
        }
        if (this.isCanceled()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (results.isEmpty()) {
                    SearchExecutor.this.master.setResults(null);
                } else {
                    SearchExecutor.this.master.setResults(results);
                }
            }
        });
    }

    private Date parseDate(String strDate) {
        Date date = null;
        if (strDate != null) {
            for (DateFormat fd : dateFormats) {
                try {
                    date = fd.parse(strDate);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
        return date;
    }
}

