/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.diff.ExportCommit;
import org.netbeans.modules.git.ui.diff.ExportUncommittedChangesAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class ExportCommitAction
extends SingleRepositoryAction {
    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.exportCommit(repository, "HEAD");
    }

    public void exportCommit(final File repository, final String preselectedRevision) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ExportCommit exportDiffSupport = new ExportCommit(repository, preselectedRevision){

                    public void writeDiffFile(final File toFile) {
                        final String revStr = this.getSelectionRevision();
                        ExportCommitAction.saveFolderToPrefs(toFile);
                        GitProgressSupport support = new GitProgressSupport(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void perform() {
                                boolean success = false;
                                OutputStream out = null;
                                try {
                                    GitClient client = this.getClient();
                                    ExportCommitAction.ensureParentExists(toFile);
                                    out = new BufferedOutputStream(new FileOutputStream(toFile));
                                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new File[0]));
                                    this.setProgress(NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"MSG_ExportCommitAction.preparingDiff"));
                                    client.exportCommit(revStr, out, (ProgressMonitor)this);
                                    if (!this.isCanceled()) {
                                        success = true;
                                    }
                                }
                                catch (Exception ex) {
                                    GitClientExceptionHandler.notifyException(ex, true);
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.flush();
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (success && toFile.length() > 0L) {
                                        Utils.openFile((File)toFile);
                                    } else {
                                        toFile.delete();
                                    }
                                }
                            }
                        };
                        support.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ExportCommitAction.class, (String)"LBL_ExportCommitAction_Progress")).waitFinished();
                    }
                };
                exportDiffSupport.export();
            }
        });
    }

    private static void saveFolderToPrefs(File file) {
        if (file.getParent() != null) {
            GitModuleConfig.getDefault().getPreferences().put("ExportDiff.saveFolder", file.getParent());
        }
    }

    private static void ensureParentExists(File destination) {
        File parent = destination.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }
}

